/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.pop.ssme.Description;
import org.eclipse.pop.ssme.Identifier;
import org.eclipse.pop.ssme.InterfaceDefinition;
import org.eclipse.pop.ssme.ModelKind;
import org.eclipse.pop.ssme.ProcessModel;
import org.eclipse.pop.ssme.SsmePackage;
import org.eclipse.pop.ssme.VisibilityKind;
import org.eclipse.pop.ssme.polychrony.PKTrees;
import org.eclipse.pop.ssme.polychrony.PkPlugin;
import org.eclipse.pop.ssme.polychrony.SignalOperators;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Process Model</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.impl.ProcessModelImpl#getIdentifier <em>Identifier</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.impl.ProcessModelImpl#getInterfaceDefinition <em>Interface Definition</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.impl.ProcessModelImpl#getDescription <em>Description</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.impl.ProcessModelImpl#getModelKind <em>Model Kind</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.impl.ProcessModelImpl#getVisibilityKind <em>Visibility Kind</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ProcessModelImpl extends SignalElementImpl implements ProcessModel {
	/**
	 * The cached value of the '{@link #getIdentifier() <em>Identifier</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIdentifier()
	 * @generated
	 * @ordered
	 */
	protected Identifier identifier;

	/**
	 * The cached value of the '{@link #getInterfaceDefinition() <em>Interface Definition</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInterfaceDefinition()
	 * @generated
	 * @ordered
	 */
	protected InterfaceDefinition interfaceDefinition;

	/**
	 * The cached value of the '{@link #getDescription() <em>Description</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDescription()
	 * @generated
	 * @ordered
	 */
	protected Description description;

	/**
	 * The default value of the '{@link #getModelKind() <em>Model Kind</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getModelKind()
	 * @generated
	 * @ordered
	 */
	protected static final ModelKind MODEL_KIND_EDEFAULT = ModelKind.PROCESS_LITERAL;

	/**
	 * The cached value of the '{@link #getModelKind() <em>Model Kind</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getModelKind()
	 * @generated
	 * @ordered
	 */
	protected ModelKind modelKind = MODEL_KIND_EDEFAULT;

	/**
	 * The default value of the '{@link #getVisibilityKind() <em>Visibility Kind</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVisibilityKind()
	 * @generated
	 * @ordered
	 */
	protected static final VisibilityKind VISIBILITY_KIND_EDEFAULT = VisibilityKind.PUBLIC_LITERAL;

	/**
	 * The cached value of the '{@link #getVisibilityKind() <em>Visibility Kind</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVisibilityKind()
	 * @generated
	 * @ordered
	 */
	protected VisibilityKind visibilityKind = VISIBILITY_KIND_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ProcessModelImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SsmePackage.eINSTANCE.getProcessModel();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Identifier getIdentifier() {
		return identifier;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetIdentifier(Identifier newIdentifier, NotificationChain msgs) {
		Identifier oldIdentifier = identifier;
		identifier = newIdentifier;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.PROCESS_MODEL__IDENTIFIER, oldIdentifier, newIdentifier);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIdentifier(Identifier newIdentifier) {
		if (newIdentifier != identifier) {
			NotificationChain msgs = null;
			if (identifier != null)
				msgs = ((InternalEObject)identifier).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.PROCESS_MODEL__IDENTIFIER, null, msgs);
			if (newIdentifier != null)
				msgs = ((InternalEObject)newIdentifier).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.PROCESS_MODEL__IDENTIFIER, null, msgs);
			msgs = basicSetIdentifier(newIdentifier, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.PROCESS_MODEL__IDENTIFIER, newIdentifier, newIdentifier));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public InterfaceDefinition getInterfaceDefinition() {
		return interfaceDefinition;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetInterfaceDefinition(InterfaceDefinition newInterfaceDefinition, NotificationChain msgs) {
		InterfaceDefinition oldInterfaceDefinition = interfaceDefinition;
		interfaceDefinition = newInterfaceDefinition;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.PROCESS_MODEL__INTERFACE_DEFINITION, oldInterfaceDefinition, newInterfaceDefinition);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInterfaceDefinition(InterfaceDefinition newInterfaceDefinition) {
		if (newInterfaceDefinition != interfaceDefinition) {
			NotificationChain msgs = null;
			if (interfaceDefinition != null)
				msgs = ((InternalEObject)interfaceDefinition).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.PROCESS_MODEL__INTERFACE_DEFINITION, null, msgs);
			if (newInterfaceDefinition != null)
				msgs = ((InternalEObject)newInterfaceDefinition).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.PROCESS_MODEL__INTERFACE_DEFINITION, null, msgs);
			msgs = basicSetInterfaceDefinition(newInterfaceDefinition, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.PROCESS_MODEL__INTERFACE_DEFINITION, newInterfaceDefinition, newInterfaceDefinition));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Description getDescription() {
		return description;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetDescription(Description newDescription, NotificationChain msgs) {
		Description oldDescription = description;
		description = newDescription;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.PROCESS_MODEL__DESCRIPTION, oldDescription, newDescription);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDescription(Description newDescription) {
		if (newDescription != description) {
			NotificationChain msgs = null;
			if (description != null)
				msgs = ((InternalEObject)description).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.PROCESS_MODEL__DESCRIPTION, null, msgs);
			if (newDescription != null)
				msgs = ((InternalEObject)newDescription).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.PROCESS_MODEL__DESCRIPTION, null, msgs);
			msgs = basicSetDescription(newDescription, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.PROCESS_MODEL__DESCRIPTION, newDescription, newDescription));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ModelKind getModelKind() {
		return modelKind;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setModelKind(ModelKind newModelKind) {
		ModelKind oldModelKind = modelKind;
		modelKind = newModelKind == null ? MODEL_KIND_EDEFAULT : newModelKind;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.PROCESS_MODEL__MODEL_KIND, oldModelKind, modelKind));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public VisibilityKind getVisibilityKind() {
		return visibilityKind;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setVisibilityKind(VisibilityKind newVisibilityKind) {
		VisibilityKind oldVisibilityKind = visibilityKind;
		visibilityKind = newVisibilityKind == null ? VISIBILITY_KIND_EDEFAULT : newVisibilityKind;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.PROCESS_MODEL__VISIBILITY_KIND, oldVisibilityKind, visibilityKind));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case SsmePackage.PROCESS_MODEL__IDENTIFIER:
				return basicSetIdentifier(null, msgs);
			case SsmePackage.PROCESS_MODEL__INTERFACE_DEFINITION:
				return basicSetInterfaceDefinition(null, msgs);
			case SsmePackage.PROCESS_MODEL__DESCRIPTION:
				return basicSetDescription(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SsmePackage.PROCESS_MODEL__IDENTIFIER:
				return getIdentifier();
			case SsmePackage.PROCESS_MODEL__INTERFACE_DEFINITION:
				return getInterfaceDefinition();
			case SsmePackage.PROCESS_MODEL__DESCRIPTION:
				return getDescription();
			case SsmePackage.PROCESS_MODEL__MODEL_KIND:
				return getModelKind();
			case SsmePackage.PROCESS_MODEL__VISIBILITY_KIND:
				return getVisibilityKind();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SsmePackage.PROCESS_MODEL__IDENTIFIER:
				setIdentifier((Identifier)newValue);
				return;
			case SsmePackage.PROCESS_MODEL__INTERFACE_DEFINITION:
				setInterfaceDefinition((InterfaceDefinition)newValue);
				return;
			case SsmePackage.PROCESS_MODEL__DESCRIPTION:
				setDescription((Description)newValue);
				return;
			case SsmePackage.PROCESS_MODEL__MODEL_KIND:
				setModelKind((ModelKind)newValue);
				return;
			case SsmePackage.PROCESS_MODEL__VISIBILITY_KIND:
				setVisibilityKind((VisibilityKind)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SsmePackage.PROCESS_MODEL__IDENTIFIER:
				setIdentifier((Identifier)null);
				return;
			case SsmePackage.PROCESS_MODEL__INTERFACE_DEFINITION:
				setInterfaceDefinition((InterfaceDefinition)null);
				return;
			case SsmePackage.PROCESS_MODEL__DESCRIPTION:
				setDescription((Description)null);
				return;
			case SsmePackage.PROCESS_MODEL__MODEL_KIND:
				setModelKind(MODEL_KIND_EDEFAULT);
				return;
			case SsmePackage.PROCESS_MODEL__VISIBILITY_KIND:
				setVisibilityKind(VISIBILITY_KIND_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SsmePackage.PROCESS_MODEL__IDENTIFIER:
				return identifier != null;
			case SsmePackage.PROCESS_MODEL__INTERFACE_DEFINITION:
				return interfaceDefinition != null;
			case SsmePackage.PROCESS_MODEL__DESCRIPTION:
				return description != null;
			case SsmePackage.PROCESS_MODEL__MODEL_KIND:
				return modelKind != MODEL_KIND_EDEFAULT;
			case SsmePackage.PROCESS_MODEL__VISIBILITY_KIND:
				return visibilityKind != VISIBILITY_KIND_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (modelKind: ");
		result.append(modelKind);
		result.append(", visibilityKind: ");
		result.append(visibilityKind);
		result.append(')');
		return result.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public long makeAST() {
		PKTrees API = PkPlugin.getTreeAPI();
		long result = PKTrees.ERROR_NODE;
		long idNode = API.getNilTree();
		long interfaceNode = API.getNilTree();
		long descriptionNode = API.getNilTree();
		
		if (getIdentifier() != null) idNode = getIdentifier().makeAST();
		if (getInterfaceDefinition() != null)  interfaceNode = getInterfaceDefinition().makeAST();
		if (getDescription() != null) descriptionNode = getDescription().makeAST();
		
		if (idNode != PKTrees.ERROR_NODE &&
				interfaceNode != PKTrees.ERROR_NODE &&
				descriptionNode != PKTrees.ERROR_NODE) {
			if (modelKind.equals(ModelKind.ACTION_LITERAL) &&
					visibilityKind.equals(VisibilityKind.PRIVATE_LITERAL)) {
				result = API.makeTernary(SignalOperators.opactp, idNode, interfaceNode, descriptionNode);
			}
			else if (modelKind.equals(ModelKind.ACTION_LITERAL) &&
					visibilityKind.equals(VisibilityKind.PUBLIC_LITERAL)) {
				result = API.makeTernary(SignalOperators.opact, idNode, interfaceNode, descriptionNode);
			}
			else if (modelKind.equals(ModelKind.PROCESS_LITERAL) &&
					visibilityKind.equals(VisibilityKind.PRIVATE_LITERAL)) {
				result = API.makeTernary(SignalOperators.opprocessp, idNode, interfaceNode, descriptionNode);
			}
			else if (modelKind.equals(ModelKind.PROCESS_LITERAL) &&
					visibilityKind.equals(VisibilityKind.PUBLIC_LITERAL)) {
				result = API.makeTernary(SignalOperators.opprocess, idNode, interfaceNode, descriptionNode);
			}
			else if (modelKind.equals(ModelKind.NODE_LITERAL) &&
					visibilityKind.equals(VisibilityKind.PRIVATE_LITERAL)) {
				result = API.makeTernary(SignalOperators.opnodep, idNode, interfaceNode, descriptionNode);
			}
			else if (modelKind.equals(ModelKind.NODE_LITERAL) &&
					visibilityKind.equals(VisibilityKind.PUBLIC_LITERAL)) {
				result = API.makeTernary(SignalOperators.opnode, idNode, interfaceNode, descriptionNode);
			}
			else if (modelKind.equals(ModelKind.FUNCTION_LITERAL) &&
					visibilityKind.equals(VisibilityKind.PRIVATE_LITERAL)) {
				result = API.makeTernary(SignalOperators.opfuncp, idNode, interfaceNode, descriptionNode);
			}
			else if (modelKind.equals(ModelKind.FUNCTION_LITERAL) &&
					visibilityKind.equals(VisibilityKind.PUBLIC_LITERAL)) {
				result = API.makeTernary(SignalOperators.opfunc, idNode, interfaceNode, descriptionNode);
			}
			else if (modelKind.equals(ModelKind.AUTOMATON_LITERAL) &&
					visibilityKind.equals(VisibilityKind.PRIVATE_LITERAL)) {
				result = API.makeTernary(SignalOperators.opautomatonp, idNode, interfaceNode, descriptionNode);
			}
			else if (modelKind.equals(ModelKind.AUTOMATON_LITERAL) &&
					visibilityKind.equals(VisibilityKind.PUBLIC_LITERAL)) {
				result = API.makeTernary(SignalOperators.opautomaton, idNode, interfaceNode, descriptionNode);
			}
			else if (modelKind.equals(ModelKind.PROCEDURE_LITERAL) &&
					visibilityKind.equals(VisibilityKind.PRIVATE_LITERAL)) {
				result = API.makeTernary(SignalOperators.opprocedurep, idNode, interfaceNode, descriptionNode);
			}
			else if (modelKind.equals(ModelKind.PROCEDURE_LITERAL) &&
					visibilityKind.equals(VisibilityKind.PUBLIC_LITERAL)) {
				result = API.makeTernary(SignalOperators.opprocedure, idNode, interfaceNode, descriptionNode);
			}
		}
		setASTAttribute(this, result);
		return result;
	}

} //ProcessModelImpl
