/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.pop.ssme.Identifier;
import org.eclipse.pop.ssme.InterfaceDefinition;
import org.eclipse.pop.ssme.ModelKind;
import org.eclipse.pop.ssme.Pragma;
import org.eclipse.pop.ssme.ProcessType;
import org.eclipse.pop.ssme.SsmePackage;
import org.eclipse.pop.ssme.polychrony.PKTrees;
import org.eclipse.pop.ssme.polychrony.PkPlugin;
import org.eclipse.pop.ssme.polychrony.SignalOperators;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Process Type</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.impl.ProcessTypeImpl#getModelKind <em>Model Kind</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.impl.ProcessTypeImpl#getIdentifier <em>Identifier</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.impl.ProcessTypeImpl#getInterfaceDefinition <em>Interface Definition</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.impl.ProcessTypeImpl#getListPragma <em>List Pragma</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ProcessTypeImpl extends SignalElementImpl implements ProcessType {
	/**
	 * The default value of the '{@link #getModelKind() <em>Model Kind</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getModelKind()
	 * @generated
	 * @ordered
	 */
	protected static final ModelKind MODEL_KIND_EDEFAULT = ModelKind.PROCESS_LITERAL;

	/**
	 * The cached value of the '{@link #getModelKind() <em>Model Kind</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getModelKind()
	 * @generated
	 * @ordered
	 */
	protected ModelKind modelKind = MODEL_KIND_EDEFAULT;

	/**
	 * The cached value of the '{@link #getIdentifier() <em>Identifier</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIdentifier()
	 * @generated
	 * @ordered
	 */
	protected Identifier identifier;

	/**
	 * The cached value of the '{@link #getInterfaceDefinition() <em>Interface Definition</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInterfaceDefinition()
	 * @generated
	 * @ordered
	 */
	protected InterfaceDefinition interfaceDefinition;

	/**
	 * The cached value of the '{@link #getListPragma() <em>List Pragma</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getListPragma()
	 * @generated
	 * @ordered
	 */
	protected EList<Pragma> listPragma;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ProcessTypeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SsmePackage.eINSTANCE.getProcessType();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ModelKind getModelKind() {
		return modelKind;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setModelKind(ModelKind newModelKind) {
		ModelKind oldModelKind = modelKind;
		modelKind = newModelKind == null ? MODEL_KIND_EDEFAULT : newModelKind;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.PROCESS_TYPE__MODEL_KIND, oldModelKind, modelKind));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Identifier getIdentifier() {
		return identifier;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetIdentifier(Identifier newIdentifier, NotificationChain msgs) {
		Identifier oldIdentifier = identifier;
		identifier = newIdentifier;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.PROCESS_TYPE__IDENTIFIER, oldIdentifier, newIdentifier);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIdentifier(Identifier newIdentifier) {
		if (newIdentifier != identifier) {
			NotificationChain msgs = null;
			if (identifier != null)
				msgs = ((InternalEObject)identifier).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.PROCESS_TYPE__IDENTIFIER, null, msgs);
			if (newIdentifier != null)
				msgs = ((InternalEObject)newIdentifier).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.PROCESS_TYPE__IDENTIFIER, null, msgs);
			msgs = basicSetIdentifier(newIdentifier, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.PROCESS_TYPE__IDENTIFIER, newIdentifier, newIdentifier));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public InterfaceDefinition getInterfaceDefinition() {
		return interfaceDefinition;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetInterfaceDefinition(InterfaceDefinition newInterfaceDefinition, NotificationChain msgs) {
		InterfaceDefinition oldInterfaceDefinition = interfaceDefinition;
		interfaceDefinition = newInterfaceDefinition;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.PROCESS_TYPE__INTERFACE_DEFINITION, oldInterfaceDefinition, newInterfaceDefinition);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInterfaceDefinition(InterfaceDefinition newInterfaceDefinition) {
		if (newInterfaceDefinition != interfaceDefinition) {
			NotificationChain msgs = null;
			if (interfaceDefinition != null)
				msgs = ((InternalEObject)interfaceDefinition).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.PROCESS_TYPE__INTERFACE_DEFINITION, null, msgs);
			if (newInterfaceDefinition != null)
				msgs = ((InternalEObject)newInterfaceDefinition).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.PROCESS_TYPE__INTERFACE_DEFINITION, null, msgs);
			msgs = basicSetInterfaceDefinition(newInterfaceDefinition, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.PROCESS_TYPE__INTERFACE_DEFINITION, newInterfaceDefinition, newInterfaceDefinition));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Pragma> getListPragma() {
		if (listPragma == null) {
			listPragma = new EObjectContainmentEList<Pragma>(Pragma.class, this, SsmePackage.PROCESS_TYPE__LIST_PRAGMA);
		}
		return listPragma;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case SsmePackage.PROCESS_TYPE__IDENTIFIER:
				return basicSetIdentifier(null, msgs);
			case SsmePackage.PROCESS_TYPE__INTERFACE_DEFINITION:
				return basicSetInterfaceDefinition(null, msgs);
			case SsmePackage.PROCESS_TYPE__LIST_PRAGMA:
				return ((InternalEList<?>)getListPragma()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SsmePackage.PROCESS_TYPE__MODEL_KIND:
				return getModelKind();
			case SsmePackage.PROCESS_TYPE__IDENTIFIER:
				return getIdentifier();
			case SsmePackage.PROCESS_TYPE__INTERFACE_DEFINITION:
				return getInterfaceDefinition();
			case SsmePackage.PROCESS_TYPE__LIST_PRAGMA:
				return getListPragma();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SsmePackage.PROCESS_TYPE__MODEL_KIND:
				setModelKind((ModelKind)newValue);
				return;
			case SsmePackage.PROCESS_TYPE__IDENTIFIER:
				setIdentifier((Identifier)newValue);
				return;
			case SsmePackage.PROCESS_TYPE__INTERFACE_DEFINITION:
				setInterfaceDefinition((InterfaceDefinition)newValue);
				return;
			case SsmePackage.PROCESS_TYPE__LIST_PRAGMA:
				getListPragma().clear();
				getListPragma().addAll((Collection<? extends Pragma>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SsmePackage.PROCESS_TYPE__MODEL_KIND:
				setModelKind(MODEL_KIND_EDEFAULT);
				return;
			case SsmePackage.PROCESS_TYPE__IDENTIFIER:
				setIdentifier((Identifier)null);
				return;
			case SsmePackage.PROCESS_TYPE__INTERFACE_DEFINITION:
				setInterfaceDefinition((InterfaceDefinition)null);
				return;
			case SsmePackage.PROCESS_TYPE__LIST_PRAGMA:
				getListPragma().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SsmePackage.PROCESS_TYPE__MODEL_KIND:
				return modelKind != MODEL_KIND_EDEFAULT;
			case SsmePackage.PROCESS_TYPE__IDENTIFIER:
				return identifier != null;
			case SsmePackage.PROCESS_TYPE__INTERFACE_DEFINITION:
				return interfaceDefinition != null;
			case SsmePackage.PROCESS_TYPE__LIST_PRAGMA:
				return listPragma != null && !listPragma.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (modelKind: ");
		result.append(modelKind);
		result.append(')');
		return result.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public long makeAST() {
		PKTrees API = PkPlugin.getTreeAPI();
		long result = PKTrees.ERROR_NODE;
		long idNode = API.getNilTree();
		long interfaceNode = API.getNilTree();
		long pragmaNode = API.getNilTree();
		
		if (getIdentifier() != null) {
			idNode = getIdentifier().makeAST();
		}
		if (getInterfaceDefinition() != null) {
			interfaceNode = getInterfaceDefinition().makeAST();
		}
		if (getListPragma() != null && !getListPragma().isEmpty()) {
			pragmaNode = API.makeEmptyList(SignalOperators.oplprag);
			for (Pragma pragmas : getListPragma()) {
				long node = pragmas.makeAST();
				if (node != PKTrees.ERROR_NODE) {
					pragmaNode = API.post(pragmaNode, node);
				}
			}
		}
		 
		if (modelKind.equals(ModelKind.ACTION_LITERAL)) {
			result = API.makeTernary(SignalOperators.optypeact, idNode, interfaceNode, pragmaNode);
		}
		else if (modelKind.equals(ModelKind.FUNCTION_LITERAL)) {
			result = API.makeTernary(SignalOperators.optypefunc, idNode, interfaceNode, pragmaNode);
		}
		else if (modelKind.equals(ModelKind.PROCESS_LITERAL)) {
			result = API.makeTernary(SignalOperators.optypeproc, idNode, interfaceNode, pragmaNode);
		}
		else if (modelKind.equals(ModelKind.NODE_LITERAL)) {
			result = API.makeTernary(SignalOperators.optypenode, idNode, interfaceNode, pragmaNode);
		}	
		else if (modelKind.equals(ModelKind.PROCEDURE_LITERAL)) {
			result = API.makeTernary(SignalOperators.optypeprocedure, idNode, interfaceNode, pragmaNode);
		}
		else if (modelKind.equals(ModelKind.AUTOMATON_LITERAL)) {
			result = API.makeTernary(SignalOperators.optypeautomaton, idNode, interfaceNode, pragmaNode);
		}
		
		setASTAttribute(this, result);
		return result;
	}

} //ProcessTypeImpl
