/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.pop.ssme.ExprSignal;
import org.eclipse.pop.ssme.Product;
import org.eclipse.pop.ssme.SsmePackage;
import org.eclipse.pop.ssme.polychrony.PKTrees;
import org.eclipse.pop.ssme.polychrony.PkPlugin;
import org.eclipse.pop.ssme.polychrony.SignalOperators;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Product</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.impl.ProductImpl#getExprSignal1 <em>Expr Signal1</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.impl.ProductImpl#getExprSignal2 <em>Expr Signal2</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ProductImpl extends SignalElementImpl implements Product {
	/**
	 * The cached value of the '{@link #getExprSignal1() <em>Expr Signal1</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getExprSignal1()
	 * @generated
	 * @ordered
	 */
	protected ExprSignal exprSignal1;

	/**
	 * The cached value of the '{@link #getExprSignal2() <em>Expr Signal2</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getExprSignal2()
	 * @generated
	 * @ordered
	 */
	protected ExprSignal exprSignal2;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ProductImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SsmePackage.eINSTANCE.getProduct();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExprSignal getExprSignal1() {
		return exprSignal1;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetExprSignal1(ExprSignal newExprSignal1, NotificationChain msgs) {
		ExprSignal oldExprSignal1 = exprSignal1;
		exprSignal1 = newExprSignal1;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.PRODUCT__EXPR_SIGNAL1, oldExprSignal1, newExprSignal1);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setExprSignal1(ExprSignal newExprSignal1) {
		if (newExprSignal1 != exprSignal1) {
			NotificationChain msgs = null;
			if (exprSignal1 != null)
				msgs = ((InternalEObject)exprSignal1).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.PRODUCT__EXPR_SIGNAL1, null, msgs);
			if (newExprSignal1 != null)
				msgs = ((InternalEObject)newExprSignal1).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.PRODUCT__EXPR_SIGNAL1, null, msgs);
			msgs = basicSetExprSignal1(newExprSignal1, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.PRODUCT__EXPR_SIGNAL1, newExprSignal1, newExprSignal1));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExprSignal getExprSignal2() {
		return exprSignal2;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetExprSignal2(ExprSignal newExprSignal2, NotificationChain msgs) {
		ExprSignal oldExprSignal2 = exprSignal2;
		exprSignal2 = newExprSignal2;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.PRODUCT__EXPR_SIGNAL2, oldExprSignal2, newExprSignal2);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setExprSignal2(ExprSignal newExprSignal2) {
		if (newExprSignal2 != exprSignal2) {
			NotificationChain msgs = null;
			if (exprSignal2 != null)
				msgs = ((InternalEObject)exprSignal2).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.PRODUCT__EXPR_SIGNAL2, null, msgs);
			if (newExprSignal2 != null)
				msgs = ((InternalEObject)newExprSignal2).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.PRODUCT__EXPR_SIGNAL2, null, msgs);
			msgs = basicSetExprSignal2(newExprSignal2, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.PRODUCT__EXPR_SIGNAL2, newExprSignal2, newExprSignal2));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case SsmePackage.PRODUCT__EXPR_SIGNAL1:
				return basicSetExprSignal1(null, msgs);
			case SsmePackage.PRODUCT__EXPR_SIGNAL2:
				return basicSetExprSignal2(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SsmePackage.PRODUCT__EXPR_SIGNAL1:
				return getExprSignal1();
			case SsmePackage.PRODUCT__EXPR_SIGNAL2:
				return getExprSignal2();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SsmePackage.PRODUCT__EXPR_SIGNAL1:
				setExprSignal1((ExprSignal)newValue);
				return;
			case SsmePackage.PRODUCT__EXPR_SIGNAL2:
				setExprSignal2((ExprSignal)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SsmePackage.PRODUCT__EXPR_SIGNAL1:
				setExprSignal1((ExprSignal)null);
				return;
			case SsmePackage.PRODUCT__EXPR_SIGNAL2:
				setExprSignal2((ExprSignal)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SsmePackage.PRODUCT__EXPR_SIGNAL1:
				return exprSignal1 != null;
			case SsmePackage.PRODUCT__EXPR_SIGNAL2:
				return exprSignal2 != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public long makeAST() {
		PKTrees API = PkPlugin.getTreeAPI();
		long result = PKTrees.ERROR_NODE;
		long exprSignal1Node = API.getNilTree();
		if (getExprSignal1() != null) {
			exprSignal1Node = getExprSignal1().makeAST();
		}
		long exprSignal2Node = API.getNilTree();
		if (getExprSignal2() != null) {
			exprSignal2Node = getExprSignal2().makeAST();
		}
		if (exprSignal1Node != PKTrees.ERROR_NODE && exprSignal2Node != PKTrees.ERROR_NODE) {
			result = API.makeBinary(SignalOperators.opmult, exprSignal1Node, exprSignal2Node);
		}
		setASTAttribute(this, result);
		return result;
	}

} //ProductImpl
