/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.impl;



import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.pop.ssme.Comment;
import org.eclipse.pop.ssme.SignalElement;
import org.eclipse.pop.ssme.SsmePackage;
import org.eclipse.pop.ssme.polychrony.PkPlugin;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Signal Element</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.impl.SignalElementImpl#getCommentPre <em>Comment Pre</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.impl.SignalElementImpl#getCommentPost <em>Comment Post</em>}</li>
 * </ul>
 *
 * @generated
 */
public class SignalElementImpl extends EObjectImpl implements SignalElement {
	
	/**
	 * The cached value of the '{@link #getCommentPre() <em>Comment Pre</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCommentPre()
	 * @generated
	 * @ordered
	 */
	protected EList<Comment> commentPre;
	/**
	 * The cached value of the '{@link #getCommentPost() <em>Comment Post</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCommentPost()
	 * @generated
	 * @ordered
	 */
	protected EList<Comment> commentPost;
	/**
	 * @generated NOT
	 */
	protected long treeAttribute;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SignalElementImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SsmePackage.eINSTANCE.getSignalElement();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Comment> getCommentPre() {
		if (commentPre == null) {
			commentPre = new EObjectContainmentEList<Comment>(Comment.class, this, SsmePackage.SIGNAL_ELEMENT__COMMENT_PRE);
		}
		return commentPre;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Comment> getCommentPost() {
		if (commentPost == null) {
			commentPost = new EObjectContainmentEList<Comment>(Comment.class, this, SsmePackage.SIGNAL_ELEMENT__COMMENT_POST);
		}
		return commentPost;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public long getTreeAttribute() {
		return treeAttribute;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public void setTreeAttribute(long newTreeAttribute) {
		this.treeAttribute = newTreeAttribute;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public void getParent() {
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public long makeAST() {
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public void setASTAttribute(EObject sigElem, long tree) {
		if (((SignalElementImpl)sigElem).getCommentPre() != null && !((SignalElementImpl)sigElem).getCommentPre().isEmpty()) {
			for (int i=0; i<getCommentPre().size(); i++) {
				PkPlugin.getCommentAPI().addStrComment(tree,getCommentPre().get(i).getAtomString(), true);
			}
		}
		if (((SignalElementImpl)sigElem).getCommentPost() != null && !((SignalElementImpl)sigElem).getCommentPost().isEmpty()) {
			for (int i=0; i<getCommentPost().size(); i++) {
				PkPlugin.getCommentAPI().addStrComment(tree,getCommentPost().get(i).getAtomString(), false);
			}
		}
		PkPlugin.getTraceabilityAPI().getInterfaceMapSMESignal().put(sigElem, tree);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case SsmePackage.SIGNAL_ELEMENT__COMMENT_PRE:
				return ((InternalEList<?>)getCommentPre()).basicRemove(otherEnd, msgs);
			case SsmePackage.SIGNAL_ELEMENT__COMMENT_POST:
				return ((InternalEList<?>)getCommentPost()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SsmePackage.SIGNAL_ELEMENT__COMMENT_PRE:
				return getCommentPre();
			case SsmePackage.SIGNAL_ELEMENT__COMMENT_POST:
				return getCommentPost();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SsmePackage.SIGNAL_ELEMENT__COMMENT_PRE:
				getCommentPre().clear();
				getCommentPre().addAll((Collection<? extends Comment>)newValue);
				return;
			case SsmePackage.SIGNAL_ELEMENT__COMMENT_POST:
				getCommentPost().clear();
				getCommentPost().addAll((Collection<? extends Comment>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SsmePackage.SIGNAL_ELEMENT__COMMENT_PRE:
				getCommentPre().clear();
				return;
			case SsmePackage.SIGNAL_ELEMENT__COMMENT_POST:
				getCommentPost().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SsmePackage.SIGNAL_ELEMENT__COMMENT_PRE:
				return commentPre != null && !commentPre.isEmpty();
			case SsmePackage.SIGNAL_ELEMENT__COMMENT_POST:
				return commentPost != null && !commentPost.isEmpty();
		}
		return super.eIsSet(featureID);
	}

} //SignalElementImpl
