/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.pop.ssme.ExprSignal;
import org.eclipse.pop.ssme.SignalsPartialDefinition;
import org.eclipse.pop.ssme.SsmePackage;
import org.eclipse.pop.ssme.polychrony.PKTrees;
import org.eclipse.pop.ssme.polychrony.PkPlugin;
import org.eclipse.pop.ssme.polychrony.SignalOperators;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Signals Partial Definition</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.impl.SignalsPartialDefinitionImpl#getExprSignalLeft <em>Expr Signal Left</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.impl.SignalsPartialDefinitionImpl#getExprSignalRight <em>Expr Signal Right</em>}</li>
 * </ul>
 *
 * @generated
 */
public class SignalsPartialDefinitionImpl extends SignalElementImpl implements SignalsPartialDefinition {
	/**
	 * The cached value of the '{@link #getExprSignalLeft() <em>Expr Signal Left</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getExprSignalLeft()
	 * @generated
	 * @ordered
	 */
	protected ExprSignal exprSignalLeft;

	/**
	 * The cached value of the '{@link #getExprSignalRight() <em>Expr Signal Right</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getExprSignalRight()
	 * @generated
	 * @ordered
	 */
	protected ExprSignal exprSignalRight;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SignalsPartialDefinitionImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SsmePackage.eINSTANCE.getSignalsPartialDefinition();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExprSignal getExprSignalLeft() {
		return exprSignalLeft;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetExprSignalLeft(ExprSignal newExprSignalLeft, NotificationChain msgs) {
		ExprSignal oldExprSignalLeft = exprSignalLeft;
		exprSignalLeft = newExprSignalLeft;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.SIGNALS_PARTIAL_DEFINITION__EXPR_SIGNAL_LEFT, oldExprSignalLeft, newExprSignalLeft);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setExprSignalLeft(ExprSignal newExprSignalLeft) {
		if (newExprSignalLeft != exprSignalLeft) {
			NotificationChain msgs = null;
			if (exprSignalLeft != null)
				msgs = ((InternalEObject)exprSignalLeft).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.SIGNALS_PARTIAL_DEFINITION__EXPR_SIGNAL_LEFT, null, msgs);
			if (newExprSignalLeft != null)
				msgs = ((InternalEObject)newExprSignalLeft).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.SIGNALS_PARTIAL_DEFINITION__EXPR_SIGNAL_LEFT, null, msgs);
			msgs = basicSetExprSignalLeft(newExprSignalLeft, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.SIGNALS_PARTIAL_DEFINITION__EXPR_SIGNAL_LEFT, newExprSignalLeft, newExprSignalLeft));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExprSignal getExprSignalRight() {
		return exprSignalRight;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetExprSignalRight(ExprSignal newExprSignalRight, NotificationChain msgs) {
		ExprSignal oldExprSignalRight = exprSignalRight;
		exprSignalRight = newExprSignalRight;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.SIGNALS_PARTIAL_DEFINITION__EXPR_SIGNAL_RIGHT, oldExprSignalRight, newExprSignalRight);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setExprSignalRight(ExprSignal newExprSignalRight) {
		if (newExprSignalRight != exprSignalRight) {
			NotificationChain msgs = null;
			if (exprSignalRight != null)
				msgs = ((InternalEObject)exprSignalRight).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.SIGNALS_PARTIAL_DEFINITION__EXPR_SIGNAL_RIGHT, null, msgs);
			if (newExprSignalRight != null)
				msgs = ((InternalEObject)newExprSignalRight).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.SIGNALS_PARTIAL_DEFINITION__EXPR_SIGNAL_RIGHT, null, msgs);
			msgs = basicSetExprSignalRight(newExprSignalRight, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.SIGNALS_PARTIAL_DEFINITION__EXPR_SIGNAL_RIGHT, newExprSignalRight, newExprSignalRight));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case SsmePackage.SIGNALS_PARTIAL_DEFINITION__EXPR_SIGNAL_LEFT:
				return basicSetExprSignalLeft(null, msgs);
			case SsmePackage.SIGNALS_PARTIAL_DEFINITION__EXPR_SIGNAL_RIGHT:
				return basicSetExprSignalRight(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SsmePackage.SIGNALS_PARTIAL_DEFINITION__EXPR_SIGNAL_LEFT:
				return getExprSignalLeft();
			case SsmePackage.SIGNALS_PARTIAL_DEFINITION__EXPR_SIGNAL_RIGHT:
				return getExprSignalRight();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SsmePackage.SIGNALS_PARTIAL_DEFINITION__EXPR_SIGNAL_LEFT:
				setExprSignalLeft((ExprSignal)newValue);
				return;
			case SsmePackage.SIGNALS_PARTIAL_DEFINITION__EXPR_SIGNAL_RIGHT:
				setExprSignalRight((ExprSignal)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SsmePackage.SIGNALS_PARTIAL_DEFINITION__EXPR_SIGNAL_LEFT:
				setExprSignalLeft((ExprSignal)null);
				return;
			case SsmePackage.SIGNALS_PARTIAL_DEFINITION__EXPR_SIGNAL_RIGHT:
				setExprSignalRight((ExprSignal)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SsmePackage.SIGNALS_PARTIAL_DEFINITION__EXPR_SIGNAL_LEFT:
				return exprSignalLeft != null;
			case SsmePackage.SIGNALS_PARTIAL_DEFINITION__EXPR_SIGNAL_RIGHT:
				return exprSignalRight != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public long makeAST() {
		PKTrees API = PkPlugin.getTreeAPI();
		long result = PKTrees.ERROR_NODE;
		long eSig1 = API.getNilTree();
		if (getExprSignalLeft() != null) {
			eSig1 = getExprSignalLeft().makeAST();
		}
		long eSig2 = API.getNilTree();
		if (getExprSignalRight() != null) {
			eSig2 = getExprSignalRight().makeAST();
		}
		if (eSig1 != PKTrees.ERROR_NODE && eSig2 != PKTrees.ERROR_NODE) {
			result = API.makeBinary(SignalOperators.opdefpart, eSig1, eSig2);
		}
		setASTAttribute(this, result);
		return result;
	}

} //SignalsPartialDefinitionImpl
