/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.pop.ssme.ExprSignal;
import org.eclipse.pop.ssme.SsmePackage;
import org.eclipse.pop.ssme.Transposition;
import org.eclipse.pop.ssme.polychrony.PKTrees;
import org.eclipse.pop.ssme.polychrony.PkPlugin;
import org.eclipse.pop.ssme.polychrony.SignalOperators;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Transposition</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.impl.TranspositionImpl#getExprSignal <em>Expr Signal</em>}</li>
 * </ul>
 *
 * @generated
 */
public class TranspositionImpl extends SignalElementImpl implements Transposition {
	/**
	 * The cached value of the '{@link #getExprSignal() <em>Expr Signal</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getExprSignal()
	 * @generated
	 * @ordered
	 */
	protected ExprSignal exprSignal;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TranspositionImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SsmePackage.eINSTANCE.getTransposition();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExprSignal getExprSignal() {
		return exprSignal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetExprSignal(ExprSignal newExprSignal, NotificationChain msgs) {
		ExprSignal oldExprSignal = exprSignal;
		exprSignal = newExprSignal;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.TRANSPOSITION__EXPR_SIGNAL, oldExprSignal, newExprSignal);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setExprSignal(ExprSignal newExprSignal) {
		if (newExprSignal != exprSignal) {
			NotificationChain msgs = null;
			if (exprSignal != null)
				msgs = ((InternalEObject)exprSignal).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.TRANSPOSITION__EXPR_SIGNAL, null, msgs);
			if (newExprSignal != null)
				msgs = ((InternalEObject)newExprSignal).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.TRANSPOSITION__EXPR_SIGNAL, null, msgs);
			msgs = basicSetExprSignal(newExprSignal, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.TRANSPOSITION__EXPR_SIGNAL, newExprSignal, newExprSignal));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case SsmePackage.TRANSPOSITION__EXPR_SIGNAL:
				return basicSetExprSignal(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public long makeAST() {
		PKTrees API = PkPlugin.getTreeAPI();
		long result = PKTrees.ERROR_NODE;
		
		long exprSignalNode = API.getNilTree();
		if (getExprSignal() != null) {
			exprSignalNode = getExprSignal().makeAST();
		}
		
		if (exprSignalNode != PKTrees.ERROR_NODE) {
			result = API.makeUnary(SignalOperators.optran, exprSignalNode);
		}
		setASTAttribute(this, result);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SsmePackage.TRANSPOSITION__EXPR_SIGNAL:
				return getExprSignal();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SsmePackage.TRANSPOSITION__EXPR_SIGNAL:
				setExprSignal((ExprSignal)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SsmePackage.TRANSPOSITION__EXPR_SIGNAL:
				setExprSignal((ExprSignal)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SsmePackage.TRANSPOSITION__EXPR_SIGNAL:
				return exprSignal != null;
		}
		return super.eIsSet(featureID);
	}

} //TranspositionImpl
