/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.pop.ssme.GraphSpecification;
import org.eclipse.pop.ssme.SsmePackage;
import org.eclipse.pop.ssme.TupleType;
import org.eclipse.pop.ssme.TypeKind;
import org.eclipse.pop.ssme.TypesOrSignalsDeclaration;
import org.eclipse.pop.ssme.polychrony.PKTrees;
import org.eclipse.pop.ssme.polychrony.PkPlugin;
import org.eclipse.pop.ssme.polychrony.SignalOperators;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Tuple Type</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.impl.TupleTypeImpl#getListSignalsDeclaration <em>List Signals Declaration</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.impl.TupleTypeImpl#getGraphSpecification <em>Graph Specification</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.impl.TupleTypeImpl#getTypeKind <em>Type Kind</em>}</li>
 * </ul>
 *
 * @generated
 */
public class TupleTypeImpl extends SignalElementImpl implements TupleType {
	/**
	 * The cached value of the '{@link #getListSignalsDeclaration() <em>List Signals Declaration</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getListSignalsDeclaration()
	 * @generated
	 * @ordered
	 */
	protected EList<TypesOrSignalsDeclaration> listSignalsDeclaration;

	/**
	 * The cached value of the '{@link #getGraphSpecification() <em>Graph Specification</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getGraphSpecification()
	 * @generated
	 * @ordered
	 */
	protected GraphSpecification graphSpecification;

	/**
	 * The default value of the '{@link #getTypeKind() <em>Type Kind</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTypeKind()
	 * @generated
	 * @ordered
	 */
	protected static final TypeKind TYPE_KIND_EDEFAULT = TypeKind.BUNDLE_LITERAL;

	/**
	 * The cached value of the '{@link #getTypeKind() <em>Type Kind</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTypeKind()
	 * @generated
	 * @ordered
	 */
	protected TypeKind typeKind = TYPE_KIND_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TupleTypeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SsmePackage.eINSTANCE.getTupleType();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<TypesOrSignalsDeclaration> getListSignalsDeclaration() {
		if (listSignalsDeclaration == null) {
			listSignalsDeclaration = new EObjectContainmentEList<TypesOrSignalsDeclaration>(TypesOrSignalsDeclaration.class, this, SsmePackage.TUPLE_TYPE__LIST_SIGNALS_DECLARATION);
		}
		return listSignalsDeclaration;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GraphSpecification getGraphSpecification() {
		return graphSpecification;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetGraphSpecification(GraphSpecification newGraphSpecification, NotificationChain msgs) {
		GraphSpecification oldGraphSpecification = graphSpecification;
		graphSpecification = newGraphSpecification;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.TUPLE_TYPE__GRAPH_SPECIFICATION, oldGraphSpecification, newGraphSpecification);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setGraphSpecification(GraphSpecification newGraphSpecification) {
		if (newGraphSpecification != graphSpecification) {
			NotificationChain msgs = null;
			if (graphSpecification != null)
				msgs = ((InternalEObject)graphSpecification).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.TUPLE_TYPE__GRAPH_SPECIFICATION, null, msgs);
			if (newGraphSpecification != null)
				msgs = ((InternalEObject)newGraphSpecification).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.TUPLE_TYPE__GRAPH_SPECIFICATION, null, msgs);
			msgs = basicSetGraphSpecification(newGraphSpecification, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.TUPLE_TYPE__GRAPH_SPECIFICATION, newGraphSpecification, newGraphSpecification));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TypeKind getTypeKind() {
		return typeKind;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTypeKind(TypeKind newTypeKind) {
		TypeKind oldTypeKind = typeKind;
		typeKind = newTypeKind == null ? TYPE_KIND_EDEFAULT : newTypeKind;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.TUPLE_TYPE__TYPE_KIND, oldTypeKind, typeKind));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public long makeAST() {
		PKTrees API = PkPlugin.getTreeAPI();
		long result = PKTrees.ERROR_NODE;
		
		long declNode = API.getNilTree();
		if (getListSignalsDeclaration() != null && !getListSignalsDeclaration().isEmpty()) {
			declNode = API.makeEmptyList(SignalOperators.opldecs);
			for (TypesOrSignalsDeclaration sp : getListSignalsDeclaration()) {
				long node = sp.makeAST();
				if (node != PKTrees.ERROR_NODE) {
					declNode = API.post(declNode, node);
				}
			}
		}
		
		long specNode = API.getNilTree();
		if (getGraphSpecification() != null) {
			specNode = getGraphSpecification().makeAST();
		}
		
		if (typeKind.equals(TypeKind.BUNDLE_LITERAL)) {
			result = API.makeBinary(SignalOperators.opbund, declNode, specNode);
		}
		else if (typeKind.equals(TypeKind.STRUCT_LITERAL)) {
			result = API.makeUnary(SignalOperators.opstru, declNode);
		}
		setASTAttribute(this, result);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case SsmePackage.TUPLE_TYPE__LIST_SIGNALS_DECLARATION:
				return ((InternalEList<?>)getListSignalsDeclaration()).basicRemove(otherEnd, msgs);
			case SsmePackage.TUPLE_TYPE__GRAPH_SPECIFICATION:
				return basicSetGraphSpecification(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SsmePackage.TUPLE_TYPE__LIST_SIGNALS_DECLARATION:
				return getListSignalsDeclaration();
			case SsmePackage.TUPLE_TYPE__GRAPH_SPECIFICATION:
				return getGraphSpecification();
			case SsmePackage.TUPLE_TYPE__TYPE_KIND:
				return getTypeKind();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SsmePackage.TUPLE_TYPE__LIST_SIGNALS_DECLARATION:
				getListSignalsDeclaration().clear();
				getListSignalsDeclaration().addAll((Collection<? extends TypesOrSignalsDeclaration>)newValue);
				return;
			case SsmePackage.TUPLE_TYPE__GRAPH_SPECIFICATION:
				setGraphSpecification((GraphSpecification)newValue);
				return;
			case SsmePackage.TUPLE_TYPE__TYPE_KIND:
				setTypeKind((TypeKind)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SsmePackage.TUPLE_TYPE__LIST_SIGNALS_DECLARATION:
				getListSignalsDeclaration().clear();
				return;
			case SsmePackage.TUPLE_TYPE__GRAPH_SPECIFICATION:
				setGraphSpecification((GraphSpecification)null);
				return;
			case SsmePackage.TUPLE_TYPE__TYPE_KIND:
				setTypeKind(TYPE_KIND_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SsmePackage.TUPLE_TYPE__LIST_SIGNALS_DECLARATION:
				return listSignalsDeclaration != null && !listSignalsDeclaration.isEmpty();
			case SsmePackage.TUPLE_TYPE__GRAPH_SPECIFICATION:
				return graphSpecification != null;
			case SsmePackage.TUPLE_TYPE__TYPE_KIND:
				return typeKind != TYPE_KIND_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (typeKind: ");
		result.append(typeKind);
		result.append(')');
		return result.toString();
	}

} //TupleTypeImpl
