/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.util;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.Switch;
import org.eclipse.pop.ssme.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see org.eclipse.pop.ssme.SsmePackage
 * @generated
 */
public class SsmeSwitch<T> extends Switch<T> {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static SsmePackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SsmeSwitch() {
		if (modelPackage == null) {
			modelPackage = SsmePackage.eINSTANCE;
		}
	}

	/**
	 * Checks whether this is a switch for the given package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param ePackage the package in question.
	 * @return whether this is a switch for the given package.
	 * @generated
	 */
	@Override
	protected boolean isSwitchFor(EPackage ePackage) {
		return ePackage == modelPackage;
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	@Override
	protected T doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
			case SsmePackage.AFTER: {
				After after = (After)theEObject;
				T result = caseAfter(after);
				if (result == null) result = caseBinaryOperators(after);
				if (result == null) result = caseExprSignal(after);
				if (result == null) result = caseConstantDescriptionValue(after);
				if (result == null) result = caseExprParam(after);
				if (result == null) result = caseSignalElement(after);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.AND: {
				And and = (And)theEObject;
				T result = caseAnd(and);
				if (result == null) result = caseBinaryOperators(and);
				if (result == null) result = caseExprSignal(and);
				if (result == null) result = caseConstantDescriptionValue(and);
				if (result == null) result = caseExprParam(and);
				if (result == null) result = caseSignalElement(and);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.ARRAY_ELEM: {
				ArrayElem arrayElem = (ArrayElem)theEObject;
				T result = caseArrayElem(arrayElem);
				if (result == null) result = caseExprSignal(arrayElem);
				if (result == null) result = caseConstantDescriptionValue(arrayElem);
				if (result == null) result = caseExprParam(arrayElem);
				if (result == null) result = caseSignalElement(arrayElem);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.ARRAY_ELEMENTS_ENUMERATION: {
				ArrayElementsEnumeration arrayElementsEnumeration = (ArrayElementsEnumeration)theEObject;
				T result = caseArrayElementsEnumeration(arrayElementsEnumeration);
				if (result == null) result = caseIterativeEnumeration(arrayElementsEnumeration);
				if (result == null) result = caseExprSignal(arrayElementsEnumeration);
				if (result == null) result = caseConstantDescriptionValue(arrayElementsEnumeration);
				if (result == null) result = caseExprParam(arrayElementsEnumeration);
				if (result == null) result = caseSignalElement(arrayElementsEnumeration);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.ARRAY_INDEX: {
				ArrayIndex arrayIndex = (ArrayIndex)theEObject;
				T result = caseArrayIndex(arrayIndex);
				if (result == null) result = caseSignalElement(arrayIndex);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.ARRAY_PROCESS: {
				ArrayProcess arrayProcess = (ArrayProcess)theEObject;
				T result = caseArrayProcess(arrayProcess);
				if (result == null) result = caseIterationOfProcesses(arrayProcess);
				if (result == null) result = caseExprProcess(arrayProcess);
				if (result == null) result = caseProcessBody(arrayProcess);
				if (result == null) result = caseSignalElement(arrayProcess);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.ARRAY_PRODUCT: {
				ArrayProduct arrayProduct = (ArrayProduct)theEObject;
				T result = caseArrayProduct(arrayProduct);
				if (result == null) result = caseBinaryOperators(arrayProduct);
				if (result == null) result = caseExprSignal(arrayProduct);
				if (result == null) result = caseConstantDescriptionValue(arrayProduct);
				if (result == null) result = caseExprParam(arrayProduct);
				if (result == null) result = caseSignalElement(arrayProduct);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.ARRAY_RESTRUCTURATION: {
				ArrayRestructuration arrayRestructuration = (ArrayRestructuration)theEObject;
				T result = caseArrayRestructuration(arrayRestructuration);
				if (result == null) result = caseBinaryOperators(arrayRestructuration);
				if (result == null) result = caseExprSignal(arrayRestructuration);
				if (result == null) result = caseConstantDescriptionValue(arrayRestructuration);
				if (result == null) result = caseExprParam(arrayRestructuration);
				if (result == null) result = caseSignalElement(arrayRestructuration);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.ARRAY_TYPE: {
				ArrayType arrayType = (ArrayType)theEObject;
				T result = caseArrayType(arrayType);
				if (result == null) result = caseDescribedType(arrayType);
				if (result == null) result = caseType(arrayType);
				if (result == null) result = caseExprParam(arrayType);
				if (result == null) result = caseTypeDescriptionValue(arrayType);
				if (result == null) result = caseSignalElement(arrayType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.ASSERT_PROCESS: {
				AssertProcess assertProcess = (AssertProcess)theEObject;
				T result = caseAssertProcess(assertProcess);
				if (result == null) result = caseExprProcess(assertProcess);
				if (result == null) result = caseProcessBody(assertProcess);
				if (result == null) result = caseSignalElement(assertProcess);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.ASSERT_SIGNAL: {
				AssertSignal assertSignal = (AssertSignal)theEObject;
				T result = caseAssertSignal(assertSignal);
				if (result == null) result = caseProcessCallOrAssert(assertSignal);
				if (result == null) result = caseProcessInstance(assertSignal);
				if (result == null) result = caseExprProcess(assertSignal);
				if (result == null) result = caseExprSignal(assertSignal);
				if (result == null) result = caseProcessBody(assertSignal);
				if (result == null) result = caseConstantDescriptionValue(assertSignal);
				if (result == null) result = caseExprParam(assertSignal);
				if (result == null) result = caseSignalElement(assertSignal);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.BINARY_OPERATORS: {
				BinaryOperators binaryOperators = (BinaryOperators)theEObject;
				T result = caseBinaryOperators(binaryOperators);
				if (result == null) result = caseExprSignal(binaryOperators);
				if (result == null) result = caseConstantDescriptionValue(binaryOperators);
				if (result == null) result = caseExprParam(binaryOperators);
				if (result == null) result = caseSignalElement(binaryOperators);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.BOUNDS: {
				Bounds bounds = (Bounds)theEObject;
				T result = caseBounds(bounds);
				if (result == null) result = caseSignalElement(bounds);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.CARTESIAN_PRODUCT: {
				CartesianProduct cartesianProduct = (CartesianProduct)theEObject;
				T result = caseCartesianProduct(cartesianProduct);
				if (result == null) result = caseExprSignal(cartesianProduct);
				if (result == null) result = caseConstantDescriptionValue(cartesianProduct);
				if (result == null) result = caseExprParam(cartesianProduct);
				if (result == null) result = caseSignalElement(cartesianProduct);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.CASE_ENUMERATION: {
				CaseEnumeration caseEnumeration = (CaseEnumeration)theEObject;
				T result = caseCaseEnumeration(caseEnumeration);
				if (result == null) result = caseCaseExprEnumeration(caseEnumeration);
				if (result == null) result = caseSignalElement(caseEnumeration);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.CASE_EXPR_ENUMERATION: {
				CaseExprEnumeration caseExprEnumeration = (CaseExprEnumeration)theEObject;
				T result = caseCaseExprEnumeration(caseExprEnumeration);
				if (result == null) result = caseSignalElement(caseExprEnumeration);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.CASE_INTERVAL: {
				CaseInterval caseInterval = (CaseInterval)theEObject;
				T result = caseCaseInterval(caseInterval);
				if (result == null) result = caseCaseExprEnumeration(caseInterval);
				if (result == null) result = caseSignalElement(caseInterval);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.CASE_PROCESS: {
				CaseProcess caseProcess = (CaseProcess)theEObject;
				T result = caseCaseProcess(caseProcess);
				if (result == null) result = caseExprProcess(caseProcess);
				if (result == null) result = caseProcessBody(caseProcess);
				if (result == null) result = caseSignalElement(caseProcess);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.CASE_BRANCH: {
				CaseBranch caseBranch = (CaseBranch)theEObject;
				T result = caseCaseBranch(caseBranch);
				if (result == null) result = caseSignalElement(caseBranch);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.CELL: {
				Cell cell = (Cell)theEObject;
				T result = caseCell(cell);
				if (result == null) result = caseTernaryOperators(cell);
				if (result == null) result = caseExprSignal(cell);
				if (result == null) result = caseConstantDescriptionValue(cell);
				if (result == null) result = caseExprParam(cell);
				if (result == null) result = caseSignalElement(cell);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.CLOCK: {
				Clock clock = (Clock)theEObject;
				T result = caseClock(clock);
				if (result == null) result = caseUnaryOperators(clock);
				if (result == null) result = caseExprSignal(clock);
				if (result == null) result = caseConstantDescriptionValue(clock);
				if (result == null) result = caseExprParam(clock);
				if (result == null) result = caseSignalElement(clock);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.CLOCK_DIFFERENCE: {
				ClockDifference clockDifference = (ClockDifference)theEObject;
				T result = caseClockDifference(clockDifference);
				if (result == null) result = caseBinaryOperators(clockDifference);
				if (result == null) result = caseExprSignal(clockDifference);
				if (result == null) result = caseConstantDescriptionValue(clockDifference);
				if (result == null) result = caseExprParam(clockDifference);
				if (result == null) result = caseSignalElement(clockDifference);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.CLOCK_EQUALITY: {
				ClockEquality clockEquality = (ClockEquality)theEObject;
				T result = caseClockEquality(clockEquality);
				if (result == null) result = caseExprProcess(clockEquality);
				if (result == null) result = caseProcessBody(clockEquality);
				if (result == null) result = caseSignalElement(clockEquality);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.CLOCK_EXCLUSIVE_RELATION: {
				ClockExclusiveRelation clockExclusiveRelation = (ClockExclusiveRelation)theEObject;
				T result = caseClockExclusiveRelation(clockExclusiveRelation);
				if (result == null) result = caseExprProcess(clockExclusiveRelation);
				if (result == null) result = caseProcessBody(clockExclusiveRelation);
				if (result == null) result = caseSignalElement(clockExclusiveRelation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.CLOCK_INF_RELATION: {
				ClockInfRelation clockInfRelation = (ClockInfRelation)theEObject;
				T result = caseClockInfRelation(clockInfRelation);
				if (result == null) result = caseExprProcess(clockInfRelation);
				if (result == null) result = caseProcessBody(clockInfRelation);
				if (result == null) result = caseSignalElement(clockInfRelation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.CLOCK_PRODUCT: {
				ClockProduct clockProduct = (ClockProduct)theEObject;
				T result = caseClockProduct(clockProduct);
				if (result == null) result = caseBinaryOperators(clockProduct);
				if (result == null) result = caseExprSignal(clockProduct);
				if (result == null) result = caseConstantDescriptionValue(clockProduct);
				if (result == null) result = caseExprParam(clockProduct);
				if (result == null) result = caseSignalElement(clockProduct);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.CLOCK_SUP_RELATION: {
				ClockSupRelation clockSupRelation = (ClockSupRelation)theEObject;
				T result = caseClockSupRelation(clockSupRelation);
				if (result == null) result = caseExprProcess(clockSupRelation);
				if (result == null) result = caseProcessBody(clockSupRelation);
				if (result == null) result = caseSignalElement(clockSupRelation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.CLOCK_UNION: {
				ClockUnion clockUnion = (ClockUnion)theEObject;
				T result = caseClockUnion(clockUnion);
				if (result == null) result = caseBinaryOperators(clockUnion);
				if (result == null) result = caseExprSignal(clockUnion);
				if (result == null) result = caseConstantDescriptionValue(clockUnion);
				if (result == null) result = caseExprParam(clockUnion);
				if (result == null) result = caseSignalElement(clockUnion);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.COMMENT: {
				Comment comment = (Comment)theEObject;
				T result = caseComment(comment);
				if (result == null) result = caseSignalElement(comment);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.COMPLEX_CONSTRUCTOR: {
				ComplexConstructor complexConstructor = (ComplexConstructor)theEObject;
				T result = caseComplexConstructor(complexConstructor);
				if (result == null) result = caseBinaryOperators(complexConstructor);
				if (result == null) result = caseExprSignal(complexConstructor);
				if (result == null) result = caseConstantDescriptionValue(complexConstructor);
				if (result == null) result = caseExprParam(complexConstructor);
				if (result == null) result = caseSignalElement(complexConstructor);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.COMPOSITION: {
				Composition composition = (Composition)theEObject;
				T result = caseComposition(composition);
				if (result == null) result = caseExprProcess(composition);
				if (result == null) result = caseProcessBody(composition);
				if (result == null) result = caseSignalElement(composition);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.CONCATENATION: {
				Concatenation concatenation = (Concatenation)theEObject;
				T result = caseConcatenation(concatenation);
				if (result == null) result = caseBinaryOperators(concatenation);
				if (result == null) result = caseExprSignal(concatenation);
				if (result == null) result = caseConstantDescriptionValue(concatenation);
				if (result == null) result = caseExprParam(concatenation);
				if (result == null) result = caseSignalElement(concatenation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.CONDITIONED_DEPENDENCE: {
				ConditionedDependence conditionedDependence = (ConditionedDependence)theEObject;
				T result = caseConditionedDependence(conditionedDependence);
				if (result == null) result = caseDependences(conditionedDependence);
				if (result == null) result = caseExprProcess(conditionedDependence);
				if (result == null) result = caseProcessBody(conditionedDependence);
				if (result == null) result = caseSignalElement(conditionedDependence);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.CONSTANT: {
				Constant constant = (Constant)theEObject;
				T result = caseConstant(constant);
				if (result == null) result = caseExprSignal(constant);
				if (result == null) result = caseConstantDescriptionValue(constant);
				if (result == null) result = caseExprParam(constant);
				if (result == null) result = caseSignalElement(constant);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.CONSTANT_CHARACTER: {
				ConstantCharacter constantCharacter = (ConstantCharacter)theEObject;
				T result = caseConstantCharacter(constantCharacter);
				if (result == null) result = caseConstant(constantCharacter);
				if (result == null) result = caseExprSignal(constantCharacter);
				if (result == null) result = caseConstantDescriptionValue(constantCharacter);
				if (result == null) result = caseExprParam(constantCharacter);
				if (result == null) result = caseSignalElement(constantCharacter);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.CONSTANT_DEFINITION: {
				ConstantDefinition constantDefinition = (ConstantDefinition)theEObject;
				T result = caseConstantDefinition(constantDefinition);
				if (result == null) result = caseSignalElement(constantDefinition);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.CONSTANT_DESCRIPTION: {
				ConstantDescription constantDescription = (ConstantDescription)theEObject;
				T result = caseConstantDescription(constantDescription);
				if (result == null) result = caseConstantDefinition(constantDescription);
				if (result == null) result = caseSignalElement(constantDescription);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.CONSTANT_DESCRIPTION_VALUE: {
				ConstantDescriptionValue constantDescriptionValue = (ConstantDescriptionValue)theEObject;
				T result = caseConstantDescriptionValue(constantDescriptionValue);
				if (result == null) result = caseSignalElement(constantDescriptionValue);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.CONSTANT_DOUBLE_REAL: {
				ConstantDoubleReal constantDoubleReal = (ConstantDoubleReal)theEObject;
				T result = caseConstantDoubleReal(constantDoubleReal);
				if (result == null) result = caseConstant(constantDoubleReal);
				if (result == null) result = caseExprSignal(constantDoubleReal);
				if (result == null) result = caseConstantDescriptionValue(constantDoubleReal);
				if (result == null) result = caseExprParam(constantDoubleReal);
				if (result == null) result = caseSignalElement(constantDoubleReal);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.CONSTANT_ENUM: {
				ConstantEnum constantEnum = (ConstantEnum)theEObject;
				T result = caseConstantEnum(constantEnum);
				if (result == null) result = caseExprSignal(constantEnum);
				if (result == null) result = caseConstantDescriptionValue(constantEnum);
				if (result == null) result = caseExprParam(constantEnum);
				if (result == null) result = caseSignalElement(constantEnum);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.CONSTANT_INTEGER: {
				ConstantInteger constantInteger = (ConstantInteger)theEObject;
				T result = caseConstantInteger(constantInteger);
				if (result == null) result = caseConstant(constantInteger);
				if (result == null) result = caseExprSignal(constantInteger);
				if (result == null) result = caseConstantDescriptionValue(constantInteger);
				if (result == null) result = caseExprParam(constantInteger);
				if (result == null) result = caseSignalElement(constantInteger);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.CONSTANT_LOGICAL: {
				ConstantLogical constantLogical = (ConstantLogical)theEObject;
				T result = caseConstantLogical(constantLogical);
				if (result == null) result = caseConstant(constantLogical);
				if (result == null) result = caseExprSignal(constantLogical);
				if (result == null) result = caseConstantDescriptionValue(constantLogical);
				if (result == null) result = caseExprParam(constantLogical);
				if (result == null) result = caseSignalElement(constantLogical);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.CONSTANT_REAL: {
				ConstantReal constantReal = (ConstantReal)theEObject;
				T result = caseConstantReal(constantReal);
				if (result == null) result = caseConstant(constantReal);
				if (result == null) result = caseExprSignal(constantReal);
				if (result == null) result = caseConstantDescriptionValue(constantReal);
				if (result == null) result = caseExprParam(constantReal);
				if (result == null) result = caseSignalElement(constantReal);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.CONSTANTS_DECLARATION: {
				ConstantsDeclaration constantsDeclaration = (ConstantsDeclaration)theEObject;
				T result = caseConstantsDeclaration(constantsDeclaration);
				if (result == null) result = caseDeclaration(constantsDeclaration);
				if (result == null) result = caseSignalElement(constantsDeclaration);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.CONSTANT_STRING: {
				ConstantString constantString = (ConstantString)theEObject;
				T result = caseConstantString(constantString);
				if (result == null) result = caseSignalElement(constantString);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.CONVERSION: {
				Conversion conversion = (Conversion)theEObject;
				T result = caseConversion(conversion);
				if (result == null) result = caseExprSignal(conversion);
				if (result == null) result = caseConstantDescriptionValue(conversion);
				if (result == null) result = caseExprParam(conversion);
				if (result == null) result = caseSignalElement(conversion);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.CONTROLLED_PROCESS: {
				ControlledProcess controlledProcess = (ControlledProcess)theEObject;
				T result = caseControlledProcess(controlledProcess);
				if (result == null) result = caseExprProcess(controlledProcess);
				if (result == null) result = caseProcessBody(controlledProcess);
				if (result == null) result = caseSignalElement(controlledProcess);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.COUNT: {
				Count count = (Count)theEObject;
				T result = caseCount(count);
				if (result == null) result = caseBinaryOperators(count);
				if (result == null) result = caseExprSignal(count);
				if (result == null) result = caseConstantDescriptionValue(count);
				if (result == null) result = caseExprParam(count);
				if (result == null) result = caseSignalElement(count);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.DECLARATION: {
				Declaration declaration = (Declaration)theEObject;
				T result = caseDeclaration(declaration);
				if (result == null) result = caseSignalElement(declaration);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.DEFAULT: {
				Default default_ = (Default)theEObject;
				T result = caseDefault(default_);
				if (result == null) result = caseBinaryOperators(default_);
				if (result == null) result = caseExprSignal(default_);
				if (result == null) result = caseConstantDescriptionValue(default_);
				if (result == null) result = caseExprParam(default_);
				if (result == null) result = caseSignalElement(default_);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.DELAY: {
				Delay delay = (Delay)theEObject;
				T result = caseDelay(delay);
				if (result == null) result = caseTernaryOperators(delay);
				if (result == null) result = caseExprSignal(delay);
				if (result == null) result = caseConstantDescriptionValue(delay);
				if (result == null) result = caseExprParam(delay);
				if (result == null) result = caseSignalElement(delay);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.DEPENDENCES: {
				Dependences dependences = (Dependences)theEObject;
				T result = caseDependences(dependences);
				if (result == null) result = caseExprProcess(dependences);
				if (result == null) result = caseProcessBody(dependences);
				if (result == null) result = caseSignalElement(dependences);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.DESCRIBED_TYPE: {
				DescribedType describedType = (DescribedType)theEObject;
				T result = caseDescribedType(describedType);
				if (result == null) result = caseType(describedType);
				if (result == null) result = caseExprParam(describedType);
				if (result == null) result = caseTypeDescriptionValue(describedType);
				if (result == null) result = caseSignalElement(describedType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.DESCRIPTION: {
				Description description = (Description)theEObject;
				T result = caseDescription(description);
				if (result == null) result = caseSignalElement(description);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.DIV: {
				Div div = (Div)theEObject;
				T result = caseDiv(div);
				if (result == null) result = caseBinaryOperators(div);
				if (result == null) result = caseExprSignal(div);
				if (result == null) result = caseConstantDescriptionValue(div);
				if (result == null) result = caseExprParam(div);
				if (result == null) result = caseSignalElement(div);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.ELEM_DEFINITION: {
				ElemDefinition elemDefinition = (ElemDefinition)theEObject;
				T result = caseElemDefinition(elemDefinition);
				if (result == null) result = casePartialArrayDefinition(elemDefinition);
				if (result == null) result = caseSignalElement(elemDefinition);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.ELEM_DEFINITION_ENUMERATION: {
				ElemDefinitionEnumeration elemDefinitionEnumeration = (ElemDefinitionEnumeration)theEObject;
				T result = caseElemDefinitionEnumeration(elemDefinitionEnumeration);
				if (result == null) result = caseIterativeEnumeration(elemDefinitionEnumeration);
				if (result == null) result = caseExprSignal(elemDefinitionEnumeration);
				if (result == null) result = caseConstantDescriptionValue(elemDefinitionEnumeration);
				if (result == null) result = caseExprParam(elemDefinitionEnumeration);
				if (result == null) result = caseSignalElement(elemDefinitionEnumeration);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.ENUMERATION_TYPE: {
				EnumerationType enumerationType = (EnumerationType)theEObject;
				T result = caseEnumerationType(enumerationType);
				if (result == null) result = caseDescribedType(enumerationType);
				if (result == null) result = caseType(enumerationType);
				if (result == null) result = caseExprParam(enumerationType);
				if (result == null) result = caseTypeDescriptionValue(enumerationType);
				if (result == null) result = caseSignalElement(enumerationType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.EQUAL: {
				Equal equal = (Equal)theEObject;
				T result = caseEqual(equal);
				if (result == null) result = caseBinaryOperators(equal);
				if (result == null) result = caseExprSignal(equal);
				if (result == null) result = caseConstantDescriptionValue(equal);
				if (result == null) result = caseExprParam(equal);
				if (result == null) result = caseSignalElement(equal);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.EQUAL_EQUAL: {
				EqualEqual equalEqual = (EqualEqual)theEObject;
				T result = caseEqualEqual(equalEqual);
				if (result == null) result = caseBinaryOperators(equalEqual);
				if (result == null) result = caseExprSignal(equalEqual);
				if (result == null) result = caseConstantDescriptionValue(equalEqual);
				if (result == null) result = caseExprParam(equalEqual);
				if (result == null) result = caseSignalElement(equalEqual);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.EXPR_PARAM: {
				ExprParam exprParam = (ExprParam)theEObject;
				T result = caseExprParam(exprParam);
				if (result == null) result = caseSignalElement(exprParam);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.EXPR_PROCESS: {
				ExprProcess exprProcess = (ExprProcess)theEObject;
				T result = caseExprProcess(exprProcess);
				if (result == null) result = caseProcessBody(exprProcess);
				if (result == null) result = caseSignalElement(exprProcess);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.EXPR_SIGNAL: {
				ExprSignal exprSignal = (ExprSignal)theEObject;
				T result = caseExprSignal(exprSignal);
				if (result == null) result = caseConstantDescriptionValue(exprSignal);
				if (result == null) result = caseExprParam(exprSignal);
				if (result == null) result = caseSignalElement(exprSignal);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.EXTERNAL_ATTRIBUTE: {
				ExternalAttribute externalAttribute = (ExternalAttribute)theEObject;
				T result = caseExternalAttribute(externalAttribute);
				if (result == null) result = caseProcessBody(externalAttribute);
				if (result == null) result = caseTypeDescriptionValue(externalAttribute);
				if (result == null) result = caseConstantDescriptionValue(externalAttribute);
				if (result == null) result = caseSignalElement(externalAttribute);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.EXTERNAL_GRAPH: {
				ExternalGraph externalGraph = (ExternalGraph)theEObject;
				T result = caseExternalGraph(externalGraph);
				if (result == null) result = caseSignalElement(externalGraph);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.EXTERNAL_REFERENCES: {
				ExternalReferences externalReferences = (ExternalReferences)theEObject;
				T result = caseExternalReferences(externalReferences);
				if (result == null) result = caseDeclaration(externalReferences);
				if (result == null) result = caseSignalElement(externalReferences);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.FIELD_ACCESS: {
				FieldAccess fieldAccess = (FieldAccess)theEObject;
				T result = caseFieldAccess(fieldAccess);
				if (result == null) result = caseExprSignal(fieldAccess);
				if (result == null) result = caseConstantDescriptionValue(fieldAccess);
				if (result == null) result = caseExprParam(fieldAccess);
				if (result == null) result = caseSignalElement(fieldAccess);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.FORMAL_PROCESS: {
				FormalProcess formalProcess = (FormalProcess)theEObject;
				T result = caseFormalProcess(formalProcess);
				if (result == null) result = caseTypesOrSignalsDeclaration(formalProcess);
				if (result == null) result = caseDeclaration(formalProcess);
				if (result == null) result = caseSignalElement(formalProcess);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.FROM: {
				From from = (From)theEObject;
				T result = caseFrom(from);
				if (result == null) result = caseBinaryOperators(from);
				if (result == null) result = caseExprSignal(from);
				if (result == null) result = caseConstantDescriptionValue(from);
				if (result == null) result = caseExprParam(from);
				if (result == null) result = caseSignalElement(from);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.GRAPH_SPECIFICATION: {
				GraphSpecification graphSpecification = (GraphSpecification)theEObject;
				T result = caseGraphSpecification(graphSpecification);
				if (result == null) result = caseSignalElement(graphSpecification);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.GREATER: {
				Greater greater = (Greater)theEObject;
				T result = caseGreater(greater);
				if (result == null) result = caseBinaryOperators(greater);
				if (result == null) result = caseExprSignal(greater);
				if (result == null) result = caseConstantDescriptionValue(greater);
				if (result == null) result = caseExprParam(greater);
				if (result == null) result = caseSignalElement(greater);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.GREATER_OR_EQUAL: {
				GreaterOrEqual greaterOrEqual = (GreaterOrEqual)theEObject;
				T result = caseGreaterOrEqual(greaterOrEqual);
				if (result == null) result = caseBinaryOperators(greaterOrEqual);
				if (result == null) result = caseExprSignal(greaterOrEqual);
				if (result == null) result = caseConstantDescriptionValue(greaterOrEqual);
				if (result == null) result = caseExprParam(greaterOrEqual);
				if (result == null) result = caseSignalElement(greaterOrEqual);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.IDENTIFIER: {
				Identifier identifier = (Identifier)theEObject;
				T result = caseIdentifier(identifier);
				if (result == null) result = caseInterfaceDefinition(identifier);
				if (result == null) result = caseOperatorIdentifier(identifier);
				if (result == null) result = caseReferenceProcess(identifier);
				if (result == null) result = caseNullaryOperators(identifier);
				if (result == null) result = caseTypeDefinition(identifier);
				if (result == null) result = caseConstantDefinition(identifier);
				if (result == null) result = caseType(identifier);
				if (result == null) result = caseExprSignal(identifier);
				if (result == null) result = caseTypeDescriptionValue(identifier);
				if (result == null) result = caseConstantDescriptionValue(identifier);
				if (result == null) result = caseExprParam(identifier);
				if (result == null) result = caseSignalElement(identifier);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.IDENTITY_EQUATION: {
				IdentityEquation identityEquation = (IdentityEquation)theEObject;
				T result = caseIdentityEquation(identityEquation);
				if (result == null) result = caseExprProcess(identityEquation);
				if (result == null) result = caseProcessBody(identityEquation);
				if (result == null) result = caseSignalElement(identityEquation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.IF_THEN_ELSE: {
				IfThenElse ifThenElse = (IfThenElse)theEObject;
				T result = caseIfThenElse(ifThenElse);
				if (result == null) result = caseTernaryOperators(ifThenElse);
				if (result == null) result = caseExprSignal(ifThenElse);
				if (result == null) result = caseConstantDescriptionValue(ifThenElse);
				if (result == null) result = caseExprParam(ifThenElse);
				if (result == null) result = caseSignalElement(ifThenElse);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.INDEX: {
				Index index = (Index)theEObject;
				T result = caseIndex(index);
				if (result == null) result = caseTernaryOperators(index);
				if (result == null) result = caseExprSignal(index);
				if (result == null) result = caseConstantDescriptionValue(index);
				if (result == null) result = caseExprParam(index);
				if (result == null) result = caseSignalElement(index);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.INTERFACE_DEFINITION: {
				InterfaceDefinition interfaceDefinition = (InterfaceDefinition)theEObject;
				T result = caseInterfaceDefinition(interfaceDefinition);
				if (result == null) result = caseSignalElement(interfaceDefinition);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.IO_PROFILE: {
				IOProfile ioProfile = (IOProfile)theEObject;
				T result = caseIOProfile(ioProfile);
				if (result == null) result = caseSignalElement(ioProfile);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.ITERATION: {
				Iteration iteration = (Iteration)theEObject;
				T result = caseIteration(iteration);
				if (result == null) result = casePartialArrayDefinition(iteration);
				if (result == null) result = caseSignalElement(iteration);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.ITERATION_OF_PROCESSES: {
				IterationOfProcesses iterationOfProcesses = (IterationOfProcesses)theEObject;
				T result = caseIterationOfProcesses(iterationOfProcesses);
				if (result == null) result = caseExprProcess(iterationOfProcesses);
				if (result == null) result = caseProcessBody(iterationOfProcesses);
				if (result == null) result = caseSignalElement(iterationOfProcesses);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.ITERATION_PROCESS: {
				IterationProcess iterationProcess = (IterationProcess)theEObject;
				T result = caseIterationProcess(iterationProcess);
				if (result == null) result = caseIterationOfProcesses(iterationProcess);
				if (result == null) result = caseExprProcess(iterationProcess);
				if (result == null) result = caseProcessBody(iterationProcess);
				if (result == null) result = caseSignalElement(iterationProcess);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.ITERATIVE_ENUMERATION: {
				IterativeEnumeration iterativeEnumeration = (IterativeEnumeration)theEObject;
				T result = caseIterativeEnumeration(iterativeEnumeration);
				if (result == null) result = caseExprSignal(iterativeEnumeration);
				if (result == null) result = caseConstantDescriptionValue(iterativeEnumeration);
				if (result == null) result = caseExprParam(iterativeEnumeration);
				if (result == null) result = caseSignalElement(iterativeEnumeration);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.LABELLED_PROCESS: {
				LabelledProcess labelledProcess = (LabelledProcess)theEObject;
				T result = caseLabelledProcess(labelledProcess);
				if (result == null) result = caseExprProcess(labelledProcess);
				if (result == null) result = caseProcessBody(labelledProcess);
				if (result == null) result = caseSignalElement(labelledProcess);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.LABELS: {
				Labels labels = (Labels)theEObject;
				T result = caseLabels(labels);
				if (result == null) result = caseDeclaration(labels);
				if (result == null) result = caseSignalElement(labels);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.LESS: {
				Less less = (Less)theEObject;
				T result = caseLess(less);
				if (result == null) result = caseBinaryOperators(less);
				if (result == null) result = caseExprSignal(less);
				if (result == null) result = caseConstantDescriptionValue(less);
				if (result == null) result = caseExprParam(less);
				if (result == null) result = caseSignalElement(less);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.LESS_LESS_EQUAL: {
				LessLessEqual lessLessEqual = (LessLessEqual)theEObject;
				T result = caseLessLessEqual(lessLessEqual);
				if (result == null) result = caseBinaryOperators(lessLessEqual);
				if (result == null) result = caseExprSignal(lessLessEqual);
				if (result == null) result = caseConstantDescriptionValue(lessLessEqual);
				if (result == null) result = caseExprParam(lessLessEqual);
				if (result == null) result = caseSignalElement(lessLessEqual);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.LESS_OR_EQUAL: {
				LessOrEqual lessOrEqual = (LessOrEqual)theEObject;
				T result = caseLessOrEqual(lessOrEqual);
				if (result == null) result = caseBinaryOperators(lessOrEqual);
				if (result == null) result = caseExprSignal(lessOrEqual);
				if (result == null) result = caseConstantDescriptionValue(lessOrEqual);
				if (result == null) result = caseExprParam(lessOrEqual);
				if (result == null) result = caseSignalElement(lessOrEqual);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.LIST_EXPR_SIGNAL: {
				ListExprSignal listExprSignal = (ListExprSignal)theEObject;
				T result = caseListExprSignal(listExprSignal);
				if (result == null) result = caseSignalElement(listExprSignal);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.LIST_FLOWS: {
				ListFlows listFlows = (ListFlows)theEObject;
				T result = caseListFlows(listFlows);
				if (result == null) result = caseExprSignal(listFlows);
				if (result == null) result = caseConstantDescriptionValue(listFlows);
				if (result == null) result = caseExprParam(listFlows);
				if (result == null) result = caseSignalElement(listFlows);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.LIST_MODULE: {
				ListModule listModule = (ListModule)theEObject;
				T result = caseListModule(listModule);
				if (result == null) result = caseRootModel(listModule);
				if (result == null) result = caseSignalElement(listModule);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.MASKING: {
				Masking masking = (Masking)theEObject;
				T result = caseMasking(masking);
				if (result == null) result = caseExprProcess(masking);
				if (result == null) result = caseProcessBody(masking);
				if (result == null) result = caseSignalElement(masking);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.MINUS: {
				Minus minus = (Minus)theEObject;
				T result = caseMinus(minus);
				if (result == null) result = caseBinaryOperators(minus);
				if (result == null) result = caseExprSignal(minus);
				if (result == null) result = caseConstantDescriptionValue(minus);
				if (result == null) result = caseExprParam(minus);
				if (result == null) result = caseSignalElement(minus);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.MODULE: {
				Module module = (Module)theEObject;
				T result = caseModule(module);
				if (result == null) result = caseSignalElement(module);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.MODULE_DESCRIPTION: {
				ModuleDescription moduleDescription = (ModuleDescription)theEObject;
				T result = caseModuleDescription(moduleDescription);
				if (result == null) result = caseSignalElement(moduleDescription);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.MODULES_IMPORT: {
				ModulesImport modulesImport = (ModulesImport)theEObject;
				T result = caseModulesImport(modulesImport);
				if (result == null) result = caseDeclaration(modulesImport);
				if (result == null) result = caseSignalElement(modulesImport);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.MODULO: {
				Modulo modulo = (Modulo)theEObject;
				T result = caseModulo(modulo);
				if (result == null) result = caseBinaryOperators(modulo);
				if (result == null) result = caseExprSignal(modulo);
				if (result == null) result = caseConstantDescriptionValue(modulo);
				if (result == null) result = caseExprParam(modulo);
				if (result == null) result = caseSignalElement(modulo);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.NOT: {
				Not not = (Not)theEObject;
				T result = caseNot(not);
				if (result == null) result = caseUnaryOperators(not);
				if (result == null) result = caseExprSignal(not);
				if (result == null) result = caseConstantDescriptionValue(not);
				if (result == null) result = caseExprParam(not);
				if (result == null) result = caseSignalElement(not);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.NOT_EQUAL: {
				NotEqual notEqual = (NotEqual)theEObject;
				T result = caseNotEqual(notEqual);
				if (result == null) result = caseBinaryOperators(notEqual);
				if (result == null) result = caseExprSignal(notEqual);
				if (result == null) result = caseConstantDescriptionValue(notEqual);
				if (result == null) result = caseExprParam(notEqual);
				if (result == null) result = caseSignalElement(notEqual);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.NULLARY_OPERATORS: {
				NullaryOperators nullaryOperators = (NullaryOperators)theEObject;
				T result = caseNullaryOperators(nullaryOperators);
				if (result == null) result = caseExprSignal(nullaryOperators);
				if (result == null) result = caseConstantDescriptionValue(nullaryOperators);
				if (result == null) result = caseExprParam(nullaryOperators);
				if (result == null) result = caseSignalElement(nullaryOperators);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.NULL_CLOCK: {
				NullClock nullClock = (NullClock)theEObject;
				T result = caseNullClock(nullClock);
				if (result == null) result = caseNullaryOperators(nullClock);
				if (result == null) result = caseExprSignal(nullClock);
				if (result == null) result = caseConstantDescriptionValue(nullClock);
				if (result == null) result = caseExprParam(nullClock);
				if (result == null) result = caseSignalElement(nullClock);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.NULL_PROC: {
				NullProc nullProc = (NullProc)theEObject;
				T result = caseNullProc(nullProc);
				if (result == null) result = caseExprProcess(nullProc);
				if (result == null) result = caseProcessBody(nullProc);
				if (result == null) result = caseSignalElement(nullProc);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.OPERATOR: {
				Operator operator = (Operator)theEObject;
				T result = caseOperator(operator);
				if (result == null) result = caseOperatorIdentifier(operator);
				if (result == null) result = caseSignalElement(operator);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.OPERATOR_IDENTIFIER: {
				OperatorIdentifier operatorIdentifier = (OperatorIdentifier)theEObject;
				T result = caseOperatorIdentifier(operatorIdentifier);
				if (result == null) result = caseSignalElement(operatorIdentifier);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.OPERATOR_MODEL: {
				OperatorModel operatorModel = (OperatorModel)theEObject;
				T result = caseOperatorModel(operatorModel);
				if (result == null) result = caseProcessDeclaration(operatorModel);
				if (result == null) result = caseDeclaration(operatorModel);
				if (result == null) result = caseRootModel(operatorModel);
				if (result == null) result = caseSignalElement(operatorModel);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.OR: {
				Or or = (Or)theEObject;
				T result = caseOr(or);
				if (result == null) result = caseBinaryOperators(or);
				if (result == null) result = caseExprSignal(or);
				if (result == null) result = caseConstantDescriptionValue(or);
				if (result == null) result = caseExprParam(or);
				if (result == null) result = caseSignalElement(or);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.PARTIAL_ARRAY_DEFINITION: {
				PartialArrayDefinition partialArrayDefinition = (PartialArrayDefinition)theEObject;
				T result = casePartialArrayDefinition(partialArrayDefinition);
				if (result == null) result = caseSignalElement(partialArrayDefinition);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.PARTIAL_ITERATION: {
				PartialIteration partialIteration = (PartialIteration)theEObject;
				T result = casePartialIteration(partialIteration);
				if (result == null) result = caseSignalElement(partialIteration);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.PLUS: {
				Plus plus = (Plus)theEObject;
				T result = casePlus(plus);
				if (result == null) result = caseBinaryOperators(plus);
				if (result == null) result = caseExprSignal(plus);
				if (result == null) result = caseConstantDescriptionValue(plus);
				if (result == null) result = caseExprParam(plus);
				if (result == null) result = caseSignalElement(plus);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.POWER: {
				Power power = (Power)theEObject;
				T result = casePower(power);
				if (result == null) result = caseBinaryOperators(power);
				if (result == null) result = caseExprSignal(power);
				if (result == null) result = caseConstantDescriptionValue(power);
				if (result == null) result = caseExprParam(power);
				if (result == null) result = caseSignalElement(power);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.PRAGMA: {
				Pragma pragma = (Pragma)theEObject;
				T result = casePragma(pragma);
				if (result == null) result = caseSignalElement(pragma);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.PREDEFINED_TYPE: {
				PredefinedType predefinedType = (PredefinedType)theEObject;
				T result = casePredefinedType(predefinedType);
				if (result == null) result = caseDescribedType(predefinedType);
				if (result == null) result = caseType(predefinedType);
				if (result == null) result = caseExprParam(predefinedType);
				if (result == null) result = caseTypeDescriptionValue(predefinedType);
				if (result == null) result = caseSignalElement(predefinedType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.PREVIOUS_ITERATION_REF: {
				PreviousIterationRef previousIterationRef = (PreviousIterationRef)theEObject;
				T result = casePreviousIterationRef(previousIterationRef);
				if (result == null) result = caseUnaryOperators(previousIterationRef);
				if (result == null) result = caseExprSignal(previousIterationRef);
				if (result == null) result = caseConstantDescriptionValue(previousIterationRef);
				if (result == null) result = caseExprParam(previousIterationRef);
				if (result == null) result = caseSignalElement(previousIterationRef);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.PROCESS_ATTRIBUTE: {
				ProcessAttribute processAttribute = (ProcessAttribute)theEObject;
				T result = caseProcessAttribute(processAttribute);
				if (result == null) result = caseSignalElement(processAttribute);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.PROCESS_BODY: {
				ProcessBody processBody = (ProcessBody)theEObject;
				T result = caseProcessBody(processBody);
				if (result == null) result = caseSignalElement(processBody);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.PROCESS_CALL: {
				ProcessCall processCall = (ProcessCall)theEObject;
				T result = caseProcessCall(processCall);
				if (result == null) result = caseProcessCallOrAssert(processCall);
				if (result == null) result = caseProcessInstance(processCall);
				if (result == null) result = caseExprProcess(processCall);
				if (result == null) result = caseExprSignal(processCall);
				if (result == null) result = caseProcessBody(processCall);
				if (result == null) result = caseConstantDescriptionValue(processCall);
				if (result == null) result = caseExprParam(processCall);
				if (result == null) result = caseSignalElement(processCall);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.PROCESS_CALL_OR_ASSERT: {
				ProcessCallOrAssert processCallOrAssert = (ProcessCallOrAssert)theEObject;
				T result = caseProcessCallOrAssert(processCallOrAssert);
				if (result == null) result = caseProcessInstance(processCallOrAssert);
				if (result == null) result = caseExprProcess(processCallOrAssert);
				if (result == null) result = caseExprSignal(processCallOrAssert);
				if (result == null) result = caseProcessBody(processCallOrAssert);
				if (result == null) result = caseConstantDescriptionValue(processCallOrAssert);
				if (result == null) result = caseExprParam(processCallOrAssert);
				if (result == null) result = caseSignalElement(processCallOrAssert);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.PROCESS_DECLARATION: {
				ProcessDeclaration processDeclaration = (ProcessDeclaration)theEObject;
				T result = caseProcessDeclaration(processDeclaration);
				if (result == null) result = caseDeclaration(processDeclaration);
				if (result == null) result = caseRootModel(processDeclaration);
				if (result == null) result = caseSignalElement(processDeclaration);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.PROCESS_EXPANSION: {
				ProcessExpansion processExpansion = (ProcessExpansion)theEObject;
				T result = caseProcessExpansion(processExpansion);
				if (result == null) result = caseProcessInstance(processExpansion);
				if (result == null) result = caseReferenceProcess(processExpansion);
				if (result == null) result = caseExprProcess(processExpansion);
				if (result == null) result = caseExprSignal(processExpansion);
				if (result == null) result = caseProcessBody(processExpansion);
				if (result == null) result = caseConstantDescriptionValue(processExpansion);
				if (result == null) result = caseExprParam(processExpansion);
				if (result == null) result = caseSignalElement(processExpansion);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.PROCESS_INSTANCE: {
				ProcessInstance processInstance = (ProcessInstance)theEObject;
				T result = caseProcessInstance(processInstance);
				if (result == null) result = caseExprProcess(processInstance);
				if (result == null) result = caseExprSignal(processInstance);
				if (result == null) result = caseProcessBody(processInstance);
				if (result == null) result = caseConstantDescriptionValue(processInstance);
				if (result == null) result = caseExprParam(processInstance);
				if (result == null) result = caseSignalElement(processInstance);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.PROCESS_MODEL: {
				ProcessModel processModel = (ProcessModel)theEObject;
				T result = caseProcessModel(processModel);
				if (result == null) result = caseProcessDeclaration(processModel);
				if (result == null) result = caseDeclaration(processModel);
				if (result == null) result = caseRootModel(processModel);
				if (result == null) result = caseSignalElement(processModel);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.PROCESS_MODEL_INTERFACE: {
				ProcessModelInterface processModelInterface = (ProcessModelInterface)theEObject;
				T result = caseProcessModelInterface(processModelInterface);
				if (result == null) result = caseInterfaceDefinition(processModelInterface);
				if (result == null) result = caseSignalElement(processModelInterface);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.PROCESS_TYPE: {
				ProcessType processType = (ProcessType)theEObject;
				T result = caseProcessType(processType);
				if (result == null) result = caseTypeDefinition(processType);
				if (result == null) result = caseSignalElement(processType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.PRODUCT: {
				Product product = (Product)theEObject;
				T result = caseProduct(product);
				if (result == null) result = caseBinaryOperators(product);
				if (result == null) result = caseExprSignal(product);
				if (result == null) result = caseConstantDescriptionValue(product);
				if (result == null) result = caseExprParam(product);
				if (result == null) result = caseSignalElement(product);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.RECOVER: {
				Recover recover = (Recover)theEObject;
				T result = caseRecover(recover);
				if (result == null) result = caseBinaryOperators(recover);
				if (result == null) result = caseExprSignal(recover);
				if (result == null) result = caseConstantDescriptionValue(recover);
				if (result == null) result = caseExprParam(recover);
				if (result == null) result = caseSignalElement(recover);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.REFERENCE_PROCESS: {
				ReferenceProcess referenceProcess = (ReferenceProcess)theEObject;
				T result = caseReferenceProcess(referenceProcess);
				if (result == null) result = caseSignalElement(referenceProcess);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.REPETITION: {
				Repetition repetition = (Repetition)theEObject;
				T result = caseRepetition(repetition);
				if (result == null) result = caseBinaryOperators(repetition);
				if (result == null) result = caseExprSignal(repetition);
				if (result == null) result = caseConstantDescriptionValue(repetition);
				if (result == null) result = caseExprParam(repetition);
				if (result == null) result = caseSignalElement(repetition);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.RESTRICTION_PROCESS: {
				RestrictionProcess restrictionProcess = (RestrictionProcess)theEObject;
				T result = caseRestrictionProcess(restrictionProcess);
				if (result == null) result = caseExprProcess(restrictionProcess);
				if (result == null) result = caseProcessBody(restrictionProcess);
				if (result == null) result = caseSignalElement(restrictionProcess);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.ROOT_MODEL: {
				RootModel rootModel = (RootModel)theEObject;
				T result = caseRootModel(rootModel);
				if (result == null) result = caseSignalElement(rootModel);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.SEQUENTIAL_DEFINITION: {
				SequentialDefinition sequentialDefinition = (SequentialDefinition)theEObject;
				T result = caseSequentialDefinition(sequentialDefinition);
				if (result == null) result = caseBinaryOperators(sequentialDefinition);
				if (result == null) result = caseExprSignal(sequentialDefinition);
				if (result == null) result = caseConstantDescriptionValue(sequentialDefinition);
				if (result == null) result = caseExprParam(sequentialDefinition);
				if (result == null) result = caseSignalElement(sequentialDefinition);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.SHARED_VARIABLES_DECLARATION: {
				SharedVariablesDeclaration sharedVariablesDeclaration = (SharedVariablesDeclaration)theEObject;
				T result = caseSharedVariablesDeclaration(sharedVariablesDeclaration);
				if (result == null) result = caseDeclaration(sharedVariablesDeclaration);
				if (result == null) result = caseSignalElement(sharedVariablesDeclaration);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.SIGNAL_ELEMENT: {
				SignalElement signalElement = (SignalElement)theEObject;
				T result = caseSignalElement(signalElement);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.SIGNAL_NAMING: {
				SignalNaming signalNaming = (SignalNaming)theEObject;
				T result = caseSignalNaming(signalNaming);
				if (result == null) result = caseSignalElement(signalNaming);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.SIGNALS: {
				Signals signals = (Signals)theEObject;
				T result = caseSignals(signals);
				if (result == null) result = caseSignalElement(signals);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.SIGNALS_DECLARATION: {
				SignalsDeclaration signalsDeclaration = (SignalsDeclaration)theEObject;
				T result = caseSignalsDeclaration(signalsDeclaration);
				if (result == null) result = caseTypesOrSignalsDeclaration(signalsDeclaration);
				if (result == null) result = caseDeclaration(signalsDeclaration);
				if (result == null) result = caseSignalElement(signalsDeclaration);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.SIGNALS_DEFINITION: {
				SignalsDefinition signalsDefinition = (SignalsDefinition)theEObject;
				T result = caseSignalsDefinition(signalsDefinition);
				if (result == null) result = caseExprProcess(signalsDefinition);
				if (result == null) result = caseProcessBody(signalsDefinition);
				if (result == null) result = caseSignalElement(signalsDefinition);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.SIGNALS_PARTIAL_DEFAULT_DEFINITION: {
				SignalsPartialDefaultDefinition signalsPartialDefaultDefinition = (SignalsPartialDefaultDefinition)theEObject;
				T result = caseSignalsPartialDefaultDefinition(signalsPartialDefaultDefinition);
				if (result == null) result = caseExprProcess(signalsPartialDefaultDefinition);
				if (result == null) result = caseProcessBody(signalsPartialDefaultDefinition);
				if (result == null) result = caseSignalElement(signalsPartialDefaultDefinition);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.SIGNALS_PARTIAL_DEFINITION: {
				SignalsPartialDefinition signalsPartialDefinition = (SignalsPartialDefinition)theEObject;
				T result = caseSignalsPartialDefinition(signalsPartialDefinition);
				if (result == null) result = caseExprProcess(signalsPartialDefinition);
				if (result == null) result = caseProcessBody(signalsPartialDefinition);
				if (result == null) result = caseSignalElement(signalsPartialDefinition);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.STATE_VARIABLES_DECLARATION: {
				StateVariablesDeclaration stateVariablesDeclaration = (StateVariablesDeclaration)theEObject;
				T result = caseStateVariablesDeclaration(stateVariablesDeclaration);
				if (result == null) result = caseDeclaration(stateVariablesDeclaration);
				if (result == null) result = caseSignalElement(stateVariablesDeclaration);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.STATE_VARIABLE_VALUE: {
				StateVariableValue stateVariableValue = (StateVariableValue)theEObject;
				T result = caseStateVariableValue(stateVariableValue);
				if (result == null) result = caseExprSignal(stateVariableValue);
				if (result == null) result = caseConstantDescriptionValue(stateVariableValue);
				if (result == null) result = caseExprParam(stateVariableValue);
				if (result == null) result = caseSignalElement(stateVariableValue);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.STRING_VALUE: {
				StringValue stringValue = (StringValue)theEObject;
				T result = caseStringValue(stringValue);
				if (result == null) result = caseConstant(stringValue);
				if (result == null) result = caseExprSignal(stringValue);
				if (result == null) result = caseConstantDescriptionValue(stringValue);
				if (result == null) result = caseExprParam(stringValue);
				if (result == null) result = caseSignalElement(stringValue);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.TERNARY_OPERATORS: {
				TernaryOperators ternaryOperators = (TernaryOperators)theEObject;
				T result = caseTernaryOperators(ternaryOperators);
				if (result == null) result = caseExprSignal(ternaryOperators);
				if (result == null) result = caseConstantDescriptionValue(ternaryOperators);
				if (result == null) result = caseExprParam(ternaryOperators);
				if (result == null) result = caseSignalElement(ternaryOperators);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.TRANSPOSITION: {
				Transposition transposition = (Transposition)theEObject;
				T result = caseTransposition(transposition);
				if (result == null) result = caseUnaryOperators(transposition);
				if (result == null) result = caseExprSignal(transposition);
				if (result == null) result = caseConstantDescriptionValue(transposition);
				if (result == null) result = caseExprParam(transposition);
				if (result == null) result = caseSignalElement(transposition);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.TUPLE_TYPE: {
				TupleType tupleType = (TupleType)theEObject;
				T result = caseTupleType(tupleType);
				if (result == null) result = caseDescribedType(tupleType);
				if (result == null) result = caseType(tupleType);
				if (result == null) result = caseExprParam(tupleType);
				if (result == null) result = caseTypeDescriptionValue(tupleType);
				if (result == null) result = caseSignalElement(tupleType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.TYPE: {
				Type type = (Type)theEObject;
				T result = caseType(type);
				if (result == null) result = caseTypeDescriptionValue(type);
				if (result == null) result = caseSignalElement(type);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.TYPE_DEFINITION: {
				TypeDefinition typeDefinition = (TypeDefinition)theEObject;
				T result = caseTypeDefinition(typeDefinition);
				if (result == null) result = caseSignalElement(typeDefinition);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.TYPE_DESCRIPTION: {
				TypeDescription typeDescription = (TypeDescription)theEObject;
				T result = caseTypeDescription(typeDescription);
				if (result == null) result = caseTypeDefinition(typeDescription);
				if (result == null) result = caseSignalElement(typeDescription);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.TYPE_DESCRIPTION_VALUE: {
				TypeDescriptionValue typeDescriptionValue = (TypeDescriptionValue)theEObject;
				T result = caseTypeDescriptionValue(typeDescriptionValue);
				if (result == null) result = caseSignalElement(typeDescriptionValue);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.TYPE_MORPHISM: {
				TypeMorphism typeMorphism = (TypeMorphism)theEObject;
				T result = caseTypeMorphism(typeMorphism);
				if (result == null) result = caseTypeDefinition(typeMorphism);
				if (result == null) result = caseSignalElement(typeMorphism);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.TYPES_DECLARATION: {
				TypesDeclaration typesDeclaration = (TypesDeclaration)theEObject;
				T result = caseTypesDeclaration(typesDeclaration);
				if (result == null) result = caseTypesOrSignalsDeclaration(typesDeclaration);
				if (result == null) result = caseDeclaration(typesDeclaration);
				if (result == null) result = caseSignalElement(typesDeclaration);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.TYPES_OR_SIGNALS_DECLARATION: {
				TypesOrSignalsDeclaration typesOrSignalsDeclaration = (TypesOrSignalsDeclaration)theEObject;
				T result = caseTypesOrSignalsDeclaration(typesOrSignalsDeclaration);
				if (result == null) result = caseDeclaration(typesOrSignalsDeclaration);
				if (result == null) result = caseSignalElement(typesOrSignalsDeclaration);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.UNARY_MINUS: {
				UnaryMinus unaryMinus = (UnaryMinus)theEObject;
				T result = caseUnaryMinus(unaryMinus);
				if (result == null) result = caseUnaryOperators(unaryMinus);
				if (result == null) result = caseExprSignal(unaryMinus);
				if (result == null) result = caseConstantDescriptionValue(unaryMinus);
				if (result == null) result = caseExprParam(unaryMinus);
				if (result == null) result = caseSignalElement(unaryMinus);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.UNARY_PLUS: {
				UnaryPlus unaryPlus = (UnaryPlus)theEObject;
				T result = caseUnaryPlus(unaryPlus);
				if (result == null) result = caseUnaryOperators(unaryPlus);
				if (result == null) result = caseExprSignal(unaryPlus);
				if (result == null) result = caseConstantDescriptionValue(unaryPlus);
				if (result == null) result = caseExprParam(unaryPlus);
				if (result == null) result = caseSignalElement(unaryPlus);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.UNARY_OPERATORS: {
				UnaryOperators unaryOperators = (UnaryOperators)theEObject;
				T result = caseUnaryOperators(unaryOperators);
				if (result == null) result = caseExprSignal(unaryOperators);
				if (result == null) result = caseConstantDescriptionValue(unaryOperators);
				if (result == null) result = caseExprParam(unaryOperators);
				if (result == null) result = caseSignalElement(unaryOperators);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.UNARY_WHEN: {
				UnaryWhen unaryWhen = (UnaryWhen)theEObject;
				T result = caseUnaryWhen(unaryWhen);
				if (result == null) result = caseUnaryOperators(unaryWhen);
				if (result == null) result = caseExprSignal(unaryWhen);
				if (result == null) result = caseConstantDescriptionValue(unaryWhen);
				if (result == null) result = caseExprParam(unaryWhen);
				if (result == null) result = caseSignalElement(unaryWhen);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.UNCONDITIONED_DEPENDENCES: {
				UnconditionedDependences unconditionedDependences = (UnconditionedDependences)theEObject;
				T result = caseUnconditionedDependences(unconditionedDependences);
				if (result == null) result = caseDependences(unconditionedDependences);
				if (result == null) result = caseExprProcess(unconditionedDependences);
				if (result == null) result = caseProcessBody(unconditionedDependences);
				if (result == null) result = caseSignalElement(unconditionedDependences);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.VAR: {
				Var var = (Var)theEObject;
				T result = caseVar(var);
				if (result == null) result = caseBinaryOperators(var);
				if (result == null) result = caseExprSignal(var);
				if (result == null) result = caseConstantDescriptionValue(var);
				if (result == null) result = caseExprParam(var);
				if (result == null) result = caseSignalElement(var);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.WHEN: {
				When when = (When)theEObject;
				T result = caseWhen(when);
				if (result == null) result = caseBinaryOperators(when);
				if (result == null) result = caseExprSignal(when);
				if (result == null) result = caseConstantDescriptionValue(when);
				if (result == null) result = caseExprParam(when);
				if (result == null) result = caseSignalElement(when);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.WINDOW: {
				Window window = (Window)theEObject;
				T result = caseWindow(window);
				if (result == null) result = caseTernaryOperators(window);
				if (result == null) result = caseExprSignal(window);
				if (result == null) result = caseConstantDescriptionValue(window);
				if (result == null) result = caseExprParam(window);
				if (result == null) result = caseSignalElement(window);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SsmePackage.XOR: {
				Xor xor = (Xor)theEObject;
				T result = caseXor(xor);
				if (result == null) result = caseBinaryOperators(xor);
				if (result == null) result = caseExprSignal(xor);
				if (result == null) result = caseConstantDescriptionValue(xor);
				if (result == null) result = caseExprParam(xor);
				if (result == null) result = caseSignalElement(xor);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			default: return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>After</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>After</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAfter(After object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>And</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>And</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAnd(And object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Array Elem</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Array Elem</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseArrayElem(ArrayElem object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Array Elements Enumeration</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Array Elements Enumeration</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseArrayElementsEnumeration(ArrayElementsEnumeration object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Array Index</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Array Index</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseArrayIndex(ArrayIndex object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Array Process</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Array Process</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseArrayProcess(ArrayProcess object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Array Product</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Array Product</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseArrayProduct(ArrayProduct object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Array Restructuration</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Array Restructuration</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseArrayRestructuration(ArrayRestructuration object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Array Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Array Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseArrayType(ArrayType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Assert Process</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Assert Process</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAssertProcess(AssertProcess object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Assert Signal</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Assert Signal</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAssertSignal(AssertSignal object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Binary Operators</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Binary Operators</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseBinaryOperators(BinaryOperators object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Bounds</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Bounds</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseBounds(Bounds object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Cartesian Product</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Cartesian Product</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCartesianProduct(CartesianProduct object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Case Enumeration</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Case Enumeration</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCaseEnumeration(CaseEnumeration object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Case Expr Enumeration</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Case Expr Enumeration</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCaseExprEnumeration(CaseExprEnumeration object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Case Interval</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Case Interval</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCaseInterval(CaseInterval object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Case Process</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Case Process</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCaseProcess(CaseProcess object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Case Branch</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Case Branch</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCaseBranch(CaseBranch object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Cell</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Cell</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCell(Cell object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Clock</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Clock</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseClock(Clock object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Clock Difference</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Clock Difference</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseClockDifference(ClockDifference object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Clock Equality</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Clock Equality</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseClockEquality(ClockEquality object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Clock Exclusive Relation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Clock Exclusive Relation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseClockExclusiveRelation(ClockExclusiveRelation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Clock Inf Relation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Clock Inf Relation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseClockInfRelation(ClockInfRelation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Clock Product</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Clock Product</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseClockProduct(ClockProduct object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Clock Sup Relation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Clock Sup Relation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseClockSupRelation(ClockSupRelation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Clock Union</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Clock Union</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseClockUnion(ClockUnion object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Comment</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Comment</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseComment(Comment object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Complex Constructor</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Complex Constructor</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseComplexConstructor(ComplexConstructor object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Composition</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Composition</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseComposition(Composition object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Concatenation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Concatenation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseConcatenation(Concatenation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Conditioned Dependence</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Conditioned Dependence</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseConditionedDependence(ConditionedDependence object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Constant</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Constant</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseConstant(Constant object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Constant Character</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Constant Character</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseConstantCharacter(ConstantCharacter object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Constant Definition</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Constant Definition</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseConstantDefinition(ConstantDefinition object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Constant Description</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Constant Description</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseConstantDescription(ConstantDescription object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Constant Description Value</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Constant Description Value</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseConstantDescriptionValue(ConstantDescriptionValue object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Constant Double Real</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Constant Double Real</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseConstantDoubleReal(ConstantDoubleReal object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Constant Enum</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Constant Enum</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseConstantEnum(ConstantEnum object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Constant Integer</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Constant Integer</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseConstantInteger(ConstantInteger object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Constant Logical</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Constant Logical</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseConstantLogical(ConstantLogical object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Constant Real</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Constant Real</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseConstantReal(ConstantReal object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Constants Declaration</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Constants Declaration</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseConstantsDeclaration(ConstantsDeclaration object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Constant String</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Constant String</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseConstantString(ConstantString object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Conversion</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Conversion</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseConversion(Conversion object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Count</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Count</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCount(Count object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Declaration</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Declaration</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDeclaration(Declaration object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Default</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Default</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDefault(Default object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Delay</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Delay</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDelay(Delay object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Dependences</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Dependences</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDependences(Dependences object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Described Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Described Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDescribedType(DescribedType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Description</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Description</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDescription(Description object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Div</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Div</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDiv(Div object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Elem Definition</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Elem Definition</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseElemDefinition(ElemDefinition object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Elem Definition Enumeration</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Elem Definition Enumeration</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseElemDefinitionEnumeration(ElemDefinitionEnumeration object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Enumeration Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Enumeration Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseEnumerationType(EnumerationType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Equal</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Equal</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseEqual(Equal object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Equal Equal</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Equal Equal</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseEqualEqual(EqualEqual object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Expr Param</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Expr Param</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseExprParam(ExprParam object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Expr Process</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Expr Process</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseExprProcess(ExprProcess object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Expr Signal</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Expr Signal</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseExprSignal(ExprSignal object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>External Attribute</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>External Attribute</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseExternalAttribute(ExternalAttribute object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>External Graph</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>External Graph</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseExternalGraph(ExternalGraph object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>External References</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>External References</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseExternalReferences(ExternalReferences object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Field Access</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Field Access</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseFieldAccess(FieldAccess object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Formal Process</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Formal Process</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseFormalProcess(FormalProcess object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>From</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>From</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseFrom(From object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Graph Specification</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Graph Specification</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseGraphSpecification(GraphSpecification object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Greater</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Greater</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseGreater(Greater object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Greater Or Equal</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Greater Or Equal</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseGreaterOrEqual(GreaterOrEqual object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Identifier</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Identifier</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIdentifier(Identifier object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Identity Equation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Identity Equation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIdentityEquation(IdentityEquation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>If Then Else</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>If Then Else</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfThenElse(IfThenElse object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Index</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Index</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIndex(Index object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Interface Definition</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Interface Definition</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseInterfaceDefinition(InterfaceDefinition object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>IO Profile</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>IO Profile</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIOProfile(IOProfile object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Iteration</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Iteration</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIteration(Iteration object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Iteration Of Processes</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Iteration Of Processes</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIterationOfProcesses(IterationOfProcesses object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Iteration Process</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Iteration Process</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIterationProcess(IterationProcess object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Iterative Enumeration</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Iterative Enumeration</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIterativeEnumeration(IterativeEnumeration object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Labelled Process</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Labelled Process</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseLabelledProcess(LabelledProcess object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Labels</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Labels</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseLabels(Labels object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Less</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Less</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseLess(Less object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Less Less Equal</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Less Less Equal</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseLessLessEqual(LessLessEqual object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Less Or Equal</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Less Or Equal</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseLessOrEqual(LessOrEqual object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>List Expr Signal</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>List Expr Signal</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseListExprSignal(ListExprSignal object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>List Flows</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>List Flows</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseListFlows(ListFlows object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>List Module</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>List Module</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseListModule(ListModule object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Masking</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Masking</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseMasking(Masking object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Minus</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Minus</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseMinus(Minus object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Module</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Module</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseModule(Module object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Module Description</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Module Description</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseModuleDescription(ModuleDescription object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Modules Import</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Modules Import</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseModulesImport(ModulesImport object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Modulo</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Modulo</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseModulo(Modulo object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Not</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Not</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseNot(Not object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Not Equal</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Not Equal</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseNotEqual(NotEqual object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Nullary Operators</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Nullary Operators</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseNullaryOperators(NullaryOperators object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Null Clock</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Null Clock</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseNullClock(NullClock object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Null Proc</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Null Proc</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseNullProc(NullProc object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Operator</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Operator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseOperator(Operator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Operator Identifier</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Operator Identifier</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseOperatorIdentifier(OperatorIdentifier object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Operator Model</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Operator Model</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseOperatorModel(OperatorModel object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Or</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Or</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseOr(Or object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Partial Array Definition</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Partial Array Definition</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePartialArrayDefinition(PartialArrayDefinition object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Partial Iteration</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Partial Iteration</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePartialIteration(PartialIteration object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Plus</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Plus</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePlus(Plus object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Power</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Power</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePower(Power object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Pragma</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Pragma</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePragma(Pragma object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Predefined Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Predefined Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePredefinedType(PredefinedType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Previous Iteration Ref</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Previous Iteration Ref</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePreviousIterationRef(PreviousIterationRef object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Process Attribute</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Process Attribute</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseProcessAttribute(ProcessAttribute object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Process Body</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Process Body</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseProcessBody(ProcessBody object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Process Call</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Process Call</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseProcessCall(ProcessCall object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Process Call Or Assert</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Process Call Or Assert</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseProcessCallOrAssert(ProcessCallOrAssert object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Process Declaration</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Process Declaration</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseProcessDeclaration(ProcessDeclaration object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Process Expansion</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Process Expansion</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseProcessExpansion(ProcessExpansion object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Process Instance</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Process Instance</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseProcessInstance(ProcessInstance object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Process Model</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Process Model</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseProcessModel(ProcessModel object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Process Model Interface</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Process Model Interface</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseProcessModelInterface(ProcessModelInterface object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Process Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Process Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseProcessType(ProcessType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Product</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Product</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseProduct(Product object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Recover</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Recover</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRecover(Recover object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Reference Process</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Reference Process</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseReferenceProcess(ReferenceProcess object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Repetition</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Repetition</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRepetition(Repetition object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Restriction Process</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Restriction Process</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRestrictionProcess(RestrictionProcess object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Root Model</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Root Model</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRootModel(RootModel object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Sequential Definition</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Sequential Definition</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSequentialDefinition(SequentialDefinition object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Shared Variables Declaration</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Shared Variables Declaration</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSharedVariablesDeclaration(SharedVariablesDeclaration object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Signal Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Signal Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSignalElement(SignalElement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Signal Naming</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Signal Naming</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSignalNaming(SignalNaming object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Signals</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Signals</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSignals(Signals object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Signals Declaration</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Signals Declaration</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSignalsDeclaration(SignalsDeclaration object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Signals Definition</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Signals Definition</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSignalsDefinition(SignalsDefinition object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Signals Partial Default Definition</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Signals Partial Default Definition</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSignalsPartialDefaultDefinition(SignalsPartialDefaultDefinition object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Signals Partial Definition</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Signals Partial Definition</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSignalsPartialDefinition(SignalsPartialDefinition object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>State Variables Declaration</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>State Variables Declaration</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseStateVariablesDeclaration(StateVariablesDeclaration object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>State Variable Value</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>State Variable Value</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseStateVariableValue(StateVariableValue object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>String Value</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>String Value</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseStringValue(StringValue object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ternary Operators</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ternary Operators</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTernaryOperators(TernaryOperators object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Transposition</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Transposition</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTransposition(Transposition object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Tuple Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Tuple Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTupleType(TupleType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseType(Type object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Type Definition</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Type Definition</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTypeDefinition(TypeDefinition object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Type Description</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Type Description</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTypeDescription(TypeDescription object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Type Description Value</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Type Description Value</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTypeDescriptionValue(TypeDescriptionValue object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Type Morphism</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Type Morphism</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTypeMorphism(TypeMorphism object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Types Declaration</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Types Declaration</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTypesDeclaration(TypesDeclaration object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Types Or Signals Declaration</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Types Or Signals Declaration</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTypesOrSignalsDeclaration(TypesOrSignalsDeclaration object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Unary Minus</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Unary Minus</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseUnaryMinus(UnaryMinus object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Unary Plus</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Unary Plus</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseUnaryPlus(UnaryPlus object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Unary Operators</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Unary Operators</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseUnaryOperators(UnaryOperators object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Unary When</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Unary When</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseUnaryWhen(UnaryWhen object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Unconditioned Dependences</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Unconditioned Dependences</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseUnconditionedDependences(UnconditionedDependences object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Var</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Var</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseVar(Var object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>When</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>When</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseWhen(When object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Window</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Window</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseWindow(Window object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Xor</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Xor</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseXor(Xor object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Controlled Process</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Controlled Process</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseControlledProcess(ControlledProcess object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	@Override
	public T defaultCase(EObject object) {
		return null;
	}

} //SsmeSwitch
