/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pop.ssme.compilation.utils.popup.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.pop.ssme.compilation.utils.jobs.CompilingMethods;
import org.eclipse.pop.ssme.compilation.utils.popup.actions.CompilationUtils;
import org.eclipse.pop.ssme.polychrony.GraphValue;
import org.eclipse.pop.ssme.polychrony.PkPlugin;
import org.eclipse.pop.ssme.polychrony.utils.PolychronyConsole;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class InteractiveCompiling {
    private boolean clustersApplied;
    private boolean abstractionApplied;

    public InteractiveCompiling(final CompilingMethods compilingMethods, final long finalTree, IFile sourceFile, final GraphValue graphValue, final CompilationUtils compilationUtils) {
        Display display = Display.getCurrent();
        IPath fileLocation = sourceFile.getLocation();
        final IPath fileDirectory = fileLocation.removeFileExtension();
        final Shell shell = new Shell(display);
        shell.setLayout((Layout)new GridLayout());
        shell.setText("Interactive Compilation");
        Group groupOptions = this.createGroup(shell, "General Options");
        final Button events2BooleansButton = this.createButton(groupOptions, "Events To Booleans");
        final Button unificationButton = this.createButton(groupOptions, "Signals Unification");
        final Button flatteningButton = this.createButton(groupOptions, "Flattening");
        final Button clockCalculusButton = this.createButton(groupOptions, "Clock Calculus");
        final Button sequentializingButton = this.createButton(groupOptions, "Sequentializing");
        final Button retimingButton = this.createButton(groupOptions, "Retiming");
        final Button boolean2EventsButton = this.createButton(groupOptions, "Booleans To Events");
        final Button abstractionButton = this.createButton(groupOptions, "Abstraction");
        final Button sequentialClusteringButton = this.createButton(groupOptions, "Sequential Clustering");
        final Button profilingButton = this.createButton(groupOptions, "Profiling");
        Group groupExportTools = this.createGroup(shell, "Export Tools");
        final Button lustreButton = this.createButton(groupExportTools, "Lustre Generation");
        final Button syndexButton = this.createButton(groupExportTools, "Syndex Generation");
        Button sigaliGenButton = this.createButton(groupExportTools, "Z/3Z - Sigali");
        Group groupGeneration = this.createGroup(shell, "Code Generation");
        final Button cGenButton = this.createButton(groupGeneration, "C Generation");
        final Button cppGenButton = this.createButton(groupGeneration, "C++ Generation");
        final Button javaGenButton = this.createButton(groupGeneration, "Java Generation");
        Group groupSignalForms = this.createGroup(shell, "Signal Forms");
        Button signalGenButton = this.createButton(groupSignalForms, "Signal Generation");
        Button signalLISGenButton = this.createButton(groupSignalForms, "Signal LIS Generation");
        Button signalTRAGenButton = this.createButton(groupSignalForms, "Signal TRA Generation");
        final Button signalAbstractionButton = this.createButton(groupSignalForms, "Signal Abstraction");
        Button ssmeGenButton = this.createButton(groupSignalForms, "SSME Generation");
        Button quitButton = new Button((Composite)shell, 8);
        quitButton.setText("Quit");
        GridData gridDataQuitButton = new GridData();
        gridDataQuitButton.horizontalAlignment = 4;
        quitButton.setLayoutData((Object)gridDataQuitButton);
        if (sourceFile.getFileExtension().equalsIgnoreCase("ssme")) {
            ssmeGenButton.setEnabled(false);
        } else if (sourceFile.getFileExtension().equalsIgnoreCase("sig")) {
            signalGenButton.setEnabled(false);
        }
        sequentialClusteringButton.setEnabled(false);
        sequentializingButton.setEnabled(false);
        flatteningButton.setEnabled(false);
        cGenButton.setEnabled(false);
        cppGenButton.setEnabled(false);
        javaGenButton.setEnabled(false);
        profilingButton.setEnabled(false);
        lustreButton.setEnabled(false);
        syndexButton.setEnabled(false);
        signalAbstractionButton.setEnabled(false);
        events2BooleansButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (e.type == 13) {
                    IStatus status = compilingMethods.DCGPoly2DCGBool(graphValue);
                    if (!status.equals(Status.OK_STATUS)) {
                        PolychronyConsole.printDetectedError((String)status.getMessage());
                    } else {
                        retimingButton.setEnabled(false);
                        boolean2EventsButton.setEnabled(false);
                        unificationButton.setEnabled(false);
                        clockCalculusButton.setEnabled(false);
                        events2BooleansButton.setEnabled(false);
                        abstractionButton.setEnabled(false);
                        sequentialClusteringButton.setEnabled(true);
                        sequentializingButton.setEnabled(true);
                        flatteningButton.setEnabled(true);
                        profilingButton.setEnabled(true);
                    }
                }
            }
        });
        unificationButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                IStatus status;
                if (e.type == 13 && InteractiveCompiling.this.isActionOk(status = compilingMethods.unify(graphValue))) {
                    unificationButton.setEnabled(false);
                }
            }
        });
        flatteningButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                IStatus status;
                if (e.type == 13 && InteractiveCompiling.this.isActionOk(status = compilingMethods.Flattening(graphValue))) {
                    sequentializingButton.setEnabled(false);
                    flatteningButton.setEnabled(false);
                    syndexButton.setEnabled(true);
                }
            }
        });
        clockCalculusButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                IStatus status;
                if (e.type == 13 && InteractiveCompiling.this.isActionOk(status = compilingMethods.clockCalculus(graphValue))) {
                    clockCalculusButton.setEnabled(false);
                }
            }
        });
        sequentializingButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                IStatus status;
                if (e.type == 13 && InteractiveCompiling.this.isActionOk(status = compilingMethods.sequentializing(graphValue, finalTree, InteractiveCompiling.this.clustersApplied))) {
                    sequentialClusteringButton.setEnabled(false);
                    sequentializingButton.setEnabled(false);
                    flatteningButton.setEnabled(false);
                    cGenButton.setEnabled(true);
                    cppGenButton.setEnabled(true);
                    javaGenButton.setEnabled(true);
                    lustreButton.setEnabled(true);
                }
            }
        });
        retimingButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                IStatus status;
                if (e.type == 13 && InteractiveCompiling.this.isActionOk(status = compilingMethods.retiming(graphValue))) {
                    retimingButton.setEnabled(false);
                }
            }
        });
        boolean2EventsButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                IStatus status;
                if (e.type == 13 && InteractiveCompiling.this.isActionOk(status = compilingMethods.boolean2Events(graphValue))) {
                    boolean2EventsButton.setEnabled(false);
                }
            }
        });
        abstractionButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (e.type == 13) {
                    InteractiveCompiling.this.abstractionApplied = true;
                    IStatus status = compilingMethods.abstraction(graphValue);
                    if (InteractiveCompiling.this.isActionOk(status)) {
                        retimingButton.setEnabled(false);
                        boolean2EventsButton.setEnabled(false);
                        unificationButton.setEnabled(false);
                        clockCalculusButton.setEnabled(false);
                        events2BooleansButton.setEnabled(false);
                        abstractionButton.setEnabled(false);
                        sequentialClusteringButton.setEnabled(true);
                        sequentializingButton.setEnabled(true);
                        flatteningButton.setEnabled(true);
                        profilingButton.setEnabled(true);
                        signalAbstractionButton.setEnabled(true);
                    }
                }
            }
        });
        sequentialClusteringButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (e.type == 13) {
                    IStatus status = compilingMethods.cluster(graphValue);
                    if (InteractiveCompiling.this.isActionOk(status)) {
                        sequentialClusteringButton.setEnabled(false);
                    }
                    InteractiveCompiling.this.clustersApplied = status.isOK();
                }
            }
        });
        profilingButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (e.type == 13) {
                    IStatus status = compilingMethods.generateProfiling(graphValue.getGraph());
                    InteractiveCompiling.this.endActionrefreshContent(compilationUtils, status);
                }
            }
        });
        lustreButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (e.type == 13) {
                    IStatus status = compilingMethods.generateLustre(graphValue.getGraph());
                    InteractiveCompiling.this.endActionrefreshContent(compilationUtils, status);
                }
            }
        });
        syndexButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (e.type == 13) {
                    IStatus status = compilingMethods.generateSyndex(graphValue.getGraph());
                    InteractiveCompiling.this.endActionrefreshContent(compilationUtils, status);
                }
            }
        });
        sigaliGenButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (e.type == 13) {
                    IStatus status = compilingMethods.generateSigali(graphValue.getGraph());
                    InteractiveCompiling.this.endActionrefreshContent(compilationUtils, status);
                }
            }
        });
        cGenButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (e.type == 13) {
                    IStatus status = compilingMethods.generateC(graphValue.getGraph(), InteractiveCompiling.this.abstractionApplied);
                    InteractiveCompiling.this.endActionrefreshContent(compilationUtils, status);
                }
            }
        });
        cppGenButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (e.type == 13) {
                    IStatus status = compilingMethods.generateCPP(graphValue.getGraph(), InteractiveCompiling.this.abstractionApplied);
                    InteractiveCompiling.this.endActionrefreshContent(compilationUtils, status);
                }
            }
        });
        javaGenButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (e.type == 13) {
                    IStatus status = compilingMethods.generateJava(graphValue.getGraph(), fileDirectory, InteractiveCompiling.this.abstractionApplied, compilationUtils);
                    InteractiveCompiling.this.endActionrefreshContent(compilationUtils, status);
                }
            }
        });
        signalGenButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (e.type == 13) {
                    IStatus status = compilingMethods.generateSignal(finalTree, fileDirectory);
                    InteractiveCompiling.this.endActionrefreshContent(compilationUtils, status);
                }
            }
        });
        signalLISGenButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (e.type == 13) {
                    IStatus status = compilingMethods.generateSignalLIS(finalTree);
                    InteractiveCompiling.this.endActionrefreshContent(compilationUtils, status);
                }
            }
        });
        signalTRAGenButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (e.type == 13) {
                    IStatus status = compilingMethods.generateSignalTRA(graphValue.getGraph());
                    InteractiveCompiling.this.endActionrefreshContent(compilationUtils, status);
                }
            }
        });
        signalAbstractionButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (e.type == 13) {
                    IStatus status = compilingMethods.generateSignalAbstraction(graphValue.getGraph());
                    InteractiveCompiling.this.endActionrefreshContent(compilationUtils, status);
                }
            }
        });
        ssmeGenButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (e.type == 13) {
                    IStatus status = compilingMethods.generateSSME(finalTree, fileDirectory);
                    InteractiveCompiling.this.endActionrefreshContent(compilationUtils, status);
                }
            }
        });
        quitButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (e.type == 13) {
                    PkPlugin.getServices().setEnv("SIGNAL_LIBRARY_PATH", compilationUtils.getSaveLibraryPath());
                    shell.dispose();
                }
            }
        });
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    protected boolean isActionOk(IStatus status) {
        if (status.equals(Status.OK_STATUS)) {
            return true;
        }
        PolychronyConsole.printDetectedError((String)status.getMessage());
        return false;
    }

    protected void endActionrefreshContent(CompilationUtils compilationUtils, IStatus status) {
        if (this.isActionOk(status)) {
            compilationUtils.refreshContent();
        }
    }

    public Button createButton(Group group, String buttonName) {
        Button button = new Button((Composite)group, 8);
        button.setText(buttonName);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)gridData);
        return button;
    }

    public Group createGroup(Shell shell, String groupName) {
        Group group = new Group((Composite)shell, 0);
        group.setLayout((Layout)new GridLayout(2, true));
        group.setText(groupName);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        group.setLayoutData((Object)gridData);
        return group;
    }
}

