/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pop.ssme.compilation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum GeneratorKind implements Enumerator
{
    SIGNAL_LITERAL(0, "Signal", "Signal Textual (SIG)"),
    SIGNAL_LIS_LITERAL(1, "Signal_LIS", "Signal Textual (LIS)"),
    SIGNAL_TRA_LITERAL(2, "Signal_TRA", "Signal Textual (TRA)"),
    SSME_LITERAL(3, "Ssme", "Signal Model (SSME)"),
    SIGNAL_ABSTRACTION_LITERAL(4, "SignalAbstraction", "Signal Abstraction"),
    SIGALI_LITERAL(5, "Sigali", "Sigali"),
    CANSI_LITERAL(6, "C_ANSI", "C ANSI"),
    CPP_LITERAL(7, "CPP", "C++"),
    JAVA_LITERAL(8, "Java", "Java"),
    PROFILING_LITERAL(9, "Profiling", "Profiling"),
    LUSTRE_LITERAL(10, "Lustre", "Lustre"),
    SYNDEX_LITERAL(11, "Syndex", "SynDEx");

    public static final int SIGNAL = 0;
    public static final int SIGNAL_LIS = 1;
    public static final int SIGNAL_TRA = 2;
    public static final int SSME = 3;
    public static final int SIGNAL_ABSTRACTION = 4;
    public static final int SIGALI = 5;
    public static final int CANSI = 6;
    public static final int CPP = 7;
    public static final int JAVA = 8;
    public static final int PROFILING = 9;
    public static final int LUSTRE = 10;
    public static final int SYNDEX = 11;
    public static final int SME = 12;
    private static final GeneratorKind[] VALUES_ARRAY;
    public static final List<GeneratorKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new GeneratorKind[]{SIGNAL_LITERAL, SIGNAL_LIS_LITERAL, SIGNAL_TRA_LITERAL, SSME_LITERAL, SIGNAL_ABSTRACTION_LITERAL, SIGALI_LITERAL, CANSI_LITERAL, CPP_LITERAL, JAVA_LITERAL, PROFILING_LITERAL, LUSTRE_LITERAL, SYNDEX_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static GeneratorKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            GeneratorKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static GeneratorKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            GeneratorKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static GeneratorKind get(int value) {
        switch (value) {
            case 0: {
                return SIGNAL_LITERAL;
            }
            case 1: {
                return SIGNAL_LIS_LITERAL;
            }
            case 2: {
                return SIGNAL_TRA_LITERAL;
            }
            case 3: {
                return SSME_LITERAL;
            }
            case 4: {
                return SIGNAL_ABSTRACTION_LITERAL;
            }
            case 5: {
                return SIGALI_LITERAL;
            }
            case 6: {
                return CANSI_LITERAL;
            }
            case 7: {
                return CPP_LITERAL;
            }
            case 8: {
                return JAVA_LITERAL;
            }
            case 9: {
                return PROFILING_LITERAL;
            }
            case 10: {
                return LUSTRE_LITERAL;
            }
            case 11: {
                return SYNDEX_LITERAL;
            }
        }
        return null;
    }

    private GeneratorKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

