/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pop.ssme.polychrony;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ExitStatus implements Enumerator
{
    NO_ERROR_LITERAL(0, "NoError", "No Error"),
    OPTION_ERROR_LITERAL(-3, "OptionError", "Option error"),
    NO_ARGS_LITERAL(-2, "NoArgs", "Missing argument"),
    NO_FILE_LITERAL(-1, "NoFile", "Missing file argument"),
    INIT_ERROR_LITERAL(1, "InitError", "Error during the initialization (library not found,...)"),
    SYNTAX_ERROR_PROG_LITERAL(2, "SyntaxeErrorProg", "Syntax error in the program"),
    SYNTAX_ERROR_PARAM_LITERAL(3, "SyntaxeErrorParam", "Syntax error for the parameters"),
    SOLVING_REF_ERROR_LITERAL(4, "SolvingRefError", "Error during the solving reference step"),
    TYPE_ERROR_LITERAL(5, "TypeError", "Program not well typed"),
    CYCLE_LITERAL(6, "Cycle", "Program with cycles"),
    PROFILING_ERROR_LITERAL(7, "ProfilingError", "Error during the profiling functionality"),
    ABSTRACTION_ERROR_LITERAL(8, "AbstractionError", "Error during the abstraction functionality"),
    INTERNAL_ERROR_LITERAL(9999, "InternalError", "Error inside the native part compiler");

    public static final int NO_ERROR = 0;
    public static final int OPTION_ERROR = -3;
    public static final int NO_ARGS = -2;
    public static final int NO_FILE = -1;
    public static final int INIT_ERROR = 1;
    public static final int SYNTAX_ERROR_PROG = 2;
    public static final int SYNTAX_ERROR_PARAM = 3;
    public static final int SOLVING_REF_ERROR = 4;
    public static final int TYPE_ERROR = 5;
    public static final int CYCLE = 6;
    public static final int PROFILING_ERROR = 7;
    public static final int ABSTRACTION_ERROR = 8;
    public static final int INTERNAL_ERROR = 9999;
    private static final ExitStatus[] VALUES_ARRAY;
    public static final List<ExitStatus> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ExitStatus[]{NO_ERROR_LITERAL, OPTION_ERROR_LITERAL, NO_ARGS_LITERAL, NO_FILE_LITERAL, INIT_ERROR_LITERAL, SYNTAX_ERROR_PROG_LITERAL, SYNTAX_ERROR_PARAM_LITERAL, SOLVING_REF_ERROR_LITERAL, TYPE_ERROR_LITERAL, CYCLE_LITERAL, PROFILING_ERROR_LITERAL, ABSTRACTION_ERROR_LITERAL, INTERNAL_ERROR_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ExitStatus get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ExitStatus result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ExitStatus getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ExitStatus result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ExitStatus get(int value) {
        switch (value) {
            case -3: {
                return OPTION_ERROR_LITERAL;
            }
            case -2: {
                return NO_ARGS_LITERAL;
            }
            case -1: {
                return NO_FILE_LITERAL;
            }
            case 1: {
                return INIT_ERROR_LITERAL;
            }
            case 2: {
                return SYNTAX_ERROR_PROG_LITERAL;
            }
            case 3: {
                return SYNTAX_ERROR_PARAM_LITERAL;
            }
            case 4: {
                return SOLVING_REF_ERROR_LITERAL;
            }
            case 5: {
                return TYPE_ERROR_LITERAL;
            }
            case 6: {
                return CYCLE_LITERAL;
            }
            case 7: {
                return PROFILING_ERROR_LITERAL;
            }
            case 8: {
                return ABSTRACTION_ERROR_LITERAL;
            }
            case 9999: {
                return INTERNAL_ERROR_LITERAL;
            }
        }
        return NO_ERROR_LITERAL;
    }

    private ExitStatus(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

