/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pop.ssme.polychrony.traceability;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.pop.ssme.polychrony.PKTrees;
import org.eclipse.pop.ssme.polychrony.PkPlugin;
import org.eclipse.pop.ssme.polychrony.traceability.SSMENode;
import org.eclipse.pop.ssme.polychrony.utils.PolychronyDiagnostic;

public class TreesInterface {
    private Map<EObject, Long> interfaceMapSSMESignal = new HashMap<EObject, Long>();
    private List<SSMENode> SSMENodesList;

    public List<SSMENode> getSMENodesList() {
        return this.SSMENodesList;
    }

    public Map<EObject, Long> getInterfaceMapSMESignal() {
        return this.interfaceMapSSMESignal;
    }

    public void clearMap() {
        this.interfaceMapSSMESignal.clear();
    }

    public void initializeSSMENodesList() {
        this.SSMENodesList = new ArrayList<SSMENode>();
        for (Map.Entry<EObject, Long> entryMap : this.interfaceMapSSMESignal.entrySet()) {
            SSMENode smeNode = new SSMENode();
            smeNode.setNode(entryMap.getKey());
            this.SSMENodesList.add(smeNode);
        }
    }

    public void printInformations(boolean debug) {
        if (debug) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("\n-------------------------------------------------------------------\n\n");
            buffer.append("Interface HashMap between the Polychrony native AST and the SSME AST\n\n");
            buffer.append("Hashmap size : " + this.interfaceMapSSMESignal.size() + "\n\n");
            for (Map.Entry<EObject, Long> map : this.interfaceMapSSMESignal.entrySet()) {
                EObject key = map.getKey();
                long value = map.getValue();
                buffer.append(String.valueOf(key.toString()) + "\n" + value + "\n\n");
            }
            buffer.append("\n\n");
            System.out.println(buffer.toString());
        }
    }

    public void printTree(long node, int level, boolean debug) {
        if (debug) {
            if (level == 0) {
                System.out.println("\nAbstract Syntax Tree :\n");
            }
            PKTrees API = PkPlugin.getTreeAPI();
            System.out.print("LEVEL " + level + " : ");
            int i = 0;
            while (i < level) {
                System.out.print("......");
                ++i;
            }
            if (node == -1L) {
                System.out.println("(error)");
            }
            if (node == API.getNilTree()) {
                System.out.println("(nil)");
            } else {
                System.out.print("(node : " + node + ", arity: " + API.treeArity(node) + ")");
                if (this.getKey(node) != null) {
                    System.out.println(" ==> " + this.getKey(node));
                } else {
                    System.out.println();
                }
                if (API.oper(node) >= 101) {
                    i = 1;
                    while (i <= API.treeArity(node)) {
                        long child = API.child(i, node);
                        this.printTree(child, level + 1, debug);
                        ++i;
                    }
                } else {
                    System.out.print("LEVEL " + (level + 1) + " : ");
                    i = 0;
                    while (i < level + 1) {
                        System.out.print("......");
                        ++i;
                    }
                    System.out.println("(node : " + API.intOf(node) + ")");
                }
            }
        }
    }

    public void printErrorsOnModel(long tree, boolean debug) {
        PKTrees API = PkPlugin.getTreeAPI();
        long errorTree = PkPlugin.getCommentAPI().getAnnotations(tree, API.getNilTree());
        if (errorTree != API.getNilTree()) {
            int i = 1;
            while (i <= API.treeArity(errorTree)) {
                long errorTreeChild = API.child(i, errorTree);
                long intOfErrorTreeChild = API.intOf(errorTreeChild);
                long annotationsTree = PkPlugin.getCommentAPI().getAnnotation(intOfErrorTreeChild);
                if (debug) {
                    System.out.println("\n-----------------");
                    System.out.println("CORRESPONDENCE " + i + ":");
                    System.out.println("-----------------\n");
                    System.out.println("Node address : " + intOfErrorTreeChild + "\n");
                }
                EObject smeObject = this.getKey(intOfErrorTreeChild);
                if (debug) {
                    if (smeObject == null) {
                        System.out.println("No correspondence in the SSME nodes table\n");
                    } else {
                        System.out.println("Associated SSME node :\n\t" + smeObject + "\n");
                    }
                }
                int j = 1;
                while (j <= API.treeArity(annotationsTree)) {
                    long annotationsTreeChild = API.child(j, annotationsTree);
                    String annotation = API.stringOf(annotationsTreeChild);
                    if (debug) {
                        System.out.println("Error / Warning message : " + annotation + "\n");
                    }
                    if (smeObject != null && !annotation.matches("(.)*cf no-((\\d)+)")) {
                        annotation = annotation.replaceAll(" \\(ref-(.)*\\)", "");
                        for (SSMENode smeNode : this.SSMENodesList) {
                            if (!smeNode.getNode().equals(smeObject)) continue;
                            smeNode.setError(true);
                            smeNode.setErrorMessage(annotation);
                        }
                        PolychronyDiagnostic.add(4, annotation, smeObject);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public EObject getKey(long value) {
        EObject key = null;
        for (Map.Entry<EObject, Long> entryMap : this.interfaceMapSSMESignal.entrySet()) {
            EObject currentKey = entryMap.getKey();
            long currentValue = entryMap.getValue();
            if (currentValue != value) continue;
            key = currentKey;
        }
        return key;
    }
}

