/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pop.ssme;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ModelKind implements Enumerator
{
    PROCESS_LITERAL(0, "process", "process"),
    FUNCTION_LITERAL(1, "function", "function"),
    NODE_LITERAL(2, "node", "node"),
    ACTION_LITERAL(3, "action", "action"),
    PROCEDURE_LITERAL(4, "procedure", "procedure"),
    AUTOMATON_LITERAL(5, "automaton", "automaton");

    public static final int PROCESS = 0;
    public static final int FUNCTION = 1;
    public static final int NODE = 2;
    public static final int ACTION = 3;
    public static final int PROCEDURE = 4;
    public static final int AUTOMATON = 5;
    private static final ModelKind[] VALUES_ARRAY;
    public static final List<ModelKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ModelKind[]{PROCESS_LITERAL, FUNCTION_LITERAL, NODE_LITERAL, ACTION_LITERAL, PROCEDURE_LITERAL, AUTOMATON_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ModelKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ModelKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ModelKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ModelKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ModelKind get(int value) {
        switch (value) {
            case 0: {
                return PROCESS_LITERAL;
            }
            case 1: {
                return FUNCTION_LITERAL;
            }
            case 2: {
                return NODE_LITERAL;
            }
            case 3: {
                return ACTION_LITERAL;
            }
            case 4: {
                return PROCEDURE_LITERAL;
            }
            case 5: {
                return AUTOMATON_LITERAL;
            }
        }
        return null;
    }

    private ModelKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

