/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pop.ssme.compilation.utils.dialogs;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.pop.ssme.compilation.Scenario;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;

public class FindCompilationScenarioDialog
extends Dialog {
    private Composite dialog;
    private Text scenarioTxt;
    private Button scenarioBtn;
    private Scenario scenario;
    private Label comment;

    public FindCompilationScenarioDialog(Shell parentShell) {
        super(parentShell);
        this.setBlockOnOpen(true);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.scenario = null;
    }

    protected void configureShell(Shell newShell) {
        newShell.setText("Select the compilation scenario...");
        newShell.setMinimumSize(400, 200);
        super.configureShell(newShell);
    }

    protected Control createDialogArea(Composite parent) {
        this.dialog = (Composite)super.createDialogArea(parent);
        this.dialog.setLayout((Layout)new GridLayout(3, false));
        this.dialog.setLayoutData((Object)new GridData(1808));
        Label modelLbl = new Label(this.dialog, 0);
        modelLbl.setText("Scenario file : ");
        this.scenarioTxt = new Text(this.dialog, 2048);
        this.scenarioTxt.setLayoutData((Object)new GridData(768));
        this.scenarioTxt.setEnabled(false);
        this.scenarioBtn = new Button(this.dialog, 8);
        this.scenarioBtn.setText("...");
        this.scenarioBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                FindCompilationScenarioDialog.this.selectFile();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                FindCompilationScenarioDialog.this.selectFile();
            }
        });
        this.comment = new Label(this.dialog, 0);
        GridData data = new GridData(768);
        data.horizontalSpan = 3;
        this.comment.setLayoutData((Object)data);
        return this.dialog;
    }

    protected void cancelPressed() {
        this.scenario = null;
        super.cancelPressed();
    }

    public Scenario getScenario() {
        return this.scenario;
    }

    private void selectFile() {
        this.getButton(0).setEnabled(false);
        ResourceSelectionDialog dialog = new ResourceSelectionDialog(this.getShell(), (IAdaptable)ResourcesPlugin.getWorkspace().getRoot(), "Choose a compilation scenario file :");
        if (dialog.open() == 0) {
            Object[] results = dialog.getResult();
            if (results.length == 1 && results[0] instanceof IFile) {
                this.scenarioTxt.setText(((IFile)results[0]).getFullPath().toString());
                this.checkFile((IFile)results[0]);
            } else {
                this.comment.setText("Select one and only file");
                this.getButton(0).setEnabled(false);
            }
        }
    }

    private void checkFile(IFile file) {
        this.scenario = null;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI fileURI = URI.createFileURI((String)file.getLocation().toOSString());
        Resource resource = resourceSet.getResource(fileURI, true);
        for (EObject obj : resource.getContents()) {
            if (!(obj instanceof Scenario)) continue;
            this.scenario = (Scenario)obj;
        }
        if (this.scenario == null) {
            this.comment.setText("The selected file does not contain a compilation scenario.");
            this.getButton(0).setEnabled(false);
        } else {
            this.comment.setText("You select the scenario named : " + this.scenario.getDescription());
            this.getButton(0).setEnabled(true);
        }
    }
}

