/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pop.ssme.compilation.utils.jobs;

import java.util.LinkedList;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.pop.ssme.compilation.utils.CompilationUtilsPlugin;
import org.eclipse.pop.ssme.compilation.utils.popup.actions.CompilationUtils;
import org.eclipse.pop.ssme.compilation.utils.simulation.CreateJavaProject;
import org.eclipse.pop.ssme.polychrony.GraphValue;
import org.eclipse.pop.ssme.polychrony.PKServices;
import org.eclipse.pop.ssme.polychrony.PkPlugin;
import org.eclipse.pop.ssme.polychrony.utils.PolychronyConsole;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class CompilingMethods {
    public IStatus getErrorCompilationStatus(String message) {
        return new Status(4, "org.eclipse.pop.ssme.compilation.utils", message);
    }

    private boolean askUserForGeneration(final String windowTitle, final String message) {
        final LinkedList result = new LinkedList();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                result.add(MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)windowTitle, (String)message));
            }
        });
        return (Boolean)result.get(0);
    }

    public IStatus abstraction(GraphValue graph) {
        PkPlugin.getServices();
        if (PKServices.separatedCompilingPoly((long)graph.getGraph(), (boolean)true)) {
            return Status.OK_STATUS;
        }
        return this.getErrorCompilationStatus("Error during the abstraction building step");
    }

    public IStatus boolean2Events(GraphValue graph) {
        PkPlugin.getServices();
        if (PKServices.transformBooleanClocks2Events((long)graph.getGraph())) {
            return Status.OK_STATUS;
        }
        return this.getErrorCompilationStatus("Error during the boolean to events transformation step");
    }

    public IStatus clockCalculus(GraphValue graph) {
        PkPlugin.getServices();
        graph = PKServices.DCGBasic2DCGPoly((long)graph.getGraph());
        PkPlugin.getServices();
        if (PKServices.setIntrinsicClocks((long)graph.getGraph())) {
            PkPlugin.getServices();
            PKServices.nonProductiveSignalElimination((long)graph.getGraph());
            return Status.OK_STATUS;
        }
        return this.getErrorCompilationStatus("Error during the clock calculus step");
    }

    public IStatus cluster(GraphValue graph) {
        boolean generate;
        PkPlugin.getServices();
        PKServices.setIntrinsicClocks((long)graph.getGraph());
        PkPlugin.getServices();
        graph = PKServices.DCGPoly2DCGBool((long)graph.getGraph());
        if (graph.getReturnCode() == 1) {
            return this.getErrorCompilationStatus("Error during the booleanizing operation");
        }
        PkPlugin.getServices();
        PKServices.nonProductiveSignalElimination((long)graph.getGraph());
        PkPlugin.getServices();
        PKServices.setClockDependences((long)graph.getGraph());
        PkPlugin.getServices();
        boolean bl = generate = !PKServices.hasUnsolvedClockConstraints((long)graph.getGraph());
        if (!generate) {
            generate = this.askUserForGeneration("Force the clustering ?", "There are some unresolved constraints. Do you want to force the clustering operation ?");
        }
        if (!generate) {
            return Status.CANCEL_STATUS;
        }
        PkPlugin.getServices();
        if (PKServices.hasStaticCycle((long)graph.getGraph(), (boolean)false)) {
            PkPlugin.getServices();
            PKServices.nonProductiveSignalElimination((long)graph.getGraph());
            PkPlugin.getServices();
            PKServices.phylumClustering((long)graph.getGraph());
            PkPlugin.getServices();
            PKServices.nonProductiveSignalElimination((long)graph.getGraph());
            return Status.OK_STATUS;
        }
        return this.getErrorCompilationStatus("Error during the cycle detection operation");
    }

    public IStatus DCGPoly2DCGBool(GraphValue graph) {
        PkPlugin.getServices();
        graph = PKServices.DCGPoly2DCGBool((long)graph.getGraph());
        if (graph.getReturnCode() == 1) {
            return this.getErrorCompilationStatus("Error during the events to Booleans Booleanizing operation");
        }
        PkPlugin.getServices();
        if (PKServices.nonProductiveSignalElimination((long)graph.getGraph())) {
            return Status.OK_STATUS;
        }
        return this.getErrorCompilationStatus("Error during the events to booleans pruning operation");
    }

    public IStatus Flattening(GraphValue graph) {
        PkPlugin.getServices();
        graph = PKServices.DCGBool2DCGFlat((long)graph.getGraph());
        if (graph.getReturnCode() == 0) {
            return Status.OK_STATUS;
        }
        return this.getErrorCompilationStatus("Error during the flattening step");
    }

    public IStatus retiming(GraphValue graph) {
        PkPlugin.getServices();
        if (PKServices.moveIn2OutDelays((long)graph.getGraph())) {
            return Status.OK_STATUS;
        }
        return this.getErrorCompilationStatus("Error during the retiming step");
    }

    public IStatus sequentializing(GraphValue graph, long tree, boolean clustersApplied) {
        if (!clustersApplied) {
            boolean generate;
            PkPlugin.getServices();
            if (!PKServices.delayTreeBuild((long)graph.getGraph())) {
                return this.getErrorCompilationStatus("Error during the delay Tree generation");
            }
            PkPlugin.getServices();
            PKServices.nonProductiveSignalElimination((long)graph.getGraph());
            PkPlugin.getServices();
            PKServices.setClockDependences((long)graph.getGraph());
            PkPlugin.getServices();
            boolean bl = generate = !PKServices.hasUnsolvedClockConstraints((long)graph.getGraph());
            if (!generate) {
                generate = this.askUserForGeneration("Force the sequentializing ?", "There are some unresolved constraints. Do you want to force the sequentializing operation ?");
            }
            if (!generate) {
                return Status.CANCEL_STATUS;
            }
            PkPlugin.getServices();
            if (!PKServices.hasStaticCycle((long)graph.getGraph(), (boolean)false)) {
                return this.getErrorCompilationStatus("Error during the cycle detection operation");
            }
        }
        PkPlugin.getServices();
        graph = PKServices.Serializing((long)graph.getGraph(), (boolean)true, (boolean)true, (boolean)true, (boolean)true);
        if (graph.getReturnCode() == 0) {
            return Status.OK_STATUS;
        }
        return this.getErrorCompilationStatus("Error during the sequentializing operation");
    }

    public IStatus unify(GraphValue graph) {
        PkPlugin.getServices();
        if (PKServices.removeSignalClones((long)graph.getGraph())) {
            return Status.OK_STATUS;
        }
        return this.getErrorCompilationStatus("Error during the signal unification step");
    }

    public IStatus generateC(long graph, boolean abstractionApplied) {
        boolean res;
        if (abstractionApplied) {
            PkPlugin.getServices();
            res = PKServices.genCodeCSeparate((long)graph);
        } else {
            PkPlugin.getServices();
            res = PKServices.genCodeC((long)graph, (boolean)true, (boolean)true, (boolean)true);
        }
        if (res) {
            return Status.OK_STATUS;
        }
        return this.getErrorCompilationStatus("Error during the C code generation");
    }

    public IStatus generateCPP(long graph, boolean abstractionApplied) {
        boolean res;
        if (abstractionApplied) {
            PkPlugin.getServices();
            res = PKServices.genCodeCPPSeparate((long)graph);
        } else {
            PkPlugin.getServices();
            res = PKServices.genCodeCPP((long)graph, (boolean)true, (boolean)true, (boolean)true);
        }
        if (res) {
            return Status.OK_STATUS;
        }
        return this.getErrorCompilationStatus("Error during the CPP code generation");
    }

    public IStatus generateJava(long graph, IPath targetDir, boolean abstractionApplied, CompilationUtils compilationUtils) {
        boolean res;
        PolychronyConsole.printInfo((String)("\n   ==> Create the Java project: " + targetDir.lastSegment() + "\n"));
        CreateJavaProject project = new CreateJavaProject("org.eclipse.pop.ssme.compilation.utils", "javalibs/simulation.zip", targetDir.lastSegment());
        IProject pr = project.create();
        compilationUtils.getResources().add((IResource)pr);
        IFolder dir = pr.getFolder("src");
        if (!dir.exists()) {
            try {
                dir.create(true, true, null);
                PkPlugin.getPrinter().setOutputDirectory(dir.getLocation().toOSString());
            }
            catch (CoreException e) {
                CompilationUtilsPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.pop.ssme.compilation.utils", 0, e.getMessage(), (Throwable)e));
            }
        }
        if (abstractionApplied) {
            PkPlugin.getServices();
            res = PKServices.genCodeJavaSeparate((long)graph);
        } else {
            PkPlugin.getServices();
            res = PKServices.genCodeJava((long)graph, (boolean)true, (boolean)true, (boolean)true);
        }
        PkPlugin.getPrinter().setOutputDirectory(targetDir.toOSString());
        if (res) {
            return Status.OK_STATUS;
        }
        return this.getErrorCompilationStatus("Error during the Java code generation");
    }

    public IStatus generateLustre(long graph) {
        PkPlugin.getServices();
        if (PKServices.LustreUnparse((long)graph)) {
            return Status.OK_STATUS;
        }
        return this.getErrorCompilationStatus("Error during the Lustre code generation");
    }

    public IStatus generateProfiling(long graph) {
        PkPlugin.getServices();
        if (PKServices.applyTabularMorphism((long)graph)) {
            return Status.OK_STATUS;
        }
        return this.getErrorCompilationStatus("Error during the profiling");
    }

    public IStatus generateSigali(long graph) {
        PkPlugin.getServices();
        if (PKServices.SigaliPrintExtraction((long)graph)) {
            return Status.OK_STATUS;
        }
        return this.getErrorCompilationStatus("Error during the Sigali code generation");
    }

    public IStatus generateSignal(long tree, IPath fileDirectory) {
        PkPlugin.getPrinter().setOutputDirectory(fileDirectory.toOSString());
        if (!PkPlugin.getPrinter().printTree(tree)) {
            return this.getErrorCompilationStatus("Error during the Signal code generation");
        }
        return Status.OK_STATUS;
    }

    public IStatus generateSignalFile(long tree, String AbsfileName) {
        if (!PkPlugin.getPrinter().printTreeFile(tree, AbsfileName)) {
            return this.getErrorCompilationStatus("Error during the Signal code generation");
        }
        return Status.OK_STATUS;
    }

    public IStatus generateSignalLIS(long tree) {
        PkPlugin.getServices();
        boolean signalLISPrinted = PKServices.printSignalLIS((long)tree, (long)0L);
        if (!signalLISPrinted) {
            return this.getErrorCompilationStatus("Error during the Signal code generation");
        }
        return Status.OK_STATUS;
    }

    public IStatus generateSignalTRA(long graph) {
        PkPlugin.getServices();
        if (PKServices.unparse((long)graph)) {
            return Status.OK_STATUS;
        }
        return this.getErrorCompilationStatus("Error during the Signal code generation");
    }

    public IStatus generateSignalAbstraction(long graph) {
        PkPlugin.getServices();
        if (PKServices.unparseAbstraction((long)graph)) {
            return Status.OK_STATUS;
        }
        return this.getErrorCompilationStatus("Error during the Signal Abstraction generation");
    }

    public IStatus generateSSME(long tree, IPath fileDirectory) {
        PkPlugin.getPrinter().setOutputDirectory(fileDirectory.toOSString());
        PkPlugin.getServices();
        if (PKServices.signal2SSME((long)tree, (String)fileDirectory.toOSString())) {
            return Status.OK_STATUS;
        }
        return this.getErrorCompilationStatus("Error during the generation of the Signal model file.");
    }

    public IStatus generateSyndex(long graph) {
        PkPlugin.getServices();
        if (PKServices.SynDExUnparse((long)graph)) {
            return Status.OK_STATUS;
        }
        return this.getErrorCompilationStatus("Error during the SynDEx code generation");
    }
}

