/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pop.ssme.compilation.utils.jobs;

import java.io.IOException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.pop.ssme.RootModel;
import org.eclipse.pop.ssme.compilation.Functionality;
import org.eclipse.pop.ssme.compilation.FunctionalityKind;
import org.eclipse.pop.ssme.compilation.Generator;
import org.eclipse.pop.ssme.compilation.GeneratorKind;
import org.eclipse.pop.ssme.compilation.Scenario;
import org.eclipse.pop.ssme.compilation.ScenarioItem;
import org.eclipse.pop.ssme.compilation.utils.jobs.CompilingMethods;
import org.eclipse.pop.ssme.compilation.utils.popup.actions.CompilationUtils;
import org.eclipse.pop.ssme.polychrony.ExitStatus;
import org.eclipse.pop.ssme.polychrony.GraphValue;
import org.eclipse.pop.ssme.polychrony.PKServices;
import org.eclipse.pop.ssme.polychrony.PkPlugin;
import org.eclipse.pop.ssme.polychrony.traceability.SSMENode;
import org.eclipse.pop.ssme.polychrony.utils.PolychronyConsole;
import org.eclipse.pop.ssme.polychrony.utils.PolychronyDiagnostic;

public class ExecuteScenarioJob
extends Job {
    private Scenario scenario;
    private CompilingMethods compilingMethods;
    private IFile sourceFile;
    private boolean clustersApplied;
    private boolean abstractionApplied;
    private CompilationUtils compilationUtils;

    public ExecuteScenarioJob(IFile file, Scenario scenario, CompilationUtils compilationUtils) {
        super("Execute scenario: " + scenario);
        this.sourceFile = file;
        this.scenario = scenario;
        this.compilationUtils = compilationUtils;
        this.compilingMethods = new CompilingMethods();
        this.clustersApplied = false;
        this.abstractionApplied = false;
        this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
    }

    private void initialize() {
        this.compilationUtils.printBanner();
        PolychronyConsole.printInfo((String)("Input file : " + this.sourceFile.getFullPath() + "\n\n"));
        PolychronyDiagnostic.clear();
        PkPlugin.getServices();
        PKServices.resetMachine();
    }

    private IStatus finalize(IProgressMonitor monitor, IStatus status) {
        MultiStatus mStatus = new MultiStatus("org.eclipse.pop.ssme.compilation.utils", 0, "Execute scenario action status", null);
        mStatus.add(status);
        PkPlugin.getServices();
        PKServices.setEnv((String)"SIGNAL_LIBRARY_PATH", (String)this.compilationUtils.getSaveLibraryPath());
        if (!monitor.isCanceled()) {
            monitor.setTaskName("Markers creation");
            Diagnostic diagnostic = PolychronyDiagnostic.getUniqueDiagnostics();
            if (this.sourceFile != null) {
                this.compilationUtils.refreshErrors(this.sourceFile);
                if (diagnostic.getSeverity() == 4) {
                    mStatus.add(this.compilingMethods.getErrorCompilationStatus("Some errors has been detected during the generation. Check the Problem view and correct them."));
                }
            }
        }
        monitor.done();
        PkPlugin.getServices();
        PKServices.resetMachine();
        return mStatus;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            boolean isSignalTextOrEMFModel;
            PkPlugin.getServices();
            this.compilationUtils.setSaveLibraryPath(PKServices.getEnv((String)"SIGNAL_LIBRARY_PATH"));
            if (this.sourceFile == null) {
                return this.finalize(monitor, this.compilingMethods.getErrorCompilationStatus("No file selected"));
            }
            if (this.scenario == null) {
                return this.finalize(monitor, this.compilingMethods.getErrorCompilationStatus("No compilation scenario selected"));
            }
            boolean isSignalTextualFile = this.sourceFile.getFileExtension().equalsIgnoreCase("SIG");
            boolean isSignalEMFModel = this.sourceFile.getFileExtension().equalsIgnoreCase("SSME");
            boolean bl = isSignalTextOrEMFModel = isSignalTextualFile || isSignalEMFModel;
            if (!isSignalTextOrEMFModel) {
                return this.finalize(monitor, this.compilingMethods.getErrorCompilationStatus("The file is neither a Signal model nor a Signal textual file."));
            }
            this.initialize();
            monitor.beginTask("Compilation scenario execution", 100);
            IPath fileLocation = this.sourceFile.getLocation();
            IPath fileDirectory = fileLocation.removeFileExtension();
            int monitorStep = 0;
            long tree = -1L;
            if (isSignalEMFModel) {
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                URI fileURI = URI.createFileURI((String)fileLocation.toOSString());
                Resource resource = resourceSet.getResource(fileURI, true);
                if (resource.getContents().size() != 1) {
                    return this.finalize(monitor, this.compilingMethods.getErrorCompilationStatus("The sme file must only have one single root element."));
                }
                RootModel rootModel = null;
                EObject obj = (EObject)resource.getContents().get(0);
                if (!(obj instanceof RootModel)) {
                    return this.finalize(monitor, this.compilingMethods.getErrorCompilationStatus("No root model was found in the Signal model file."));
                }
                rootModel = (RootModel)obj;
                monitor.subTask("Model validation");
                if (!this.compilationUtils.validModel(resource)) {
                    return this.finalize(monitor, this.compilingMethods.getErrorCompilationStatus("The model is not valid. Correct these errors before calling compiler functionalities."));
                }
                monitor.worked(10);
                monitor.subTask("AST creation");
                PkPlugin.getTraceabilityAPI().clearMap();
                tree = rootModel.makeAST();
                PkPlugin.getTraceabilityAPI().initializeSSMENodesList();
                PkPlugin.getTraceabilityAPI().printInformations(false);
                PkPlugin.getTraceabilityAPI().printTree(tree, 0, false);
                monitorStep = 10;
            } else if (isSignalTextualFile) {
                monitor.subTask("AST creation");
                tree = PkPlugin.getParser().parseSrcfile(fileLocation.toOSString());
                monitorStep = 20;
            }
            if (tree == -1L) {
                return this.finalize(monitor, this.compilingMethods.getErrorCompilationStatus("Error during the creation of the abstract syntax tree: too many errors to correct before compiling."));
            }
            monitor.worked(monitorStep);
            boolean generateGraph = false;
            if (!this.scenario.getElements().isEmpty()) {
                for (ScenarioItem scit1 : this.scenario.getElements()) {
                    boolean graphGenerationNeeded;
                    if (!(scit1 instanceof Generator)) continue;
                    Generator generator = (Generator)scit1;
                    int generationType = generator.getKind().getValue();
                    boolean bl2 = graphGenerationNeeded = generationType != 3 && generationType != 0;
                    if (!graphGenerationNeeded) continue;
                    generateGraph = true;
                }
            }
            this.compilationUtils.addPathSignalLibraryPath(fileDirectory);
            GraphValue graphValue = null;
            if (generateGraph) {
                monitor.subTask("Tree to Graph transformation");
                PkPlugin.getServices();
                graphValue = PKServices.tree2DCG((long)tree, (boolean)true, (long)PkPlugin.getTreeAPI().getNilTree(), (boolean)true, (String)fileDirectory.toOSString(), (boolean)false, (boolean)isSignalEMFModel);
                if (!graphValue.isOk()) {
                    PkPlugin.getTraceabilityAPI().printErrorsOnModel(tree, false);
                    return this.finalize(monitor, this.compilingMethods.getErrorCompilationStatus("Error during the graph transformation: " + ExitStatus.get((int)graphValue.getReturnCode()).getLiteral()));
                }
                monitor.worked(10);
            }
            MultiStatus status = new MultiStatus("org.eclipse.pop.ssme.compilation.utils", 0, "Scenario status", null);
            if (!this.scenario.getElements().isEmpty()) {
                PkPlugin.getServices();
                PKServices.displayWarnings((boolean)this.scenario.isDisplayWarnings());
                SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 60);
                subMonitor.beginTask("Scenario execution", this.scenario.getElements().size() * 10);
                for (ScenarioItem scit : this.scenario.getElements()) {
                    subMonitor.subTask(scit.toString());
                    if (scit instanceof Functionality) {
                        Functionality func = (Functionality)scit;
                        IStatus res = this.executeFunctionality(func.getKind(), graphValue, tree);
                        status.add(res);
                        if (!res.isOK()) {
                            break;
                        }
                    } else if (scit instanceof Generator) {
                        Generator gen = (Generator)scit;
                        if (gen.getKind().getValue() == 3 || gen.getKind().getValue() == 0 || gen.getKind().getValue() == 1) {
                            status.add(this.executeGenerator(gen.getKind(), 0L, tree, fileDirectory));
                        } else {
                            status.add(this.executeGenerator(gen.getKind(), graphValue.getGraph(), 0L, fileDirectory));
                        }
                    } else {
                        status.add(this.compilingMethods.getErrorCompilationStatus("Feature not yet implemented:" + scit.toString()));
                    }
                    subMonitor.worked(10);
                }
                subMonitor.done();
            }
            return this.finalize(monitor, (IStatus)status);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private IStatus executeFunctionality(FunctionalityKind kind, GraphValue graph, long tree) throws IOException {
        IStatus returnStatus = Status.OK_STATUS;
        int functionality = kind.getValue();
        if (functionality == 5) {
            returnStatus = this.compilingMethods.abstraction(graph);
            this.abstractionApplied = returnStatus.isOK();
        } else if (functionality == 1) {
            returnStatus = this.compilingMethods.boolean2Events(graph);
        } else if (functionality == 3) {
            returnStatus = this.compilingMethods.clockCalculus(graph);
        } else if (functionality == 6) {
            returnStatus = this.compilingMethods.cluster(graph);
            this.clustersApplied = returnStatus.isOK();
        } else if (functionality == 4) {
            returnStatus = this.compilingMethods.DCGPoly2DCGBool(graph);
        } else if (functionality == 8) {
            returnStatus = this.compilingMethods.Flattening(graph);
        } else if (functionality == 0) {
            returnStatus = this.compilingMethods.retiming(graph);
        } else if (functionality == 7) {
            returnStatus = this.compilingMethods.sequentializing(graph, tree, this.clustersApplied);
        } else if (functionality == 2) {
            returnStatus = this.compilingMethods.unify(graph);
        }
        return returnStatus;
    }

    private IStatus executeGenerator(GeneratorKind kind, long graph, long tree, IPath fileDir) throws IOException {
        IStatus returnStatus = Status.OK_STATUS;
        int generator = kind.getValue();
        if (generator == 6) {
            returnStatus = this.compilingMethods.generateC(graph, this.abstractionApplied);
        } else if (generator == 7) {
            returnStatus = this.compilingMethods.generateCPP(graph, this.abstractionApplied);
        } else if (generator == 8) {
            returnStatus = this.compilingMethods.generateJava(graph, fileDir, this.abstractionApplied, this.compilationUtils);
        } else if (generator == 10) {
            returnStatus = this.compilingMethods.generateLustre(graph);
        } else if (generator == 9) {
            returnStatus = this.compilingMethods.generateProfiling(graph);
        } else if (generator == 5) {
            returnStatus = this.compilingMethods.generateSigali(graph);
        } else if (generator == 0) {
            returnStatus = this.compilingMethods.generateSignal(tree, fileDir);
        } else if (generator == 4) {
            returnStatus = this.compilingMethods.generateSignalAbstraction(graph);
        } else if (generator == 3) {
            returnStatus = this.compilingMethods.generateSSME(tree, fileDir);
        } else if (generator == 12) {
            returnStatus = this.compilingMethods.generateSSME(tree, fileDir);
        } else if (generator == 11) {
            returnStatus = this.compilingMethods.generateSyndex(graph);
        } else if (generator == 1) {
            returnStatus = this.compilingMethods.generateSignalLIS(tree);
        } else if (generator == 2) {
            returnStatus = this.compilingMethods.generateSignalTRA(graph);
        }
        return returnStatus;
    }

    public List<SSMENode> getSSMENodesList() {
        return PkPlugin.getTraceabilityAPI().getSMENodesList();
    }
}

