/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pop.ssme.compilation.utils.popup.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.pop.ssme.compilation.utils.jobs.CompilingMethods;
import org.eclipse.pop.ssme.compilation.utils.popup.actions.CompilationUtils;
import org.eclipse.pop.ssme.polychrony.GraphValue;
import org.eclipse.pop.ssme.polychrony.PKOptionManager;
import org.eclipse.pop.ssme.polychrony.utils.PolychronyConsole;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class BatchCompiling {
    Shell shell;
    Text text;
    Button compileButton;
    Button quitButton;
    Button SelectDirButton;
    DirectoryDialog dirDialog;
    static String selectedDir = null;

    public BatchCompiling(CompilingMethods compilingMethods, final long finalTree, IFile sourceFile, final GraphValue graphValue, final CompilationUtils compilationUtils, final IPath fileDirectory) {
        final PKOptionManager optionManager = new PKOptionManager();
        Display display = Display.getCurrent();
        this.shell = new Shell(display);
        this.shell.setLayout((Layout)new GridLayout(2, false));
        this.shell.setSize(2000, 3000);
        this.shell.setText("Enter or modify the compiling options");
        Composite compositeButtons = new Composite((Composite)this.shell, 2048);
        compositeButtons.setLayout((Layout)new GridLayout());
        this.text = new Text((Composite)this.shell, 16642);
        this.text.setLayoutData((Object)new GridData(4, 4, true, true));
        this.text.append("                                                                   \n");
        this.text.append("-tra -poly \n");
        if (selectedDir != null) {
            this.text.append(String.valueOf(selectedDir) + "\n");
        }
        this.compileButton = new Button(compositeButtons, 8);
        this.compileButton.setLayoutData((Object)new GridData(4, 4, true, true));
        this.compileButton.setText("Compile");
        this.compileButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (e.type == 13) {
                    PolychronyConsole.clear();
                    optionManager.compile(finalTree, graphValue.getGraph(), BatchCompiling.this.getBatchCompilerOptions(), fileDirectory.removeLastSegments(1).toString());
                    BatchCompiling.this.shell.dispose();
                }
                compilationUtils.refreshContent();
            }
        });
        this.quitButton = new Button(compositeButtons, 8);
        this.quitButton.setLayoutData((Object)new GridData(4, 4, true, true));
        this.quitButton.setText("Quit");
        this.quitButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (e.type == 13) {
                    BatchCompiling.this.dispose();
                }
            }
        });
        this.SelectDirButton = new Button(compositeButtons, 8);
        this.SelectDirButton.setLayoutData((Object)new GridData(4, 4, true, true));
        this.SelectDirButton.setText("Select output directory");
        this.SelectDirButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (e.type == 13 && (selectedDir = BatchCompiling.this.dirDialog.open()) != null) {
                    selectedDir = "-D= " + selectedDir;
                    BatchCompiling.this.text.append(String.valueOf(selectedDir) + "\n");
                }
            }
        });
        this.dirDialog = new DirectoryDialog(this.shell, 0);
        this.shell.pack();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        this.dispose();
    }

    private void dispose() {
        this.shell.dispose();
    }

    public String getBatchCompilerOptions() {
        String vstr = this.text.getText();
        vstr = vstr.replaceAll("\n", " ");
        vstr = vstr.replaceAll("\t", " ");
        vstr = vstr.replaceAll("\f", " ");
        vstr = vstr.replaceAll("\r", " ");
        vstr = vstr.replaceAll("  ", " ");
        vstr = "signal " + vstr;
        return vstr;
    }
}

