/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pop.ssme.compilation.utils.simulation;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.pop.ssme.compilation.utils.CompilationUtilsPlugin;

public class GenerateBuildFile {
    private IPath sourceLocation;
    private String name;

    public GenerateBuildFile(IPath source, String name) {
        this.sourceLocation = source;
        this.name = name;
    }

    public void generateJavaFile() {
        File file;
        File dir;
        if (this.sourceLocation == null) {
            CompilationUtilsPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.pop.ssme.compilation.utils", "GenerateBuildFile: The sourceLocation is null"));
        }
        if (!(dir = this.sourceLocation.toFile()).exists()) {
            dir.mkdirs();
        }
        if ((file = new File(dir, "buildJava.xml")).exists()) {
            return;
        }
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            pw.println("<project name=\"" + this.name + "\" default=\"exec\" basedir=\".\">");
            pw.println();
            pw.println("\t<property name=\"bin\" value=\"${basedir}/bin\"/>");
            pw.println();
            pw.println("\t<!-- =================================");
            pw.println("\t      target: clean");
            pw.println("\t     ================================= -->");
            pw.println("\t<target name=\"clean\" description=\"Delete the binary directory and all its content\">");
            pw.println("\t    <delete dir=\"${bin}\"/>");
            pw.println("\t</target>");
            pw.println();
            pw.println("\t<!-- =================================");
            pw.println("\t      target: build");
            pw.println("\t     ================================= -->");
            pw.println("\t<target name=\"build\" depends=\"clean\" description=\"Compile the " + this.name + " simulation\">");
            pw.println("\t    <mkdir dir=\"${bin}\" description=\"Create the binary directory\" />");
            pw.println("\t    <javac srcdir=\"${basedir}\" destdir=\"${bin}\" includes=\"*.java\" ");
            pw.println("\t    \tclasspath=\"PolychronyJavaLibs.jar\" debug=\"on\" />");
            pw.println("\t</target>");
            pw.println();
            pw.println("\t<!-- =================================");
            pw.println("\t      target: exec");
            pw.println("\t     ================================= -->");
            pw.println("\t<target name=\"exec\" depends=\"build\" description=\"Execute the " + this.name + " simulation\">");
            pw.println("\t    <java classname=\"" + this.name + "_main\">");
            pw.println("\t    \t<classpath>");
            pw.println("\t    \t\t<pathelement location=\"${basedir}/PolychronyJavaLibs.jar\"/>");
            pw.println("\t    \t\t<pathelement path=\"${bin}${path.separator}${java.class.path}\"/>");
            pw.println("\t    \t</classpath>");
            pw.println("\t    </java>");
            pw.println("\t</target>");
            pw.println();
            pw.println("</project>");
            pw.close();
        }
        catch (IOException ioe) {
            CompilationUtilsPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.pop.ssme.compilation.utils", 4, ioe.getMessage(), (Throwable)ioe));
        }
    }
}

