/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pop.ssme.compilation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum FunctionalityKind implements Enumerator
{
    RETIMING_LITERAL(0, "Retiming", "Retiming"),
    BOOLEAN2_EVENTS_LITERAL(1, "Boolean2Events", "Boolean to Events"),
    SIGNAL_UNIFICATIONS_LITERAL(2, "SignalUnifications", "Signal Unifications"),
    CLOCK_CALCULUS_LITERAL(3, "ClockCalculus", "Clock Calculus"),
    EVENTS2_BOOLEAN_LITERAL(4, "Events2Boolean", "Events to Boolean"),
    ABSTRACTION_LITERAL(5, "Abstraction", "Abstraction"),
    CLUSTERING_LITERAL(6, "Clustering", "Sequential Clustering"),
    SEQUENTIALIZING_LITERAL(7, "Sequentializing", "Sequentializing"),
    FLATTENING_LITERAL(8, "Flattening", "Flattening (STS)");

    public static final int RETIMING = 0;
    public static final int BOOLEAN2_EVENTS = 1;
    public static final int SIGNAL_UNIFICATIONS = 2;
    public static final int CLOCK_CALCULUS = 3;
    public static final int EVENTS2_BOOLEAN = 4;
    public static final int ABSTRACTION = 5;
    public static final int CLUSTERING = 6;
    public static final int SEQUENTIALIZING = 7;
    public static final int FLATTENING = 8;
    private static final FunctionalityKind[] VALUES_ARRAY;
    public static final List<FunctionalityKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new FunctionalityKind[]{RETIMING_LITERAL, BOOLEAN2_EVENTS_LITERAL, SIGNAL_UNIFICATIONS_LITERAL, CLOCK_CALCULUS_LITERAL, EVENTS2_BOOLEAN_LITERAL, ABSTRACTION_LITERAL, CLUSTERING_LITERAL, SEQUENTIALIZING_LITERAL, FLATTENING_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static FunctionalityKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FunctionalityKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FunctionalityKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FunctionalityKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FunctionalityKind get(int value) {
        switch (value) {
            case 0: {
                return RETIMING_LITERAL;
            }
            case 1: {
                return BOOLEAN2_EVENTS_LITERAL;
            }
            case 2: {
                return SIGNAL_UNIFICATIONS_LITERAL;
            }
            case 3: {
                return CLOCK_CALCULUS_LITERAL;
            }
            case 4: {
                return EVENTS2_BOOLEAN_LITERAL;
            }
            case 5: {
                return ABSTRACTION_LITERAL;
            }
            case 6: {
                return CLUSTERING_LITERAL;
            }
            case 7: {
                return SEQUENTIALIZING_LITERAL;
            }
            case 8: {
                return FLATTENING_LITERAL;
            }
        }
        return null;
    }

    private FunctionalityKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

