/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pop.ssme.polychrony;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ModelKind implements Enumerator
{
    ACTION_LITERAL(517, "opact", "action"),
    ACTION_P_LITERAL(518, "opactp", "private action"),
    FUNCTION_LITERAL(506, "opfunc", "function"),
    FUNCTION_P_LITERAL(507, "opfuncp", "private function"),
    NODE_LITERAL(522, "opnode", "node"),
    NODE_P_LITERAL(523, "opnodep", "private node"),
    PROCESS_LITERAL(511, "opprocess", "process"),
    PROCESS_P_LITERAL(512, "opprocessp", "private process"),
    MODULE_LITERAL(243, "opmodu", "module"),
    L_MODULE_LITERAL(441, "oplmodu", "l_module");

    public static final int ACTION = 517;
    public static final int ACTION_P = 518;
    public static final int FUNCTION = 506;
    public static final int FUNCTION_P = 507;
    public static final int NODE = 522;
    public static final int NODE_P = 523;
    public static final int PROCESS = 511;
    public static final int PROCESS_P = 512;
    public static final int MODULE = 243;
    public static final int L_MODULE = 441;
    private static final ModelKind[] VALUES_ARRAY;
    public static final List<ModelKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ModelKind[]{ACTION_LITERAL, ACTION_P_LITERAL, FUNCTION_LITERAL, FUNCTION_P_LITERAL, NODE_LITERAL, NODE_P_LITERAL, PROCESS_LITERAL, PROCESS_P_LITERAL, MODULE_LITERAL, L_MODULE_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ModelKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ModelKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ModelKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ModelKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ModelKind get(int value) {
        switch (value) {
            case 517: {
                return ACTION_LITERAL;
            }
            case 518: {
                return ACTION_P_LITERAL;
            }
            case 506: {
                return FUNCTION_LITERAL;
            }
            case 507: {
                return FUNCTION_P_LITERAL;
            }
            case 522: {
                return NODE_LITERAL;
            }
            case 523: {
                return NODE_P_LITERAL;
            }
            case 511: {
                return PROCESS_LITERAL;
            }
            case 512: {
                return PROCESS_P_LITERAL;
            }
            case 243: {
                return MODULE_LITERAL;
            }
            case 441: {
                return L_MODULE_LITERAL;
            }
        }
        return null;
    }

    private ModelKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }
}

