/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pop.ssme.polychrony;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.pop.ssme.polychrony.ExclusiveClockLevelKind;
import org.eclipse.pop.ssme.polychrony.GraphValue;
import org.eclipse.pop.ssme.polychrony.PKTrees;
import org.eclipse.pop.ssme.polychrony.PkPlugin;
import org.eclipse.pop.ssme.polychrony.SignalParser;
import org.eclipse.pop.ssme.polychrony.SignalTreeBuilting;
import org.eclipse.pop.ssme.polychrony.SignalTreeComment;
import org.eclipse.pop.ssme.polychrony.SignalTreeExploring;
import org.eclipse.pop.ssme.polychrony.SignalTreePrinter;
import org.eclipse.pop.ssme.polychrony.traceability.TreesInterface;

public class PKServices {
    private static final String NATIVE_LIB_NOT_FOUND = "The native library for POP is not available.";
    private static final String NO_NATIVE_RESOURCES = "Cannot find native resources to initialize the SignalToolBox";
    private static final String BAD_SIGNALTOOLBOX_VERSION = "Bad SignalToolBox version, expected version: ";
    private static final String UPDATE_SIGNALTOOBOX_PREFERENCES = " Update your POP preferences (Select: Windows->Preferences->Pop)";
    private static final String BAD_SIGNALTOOLBOX_PATH = "Bad SignalToolBox path (or old version)";
    private static final String USING_SIGNALTOOLBOX_USER_ENVIRONMENT = "Using the SignalToolBox defined in your environment. To modify it, Update your POP preferences (Select: Windows->Preferences->Pop)";
    private static boolean SignaltoolBoxLoaded = false;
    private static String pK_Signal_bin;
    public static String pK_Version;
    private static String pK_Signal_obj;
    private static String pK_SignalLib_Std;
    private static String pK_ROOT;
    public static final PKServices INSTANCE;
    private SignalParser parser;
    private SignalTreePrinter printer;
    private SignalTreeBuilting builder;
    private PKTrees treeAPI;
    private SignalTreeComment comment;
    private TreesInterface treesInterface;
    private SignalTreeExploring explorer;

    static {
        pK_Version = "xxx";
        pK_Signal_obj = null;
        pK_SignalLib_Std = null;
        pK_ROOT = null;
        ILog alog = PkPlugin.getDefault().getLog();
        IPreferenceStore pref = PkPlugin.getDefault().getPreferenceStore();
        pK_ROOT = pref.getString("SignalToolBox");
        int i = 1;
        String pK_Signal = "";
        while (pK_Version.equals("xxx") && i <= 2) {
            pK_Signal = String.valueOf(pK_ROOT) + File.separatorChar + "Signal";
            pK_Signal_bin = String.valueOf(pK_Signal) + File.separatorChar + "bin";
            try {
                String file = String.valueOf(pK_Signal_bin) + File.separatorChar + "pop_polarsys.data";
                FileReader fr = new FileReader(file);
                BufferedReader br = new BufferedReader(fr);
                pK_Version = br.readLine();
                fr.close();
            }
            catch (IOException iOException) {
                ++i;
                pK_ROOT = System.getenv("pK_ROOT");
            }
        }
        if (pK_Version.equals("xxx")) {
            alog.log((IStatus)new Status(4, "org.eclipse.pop.ssme.polychrony", BAD_SIGNALTOOLBOX_PATH, null));
            alog.log((IStatus)new Status(4, "org.eclipse.pop.ssme.polychrony", UPDATE_SIGNALTOOBOX_PREFERENCES, null));
            alog.log((IStatus)new Status(4, "org.eclipse.pop.ssme.polychrony", NATIVE_LIB_NOT_FOUND, null));
        } else if (pK_Version.equals("4.21")) {
            pK_Signal_obj = String.valueOf(pK_Signal) + File.separatorChar + "obj";
            pK_SignalLib_Std = String.valueOf(pK_ROOT) + File.separatorChar + "SignalLibraries" + File.separatorChar + "Std";
            try {
                String OslibName = System.mapLibraryName("SignalToolBoxEclipse_4.21");
                String str = String.valueOf(pK_Signal_obj) + File.separatorChar + OslibName;
                System.out.println(" Loading native library,  " + str);
                System.load(str);
                SignaltoolBoxLoaded = true;
                if (i == 2) {
                    pref.setValue("SignalToolBox", pK_ROOT);
                    alog.log((IStatus)new Status(1, "org.eclipse.pop.ssme.polychrony", USING_SIGNALTOOLBOX_USER_ENVIRONMENT, null));
                }
            }
            catch (UnsatisfiedLinkError ule) {
                alog.log((IStatus)new Status(4, "org.eclipse.pop.ssme.polychrony", NATIVE_LIB_NOT_FOUND, (Throwable)ule));
            }
        }
        INSTANCE = new PKServices();
    }

    private PKServices() {
        if (SignaltoolBoxLoaded) {
            PKServices.setEnv("Signal_bin", pK_Signal_bin);
            PKServices.setEnv("Signal_obj", pK_Signal_obj);
            PKServices.setEnv("pK_VERSION", pK_Version);
            try {
                PKServices.newMachine();
                IPreferenceStore pref = PkPlugin.getDefault().getPreferenceStore();
                String value = pref.getString("SignalLib_Std");
                PKServices.setSignalLibraryPath(value);
                if (!"".equals(value)) {
                    value = String.valueOf(value) + File.pathSeparator;
                }
                value = String.valueOf(value) + pK_SignalLib_Std;
                PKServices.setEnv("SIGNAL_LIBRARY_PATH", value);
                int val = pref.getInt("maxTypeTableSize");
                if (val <= 0) {
                    val = 4096;
                }
                PKServices.setEnv("SHELL_TypeTableMaxSize", "" + val);
                val = pref.getInt("polychronyTreeMemorySize");
                if (val <= 0) {
                    val = 60000000;
                }
                PKServices.setEnv("T_MEM_ARB", "" + val);
                val = pref.getInt("polychronyStringMemorySize");
                if (val <= 0) {
                    val = 0x100000;
                }
                PKServices.setEnv("T_MEM_CHAIN", "" + val);
                PKServices.initMachine();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.parser = new SignalParser();
            this.printer = new SignalTreePrinter();
            this.builder = new SignalTreeBuilting();
            this.treeAPI = new PKTrees();
            this.comment = new SignalTreeComment();
            this.treesInterface = new TreesInterface();
            this.explorer = new SignalTreeExploring();
        }
    }

    public boolean isSignalToolBoxLoaded() {
        return SignaltoolBoxLoaded;
    }

    public String getWaitedVersion() {
        return "4.21";
    }

    public SignalParser getParser() {
        return this.parser;
    }

    public SignalTreePrinter getPrinter() {
        return this.printer;
    }

    public SignalTreeBuilting getTreeBuilder() {
        return this.builder;
    }

    public SignalTreeExploring getTreeExplorer() {
        return this.explorer;
    }

    public PKTrees getTreeAPI() {
        return this.treeAPI;
    }

    public SignalTreeComment getCommentAPI() {
        return this.comment;
    }

    public TreesInterface getTraceabilityAPI() {
        return this.treesInterface;
    }

    public static void setSignalLibraryPath(String value) {
        if (SignaltoolBoxLoaded) {
            if (!"".equals(value)) {
                value = String.valueOf(value) + File.pathSeparator;
            }
            value = String.valueOf(value) + pK_SignalLib_Std;
            PKServices.setEnv("SIGNAL_LIBRARY_PATH", value);
        }
    }

    private static synchronized native void newMachine();

    private static synchronized native void initMachine();

    public static synchronized native void resetMachine();

    public static synchronized native void displayWarnings(boolean var0);

    public synchronized native void finalize();

    public static synchronized native GraphValue tree2DCG(long var0, boolean var2, long var3, boolean var5, String var6, boolean var7, boolean var8);

    public static synchronized native boolean printSignalLIS(long var0, long var2);

    public static synchronized native boolean signal2SSME(long var0, String var2);

    public static synchronized native boolean signal2SSME(String var0, String var1);

    public static synchronized native boolean signal2SME(String var0, String var1);

    public static synchronized native boolean signal2SME(long var0, String var2);

    public static synchronized native boolean genCodeC(long var0, boolean var2, boolean var3, boolean var4);

    public static synchronized native boolean genCodeCPP(long var0, boolean var2, boolean var3, boolean var4);

    public static synchronized native boolean genCodeCPPSeparate(long var0);

    public static synchronized native boolean genCodeCSeparate(long var0);

    public static synchronized native boolean DotUnparse(long var0);

    public static synchronized native boolean genCodeJava(long var0, boolean var2, boolean var3, boolean var4);

    public static synchronized native boolean genCodeJavaSeparate(long var0);

    public static synchronized native boolean expressionExpand(long var0);

    public static synchronized native boolean unparse(long var0);

    public static synchronized native long produce(long var0);

    public static synchronized native long produceFlat(long var0);

    public static synchronized native boolean SynDExUnparse(long var0);

    public static synchronized native boolean genCodeJavaThreads(long var0, boolean var2, boolean var3, boolean var4);

    public static synchronized native boolean IGraph2Vhdl(long var0);

    public static synchronized native boolean SigaliPrintExtraction(long var0);

    public static synchronized native long produceInterfaceAbstraction(long var0);

    public static synchronized native long buildAbstraction(long var0);

    public static synchronized native void memoryOptimizations(long var0, boolean var2);

    public static synchronized native GraphValue DCGPoly2DCGBool(long var0);

    public static synchronized native boolean transformBooleanClocks2Events(long var0);

    public static synchronized native void separateBooleansOthers(long var0);

    public static synchronized native GraphValue DCGBasic2DCGPoly(long var0);

    public static synchronized native boolean setIntrinsicClocks(long var0);

    public static synchronized native boolean dependenceReinforcing(long var0);

    public static synchronized native boolean addExceptionsForConstraints(long var0);

    public static synchronized native boolean hasStaticCycle(long var0, boolean var2);

    public static synchronized native boolean splitDefaultDefinitions(long var0);

    public static synchronized native boolean setDelayMemoryOverloading(long var0);

    public static synchronized native boolean moveIn2OutDelays(long var0);

    public static synchronized native void computeClockExclusions(long var0, int var2);

    public static synchronized void computeClockExclusions(long graphNode, ExclusiveClockLevelKind level) {
        PKServices.computeClockExclusions(graphNode, level.getValue());
    }

    public static synchronized native boolean expandModelReference(long var0, boolean var2);

    public static synchronized native boolean breakCPG(long var0);

    public static synchronized native boolean checkExplicitTyping(long var0);

    public static synchronized native boolean printCHStatistics(long var0);

    public static synchronized native boolean phylumClustering(long var0);

    public static synchronized native boolean buildClockProcessInterface(long var0);

    public static synchronized native boolean hasUnsolvedClockConstraints(long var0);

    public static synchronized native boolean delayTreeBuild(long var0);

    public static synchronized native boolean groupPartialDefinitions(long var0);

    public static synchronized native boolean applyTabularMorphism(long var0);

    public static synchronized native boolean buildIOClockSubHierarchy(long var0, boolean var2);

    public static synchronized native boolean nonProductiveSignalElimination(long var0);

    public static synchronized native boolean removeSignalEqualities(long var0);

    public static synchronized native boolean separatedCompilingPoly(long var0, boolean var2);

    public static synchronized native GraphValue Serializing(long var0, boolean var2, boolean var3, boolean var4, boolean var5);

    public static synchronized native boolean setClockDependences(long var0);

    public static synchronized native boolean unparseAbstraction(long var0);

    public static synchronized native boolean splitDataStructure(long var0);

    public static synchronized native void separateStatesOthers(long var0);

    public static synchronized native void computeProductiveClockStateVar(long var0);

    public static synchronized native GraphValue DCGBool2DCGFlat(long var0);

    public static synchronized native long produceSubgraph(long var0, int var2);

    public static synchronized native boolean substituteExpr2Var(long var0, int var2);

    public static synchronized native boolean computeIOTransitiveClosure(long var0);

    public static synchronized native boolean removeSignalClones(long var0);

    public static synchronized native void computeProductiveClock(long var0);

    public static synchronized native boolean LustreUnparse(long var0);

    public static synchronized native long parse(String var0, String var1);

    public static synchronized native void setEnv(String var0, String var1);

    public static synchronized native String getEnv(String var0);
}

