/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pop.ssme.polychrony.utils;

import java.io.IOException;
import org.eclipse.pop.ssme.polychrony.PKServices;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;

public class PolychronyConsole {
    private static final PolychronyConsole INSTANCE = new PolychronyConsole();
    private IOConsole console = new IOConsole("Pop console (SSME version 1.0.0, Signal Toolbox " + PKServices.pK_Version + ")", null);
    private IOConsoleOutputStream outputStream = null;

    private PolychronyConsole() {
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{this.console});
        ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)this.console);
        this.console.activate();
    }

    private IOConsoleOutputStream getOutputStream() {
        if (this.outputStream == null) {
            this.outputStream = this.console.newOutputStream();
        }
        return this.outputStream;
    }

    public void print(Color color, String message) {
        if (message == null) {
            return;
        }
        if (color != null) {
            this.changeColor(color);
        }
        IOConsoleOutputStream stream = this.getOutputStream();
        try {
            stream.write(message);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    public static void printNewLine() {
        INSTANCE.print(null, "\n");
    }

    public static void printInfo(String message) {
        INSTANCE.print(new Color((Device)Display.getCurrent(), 0, 0, 0), message);
    }

    public static void printWarning(String message) {
        INSTANCE.print(new Color((Device)Display.getCurrent(), 255, 170, 0), message);
    }

    public static void printError(String message) {
        INSTANCE.print(new Color((Device)Display.getCurrent(), 255, 0, 0), message);
    }

    public static void printDetectedError(String message) {
        PolychronyConsole.printError("Error detected : " + message);
        PolychronyConsole.printNewLine();
    }

    private void changeColor(Color c) {
        Color previousColor = this.getOutputStream().getColor();
        if (!c.equals((Object)previousColor)) {
            this.outputStream = null;
            this.getOutputStream().setColor(c);
        }
    }

    public static void clear() {
        PolychronyConsole.INSTANCE.console.clearConsole();
    }

    public void dispose() {
        try {
            this.outputStream.close();
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    public void finalize() throws Throwable {
        super.finalize();
        if (this.outputStream != null && !this.outputStream.isClosed()) {
            this.outputStream.close();
        }
    }
}

