/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pop.ssme;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TypeKind implements Enumerator
{
    BUNDLE_LITERAL(1, "bundle", "bundle"),
    STRUCT_LITERAL(0, "struct", "struct");

    public static final int BUNDLE = 1;
    public static final int STRUCT = 0;
    private static final TypeKind[] VALUES_ARRAY;
    public static final List<TypeKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TypeKind[]{BUNDLE_LITERAL, STRUCT_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TypeKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TypeKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TypeKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TypeKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TypeKind get(int value) {
        switch (value) {
            case 1: {
                return BUNDLE_LITERAL;
            }
            case 0: {
                return STRUCT_LITERAL;
            }
        }
        return null;
    }

    private TypeKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

