/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.frame.ui.annotation.impl;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.mylyn.reviews.frame.ui.annotation.IEditorInputListener;
import org.eclipse.mylyn.reviews.frame.ui.annotation.IReviewAnnotationModel;
import org.eclipse.ui.texteditor.ITextEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReviewEditorInputListener
implements IEditorInputListener {
    protected final IReviewAnnotationModel fAnnotationModel;
    protected final ISourceViewer fSourceViewer;

    public ReviewEditorInputListener(ISourceViewer aSourceViewer, IReviewAnnotationModel aAnnotationModel) {
        this.fSourceViewer = aSourceViewer;
        this.fAnnotationModel = aAnnotationModel;
    }

    @Override
    public abstract ITextEditor getEditor();

    public void inputDocumentAboutToBeChanged(IDocument aOldInput, IDocument aNewInput) {
    }

    protected abstract void addAnnotationModel(IAnnotationModel var1, IDocument var2);

    public void inputDocumentChanged(IDocument aOldInput, IDocument aNewInput) {
        if (aOldInput != null) {
            this.fAnnotationModel.disconnect(aOldInput);
        }
        if (aNewInput != null && this.fSourceViewer != null) {
            IAnnotationModel originalAnnotationModel = this.fSourceViewer.getAnnotationModel();
            this.addAnnotationModel(originalAnnotationModel, aNewInput);
        }
    }

    protected void configureViewerAnnotations(IAnnotationModel aModel, IDocument aInput) throws SecurityException, NoSuchFieldException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<SourceViewer> sourceViewerClazz = SourceViewer.class;
        Field declaredField2 = sourceViewerClazz.getDeclaredField("fVisualAnnotationModel");
        declaredField2.setAccessible(true);
        Method declaredMethod = sourceViewerClazz.getDeclaredMethod("createVisualAnnotationModel", IAnnotationModel.class);
        declaredMethod.setAccessible(true);
        aModel = (IAnnotationModel)declaredMethod.invoke((Object)this.fSourceViewer, this.fAnnotationModel);
        declaredField2.set(this.fSourceViewer, aModel);
        aModel.connect(aInput);
        this.updateVerticalRuler(sourceViewerClazz);
        this.updateOverviewRuler(sourceViewerClazz);
    }

    protected abstract void updateVerticalRuler(Class<SourceViewer> var1) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchFieldException;

    protected abstract void updateOverviewRuler(Class<SourceViewer> var1) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchFieldException;
}

