/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.frame.ui.internal.annotation.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHoverExtension;
import org.eclipse.jface.text.source.IAnnotationHoverExtension2;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension2;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.jface.text.source.projection.AnnotationBag;
import org.eclipse.mylyn.reviews.frame.ui.annotation.IReviewAnnotation;
import org.eclipse.mylyn.reviews.frame.ui.annotation.IReviewAnnotationModel;
import org.eclipse.mylyn.reviews.frame.ui.annotation.impl.ReviewAnnotationConfigFactory;
import org.eclipse.mylyn.reviews.frame.ui.annotation.impl.ReviewAnnotationHoverInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReviewAnnotationHover
implements IAnnotationHover,
IAnnotationHoverExtension,
IAnnotationHoverExtension2 {
    private final IInformationControlCreator fInformationControlCreator = ReviewAnnotationConfigFactory.createInformationControlCreator();

    public String getHoverInfo(ISourceViewer aSourceViewer, int aLineNumber) {
        return null;
    }

    public IInformationControlCreator getHoverControlCreator() {
        return this.fInformationControlCreator;
    }

    private IAnnotationModel getAnnotationModel(ISourceViewer aViewer) {
        if (aViewer instanceof ISourceViewerExtension2) {
            ISourceViewerExtension2 extension = (ISourceViewerExtension2)aViewer;
            return extension.getVisualAnnotationModel();
        }
        return aViewer.getAnnotationModel();
    }

    private boolean isContained(Annotation aAnnotation, Position aPosition, List<IReviewAnnotation> aAnnotations) {
        if (!(aAnnotation instanceof IReviewAnnotation)) {
            return false;
        }
        return !aAnnotations.contains(aAnnotation);
    }

    public Object getHoverInfo(ISourceViewer aSourceViewer, ILineRange aLineRange, int aVisibleNumberOfLines) {
        IAnnotationModel model;
        List<IReviewAnnotation> annotationsForLine = this.getAnnotationsForLine(aSourceViewer, aLineRange.getStartLine());
        if (annotationsForLine.size() > 0 && (model = aSourceViewer.getAnnotationModel()) instanceof IReviewAnnotationModel) {
            return new ReviewAnnotationHoverInput(annotationsForLine);
        }
        return this.getHoverInfo(aSourceViewer, aLineRange.getStartLine());
    }

    public boolean canHandleMouseCursor() {
        return true;
    }

    public boolean canHandleMouseWheel() {
        return true;
    }

    public ILineRange getHoverLineRange(ISourceViewer aViewer, int aLineNumber) {
        List<IReviewAnnotation> reviewAnnotations = this.getAnnotationsForLine(aViewer, aLineNumber);
        if (reviewAnnotations.size() > 0) {
            IDocument document = aViewer.getDocument();
            int lowestStart = Integer.MAX_VALUE;
            int highestEnd = 0;
            for (IReviewAnnotation a : reviewAnnotations) {
                Position p = a.getPosition();
                try {
                    int start = document.getLineOfOffset(p.offset);
                    int end = document.getLineOfOffset(p.offset + p.length);
                    if (start < lowestStart) {
                        lowestStart = start;
                    }
                    if (end <= highestEnd) continue;
                    highestEnd = end;
                }
                catch (BadLocationException e) {
                    if (ReviewAnnotationConfigFactory.getPlugin() == null) continue;
                    ReviewAnnotationConfigFactory.getPlugin().getLog().log((IStatus)new Status(4, ReviewAnnotationConfigFactory.getPlugin().getBundle().getSymbolicName(), 0, e.getMessage(), (Throwable)e));
                }
            }
            if (lowestStart != Integer.MAX_VALUE) {
                return new LineRange(lowestStart, highestEnd - lowestStart);
            }
            return new LineRange(aLineNumber, 1);
        }
        return new LineRange(aLineNumber, 1);
    }

    private boolean isRulerLine(Position aPosition, IDocument aDocument, int aLine) {
        block3: {
            if (aPosition.getOffset() > -1 && aPosition.getLength() > -1) {
                try {
                    return aLine == aDocument.getLineOfOffset(aPosition.getOffset());
                }
                catch (BadLocationException ex) {
                    if (ReviewAnnotationConfigFactory.getPlugin() == null) break block3;
                    ReviewAnnotationConfigFactory.getPlugin().getLog().log((IStatus)new Status(4, ReviewAnnotationConfigFactory.getPlugin().getBundle().getSymbolicName(), 0, ex.getMessage(), (Throwable)ex));
                }
            }
        }
        return false;
    }

    private List<IReviewAnnotation> getAnnotationsForLine(ISourceViewer aViewer, int aLine) {
        IAnnotationModel model = this.getAnnotationModel(aViewer);
        if (model == null) {
            return Collections.emptyList();
        }
        IDocument document = aViewer.getDocument();
        ArrayList<IReviewAnnotation> reviewAnnotations = new ArrayList<IReviewAnnotation>();
        Iterator it = model.getAnnotationIterator();
        while (it.hasNext()) {
            Annotation annotation2 = (Annotation)it.next();
            Position position = model.getPosition(annotation2);
            if (position == null || !this.isRulerLine(position, document, aLine)) continue;
            if (annotation2 instanceof AnnotationBag) {
                AnnotationBag bag = (AnnotationBag)annotation2;
                for (Annotation annotation2 : bag) {
                    position = model.getPosition(annotation2);
                    if (position == null || !this.isContained(annotation2, position, reviewAnnotations) || !(annotation2 instanceof IReviewAnnotation)) continue;
                    reviewAnnotations.add((IReviewAnnotation)annotation2);
                }
                continue;
            }
            if (!this.isContained(annotation2, position, reviewAnnotations) || !(annotation2 instanceof IReviewAnnotation)) continue;
            reviewAnnotations.add((IReviewAnnotation)annotation2);
        }
        return reviewAnnotations;
    }
}

