/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs;

import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.IChangeStateDialog;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewBasic;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeStateDialog
extends FormDialog
implements IChangeStateDialog {
    private static final String NEXT_REVIEW_PHASE_DIALOG_TITLE = "Select New Review Phase";
    private static final String NEXT_REVIEW_PHASE_DIALOG_VALUE = "New Phase";
    private static final String NEXT_REVIEW_PHASE_TOOLTIP = "This is used to specify the new Review Phase to advance the Review to";
    private static final String NEXT_ANOMALY_STATE_DIALOG_TITLE = "Select New Anomaly State";
    private static final String NEXT_ANOMALY_STATE_DIALOG_VALUE = "New State";
    private static final String NEXT_ANOMALY_STATE_TOOLTIP = "This is used to specify the new Anomaly State to advance the Anomaly to";
    private CCombo fNewStateCombo = null;
    private String fNewState;
    private Class<?> fElementType = null;

    public ChangeStateDialog(Shell aParentShell, Class<?> aElementType) {
        super(aParentShell);
        this.fElementType = aElementType;
        this.setBlockOnOpen(true);
    }

    protected void buttonPressed(int buttonId) {
        this.fNewState = buttonId == 0 ? this.fNewStateCombo.getText() : null;
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.fElementType.equals(R4EUIReviewBasic.class) ? NEXT_REVIEW_PHASE_DIALOG_TITLE : NEXT_ANOMALY_STATE_DIALOG_TITLE);
    }

    protected void createFormContent(IManagedForm mform) {
        FormToolkit toolkit = mform.getToolkit();
        ScrolledForm sform = mform.getForm();
        sform.setExpandVertical(true);
        Composite composite = sform.getBody();
        GridLayout layout = new GridLayout(4, false);
        composite.setLayout((Layout)layout);
        GridData textGridData = null;
        Label label = toolkit.createLabel(composite, this.fElementType.equals(R4EUIReviewBasic.class) ? NEXT_REVIEW_PHASE_DIALOG_VALUE : NEXT_ANOMALY_STATE_DIALOG_VALUE);
        label.setToolTipText("The type of the Review:  Basic Reviews are the Simplest and most Flexible ones.  Informal Reviews introduces State Tracking for Anomalies.  Formal Reviews are Structured Reviews that Conforms to the IEEE standard 1028");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fNewStateCombo = new CCombo(composite, 2056);
        textGridData = new GridData(4, 4, true, false);
        textGridData.horizontalSpan = 3;
        this.fNewStateCombo.setToolTipText(this.fElementType.equals(R4EUIReviewBasic.class) ? NEXT_REVIEW_PHASE_TOOLTIP : NEXT_ANOMALY_STATE_TOOLTIP);
        this.fNewStateCombo.setLayoutData((Object)textGridData);
    }

    @Override
    public String getState() {
        return this.fNewState;
    }

    @Override
    public void setStates(String[] aStates) {
        this.fNewStateCombo.setItems(aStates);
        this.fNewStateCombo.select(0);
    }
}

