/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.editors;

import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.reviews.frame.ui.annotation.IReviewAnnotationSupport;
import org.eclipse.mylyn.reviews.r4e.ui.internal.editors.R4ECompareEditorInput;
import org.eclipse.mylyn.reviews.r4e.ui.internal.editors.R4EDiffNode;
import org.eclipse.mylyn.reviews.r4e.ui.internal.editors.R4EFileTypedElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIFileContext;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.swt.widgets.Composite;

public class R4EFileContextCompareEditorInput
extends R4ECompareEditorInput {
    private static final String R4E_FILE_COMPARE_EDITOR_TITLE = "R4E File Compare";

    public R4EFileContextCompareEditorInput(R4EUIFileContext aContext) {
        this.fCurrentDiffNode = new R4EDiffNode(aContext, aContext, false);
        this.initConfiguration();
        this.setTitle(R4E_FILE_COMPARE_EDITOR_TITLE);
    }

    protected void initConfiguration() {
        super.initConfiguration();
        this.getCompareConfiguration().setLeftLabel(this.fCurrentDiffNode.getTargetLabel());
        this.getCompareConfiguration().setRightLabel(this.fCurrentDiffNode.getBaseLabel());
    }

    public Object getAdapter(Class aAdapter) {
        if (IFile.class.equals((Object)aAdapter)) {
            if (this.getWorkspaceElement() != null) {
                return this.getWorkspaceElement().getResource();
            }
            return null;
        }
        return super.getAdapter(aAdapter);
    }

    private R4EFileTypedElement getWorkspaceElement() {
        ITypedElement targetElement = this.fCurrentDiffNode.getTargetTypedElement();
        if (targetElement instanceof R4EFileTypedElement) {
            return (R4EFileTypedElement)targetElement;
        }
        return null;
    }

    public Viewer findContentViewer(Viewer aOldViewer, ICompareInput aInput, Composite aParent) {
        Viewer contentViewer = super.findContentViewer(aOldViewer, aInput, aParent);
        if (aInput instanceof R4EDiffNode) {
            if (((R4EDiffNode)aInput).getTargetTypedElement() instanceof R4EFileTypedElement) {
                this.getCompareConfiguration().setLeftEditable(true);
            }
            IReviewAnnotationSupport annotationSupport = UIUtils.getCompareAnnotationSupport(contentViewer, ((R4EDiffNode)aInput).getTargetFile(), null);
            ((R4EDiffNode)aInput).setAnnotationSupport(annotationSupport);
            UIUtils.insertAnnotationNavigationCommands((IToolBarManager)CompareViewerPane.getToolBarManager((Composite)aParent), annotationSupport);
        }
        return contentViewer;
    }
}

