/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.editors;

import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.rcptt.core.model.IElementChangedListener;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7ElementDelta;
import org.eclipse.rcptt.core.model.IQ7Folder;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.IQ7Project;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.Q7ElementChangedEvent;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.core.scenario.ScenarioPackage;
import org.eclipse.rcptt.core.workspace.Q7Utils;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.builder.NamedElementReferencesResolver;
import org.eclipse.rcptt.ui.dialogs.AddProjectReferencesDialog;
import org.eclipse.rcptt.ui.editors.FilenameUpdater;
import org.eclipse.rcptt.ui.editors.INamedElementEditor;
import org.eclipse.rcptt.ui.editors.IQ7NamedElementEditorPage;
import org.eclipse.rcptt.ui.editors.NamedElementEditorActions;
import org.eclipse.rcptt.ui.editors.NamedElementEditorPage;
import org.eclipse.rcptt.ui.utils.WorkbenchUtils;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.part.FileEditorInput;

public abstract class NamedElementEditor
extends FormEditor
implements IElementChangedListener,
INamedElementEditor {
    private IQ7NamedElement model;
    private NamedElement element;
    private IQ7NamedElement handle;
    private boolean resourceTracking = true;
    private FilenameUpdater filenameUpdater;
    protected NamedElementEditorActions actions;

    public IQ7NamedElement getModel() {
        return this.model;
    }

    public NamedElement getElement() {
        return this.element;
    }

    protected void setEnableResourceTracking(boolean enableResourceTracking) {
        this.resourceTracking = enableResourceTracking;
    }

    @Override
    public void setTags(String tags) {
        if (this.element != null) {
            this.element.setTags(tags);
        }
    }

    protected void updateEditorTitle() {
        this.setPartName(this.getElement().getName());
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        try {
            IFile inputFile = this.getInputFile();
            if (inputFile == null) {
                throw new PartInitException(Messages.NamedElementEditor_InvalidInputType);
            }
            if (this.resourceTracking) {
                this.handle = (IQ7NamedElement)RcpttCore.create((IResource)inputFile);
                this.filenameUpdater = new FilenameUpdater(this.handle);
                this.updateElement();
                RcpttCore.addElementChangedListener((IElementChangedListener)this);
                this.updateEditorTitle();
                this.scheduleCheckMissingReferences();
            }
        }
        catch (PartInitException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PartInitException(Messages.NamedElementEditor_LoadingFailed, (Throwable)e);
        }
    }

    private void scheduleCheckMissingReferences() {
        new Job(Messages.NamedElementEditor_Job){

            protected IStatus run(IProgressMonitor monitor) {
                NamedElementEditor.this.checkMissingReferences();
                return Status.OK_STATUS;
            }
        }.schedule(500L);
    }

    protected void updateElement() throws ModelException, PartInitException {
        if (this.resourceTracking) {
            this.makeWorkingCopy();
            this.element = this.model.getNamedElement();
            if (this.element == null) {
                this.discardWorkingCopy();
                throw new PartInitException(Messages.NamedElementEditor_InvalidInputFormat);
            }
            new ContentAdapter(this.element);
        }
    }

    private void makeWorkingCopy() throws ModelException {
        RcpttCore.removeElementChangedListener((IElementChangedListener)this);
        if (this.model != null) {
            this.discardWorkingCopy();
        }
        this.model = this.handle.getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
        RcpttCore.addElementChangedListener((IElementChangedListener)this);
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
        if (this.resourceTracking) {
            block9: {
                try {
                    try {
                        RcpttCore.removeElementChangedListener((IElementChangedListener)this);
                        this.model.commitWorkingCopy(true, monitor);
                        this.updateEditorTitle();
                        for (Object p : this.pages) {
                            if (!(p instanceof NamedElementEditorPage)) continue;
                            ((IQ7NamedElementEditorPage)p).elementChangedEvent();
                        }
                        this.firePropertyChange(257);
                    }
                    catch (Exception e) {
                        Q7UIPlugin.log(e);
                        RcpttCore.addElementChangedListener((IElementChangedListener)this);
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    RcpttCore.addElementChangedListener((IElementChangedListener)this);
                    throw throwable;
                }
                RcpttCore.addElementChangedListener((IElementChangedListener)this);
            }
            try {
                this.filenameUpdater.update(this.model);
            }
            catch (Exception e) {
                Q7UIPlugin.log(e);
            }
        }
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    @Override
    public boolean isDirty() {
        if (this.resourceTracking) {
            block4: {
                try {
                    if (this.model != null) break block4;
                    return false;
                }
                catch (ModelException e) {
                    Q7UIPlugin.log(e);
                    return true;
                }
            }
            return this.model.hasUnsavedChanges();
        }
        return super.isDirty();
    }

    public void close(boolean save) {
        super.close(save);
        try {
            this.discardWorkingCopy();
        }
        catch (ModelException e) {
            Q7UIPlugin.log(e);
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IResource.class) {
            return Q7Utils.getLocation((NamedElement)this.element);
        }
        if (adapter.isInstance(this.element)) {
            return this.element;
        }
        if (adapter.isInstance(this.model)) {
            return this.model;
        }
        return super.getAdapter(adapter);
    }

    private void update(IQ7NamedElement newOrigin, IProgressMonitor monitor) {
        try {
            try {
                RcpttCore.removeElementChangedListener((IElementChangedListener)this);
                this.discardWorkingCopy();
                this.handle = newOrigin;
                this.updateElement();
                WorkbenchUtils.uiRun(new Runnable(){

                    @Override
                    public void run() {
                        int pageIdx = NamedElementEditor.this.getActivePage();
                        while (NamedElementEditor.this.getPageCount() > 0) {
                            NamedElementEditor.this.removePage(0);
                        }
                        NamedElementEditor.this.createPages();
                        if (NamedElementEditor.this.getPageCount() > 0) {
                            if (pageIdx < NamedElementEditor.this.getPageCount()) {
                                NamedElementEditor.this.setActivePage(pageIdx);
                            } else {
                                NamedElementEditor.this.setActivePage(0);
                            }
                        }
                        NamedElementEditor.this.updateEditorTitle();
                    }
                });
                this.firePropertyChange(257);
            }
            catch (Exception e) {
                WorkbenchUtils.uiRun(new Runnable(){

                    @Override
                    public void run() {
                        NamedElementEditor.this.close(false);
                    }
                });
                Q7UIPlugin.log(e);
                RcpttCore.addElementChangedListener((IElementChangedListener)this);
            }
        }
        finally {
            RcpttCore.addElementChangedListener((IElementChangedListener)this);
        }
    }

    private void discardWorkingCopy() throws ModelException {
        if (this.resourceTracking && this.model != null) {
            this.model.discardWorkingCopy();
            this.model = null;
        }
    }

    public void removed(NamedElement element) {
        WorkbenchUtils.uiRun(new Runnable(){

            @Override
            public void run() {
                NamedElementEditor.this.getSite().getPage().closeEditor((IEditorPart)NamedElementEditor.this, false);
            }
        });
    }

    protected IFile getInputFile() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile();
        }
        return null;
    }

    public void hideTabs() {
        if (this.getContainer() instanceof CTabFolder) {
            ((CTabFolder)this.getContainer()).setTabHeight(0);
        }
    }

    public void showSearchMatch(int scenarioPart, int offset, int length) {
    }

    private boolean hasContainerChanges(IQ7ElementDelta delta) {
        IQ7ElementDelta[] deltas;
        IPath p2;
        IPath p1;
        IQ7Element element = delta.getElement();
        if ((element instanceof IQ7Project || element instanceof IQ7Folder) && delta.getKind() == 2 && (p1 = delta.getElement().getPath()).isPrefixOf(p2 = this.model.getPath())) {
            return true;
        }
        IQ7ElementDelta[] iQ7ElementDeltaArray = deltas = delta.getAffectedChildren();
        if (deltas.length != 0) {
            IQ7ElementDelta childDelta = iQ7ElementDeltaArray[0];
            return this.hasContainerChanges(childDelta);
        }
        return false;
    }

    private IQ7Element[] hasContainerMoveChanges(IQ7ElementDelta delta) {
        IQ7ElementDelta[] deltas;
        IPath p2;
        IPath p1;
        IQ7Element element = delta.getElement();
        if ((element instanceof IQ7Project || element instanceof IQ7Folder) && delta.getKind() == 2 && (p1 = delta.getElement().getPath()).isPrefixOf(p2 = this.model.getPath())) {
            if ((delta.getFlags() & 0x10) != 0 || (delta.getFlags() & 0x20) != 0) {
                return new IQ7Element[]{delta.getElement(), delta.getMovedToElement()};
            }
            return null;
        }
        IQ7ElementDelta[] iQ7ElementDeltaArray = deltas = delta.getAffectedChildren();
        int n = deltas.length;
        int n2 = 0;
        while (n2 < n) {
            IQ7ElementDelta childDelta = iQ7ElementDeltaArray[n2];
            IQ7Element[] el = this.hasContainerMoveChanges(childDelta);
            if (el != null) {
                return el;
            }
            ++n2;
        }
        return null;
    }

    public void elementChanged(Q7ElementChangedEvent event) {
        IQ7NamedElement[] namedElements;
        if (!this.resourceTracking) {
            return;
        }
        if (this.model == null) {
            return;
        }
        IQ7ElementDelta delta = event.getDelta();
        IQ7Element[] moveTo = this.hasContainerMoveChanges(delta);
        if (moveTo != null) {
            IPath relativePath = this.model.getPath().removeFirstSegments(moveTo[0].getPath().segmentCount());
            IPath newPath = moveTo[1].getPath().append(relativePath);
            this.replaceResource(RcpttCore.create((IResource)ResourcesPlugin.getWorkspace().getRoot().findMember(newPath)));
            return;
        }
        IQ7NamedElement[] iQ7NamedElementArray = namedElements = delta.getNamedElements();
        int n = namedElements.length;
        int n2 = 0;
        while (n2 < n) {
            IQ7NamedElement e = iQ7NamedElementArray[n2];
            IQ7ElementDelta childDelta = delta.getChildBy(e);
            if (this.model.equals(e)) {
                switch (childDelta.getKind()) {
                    case 2: {
                        if ((childDelta.getFlags() & 0x10) == 0 && (childDelta.getFlags() & 0x20) == 0) {
                            this.resourceRemoved(e);
                            break;
                        }
                    }
                    case 4: {
                        IQ7Element el;
                        if ((childDelta.getFlags() & 1) == 0 && (childDelta.getFlags() & 0x10) == 0 && (childDelta.getFlags() & 0x20) == 0 && (childDelta.getFlags() & 0x80000) == 0) break;
                        if ((childDelta.getFlags() & 0x20) != 0 && (el = childDelta.getMovedToElement()) != null && el instanceof IQ7NamedElement) {
                            this.replaceResource(el);
                            return;
                        }
                        this.resourceChanged(e);
                        return;
                    }
                }
            }
            ++n2;
        }
        IQ7ElementDelta[] children = delta.getAffectedChildren();
        IQ7Project project = this.model.getQ7Project();
        IQ7ElementDelta[] iQ7ElementDeltaArray = children;
        int n3 = children.length;
        int n4 = 0;
        while (n4 < n3) {
            IQ7ElementDelta c = iQ7ElementDeltaArray[n4];
            if (c.getElement().equals(project) && (c.getFlags() & 0x400) != 0) {
                this.resourceClosed(this.model);
            }
            ++n4;
        }
        if (this.hasContainerChanges(delta)) {
            this.resourceRemoved(this.model);
            return;
        }
    }

    private void replaceResource(final IQ7Element el) {
        if (!this.resourceTracking) {
            return;
        }
        try {
            RcpttCore.removeElementChangedListener((IElementChangedListener)this);
            this.discardWorkingCopy();
            RcpttCore.addElementChangedListener((IElementChangedListener)this);
            WorkbenchUtils.uiRun(new Runnable(){

                @Override
                public void run() {
                    try {
                        NamedElementEditor.this.init(NamedElementEditor.this.getEditorSite(), (IEditorInput)new FileEditorInput((IFile)el.getResource()));
                    }
                    catch (PartInitException e) {
                        Q7UIPlugin.log(e);
                    }
                }
            });
        }
        catch (ModelException e2) {
            Q7UIPlugin.log(e2);
        }
        this.resourceChanged((IQ7NamedElement)el);
    }

    private void resourceRemoved(IQ7NamedElement e) {
        WorkbenchUtils.uiRun(new Runnable(){

            @Override
            public void run() {
                NamedElementEditor.this.close(false);
            }
        });
    }

    private void resourceClosed(IQ7NamedElement e) {
        WorkbenchUtils.uiRun(new Runnable(){

            @Override
            public void run() {
                NamedElementEditor.this.close(true);
            }
        });
    }

    private void resourceChanged(final IQ7NamedElement e) {
        if (!this.resourceTracking) {
            return;
        }
        WorkbenchUtils.uiRun(new Runnable(){

            @Override
            public void run() {
                String title = Messages.NamedElementEditor_ResourceChangedDialogTitle;
                String msg = Messages.bind((String)Messages.NamedElementEditor_ResourceChangedDialogMsg, (Object)NamedElementEditor.this.getInputFile().getName());
                if (NamedElementEditor.this.isDirty()) {
                    if (MessageDialog.openQuestion((Shell)NamedElementEditor.this.getSite().getShell(), (String)title, (String)msg)) {
                        NamedElementEditor.this.update(e, NamedElementEditor.this.getProgressMonitor());
                        int pageIdx = NamedElementEditor.this.getActivePage();
                        while (NamedElementEditor.this.getPageCount() > 0) {
                            NamedElementEditor.this.removePage(0);
                        }
                        NamedElementEditor.this.createPages();
                        if (NamedElementEditor.this.getPageCount() > 0) {
                            if (pageIdx < NamedElementEditor.this.getPageCount()) {
                                NamedElementEditor.this.setActivePage(pageIdx);
                            } else {
                                NamedElementEditor.this.setActivePage(0);
                            }
                        }
                        NamedElementEditor.this.updateEditorTitle();
                        NamedElementEditor.this.firePropertyChange(257);
                    } else {
                        NamedElementEditor.this.firePropertyChange(257);
                    }
                } else {
                    NamedElementEditor.this.update(e, NamedElementEditor.this.getProgressMonitor());
                }
                NamedElementEditor.this.scheduleCheckMissingReferences();
            }
        });
    }

    protected IProgressMonitor getProgressMonitor() {
        IProgressMonitor pm = null;
        IStatusLineManager manager = this.getStatusLineManager();
        if (manager != null) {
            pm = manager.getProgressMonitor();
        }
        return pm != null ? pm : new NullProgressMonitor();
    }

    protected IStatusLineManager getStatusLineManager() {
        return this.getEditorSite().getActionBars().getStatusLineManager();
    }

    public void dispose() {
        try {
            this.discardWorkingCopy();
        }
        catch (ModelException e) {
            Q7UIPlugin.log(e);
        }
        super.dispose();
        RcpttCore.removeElementChangedListener((IElementChangedListener)this);
    }

    protected void checkMissingReferences() {
        try {
            final Map<IProject, Set<IQ7NamedElement>> missing = NamedElementReferencesResolver.resolveMissingReferences(this.getModel());
            if (!missing.isEmpty()) {
                IFile file = Q7Utils.getLocation((NamedElement)this.getElement());
                final IProject project = file.getProject();
                this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (AddProjectReferencesDialog.open(NamedElementEditor.this.getSite().getShell(), project, missing)) {
                            NamedElementEditor.this.afterMissingReferencesAdded();
                        }
                    }
                });
            }
        }
        catch (ModelException e) {
            Q7UIPlugin.log(e);
        }
    }

    protected void afterMissingReferencesAdded() {
    }

    @Override
    public void renamed(boolean wasDirty) {
    }

    public void updateEnablement() {
        if (this.actions != null) {
            this.actions.updateEnablement();
        }
    }

    public void activateActions() {
        if (this.actions != null) {
            this.actions.activate();
        }
    }

    public void deactivateActions() {
        if (this.actions != null) {
            this.actions.deactivate();
        }
    }

    public abstract void createActions();

    private class ContentAdapter
    extends EContentAdapter {
        private final NamedElement element;

        public ContentAdapter(NamedElement element) {
            this.element = element;
            element.eAdapters().add((Object)this);
        }

        public void dispose() {
            this.element.eAdapters().remove((Object)this);
        }

        public void notifyChanged(Notification msg) {
            super.notifyChanged(msg);
            if (msg.getEventType() == 9 || msg.getEventType() == 8) {
                return;
            }
            NamedElementEditor.this.updateEditorTitle();
            NamedElementEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    NamedElementEditor.this.firePropertyChange(257);
                }
            });
            if (msg.getFeature() != null && (msg.getFeature().equals(ScenarioPackage.Literals.SCENARIO__CONTEXTS) || msg.getFeature().equals(ScenarioPackage.Literals.GROUP_CONTEXT__CONTEXT_REFERENCES))) {
                NamedElementEditor.this.checkMissingReferences();
            }
        }
    }
}

