/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.report;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.rcptt.internal.launching.reporting.ReportMaker;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.launching.IExecutionSession;
import org.eclipse.rcptt.reporting.core.Q7ReportIterator;
import org.eclipse.rcptt.sherlock.core.streams.SherlockReportOutputStream;
import org.eclipse.rcptt.ui.report.ReportWizard;

public class ReportAction
extends Action {
    private final IShellProvider shell;
    private IExecutionSession session;

    public ReportAction(IShellProvider shell) {
        super(Messages.ReportAction_Name, Images.getImageDescriptor("icons/report.gif"));
        this.shell = shell;
        this.setEnabled(false);
    }

    public void setSession(IExecutionSession session) {
        this.session = session;
        this.setEnabled(session != null);
    }

    public void run() {
        SherlockReportOutputStream out;
        File root = Q7UIPlugin.getDefault().getStateLocation().append("reporting").toFile();
        root.mkdirs();
        File reportFile = new File(root, "current.report");
        if (reportFile.exists()) {
            reportFile.delete();
        }
        try {
            out = new SherlockReportOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(reportFile)));
        }
        catch (FileNotFoundException e1) {
            Q7UIPlugin.log(e1);
            return;
        }
        ProgressMonitorDialog monDialog = new ProgressMonitorDialog(this.shell.getShell());
        try {
            monDialog.run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    new ReportMaker(out).make(ReportAction.this.session, monitor);
                    out.close();
                    monitor.done();
                }
            });
        }
        catch (Throwable e) {
            Q7UIPlugin.log(e);
        }
        ReportWizard wizard = new ReportWizard(new Q7ReportIterator(reportFile), String.valueOf(this.session.getName()) + "_" + new SimpleDateFormat("yyyy_MM_dd").format(new Date()));
        IDialogSettings ds = Q7UIPlugin.getDefault().getDialogSettings().getSection("q7.reporting");
        if (ds == null) {
            ds = Q7UIPlugin.getDefault().getDialogSettings().addNewSection("q7.reporting");
        }
        wizard.setNeedsProgressMonitor(true);
        wizard.setDialogSettings(ds);
        WizardDialog dialog = new WizardDialog(this.shell.getShell(), (IWizard)wizard);
        dialog.open();
    }
}

