/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.browser;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.browser.BrowserViewer;
import org.eclipse.ui.internal.browser.FallbackScrolledComposite;
import org.eclipse.ui.internal.browser.IBrowserViewerContainer;
import org.eclipse.ui.internal.browser.Messages;

public class BrowserText {
    private String url;
    private FallbackScrolledComposite scomp;
    private Label title;
    private Label exTitle;
    private Label text;
    private Label sep;
    protected Link link;
    private BrowserViewer viewer;
    private Button button;
    private Text exception;
    private boolean expanded;
    private Throwable ex;

    public BrowserText(Composite parent, BrowserViewer viewer, Throwable ex) {
        this.viewer = viewer;
        this.ex = ex;
        Color bg = parent.getDisplay().getSystemColor(25);
        this.scomp = new ReflowScrolledComposite(parent, 768);
        Composite client = new Composite((Composite)this.scomp, 0);
        this.fillContent(client, bg);
        this.scomp.setContent((Control)client);
        this.scomp.setBackground(bg);
    }

    private void fillContent(Composite parent, Color bg) {
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 10;
        parent.setLayout((Layout)layout);
        this.title = new Label(parent, 64);
        this.title.setText(Messages.BrowserText_title);
        this.title.setFont(JFaceResources.getHeaderFont());
        this.title.setLayoutData((Object)new GridData(768));
        this.title.setBackground(bg);
        this.link = new Link(parent, 64);
        this.link.setText(Messages.BrowserText_link);
        this.link.setLayoutData((Object)new GridData(768));
        this.link.setToolTipText(Messages.BrowserText_tooltip);
        this.link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BusyIndicator.showWhile((Display)BrowserText.this.link.getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        BrowserText.this.doOpenExternal();
                    }
                });
            }
        });
        this.link.setBackground(bg);
        this.sep = new Label(parent, 258);
        this.sep.setLayoutData((Object)new GridData(768));
        this.exTitle = new Label(parent, 0);
        this.exTitle.setBackground(bg);
        this.exTitle.setFont(JFaceResources.getBannerFont());
        this.exTitle.setText(Messages.BrowserText_dtitle);
        this.exTitle.setLayoutData((Object)new GridData(768));
        this.text = new Label(parent, 64);
        this.text.setText(Messages.BrowserText_text);
        this.text.setLayoutData((Object)new GridData(768));
        this.text.setBackground(bg);
        this.button = new Button(parent, 8);
        this.updateButtonText();
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BrowserText.this.toggleException();
            }
        });
        this.exception = new Text(parent, 2);
        this.loadExceptionText();
        GridData gd = new GridData(1808);
        gd.exclude = true;
        this.exception.setLayoutData((Object)gd);
    }

    private void loadExceptionText() {
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter(swriter);
        writer.println(this.ex.getMessage());
        this.ex.printStackTrace(writer);
        writer.close();
        this.exception.setText(swriter.toString());
    }

    protected void toggleException() {
        this.expanded = !this.expanded;
        this.updateButtonText();
        GridData gd = (GridData)this.exception.getLayoutData();
        gd.exclude = !this.expanded;
        this.exception.setVisible(this.expanded);
        this.refresh();
    }

    private void updateButtonText() {
        if (this.expanded) {
            this.button.setText(Messages.BrowserText_button_collapse);
        } else {
            this.button.setText(Messages.BrowserText_button_expand);
        }
    }

    protected void updateWidth(Composite parent) {
        Rectangle area = parent.getClientArea();
        this.updateWidth((Control)this.title, area.width);
        this.updateWidth((Control)this.text, area.width);
        this.updateWidth((Control)this.sep, area.width);
        this.updateWidth((Control)this.link, area.width);
        this.updateWidth((Control)this.exTitle, area.width);
        this.updateWidth((Control)this.exception, area.width);
    }

    private void updateWidth(Control c, int width) {
        GridData gd = (GridData)c.getLayoutData();
        if (gd != null) {
            gd.widthHint = width - 10;
        }
    }

    protected void doOpenExternal() {
        IBrowserViewerContainer container = this.viewer.getContainer();
        if (container != null) {
            container.openInExternalBrowser(this.url);
        }
    }

    public Control getControl() {
        return this.scomp;
    }

    public boolean setUrl(String url) {
        this.url = url;
        return true;
    }

    public void setFocus() {
        this.link.setFocus();
    }

    public String getUrl() {
        return this.url;
    }

    public void refresh() {
        this.scomp.reflow(true);
    }

    class ReflowScrolledComposite
    extends FallbackScrolledComposite {
        public ReflowScrolledComposite(Composite parent, int style) {
            super(parent, style);
        }

        public void reflow(boolean flushCache) {
            BrowserText.this.updateWidth((Composite)this);
            super.reflow(flushCache);
        }
    }
}

