/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ctx.resources;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.ZipInputStream;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.core.IContextProcessor;
import org.eclipse.rcptt.core.Q7Features;
import org.eclipse.rcptt.core.scenario.Context;
import org.eclipse.rcptt.ctx.impl.internal.resources.Activator;
import org.eclipse.rcptt.ctx.resources.FileBuffersUtils;
import org.eclipse.rcptt.ctx.resources.WSUtils;
import org.eclipse.rcptt.ctx.resources.WorkspaceContextMaker;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.runtime.ui.UIRunnable;
import org.eclipse.rcptt.tesla.core.TeslaLimits;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.rcptt.tesla.internal.ui.player.UIJobCollector;
import org.eclipse.rcptt.util.StringUtils;
import org.eclipse.rcptt.util.resources.ResourcesUtil;
import org.eclipse.rcptt.workspace.WSFile;
import org.eclipse.rcptt.workspace.WSFileLink;
import org.eclipse.rcptt.workspace.WSFolder;
import org.eclipse.rcptt.workspace.WSFolderLink;
import org.eclipse.rcptt.workspace.WSProject;
import org.eclipse.rcptt.workspace.WSProjectLink;
import org.eclipse.rcptt.workspace.WSRoot;
import org.eclipse.rcptt.workspace.WorkspaceContext;
import org.eclipse.rcptt.workspace.WorkspaceFactory;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class WorkspaceContextProcessor
implements IContextProcessor {
    private static IWorkspaceRunnable refreshWorkspace = new IWorkspaceRunnable(){

        public void run(IProgressMonitor monitor) throws CoreException {
            Job[] autobuildJobs;
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            WorkspaceContextProcessor.autoDeleteUnexistingProjects(root);
            try {
                root.refreshLocal(2, null);
            }
            catch (CoreException e) {
                RcpttPlugin.log((String)("Failed to refresh workspace on first time cause: + " + e.getMessage()), (Throwable)e);
                root.refreshLocal(2, null);
            }
            Job[] jobArray = autobuildJobs = Job.getJobManager().find(ResourcesPlugin.FAMILY_AUTO_BUILD);
            int n = autobuildJobs.length;
            int n2 = 0;
            while (n2 < n) {
                Job job = jobArray[n2];
                job.schedule();
                ++n2;
            }
        }
    };
    private static UIRunnable<Object> clearHistory = new UIRunnable<Object>(){

        public Object run() throws CoreException {
            ResourcesPlugin.getWorkspace().getRoot().clearHistory((IProgressMonitor)new NullProgressMonitor());
            return null;
        }
    };
    private static UIRunnable<Object> clearAllFileBuffers = new UIRunnable<Object>(){

        public Object run() throws CoreException {
            FileBuffersUtils.getFileBuffers().clearAll();
            return null;
        }
    };
    private static UIRunnable<Object> closeEditorsWithResources = new UIRunnable<Object>(){

        public Object run() throws CoreException {
            IWorkbenchWindow[] workbenchWindows;
            IWorkbenchWindow[] iWorkbenchWindowArray = workbenchWindows = PlatformUI.getWorkbench().getWorkbenchWindows();
            int n = workbenchWindows.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchPage[] pages;
                IWorkbenchWindow win = iWorkbenchWindowArray[n2];
                IWorkbenchPage[] iWorkbenchPageArray = pages = win.getPages();
                int n3 = pages.length;
                int n4 = 0;
                while (n4 < n3) {
                    IEditorReference[] refs;
                    IWorkbenchPage page = iWorkbenchPageArray[n4];
                    IEditorReference[] iEditorReferenceArray = refs = page.getEditorReferences();
                    int n5 = refs.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IEditorReference ref = iEditorReferenceArray[n6];
                        this.closeEditor(page, ref);
                        ++n6;
                    }
                    ++n4;
                }
                ++n2;
            }
            return null;
        }

        private void closeEditor(IWorkbenchPage page, IEditorReference ref) throws PartInitException {
            IEditorInput editorInput = ref.getEditorInput();
            if (!editorInput.exists()) {
                return;
            }
            int attemptCount = 10;
            while (attemptCount-- > 0) {
                IWorkbenchPart part = ref.getPart(false);
                if (part == null) {
                    return;
                }
                try {
                    page.closeEditor((IEditorPart)part, false);
                }
                catch (Throwable e) {
                    RcpttPlugin.log((String)"Failed to close editor", (Throwable)e);
                }
            }
        }
    };
    private static UIRunnable<Boolean> clearOperationHistoryEntry = new UIRunnable<Boolean>(){
        private IUndoContext anyContext = new IUndoContext(){

            public boolean matches(IUndoContext context) {
                return true;
            }

            public String getLabel() {
                return "any";
            }
        };

        public Boolean run() throws CoreException {
            try {
                IOperationHistory history = OperationHistoryFactory.getOperationHistory();
                IUndoableOperation[] iUndoableOperationArray = history.getUndoHistory(this.anyContext);
                if (iUndoableOperationArray.length != 0) {
                    IUndoableOperation op = iUndoableOperationArray[0];
                    history.replaceOperation(op, new IUndoableOperation[0]);
                    return true;
                }
                iUndoableOperationArray = history.getRedoHistory(this.anyContext);
                if (iUndoableOperationArray.length != 0) {
                    IUndoableOperation op = iUndoableOperationArray[0];
                    history.replaceOperation(op, new IUndoableOperation[0]);
                    return true;
                }
            }
            catch (Throwable e) {
                RcpttPlugin.log((Throwable)e);
            }
            return false;
        }
    };

    public void apply(Context context) throws CoreException {
        final WorkspaceContext wc = (WorkspaceContext)context;
        final UIJobCollector collector = new UIJobCollector();
        Job.getJobManager().addJobChangeListener((IJobChangeListener)collector);
        try {
            try {
                final IWorkspace ws = ResourcesPlugin.getWorkspace();
                Display display = PlatformUI.getWorkbench().getDisplay();
                this.disableMessageDialogsAndEnableCollector(collector);
                ws.run(refreshWorkspace, null, 1, null);
                if (wc.isClearWorkspace()) {
                    this.clearWorkspace(wc);
                }
                final CoreException[] ee = new CoreException[1];
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ws.run(new IWorkspaceRunnable(){

                                public void run(IProgressMonitor monitor) throws CoreException {
                                    WorkspaceContextProcessor.this.fit(wc.getLocation(), wc.getContent(), true);
                                }
                            }, null, 1, null);
                        }
                        catch (CoreException e) {
                            ee[0] = e;
                        }
                    }
                });
                if (ee[0] != null) {
                    throw ee[0];
                }
                ws.run(refreshWorkspace, null, 1, null);
                UIRunnable.exec((UIRunnable)new UIRunnable<Object>(){

                    public Object run() throws CoreException {
                        collector.setNeedDisable();
                        return null;
                    }
                });
                collector.join(TeslaLimits.getContextJoinTimeout());
            }
            catch (Exception e) {
                CoreException ee = new CoreException(RcpttPlugin.createStatus((String)("Failed to execute context: " + wc.getName() + " Cause: " + e.getMessage()), (Throwable)e));
                RcpttPlugin.log((Throwable)e);
                throw ee;
            }
        }
        finally {
            SWTUIPlayer.enableMessageDialogs();
            Job.getJobManager().removeJobChangeListener((IJobChangeListener)collector);
        }
    }

    private void clearWorkspace(final WorkspaceContext wc) throws CoreException {
        final IWorkspace ws = ResourcesPlugin.getWorkspace();
        UIRunnable.exec(closeEditorsWithResources);
        UIRunnable.exec(clearAllFileBuffers);
        UIRunnable.exec(clearHistory);
        while (((Boolean)UIRunnable.exec(clearOperationHistoryEntry)).booleanValue()) {
        }
        final CoreException[] ee = new CoreException[1];
        UIRunnable.exec((UIRunnable)new UIRunnable<Object>(){

            public Object run() throws CoreException {
                try {
                    ws.run(new IWorkspaceRunnable(){

                        public void run(IProgressMonitor monitor) throws CoreException {
                            WorkspaceContextProcessor.removeWorkspaceFiles(wc);
                        }
                    }, null, 1, null);
                }
                catch (CoreException e) {
                    ee[0] = e;
                }
                return null;
            }
        });
        if (ee[0] != null) {
            throw ee[0];
        }
    }

    private static void removeWorkspaceFiles(WorkspaceContext wc) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = root.getProjects();
        String contextName = wc.getName();
        String ignoredPattern = wc.getIgnoredByClearPattern();
        String[] resolveIgnoredPattern = WorkspaceContextProcessor.resolveIgnoredPattern("", ignoredPattern);
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                if (!WorkspaceContextProcessor.isIgnored(project.getName(), resolveIgnoredPattern)) {
                    project.delete(false, true, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (CoreException e) {
                throw new CoreException(WorkspaceContextProcessor.createProjectDeleteFailStatus(contextName, project.getName(), (Exception)((Object)e)));
            }
            ++n2;
        }
        IPath path = root.getLocation();
        if (path == null) {
            return;
        }
        File file = path.toFile();
        try {
            WorkspaceContextProcessor.tryDeleteFilesExceptMetadata(file, WorkspaceContextProcessor.resolveIgnoredPattern(file.getPath(), ignoredPattern));
        }
        catch (IOException e) {
            throw new CoreException(WorkspaceContextProcessor.createContextFailStatus(contextName, e));
        }
    }

    private void disableMessageDialogsAndEnableCollector(final UIJobCollector collector) throws CoreException {
        UIRunnable.exec((UIRunnable)new UIRunnable<Object>(){

            public Object run() throws CoreException {
                SWTUIPlayer.disableMessageDialogs();
                collector.enable();
                return null;
            }
        });
    }

    public Context create(EObject param) throws CoreException {
        WorkspaceContext context = WorkspaceFactory.eINSTANCE.createWorkspaceContext();
        final WSRoot root = WorkspaceFactory.eINSTANCE.createWSRoot();
        context.setContent(root);
        final WorkspaceContextMaker maker = new WorkspaceContextMaker();
        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IProject[] projects;
                IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject iProject = iProjectArray[n2];
                    if (iProject.exists() && iProject.isOpen()) {
                        iProject.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        WSProject wsProject = WSUtils.getProject((WSRoot)root, (String)iProject.getName(), (boolean)true);
                        root.getProjects().add((Object)wsProject);
                        WorkspaceContextProcessor.this.doCreate((WSFolder)wsProject, (IContainer)iProject, maker);
                    }
                    ++n2;
                }
            }
        }, (IProgressMonitor)new NullProgressMonitor());
        return context;
    }

    private void doCreate(WSFolder folder, IContainer iContainer, WorkspaceContextMaker maker) throws CoreException {
        IResource[] iResourceArray = iContainer.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource iResource = iResourceArray[n2];
            String name = iResource.getName();
            if (iResource instanceof IFolder) {
                WSFolder child = WSUtils.getFolder((WSFolder)folder, (String)name, (boolean)true);
                this.doCreate(child, (IContainer)((IFolder)iResource), maker);
            } else if (iResource instanceof IFile) {
                IFile iFile = (IFile)iResource;
                IPath iPath = iFile.getLocation();
                if (!iFile.isLocal(0)) {
                    Activator.logWarn("Cannot retrieve contents of a file %s (%s). File skipped.", name, iFile.getLocation());
                } else {
                    File jfile;
                    WSFile child = WSUtils.getFile((WSFolder)folder, (String)name, (boolean)true);
                    if (iPath != null && (jfile = iPath.toFile()).canExecute()) {
                        child.setExecutable(true);
                    }
                    maker.makeExecutableContext(child, iFile);
                }
            }
            ++n2;
        }
    }

    private static void tryDeleteFilesExceptMetadata(File folder, String[] ignoredPatterns) throws IOException {
        ArrayList<File> undeletedResource = new ArrayList<File>();
        WorkspaceContextProcessor.deleteFilesExceptMetadata(folder, ignoredPatterns, undeletedResource, true);
        if (undeletedResource.size() > 0 && Q7Features.getInstance().isTrue("q7.contexts.workspace.clear.force.gc")) {
            System.gc();
            System.runFinalization();
            undeletedResource.clear();
            WorkspaceContextProcessor.deleteFilesExceptMetadata(folder, ignoredPatterns, undeletedResource, true);
        }
        if (undeletedResource.size() > 0) {
            StringBuilder message = new StringBuilder("Possible resource leak in AUT. Files below are locked and cannot be deleted:");
            for (File file : undeletedResource) {
                WorkspaceContextProcessor.appendFileToList(file, message);
            }
            message.append(String.format("%nExclusion patterns:", new Object[0]));
            if (ignoredPatterns == null || ignoredPatterns.length == 0) {
                message.append(String.format("%n\t<none>", new Object[0]));
            } else {
                String[] stringArray = ignoredPatterns;
                int n = ignoredPatterns.length;
                int n2 = 0;
                while (n2 < n) {
                    String pattern = stringArray[n2];
                    message.append(String.format("%n\t'%s'", pattern));
                    ++n2;
                }
            }
            throw new IOException(message.toString());
        }
    }

    private static void appendFileToList(File file, StringBuilder sb) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                WorkspaceContextProcessor.appendFileToList(child, sb);
                ++n2;
            }
        }
        sb.append(String.format("%n\t'%s'", file.getAbsolutePath()));
    }

    private static boolean deleteFilesExceptMetadata(File folder, String[] ignoredPatterns, List<File> undeletedResource, boolean root) {
        boolean haveIgnoredChild = false;
        File[] fileArray = folder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().equals(".metadata") && root || WorkspaceContextProcessor.isIgnored(file.getPath(), ignoredPatterns)) {
                haveIgnoredChild = true;
            } else {
                boolean ignoreBecauseOfChild = false;
                if (file.isDirectory()) {
                    ignoreBecauseOfChild = WorkspaceContextProcessor.deleteFilesExceptMetadata(file, ignoredPatterns, undeletedResource, false);
                    boolean bl = haveIgnoredChild = haveIgnoredChild || ignoreBecauseOfChild;
                }
                if (!ignoreBecauseOfChild && !file.delete()) {
                    undeletedResource.add(file);
                }
            }
            ++n2;
        }
        return haveIgnoredChild;
    }

    /*
     * Unable to fully structure code
     */
    private static String[] resolveIgnoredPattern(String root, String ignoredPattern) {
        if (ignoredPattern == null) {
            return null;
        }
        result = new ArrayList<String>();
        prefix = StringUtils.isEmpty((String)root) != false ? "" : Pattern.quote(root.replace('\\', '/'));
        var7_4 = ignoredPattern.split(",");
        var6_5 = var7_4.length;
        var5_6 = 0;
        while (var5_6 < var6_5) {
            block3: {
                pattern = var7_4[var5_6];
                pattern = pattern.trim();
                if (!(pattern = pattern.replace('\\', '/')).isEmpty()) ** GOTO lbl14
                break block3;
lbl-1000:
                // 1 sources

                {
                    pattern = pattern.substring(1);
lbl14:
                    // 2 sources

                    ** while (pattern.charAt((int)0) == '/')
                }
lbl15:
                // 1 sources

                pattern = StringUtils.globToRegex((String)pattern);
                result.add(StringUtils.isEmpty((String)prefix) != false ? pattern : String.format("%s/%s", new Object[]{prefix, pattern}));
            }
            ++var5_6;
        }
        return result.toArray(new String[result.size()]);
    }

    private static boolean isIgnored(String fileName, String[] ignoredPatterns) {
        if (ignoredPatterns == null) {
            return false;
        }
        String[] stringArray = ignoredPatterns;
        int n = ignoredPatterns.length;
        int n2 = 0;
        while (n2 < n) {
            String pattern = stringArray[n2];
            fileName = fileName.replace('\\', '/');
            String fileNameWithSlash = String.valueOf(fileName) + "/";
            if (fileName.matches(pattern) || fileNameWithSlash.matches(pattern)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static IStatus createProjectDeleteFailStatus(String contextName, String projectName, Exception cause) {
        return RcpttPlugin.createStatus((String)String.format("Context '%s' failed: cannot remove project '%s' from workspace", contextName, projectName), (Throwable)cause);
    }

    private static IStatus createContextFailStatus(String contextName, Exception e) {
        return RcpttPlugin.createStatus((String)("Failed to apply context \"" + contextName + "\" caused by:\n" + e.getMessage()));
    }

    private static void autoDeleteUnexistingProjects(IWorkspaceRoot root) throws CoreException {
        IProject[] projects;
        IProject[] iProjectArray = projects = root.getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IFileInfo fileInfo;
            IFileStore store;
            IProject prj = iProjectArray[n2];
            URI uri = prj.getLocationURI();
            if (uri != null && uri.getScheme() != null && (store = EFS.getStore((URI)uri)) != null && (fileInfo = store.fetchInfo()) != null && !fileInfo.exists()) {
                prj.delete(true, true, null);
                RcpttPlugin.infoLog((String)("Q7 workspace context, automatic delete of unexisting project: " + prj.getName()));
            }
            ++n2;
        }
    }

    public boolean isApplied(Context context) {
        try {
            WorkspaceContext wc = (WorkspaceContext)context;
            return this.fit(wc.getLocation(), wc.getContent(), false);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isCreateAllowed() {
        return true;
    }

    private boolean fit(String location, WSRoot root, boolean modify) throws CoreException {
        IProject rProjectFinal;
        IProject rProject;
        IWorkspaceRoot wsRoot;
        boolean success = true;
        for (WSProject project : root.getProjects()) {
            wsRoot = ResourcesPlugin.getWorkspace().getRoot();
            rProject = (IProject)ResourcesUtil.getCaseInsensitiveChild((IContainer)wsRoot, (String)project.getName(), IProject.class);
            if (rProject == null) {
                rProject = wsRoot.getProject(project.getName());
            }
            rProjectFinal = rProject;
            success &= this.fitProject(location, project, rProjectFinal, modify);
        }
        for (WSProject project : root.getProjectLinks()) {
            wsRoot = ResourcesPlugin.getWorkspace().getRoot();
            rProject = (IProject)ResourcesUtil.getCaseInsensitiveChild((IContainer)wsRoot, (String)project.getName(), IProject.class);
            if (rProject == null) {
                rProject = wsRoot.getProject(project.getName());
            }
            rProjectFinal = rProject;
            success &= this.fitProjectLink(location, (WSProjectLink)project, rProjectFinal, modify);
        }
        return success;
    }

    private boolean fitProject(String location, WSProject project, IProject rProject, boolean modify) throws CoreException {
        if (!rProject.exists()) {
            if (!modify) {
                return false;
            }
            rProject.create((IProgressMonitor)new NullProgressMonitor());
        }
        if (!rProject.isOpen()) {
            if (!modify) {
                return false;
            }
            rProject.open((IProgressMonitor)new NullProgressMonitor());
        }
        return this.fitContent(location, (WSFolder)project, (IContainer)rProject, modify);
    }

    private boolean fitProjectLink(String location, WSProjectLink project, IProject rProject, boolean modify) throws CoreException {
        if (!rProject.exists()) {
            if (!modify) {
                return false;
            }
            rProject.create((IProgressMonitor)new NullProgressMonitor());
        }
        if (!rProject.isOpen()) {
            if (!modify) {
                return false;
            }
            rProject.open((IProgressMonitor)new NullProgressMonitor());
        }
        return this.fitContent(location, (WSFolderLink)project, (IContainer)rProject, modify);
    }

    private boolean fitContent(String location, WSFolder folder, IContainer rFolder, boolean modify) throws CoreException {
        IFolder rChild;
        boolean success = true;
        for (WSFolder child : folder.getFolders()) {
            rChild = rFolder.getFolder((IPath)new Path(child.getName()));
            success &= this.fitFolder(location, child, rChild, modify);
        }
        for (WSFolder child : folder.getFolderLinks()) {
            rChild = rFolder.getFolder((IPath)new Path(child.getName()));
            success &= this.fitFolderLink(location, (WSFolderLink)child, rChild, modify);
        }
        for (WSFolder child : folder.getFiles()) {
            rChild = rFolder.getFile((IPath)new Path(child.getName()));
            success &= this.fitFile(location, (WSFile)child, (IFile)rChild, modify);
        }
        for (WSFolder child : folder.getFileLinks()) {
            rChild = rFolder.getFile((IPath)new Path(child.getName()));
            success &= this.fitFileLink(location, (WSFileLink)child, (IFile)rChild, modify);
        }
        return success;
    }

    private boolean fitContent(String location, WSFolderLink folder, IContainer rFolder, boolean modify) throws CoreException {
        IFolder rChild;
        boolean success = true;
        for (WSFolderLink child : folder.getFolders()) {
            rChild = rFolder.getFolder((IPath)new Path(child.getName()));
            success &= this.fitFolderLink(location, child, rChild, modify);
        }
        for (WSFolderLink child : folder.getFiles()) {
            rChild = rFolder.getFile((IPath)new Path(child.getName()));
            success &= this.fitFileLink(location, (WSFileLink)child, (IFile)rChild, modify);
        }
        return success;
    }

    private boolean fitFolder(String location, WSFolder folder, IFolder rFolder, boolean modify) throws CoreException {
        if (!rFolder.exists()) {
            if (!modify) {
                return false;
            }
            rFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        return this.fitContent(location, folder, (IContainer)rFolder, modify);
    }

    private boolean fitFolderLink(String location, WSFolderLink folder, IFolder rFolder, boolean modify) throws CoreException {
        if (!rFolder.exists()) {
            if (!modify) {
                return false;
            }
            rFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        return this.fitContent(location, folder, (IContainer)rFolder, modify);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean fitFile(String location, WSFile file, IFile rFile, boolean modify) throws CoreException {
        if (!rFile.exists() && !modify) {
            return false;
        }
        try {
            byte[] content = null;
            if (file.getContent() == null) {
                content = WSUtils.getFileContent((String)location, (WSFile)file);
            } else if (Q7Features.getInstance().isTrue("q7.contexts.resources.transfer.zipped")) {
                ZipInputStream zin = new ZipInputStream(new ByteArrayInputStream(file.getContent()));
                zin.getNextEntry();
                content = WSUtils.getStreamContent((InputStream)zin);
            } else {
                content = file.getContent();
            }
            ByteArrayInputStream input = new ByteArrayInputStream(content);
            if (rFile.exists()) {
                InputStream fileContent = rFile.getContents();
                try {
                    if (this.isEquals(content, fileContent)) {
                        return true;
                    }
                }
                finally {
                    WSUtils.safeClose((Closeable)fileContent);
                }
                if (!modify) {
                    return false;
                }
                rFile.setContents((InputStream)input, false, false, (IProgressMonitor)new NullProgressMonitor());
                if (file.isExecutable()) {
                    this.updateFilePermissions(rFile);
                }
                FileBuffersUtils.getFileBuffers().syncLocation(rFile.getFullPath());
                return true;
            }
            rFile.create((InputStream)input, false, (IProgressMonitor)new NullProgressMonitor());
            if (file.isExecutable()) {
                this.updateFilePermissions(rFile);
            }
            FileBuffersUtils.getFileBuffers().syncLocation(rFile.getFullPath());
            return true;
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.rcptt.ctx.resources.impl", e.getMessage(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private void updateFilePermissions(IFile rFile) {
        IPath fileLocation = rFile.getLocation();
        if (fileLocation != null) {
            File jFile = fileLocation.toFile();
            try {
                boolean result = jFile.setExecutable(true, true);
                if (!result) {
                    RcpttPlugin.log((String)String.format("Failed to set executable permission to file: %s", jFile.getAbsolutePath()), null);
                }
            }
            catch (SecurityException e) {
                RcpttPlugin.log((String)String.format("Failed to set executable permission to file: %s", jFile.getAbsolutePath()), (Throwable)e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean fitFileLink(String location, WSFileLink fileLink, IFile rFile, boolean modify) throws CoreException {
        if (!rFile.exists() && !modify) {
            return false;
        }
        try {
            byte[] content = fileLink.getContent();
            if (Q7Features.getInstance().isTrue("q7.contexts.resources.transfer.zipped")) {
                ZipInputStream zin = new ZipInputStream(new ByteArrayInputStream(content));
                zin.getNextEntry();
                content = WSUtils.getStreamContent((InputStream)zin);
            }
            ByteArrayInputStream input = new ByteArrayInputStream(content);
            if (!rFile.exists()) {
                rFile.create((InputStream)input, false, (IProgressMonitor)new NullProgressMonitor());
                return true;
            }
            InputStream fileContent = rFile.getContents();
            try {
                if (this.isEquals(content, fileContent)) {
                    return true;
                }
            }
            finally {
                WSUtils.safeClose((Closeable)fileContent);
            }
            if (!modify) {
                return false;
            }
            rFile.setContents((InputStream)input, false, false, (IProgressMonitor)new NullProgressMonitor());
            return true;
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.rcptt.ctx.resources.impl", e.getMessage(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private boolean isEquals(byte[] content, InputStream stream) throws IOException {
        byte[] buffer = new byte[4096];
        int len = 0;
        int offset = 0;
        while ((len = stream.read(buffer)) > 0) {
            int i = 0;
            while (i < len) {
                if (buffer[i] != content[i + offset]) {
                    return false;
                }
                ++i;
            }
            offset += len;
        }
        return true;
    }
}

