/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.rcptt.core.ecl.core.model.ExecutionPhase;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.internal.launching.Executable;
import org.eclipse.rcptt.internal.launching.Q7LaunchingPlugin;
import org.eclipse.rcptt.launching.AutLaunch;

public abstract class DataExecutable
extends Executable {
    protected IQ7NamedElement element;
    private long time;
    private IStatus resultStatus;
    private boolean terminated;
    protected int status = 1;
    protected AutLaunch launch;
    protected boolean terminateUser = false;
    protected NullProgressMonitor executionMonitor;

    public DataExecutable(AutLaunch launch, IQ7NamedElement element, boolean debug) {
        this(launch, element, debug, ExecutionPhase.AUTO);
    }

    public DataExecutable(AutLaunch launch, IQ7NamedElement element, boolean debug, ExecutionPhase phase) {
        super(debug, phase);
        this.element = element;
        this.launch = launch;
        this.executionMonitor = new NullProgressMonitor();
    }

    @Override
    public AutLaunch getAut() {
        return this.launch;
    }

    @Override
    public String getName() {
        String nameByDocument = Q7SearchCore.findNameByDocument((IQ7Element)this.element);
        if (nameByDocument != null) {
            return nameByDocument;
        }
        try {
            return this.element.getElementName();
        }
        catch (ModelException modelException) {
            if (!this.element.getResource().exists()) {
                return "Resource: " + this.element.getResource().getFullPath() + " doesn't exist.";
            }
            return "Unresolved element";
        }
    }

    @Override
    public String getId() {
        try {
            String id = Q7SearchCore.findIDByDocument((IQ7Element)this.element);
            if (id == null) {
                id = this.element.getID();
            }
            return id;
        }
        catch (ModelException e) {
            Q7LaunchingPlugin.log(e);
            return null;
        }
    }

    @Override
    public Executable[] getChildren() {
        return EMPTY;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public void startLaunching() {
        this.status = 2;
    }

    /*
     * Loose catch block
     */
    @Override
    public IStatus execute() throws InterruptedException {
        block8: {
            long startTime = System.currentTimeMillis();
            try {
                this.resultStatus = this.doExecute();
            }
            catch (CoreException ce) {
                this.resultStatus = ce.getStatus();
                this.time = System.currentTimeMillis() - startTime;
                this.status = this.resultStatus.getSeverity() == 0 ? 0 : 3;
                break block8;
            }
            catch (Exception e) {
                this.resultStatus = Q7LaunchingPlugin.createStatus(e.getMessage(), e);
                this.time = System.currentTimeMillis() - startTime;
                this.status = this.resultStatus.getSeverity() == 0 ? 0 : 3;
                break block8;
            }
            catch (Throwable e) {
                this.resultStatus = Q7LaunchingPlugin.createStatus(e.getMessage(), e);
                {
                    catch (Throwable throwable) {
                        this.time = System.currentTimeMillis() - startTime;
                        this.status = this.resultStatus.getSeverity() == 0 ? 0 : 3;
                        throw throwable;
                    }
                }
                this.time = System.currentTimeMillis() - startTime;
                this.status = this.resultStatus.getSeverity() == 0 ? 0 : 3;
                break block8;
            }
            this.time = System.currentTimeMillis() - startTime;
            this.status = this.resultStatus.getSeverity() == 0 ? 0 : 3;
        }
        return this.resultStatus;
    }

    @Override
    public void terminate(boolean user) {
        this.terminated = true;
        this.terminateUser = user;
        if (this.executionMonitor != null) {
            this.executionMonitor.setCanceled(true);
        }
    }

    @Override
    public boolean isTerminated() {
        return this.terminated;
    }

    public boolean isTerminateUser() {
        return this.terminateUser;
    }

    protected abstract IStatus doExecute() throws CoreException, InterruptedException;

    @Override
    public IStatus getResultStatus() {
        return this.resultStatus;
    }

    @Override
    public long getTime() {
        return this.time;
    }

    @Override
    public IQ7NamedElement getActualElement() {
        return this.element;
    }

    public void updateStatus(int newStatus) {
        this.status = newStatus;
    }

    @Override
    public void postExecute() {
    }
}

