/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.ecl.parser.ScriptErrorStatus;
import org.eclipse.rcptt.internal.launching.ExecutionStatus;
import org.eclipse.rcptt.util.StringUtils;

public class EclStackTrace {
    public final IStatus rootCause;
    public final ScriptErrorStatus[] frames;

    private EclStackTrace(IStatus rootCause, ScriptErrorStatus[] trace) {
        this.rootCause = rootCause;
        this.frames = trace;
    }

    public static EclStackTrace fromExecStatus(ExecutionStatus status) {
        while (status.getCause() instanceof ExecutionStatus) {
            status = (ExecutionStatus)status.getCause();
        }
        ArrayList<ScriptErrorStatus> trace = new ArrayList<ScriptErrorStatus>();
        IStatus cause = status.getCause();
        while (cause instanceof ScriptErrorStatus) {
            trace.add((ScriptErrorStatus)cause);
            cause = ((ScriptErrorStatus)cause).getCause();
        }
        Collections.reverse(trace);
        return new EclStackTrace(cause, trace.toArray(new ScriptErrorStatus[trace.size()]));
    }

    public String print() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getDisplayMessage()).append("\n");
        ScriptErrorStatus[] scriptErrorStatusArray = this.frames;
        int n = this.frames.length;
        int n2 = 0;
        while (n2 < n) {
            ScriptErrorStatus frame = scriptErrorStatusArray[n2];
            sb.append(String.format("\tat %s (%s)", frame.getMessage(), EclStackTrace.getLocation(frame))).append("\n");
            ++n2;
        }
        return sb.toString();
    }

    public String getDisplayMessage() {
        if (this.rootCause == null) {
            return "Execution failed";
        }
        if (!StringUtils.isBlank((String)this.rootCause.getMessage())) {
            return this.rootCause.getMessage();
        }
        if (this.rootCause.getException() != null) {
            return this.rootCause.getException().getMessage();
        }
        return "Unknown reason";
    }

    public static String getLocation(ScriptErrorStatus status) {
        String id = status.getResource();
        String path = RcpttCore.getResourcePath((String)id);
        return path == null ? String.format("line %d", status.getLine()) : String.format("%s:%d", path, status.getLine());
    }
}

