/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.verifications.tree.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.rcptt.verifications.tree.Cell;
import org.eclipse.rcptt.verifications.tree.Column;
import org.eclipse.rcptt.verifications.tree.Row;
import org.eclipse.rcptt.verifications.tree.Tree;

public class TreeVerificationModelIterator {
    private Tree tree;
    private Row item;
    private List<Row> currentItems;
    int itemInd = 0;
    private Stack<Row> itemPath = new Stack();
    private Stack<Integer> itemInds = new Stack();

    public TreeVerificationModelIterator(Tree tree) {
        this.tree = tree;
        this.currentItems = tree.getRows();
        this.item = this.toFirstItem();
    }

    public Row nextInto() {
        this.stepInto();
        if (this.getItemsCount() == 0) {
            return this.stepReturn();
        }
        return this.item;
    }

    public Row nextOver() {
        ++this.itemInd;
        if (this.currentItems.size() > this.itemInd) {
            this.item = this.currentItems.get(this.itemInd);
            return this.getItem();
        }
        return null;
    }

    public Row stepReturn() {
        do {
            this.stepOut();
        } while (this.itemPath.size() > 0 && this.itemInd >= this.currentItems.size() - 1);
        Row next = this.nextOver();
        if (next == null && !this.isEnd()) {
            return this.stepReturn();
        }
        return next;
    }

    public Row toFirstItem() {
        this.itemInd = 0;
        if (this.currentItems.size() > 0) {
            return this.currentItems.get(0);
        }
        return null;
    }

    public List<Integer> getItemIndexPath() {
        ArrayList<Integer> path = new ArrayList<Integer>(this.itemInds);
        path.add(this.itemInd);
        return path;
    }

    public String getNonBlankItemPath() {
        return this.getNonBlankItemPath(false);
    }

    public String getNonBlankPath() {
        return this.getNonBlankItemPath(true);
    }

    public String getNonBlankItemPath(boolean pathOnly) {
        StringBuilder sb = new StringBuilder();
        for (Row curItem : this.itemPath) {
            sb.append(this.appendNonBlankItemText(curItem));
            sb.append("/");
        }
        if (!pathOnly) {
            sb.append(this.appendNonBlankItemText(this.item));
        } else if (this.itemPath.size() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private String appendNonBlankItemText(Row item) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < item.getValues().size()) {
            if (!((Cell)item.getValues().get(i)).getData().getText().equals("")) {
                sb.append(((Cell)item.getValues().get(i)).getData().getText());
                if (i == 0) break;
                sb.append(String.format("(column \"%s\")", ((Column)this.tree.getColumns().get(i)).getName()));
                break;
            }
            ++i;
        }
        return sb.toString();
    }

    private String getFullItemPath(boolean pathOnly) {
        StringBuilder sb = new StringBuilder();
        for (Row curItem : this.itemPath) {
            sb.append(curItem.getData().getText()).append("/");
        }
        if (!pathOnly) {
            sb.append(this.item.getData().getText());
        } else if (this.itemPath.size() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public String getFullItemPath() {
        return this.getFullItemPath(false);
    }

    public String getPath() {
        return this.itemPath.size() > 0 ? this.getFullItemPath(true) : null;
    }

    public int getNestingLevel() {
        return this.itemPath.size();
    }

    public Row getItem() {
        return this.item;
    }

    public int getItemIndex() {
        return this.itemInd;
    }

    public int getItemsCount() {
        return this.currentItems.size();
    }

    private void stepInto() {
        this.itemPath.push(this.item);
        this.itemInds.push(this.itemInd);
        this.currentItems = this.item.getChildren();
        this.item = this.toFirstItem();
    }

    private void stepOut() {
        if (this.itemPath.size() > 0) {
            this.item = this.itemPath.pop();
            this.itemInd = this.itemInds.pop();
            this.currentItems = this.itemPath.size() == 0 ? this.tree.getRows() : this.itemPath.peek().getChildren();
        }
    }

    public boolean isEnd() {
        return this.currentItems.size() <= this.itemInd && this.itemPath.empty();
    }
}

