/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.selection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.egit.core.AdapterUtils;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.revision.FileRevisionEditorInput;
import org.eclipse.egit.ui.internal.trace.GitTraceLocation;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.services.IServiceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionUtils {
    public static Repository getRepository(IStructuredSelection selection) {
        return SelectionUtils.getRepository(false, selection, null);
    }

    public static Repository getRepository(IEvaluationContext evaluationContext) {
        return SelectionUtils.getRepository(false, SelectionUtils.getSelection(evaluationContext), null);
    }

    public static Repository getRepositoryOrWarn(IStructuredSelection selection, Shell shell) {
        return SelectionUtils.getRepository(true, selection, shell);
    }

    public static IStructuredSelection getSelection(IEvaluationContext context) {
        if (context == null) {
            return StructuredSelection.EMPTY;
        }
        Object selection = context.getVariable("activeMenuSelection");
        if (!(selection instanceof ISelection)) {
            selection = context.getVariable("selection");
        }
        if (selection instanceof ITextSelection) {
            return SelectionUtils.getSelectionFromEditorInput(context);
        }
        if (selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }

    public static IStructuredSelection getStructuredSelection(ISelection selection) {
        if (selection instanceof ITextSelection) {
            return SelectionUtils.getSelectionFromEditorInput(SelectionUtils.getEvaluationContext());
        }
        if (selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }

    public static IPath[] getSelectedLocations(IStructuredSelection selection) {
        LinkedHashSet<IPath> result = new LinkedHashSet<IPath>();
        for (Object o : selection.toList()) {
            IPath location;
            IResource resource = (IResource)AdapterUtils.adapt(o, IResource.class);
            if (resource != null) {
                location = resource.getLocation();
                if (location == null) continue;
                result.add(location);
                continue;
            }
            location = (IPath)AdapterUtils.adapt(o, IPath.class);
            if (location != null) {
                result.add(location);
                continue;
            }
            for (IResource r : SelectionUtils.extractResourcesFromMapping(o)) {
                IPath l = r.getLocation();
                if (l == null) continue;
                result.add(l);
            }
        }
        return result.toArray(new IPath[result.size()]);
    }

    public static IResource[] getSelectedResources(IStructuredSelection selection) {
        LinkedHashSet<IResource> result = new LinkedHashSet<IResource>();
        for (Object o : selection.toList()) {
            IResource resource = (IResource)AdapterUtils.adapt(o, IResource.class);
            if (resource != null) {
                result.add(resource);
                continue;
            }
            result.addAll(SelectionUtils.extractResourcesFromMapping(o));
        }
        return result.toArray(new IResource[result.size()]);
    }

    private static List<IResource> extractResourcesFromMapping(Object o) {
        ResourceTraversal[] traversals;
        ResourceMapping mapping = (ResourceMapping)AdapterUtils.adapt((Object)o, ResourceMapping.class);
        if (mapping == null) {
            return Collections.emptyList();
        }
        try {
            traversals = mapping.getTraversals(null, null);
        }
        catch (CoreException e) {
            Activator.logError(e.getMessage(), e);
            return Collections.emptyList();
        }
        if (traversals.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<IResource> result = new ArrayList<IResource>();
        ResourceTraversal[] resourceTraversalArray = traversals;
        int n = traversals.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceTraversal traversal = resourceTraversalArray[n2];
            IResource[] resources = traversal.getResources();
            result.addAll(Arrays.asList(resources));
            ++n2;
        }
        return result;
    }

    private static Repository getRepository(boolean warn, IStructuredSelection selection, Shell shell) {
        RepositoryMapping mapping = null;
        Object[] locations = SelectionUtils.getSelectedLocations(selection);
        if (GitTraceLocation.SELECTION.isActive()) {
            GitTraceLocation.getTrace().trace(GitTraceLocation.SELECTION.getLocation(), "selection=" + selection + ", locations=" + Arrays.toString(locations));
        }
        Object[] objectArray = locations;
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            Object location = objectArray[n2];
            RepositoryMapping repositoryMapping = RepositoryMapping.getMapping((IPath)location);
            if (mapping == null) {
                mapping = repositoryMapping;
            }
            if (repositoryMapping == null) {
                return null;
            }
            if (mapping.getRepository() != repositoryMapping.getRepository()) {
                if (warn) {
                    MessageDialog.openError((Shell)shell, (String)UIText.RepositoryAction_multiRepoSelectionTitle, (String)UIText.RepositoryAction_multiRepoSelection);
                }
                return null;
            }
            ++n2;
        }
        Repository result = null;
        if (mapping == null) {
            Object[] objectArray2 = selection.toArray();
            int n3 = objectArray2.length;
            n = 0;
            while (n < n3) {
                Object o = objectArray2[n];
                Repository nextRepo = null;
                if (o instanceof Repository) {
                    nextRepo = (Repository)o;
                } else if (o instanceof PlatformObject) {
                    nextRepo = (Repository)((PlatformObject)o).getAdapter(Repository.class);
                }
                if (nextRepo != null && result != null && !result.equals(nextRepo)) {
                    if (warn) {
                        MessageDialog.openError((Shell)shell, (String)UIText.RepositoryAction_multiRepoSelectionTitle, (String)UIText.RepositoryAction_multiRepoSelection);
                    }
                    return null;
                }
                result = nextRepo;
                ++n;
            }
        } else {
            result = mapping.getRepository();
        }
        if (result == null) {
            if (warn) {
                MessageDialog.openError((Shell)shell, (String)UIText.RepositoryAction_errorFindingRepoTitle, (String)UIText.RepositoryAction_errorFindingRepo);
            }
            return null;
        }
        return result;
    }

    private static IStructuredSelection getSelectionFromEditorInput(IEvaluationContext context) {
        Object editor;
        Object object = context.getVariable("activeEditorInput");
        if (!(object instanceof IEditorInput) && (editor = context.getVariable("activeEditor")) instanceof IEditorPart) {
            object = ((IEditorPart)editor).getEditorInput();
        }
        if (object instanceof IEditorInput) {
            FileRevisionEditorInput fileRevisionEditorInput;
            IFileRevision fileRevision;
            IEditorInput editorInput = (IEditorInput)object;
            IResource resource = ResourceUtil.getResource((IEditorInput)editorInput);
            if (resource != null) {
                return new StructuredSelection((Object)resource);
            }
            if (editorInput instanceof FileRevisionEditorInput && (fileRevision = (fileRevisionEditorInput = (FileRevisionEditorInput)editorInput).getFileRevision()) != null) {
                return new StructuredSelection((Object)fileRevision);
            }
        }
        return StructuredSelection.EMPTY;
    }

    private static IEvaluationContext getEvaluationContext() {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return null;
        }
        IHandlerService hsr = CommonUtils.getService((IServiceLocator)activeWorkbenchWindow, IHandlerService.class);
        IEvaluationContext ctx = hsr.getCurrentState();
        return ctx;
    }
}

