/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.Message;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodReference;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.UnionType;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTFlattener;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.dom.TokenScanner;
import org.eclipse.jdt.internal.corext.dom.TypeBindingVisitor;
import org.eclipse.jdt.internal.corext.dom.TypeRules;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.MembersOrderPreferenceCache;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTNodes {
    public static final int NODE_ONLY = 0;
    public static final int INCLUDE_FIRST_PARENT = 1;
    public static final int INCLUDE_ALL_PARENTS = 2;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    public static final int PROBLEMS = 3;
    private static final Message[] EMPTY_MESSAGES = new Message[0];
    private static final IProblem[] EMPTY_PROBLEMS = new IProblem[0];
    private static final int CLEAR_VISIBILITY = -8;

    private ASTNodes() {
    }

    public static String asString(ASTNode node) {
        ASTFlattener flattener = new ASTFlattener();
        node.accept((ASTVisitor)flattener);
        return flattener.getResult();
    }

    public static String asFormattedString(ASTNode node, int indent, String lineDelim, Map<String, String> options) {
        String unformatted = ASTNodes.asString(node);
        TextEdit edit = CodeFormatterUtil.format2(node, unformatted, indent, lineDelim, options);
        if (edit != null) {
            Document document = new Document(unformatted);
            try {
                edit.apply((IDocument)document, 0);
            }
            catch (BadLocationException e) {
                JavaPlugin.log(e);
            }
            return document.get();
        }
        return unformatted;
    }

    public static String getNodeSource(ASTNode node, boolean extendedRange, boolean removeIndent) {
        ASTNode root = node.getRoot();
        if (root instanceof CompilationUnit) {
            CompilationUnit astRoot = (CompilationUnit)root;
            ITypeRoot typeRoot = astRoot.getTypeRoot();
            try {
                if (typeRoot != null && typeRoot.getBuffer() != null) {
                    IBuffer buffer = typeRoot.getBuffer();
                    int offset = extendedRange ? astRoot.getExtendedStartPosition(node) : node.getStartPosition();
                    int length = extendedRange ? astRoot.getExtendedLength(node) : node.getLength();
                    String str = buffer.getText(offset, length);
                    if (removeIndent) {
                        IJavaProject project = typeRoot.getJavaProject();
                        int indent = StubUtility.getIndentUsed(buffer, node.getStartPosition(), project);
                        str = Strings.changeIndent(str, indent, project, new String(), typeRoot.findRecommendedLineSeparator());
                    }
                    return str;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return null;
    }

    public static List<? extends ASTNode> getContainingList(ASTNode node) {
        StructuralPropertyDescriptor locationInParent = node.getLocationInParent();
        if (locationInParent != null && locationInParent.isChildListProperty()) {
            return ASTNodes.getChildListProperty(node.getParent(), (ChildListPropertyDescriptor)locationInParent);
        }
        return null;
    }

    public static <T extends ASTNode> List<T> getChildListProperty(ASTNode node, ChildListPropertyDescriptor propertyDescriptor) {
        return (List)node.getStructuralProperty((StructuralPropertyDescriptor)propertyDescriptor);
    }

    public static List<ASTNode> getChildren(ASTNode node) {
        ChildrenCollector visitor = new ChildrenCollector();
        node.accept((ASTVisitor)visitor);
        return visitor.result;
    }

    public static boolean isExistingNode(ASTNode node) {
        return node.getStartPosition() != -1;
    }

    public static Type getElementType(Type type) {
        if (!type.isArrayType()) {
            return type;
        }
        return ((ArrayType)type).getElementType();
    }

    public static ASTNode findDeclaration(IBinding binding, ASTNode root) {
        if ((root = root.getRoot()) instanceof CompilationUnit) {
            return ((CompilationUnit)root).findDeclaringNode(binding);
        }
        return null;
    }

    public static VariableDeclaration findVariableDeclaration(IVariableBinding binding, ASTNode root) {
        if (binding.isField()) {
            return null;
        }
        ASTNode result = ASTNodes.findDeclaration((IBinding)binding, root);
        if (result instanceof VariableDeclaration) {
            return (VariableDeclaration)result;
        }
        return null;
    }

    public static Type getType(VariableDeclaration declaration) {
        if (declaration instanceof SingleVariableDeclaration) {
            return ((SingleVariableDeclaration)declaration).getType();
        }
        if (declaration instanceof VariableDeclarationFragment) {
            ASTNode parent = ((VariableDeclarationFragment)declaration).getParent();
            if (parent instanceof VariableDeclarationExpression) {
                return ((VariableDeclarationExpression)parent).getType();
            }
            if (parent instanceof VariableDeclarationStatement) {
                return ((VariableDeclarationStatement)parent).getType();
            }
            if (parent instanceof FieldDeclaration) {
                return ((FieldDeclaration)parent).getType();
            }
            if (parent instanceof LambdaExpression) {
                return null;
            }
        }
        Assert.isTrue((boolean)false, (String)"Unknown VariableDeclaration");
        return null;
    }

    public static int getDimensions(VariableDeclaration declaration) {
        int dim = declaration.getExtraDimensions();
        if (declaration instanceof VariableDeclarationFragment && declaration.getParent() instanceof LambdaExpression) {
            LambdaExpression lambda = (LambdaExpression)declaration.getParent();
            IMethodBinding methodBinding = lambda.resolveMethodBinding();
            if (methodBinding != null) {
                ITypeBinding[] parameterTypes = methodBinding.getParameterTypes();
                int index = lambda.parameters().indexOf(declaration);
                ITypeBinding typeBinding = parameterTypes[index];
                return typeBinding.getDimensions();
            }
        } else {
            Type type = ASTNodes.getType(declaration);
            if (type instanceof ArrayType) {
                dim += ((ArrayType)type).getDimensions();
            }
        }
        return dim;
    }

    public static List<IExtendedModifier> getModifiers(VariableDeclaration declaration) {
        Assert.isNotNull((Object)declaration);
        if (declaration instanceof SingleVariableDeclaration) {
            return ((SingleVariableDeclaration)declaration).modifiers();
        }
        if (declaration instanceof VariableDeclarationFragment) {
            ASTNode parent = declaration.getParent();
            if (parent instanceof VariableDeclarationExpression) {
                return ((VariableDeclarationExpression)parent).modifiers();
            }
            if (parent instanceof VariableDeclarationStatement) {
                return ((VariableDeclarationStatement)parent).modifiers();
            }
        }
        return new ArrayList<IExtendedModifier>(0);
    }

    public static boolean isSingleDeclaration(VariableDeclaration declaration) {
        Assert.isNotNull((Object)declaration);
        if (declaration instanceof SingleVariableDeclaration) {
            return true;
        }
        if (declaration instanceof VariableDeclarationFragment) {
            ASTNode parent = declaration.getParent();
            if (parent instanceof VariableDeclarationExpression) {
                return ((VariableDeclarationExpression)parent).fragments().size() == 1;
            }
            if (parent instanceof VariableDeclarationStatement) {
                return ((VariableDeclarationStatement)parent).fragments().size() == 1;
            }
        }
        return false;
    }

    public static boolean isLiteral(Expression expression) {
        int type = expression.getNodeType();
        return type == 9 || type == 13 || type == 33 || type == 34 || type == 45 || type == 57;
    }

    public static boolean isLabel(SimpleName name) {
        int parentType = name.getParent().getNodeType();
        return parentType == 30 || parentType == 10 || parentType != 18;
    }

    public static boolean isStatic(BodyDeclaration declaration) {
        return Modifier.isStatic((int)declaration.getModifiers());
    }

    public static List<BodyDeclaration> getBodyDeclarations(ASTNode node) {
        if (node instanceof AbstractTypeDeclaration) {
            return ((AbstractTypeDeclaration)node).bodyDeclarations();
        }
        if (node instanceof AnonymousClassDeclaration) {
            return ((AnonymousClassDeclaration)node).bodyDeclarations();
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    public static ChildListPropertyDescriptor getBodyDeclarationsProperty(ASTNode node) {
        if (node instanceof AbstractTypeDeclaration) {
            return ((AbstractTypeDeclaration)node).getBodyDeclarationsProperty();
        }
        if (node instanceof AnonymousClassDeclaration) {
            return AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY;
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    public static String getTypeName(Type type) {
        final StringBuffer buffer = new StringBuffer();
        ASTVisitor visitor = new ASTVisitor(){

            public boolean visit(PrimitiveType node) {
                buffer.append(node.getPrimitiveTypeCode().toString());
                return false;
            }

            public boolean visit(SimpleType node) {
                buffer.append(ASTNodes.getSimpleNameIdentifier(node.getName()));
                return false;
            }

            public boolean visit(QualifiedType node) {
                buffer.append(node.getName().getIdentifier());
                return false;
            }

            public boolean visit(NameQualifiedType node) {
                buffer.append(node.getName().getIdentifier());
                return false;
            }

            public boolean visit(ParameterizedType node) {
                node.getType().accept((ASTVisitor)this);
                return false;
            }

            public void endVisit(ArrayType node) {
                int i = 0;
                while (i < node.dimensions().size()) {
                    buffer.append("[]");
                    ++i;
                }
            }
        };
        type.accept(visitor);
        return buffer.toString();
    }

    public static String getQualifiedTypeName(Type type) {
        final StringBuffer buffer = new StringBuffer();
        ASTVisitor visitor = new ASTVisitor(){

            public boolean visit(SimpleType node) {
                buffer.append(node.getName().getFullyQualifiedName());
                return false;
            }

            public boolean visit(QualifiedType node) {
                node.getQualifier().accept((ASTVisitor)this);
                buffer.append('.');
                buffer.append(node.getName().getIdentifier());
                return false;
            }

            public boolean visit(NameQualifiedType node) {
                buffer.append(node.getQualifier().getFullyQualifiedName());
                buffer.append('.');
                buffer.append(node.getName().getIdentifier());
                return false;
            }

            public boolean visit(ParameterizedType node) {
                node.getType().accept((ASTVisitor)this);
                return false;
            }

            public void endVisit(ArrayType node) {
                int i = 0;
                while (i < node.dimensions().size()) {
                    buffer.append("[]");
                    ++i;
                }
            }
        };
        type.accept(visitor);
        return buffer.toString();
    }

    public static InfixExpression.Operator convertToInfixOperator(Assignment.Operator operator) {
        if (operator.equals(Assignment.Operator.PLUS_ASSIGN)) {
            return InfixExpression.Operator.PLUS;
        }
        if (operator.equals(Assignment.Operator.MINUS_ASSIGN)) {
            return InfixExpression.Operator.MINUS;
        }
        if (operator.equals(Assignment.Operator.TIMES_ASSIGN)) {
            return InfixExpression.Operator.TIMES;
        }
        if (operator.equals(Assignment.Operator.DIVIDE_ASSIGN)) {
            return InfixExpression.Operator.DIVIDE;
        }
        if (operator.equals(Assignment.Operator.BIT_AND_ASSIGN)) {
            return InfixExpression.Operator.AND;
        }
        if (operator.equals(Assignment.Operator.BIT_OR_ASSIGN)) {
            return InfixExpression.Operator.OR;
        }
        if (operator.equals(Assignment.Operator.BIT_XOR_ASSIGN)) {
            return InfixExpression.Operator.XOR;
        }
        if (operator.equals(Assignment.Operator.REMAINDER_ASSIGN)) {
            return InfixExpression.Operator.REMAINDER;
        }
        if (operator.equals(Assignment.Operator.LEFT_SHIFT_ASSIGN)) {
            return InfixExpression.Operator.LEFT_SHIFT;
        }
        if (operator.equals(Assignment.Operator.RIGHT_SHIFT_SIGNED_ASSIGN)) {
            return InfixExpression.Operator.RIGHT_SHIFT_SIGNED;
        }
        if (operator.equals(Assignment.Operator.RIGHT_SHIFT_UNSIGNED_ASSIGN)) {
            return InfixExpression.Operator.RIGHT_SHIFT_UNSIGNED;
        }
        Assert.isTrue((boolean)false, (String)"Cannot convert assignment operator");
        return null;
    }

    public static boolean isControlStatementBody(StructuralPropertyDescriptor locationInParent) {
        return locationInParent == IfStatement.THEN_STATEMENT_PROPERTY || locationInParent == IfStatement.ELSE_STATEMENT_PROPERTY || locationInParent == ForStatement.BODY_PROPERTY || locationInParent == EnhancedForStatement.BODY_PROPERTY || locationInParent == WhileStatement.BODY_PROPERTY || locationInParent == DoStatement.BODY_PROPERTY;
    }

    public static ITypeBinding getExplicitCast(Expression initializer, Expression reference) {
        ITypeBinding initializerType = initializer.resolveTypeBinding();
        ITypeBinding referenceType = reference.resolveTypeBinding();
        if (initializerType == null || referenceType == null) {
            return null;
        }
        if (initializerType.isPrimitive() && referenceType.isPrimitive() && !referenceType.isEqualTo((IBinding)initializerType)) {
            return referenceType;
        }
        if (initializerType.isPrimitive() && !referenceType.isPrimitive()) {
            ITypeBinding unboxedReferenceType = Bindings.getUnboxedTypeBinding(referenceType, reference.getAST());
            if (!unboxedReferenceType.isEqualTo((IBinding)initializerType)) {
                return unboxedReferenceType;
            }
            if (ASTNodes.needsExplicitBoxing(reference)) {
                return referenceType;
            }
        } else if (!initializerType.isPrimitive() && referenceType.isPrimitive()) {
            ITypeBinding unboxedInitializerType = Bindings.getUnboxedTypeBinding(initializerType, reference.getAST());
            if (!unboxedInitializerType.isEqualTo((IBinding)referenceType)) {
                return referenceType;
            }
        } else {
            if (initializerType.isRawType() && referenceType.isParameterizedType()) {
                return referenceType;
            }
            if (initializer instanceof LambdaExpression || initializer instanceof MethodReference) {
                if (ASTNodes.isTargetAmbiguous(reference, ASTNodes.isExplicitlyTypedLambda(initializer))) {
                    return referenceType;
                }
                ITypeBinding targetType = ASTNodes.getTargetType(reference);
                if (targetType == null || targetType != referenceType) {
                    return referenceType;
                }
            } else if (!TypeRules.canAssign(initializerType, referenceType) && !Bindings.containsTypeVariables(referenceType)) {
                return referenceType;
            }
        }
        return null;
    }

    public static boolean isTargetAmbiguous(Expression expression, boolean expressionIsExplicitlyTyped) {
        ITypeBinding invocationTargetType;
        int argumentCount;
        int argumentIndex;
        IMethodBinding methodBinding;
        StructuralPropertyDescriptor locationInParent = expression.getLocationInParent();
        while (locationInParent == ParenthesizedExpression.EXPRESSION_PROPERTY || locationInParent == ConditionalExpression.THEN_EXPRESSION_PROPERTY || locationInParent == ConditionalExpression.ELSE_EXPRESSION_PROPERTY) {
            expression = (Expression)expression.getParent();
            locationInParent = expression.getLocationInParent();
        }
        ASTNode parent = expression.getParent();
        Expression invocationQualifier = null;
        if (locationInParent == MethodInvocation.ARGUMENTS_PROPERTY) {
            MethodInvocation methodInvocation = (MethodInvocation)parent;
            methodBinding = methodInvocation.resolveMethodBinding();
            argumentIndex = methodInvocation.arguments().indexOf(expression);
            argumentCount = methodInvocation.arguments().size();
            invocationQualifier = methodInvocation.getExpression();
        } else if (locationInParent == SuperMethodInvocation.ARGUMENTS_PROPERTY) {
            SuperMethodInvocation superMethodInvocation = (SuperMethodInvocation)parent;
            methodBinding = superMethodInvocation.resolveMethodBinding();
            argumentIndex = superMethodInvocation.arguments().indexOf(expression);
            argumentCount = superMethodInvocation.arguments().size();
            invocationQualifier = superMethodInvocation.getQualifier();
        } else if (locationInParent == ConstructorInvocation.ARGUMENTS_PROPERTY) {
            ConstructorInvocation constructorInvocation = (ConstructorInvocation)parent;
            methodBinding = constructorInvocation.resolveConstructorBinding();
            argumentIndex = constructorInvocation.arguments().indexOf(expression);
            argumentCount = constructorInvocation.arguments().size();
        } else if (locationInParent == SuperConstructorInvocation.ARGUMENTS_PROPERTY) {
            SuperConstructorInvocation superConstructorInvocation = (SuperConstructorInvocation)parent;
            methodBinding = superConstructorInvocation.resolveConstructorBinding();
            argumentIndex = superConstructorInvocation.arguments().indexOf(expression);
            argumentCount = superConstructorInvocation.arguments().size();
        } else if (locationInParent == ClassInstanceCreation.ARGUMENTS_PROPERTY) {
            ClassInstanceCreation creation = (ClassInstanceCreation)parent;
            methodBinding = creation.resolveConstructorBinding();
            argumentIndex = creation.arguments().indexOf(expression);
            argumentCount = creation.arguments().size();
        } else if (locationInParent == EnumConstantDeclaration.ARGUMENTS_PROPERTY) {
            EnumConstantDeclaration enumConstantDecl = (EnumConstantDeclaration)parent;
            methodBinding = enumConstantDecl.resolveConstructorBinding();
            argumentIndex = enumConstantDecl.arguments().indexOf(expression);
            argumentCount = enumConstantDecl.arguments().size();
        } else {
            return false;
        }
        if (methodBinding != null && (invocationTargetType = ASTNodes.getInvocationType(parent, methodBinding, invocationQualifier)) != null) {
            AmbiguousTargetMethodAnalyzer visitor = new AmbiguousTargetMethodAnalyzer(invocationTargetType, methodBinding, argumentIndex, argumentCount, expressionIsExplicitlyTyped);
            return !visitor.visit(invocationTargetType) || !Bindings.visitHierarchy(invocationTargetType, visitor);
        }
        return true;
    }

    public static ITypeBinding getInvocationType(ASTNode invocationNode, IMethodBinding methodBinding, Expression invocationQualifier) {
        ITypeBinding invocationType;
        if (invocationNode instanceof MethodInvocation || invocationNode instanceof SuperMethodInvocation) {
            if (invocationQualifier != null) {
                invocationType = invocationQualifier.resolveTypeBinding();
                if (invocationType != null && invocationNode instanceof SuperMethodInvocation) {
                    invocationType = invocationType.getSuperclass();
                }
            } else {
                IMethodBinding methodInHierarchy;
                ITypeBinding enclosingType = ASTNodes.getEnclosingType(invocationNode);
                if (enclosingType != null && invocationNode instanceof SuperMethodInvocation) {
                    enclosingType = enclosingType.getSuperclass();
                }
                invocationType = enclosingType != null ? ((methodInHierarchy = Bindings.findMethodInHierarchy(enclosingType, methodBinding.getName(), methodBinding.getParameterTypes())) != null ? enclosingType : methodBinding.getDeclaringClass()) : methodBinding.getDeclaringClass();
            }
        } else {
            invocationType = methodBinding.getDeclaringClass();
        }
        return invocationType;
    }

    public static ITypeBinding getTargetType(Expression expression) {
        ASTNode parent = expression.getParent();
        StructuralPropertyDescriptor locationInParent = expression.getLocationInParent();
        if (locationInParent == VariableDeclarationFragment.INITIALIZER_PROPERTY || locationInParent == SingleVariableDeclaration.INITIALIZER_PROPERTY) {
            return ((VariableDeclaration)parent).getName().resolveTypeBinding();
        }
        if (locationInParent == Assignment.RIGHT_HAND_SIDE_PROPERTY) {
            return ((Assignment)parent).getLeftHandSide().resolveTypeBinding();
        }
        if (locationInParent == ReturnStatement.EXPRESSION_PROPERTY) {
            return ASTNodes.getTargetTypeForReturnStmt((ReturnStatement)parent);
        }
        if (locationInParent == ArrayInitializer.EXPRESSIONS_PROPERTY) {
            return ASTNodes.getTargetTypeForArrayInitializer((ArrayInitializer)parent);
        }
        if (locationInParent == MethodInvocation.ARGUMENTS_PROPERTY) {
            MethodInvocation methodInvocation = (MethodInvocation)parent;
            IMethodBinding methodBinding = methodInvocation.resolveMethodBinding();
            if (methodBinding != null) {
                return ASTNodes.getParameterTypeBinding(expression, methodInvocation.arguments(), methodBinding);
            }
        } else if (locationInParent == SuperMethodInvocation.ARGUMENTS_PROPERTY) {
            SuperMethodInvocation superMethodInvocation = (SuperMethodInvocation)parent;
            IMethodBinding superMethodBinding = superMethodInvocation.resolveMethodBinding();
            if (superMethodBinding != null) {
                return ASTNodes.getParameterTypeBinding(expression, superMethodInvocation.arguments(), superMethodBinding);
            }
        } else if (locationInParent == ConstructorInvocation.ARGUMENTS_PROPERTY) {
            ConstructorInvocation constructorInvocation = (ConstructorInvocation)parent;
            IMethodBinding constructorBinding = constructorInvocation.resolveConstructorBinding();
            if (constructorBinding != null) {
                return ASTNodes.getParameterTypeBinding(expression, constructorInvocation.arguments(), constructorBinding);
            }
        } else if (locationInParent == SuperConstructorInvocation.ARGUMENTS_PROPERTY) {
            SuperConstructorInvocation superConstructorInvocation = (SuperConstructorInvocation)parent;
            IMethodBinding superConstructorBinding = superConstructorInvocation.resolveConstructorBinding();
            if (superConstructorBinding != null) {
                return ASTNodes.getParameterTypeBinding(expression, superConstructorInvocation.arguments(), superConstructorBinding);
            }
        } else if (locationInParent == ClassInstanceCreation.ARGUMENTS_PROPERTY) {
            ClassInstanceCreation creation = (ClassInstanceCreation)parent;
            IMethodBinding creationBinding = creation.resolveConstructorBinding();
            if (creationBinding != null) {
                return ASTNodes.getParameterTypeBinding(expression, creation.arguments(), creationBinding);
            }
        } else if (locationInParent == EnumConstantDeclaration.ARGUMENTS_PROPERTY) {
            EnumConstantDeclaration enumConstantDecl = (EnumConstantDeclaration)parent;
            IMethodBinding enumConstructorBinding = enumConstantDecl.resolveConstructorBinding();
            if (enumConstructorBinding != null) {
                return ASTNodes.getParameterTypeBinding(expression, enumConstantDecl.arguments(), enumConstructorBinding);
            }
        } else if (locationInParent == LambdaExpression.BODY_PROPERTY) {
            IMethodBinding methodBinding = ((LambdaExpression)parent).resolveMethodBinding();
            if (methodBinding != null) {
                return methodBinding.getReturnType();
            }
        } else {
            if (locationInParent == ConditionalExpression.THEN_EXPRESSION_PROPERTY || locationInParent == ConditionalExpression.ELSE_EXPRESSION_PROPERTY) {
                return ASTNodes.getTargetType((Expression)((ConditionalExpression)parent));
            }
            if (locationInParent == CastExpression.EXPRESSION_PROPERTY) {
                return ((CastExpression)parent).getType().resolveBinding();
            }
            if (locationInParent == ParenthesizedExpression.EXPRESSION_PROPERTY) {
                return ASTNodes.getTargetType((Expression)((ParenthesizedExpression)parent));
            }
        }
        return null;
    }

    private static ITypeBinding getParameterTypeBinding(Expression expression, List<Expression> arguments, IMethodBinding methodBinding) {
        int index = arguments.indexOf(expression);
        return ASTResolving.getParameterTypeBinding(methodBinding, index);
    }

    private static ITypeBinding getTargetTypeForArrayInitializer(ArrayInitializer arrayInitializer) {
        ITypeBinding typeBinding;
        ASTNode initializerParent = arrayInitializer.getParent();
        while (initializerParent instanceof ArrayInitializer) {
            initializerParent = initializerParent.getParent();
        }
        if (initializerParent instanceof ArrayCreation) {
            return ((ArrayCreation)initializerParent).getType().getElementType().resolveBinding();
        }
        if (initializerParent instanceof VariableDeclaration && (typeBinding = ((VariableDeclaration)initializerParent).getName().resolveTypeBinding()) != null) {
            return typeBinding.getElementType();
        }
        return null;
    }

    private static ITypeBinding getTargetTypeForReturnStmt(ReturnStatement returnStmt) {
        LambdaExpression enclosingLambdaExpr = ASTResolving.findEnclosingLambdaExpression((ASTNode)returnStmt);
        if (enclosingLambdaExpr != null) {
            IMethodBinding methodBinding = enclosingLambdaExpr.resolveMethodBinding();
            return methodBinding == null ? null : methodBinding.getReturnType();
        }
        MethodDeclaration enclosingMethodDecl = ASTResolving.findParentMethodDeclaration((ASTNode)returnStmt);
        if (enclosingMethodDecl != null) {
            IMethodBinding methodBinding = enclosingMethodDecl.resolveBinding();
            return methodBinding == null ? null : methodBinding.getReturnType();
        }
        return null;
    }

    private static boolean needsExplicitBoxing(Expression expression) {
        StructuralPropertyDescriptor locationInParent = expression.getLocationInParent();
        if (locationInParent == ParenthesizedExpression.EXPRESSION_PROPERTY) {
            return ASTNodes.needsExplicitBoxing((Expression)((ParenthesizedExpression)expression.getParent()));
        }
        return locationInParent == ClassInstanceCreation.EXPRESSION_PROPERTY || locationInParent == FieldAccess.EXPRESSION_PROPERTY || locationInParent == MethodInvocation.EXPRESSION_PROPERTY;
    }

    private static boolean isExplicitlyTypedLambda(Expression expression) {
        if (!(expression instanceof LambdaExpression)) {
            return false;
        }
        LambdaExpression lambda = (LambdaExpression)expression;
        List parameters = lambda.parameters();
        if (parameters.isEmpty()) {
            return true;
        }
        return parameters.get(0) instanceof SingleVariableDeclaration;
    }

    public static ASTNode getParent(ASTNode node, Class<? extends ASTNode> parentClass) {
        while ((node = node.getParent()) != null && !parentClass.isInstance(node)) {
        }
        return node;
    }

    public static ASTNode getParent(ASTNode node, int nodeType) {
        while ((node = node.getParent()) != null && node.getNodeType() != nodeType) {
        }
        return node;
    }

    public static ASTNode findParent(ASTNode node, StructuralPropertyDescriptor[][] pathes) {
        int p = 0;
        while (p < pathes.length) {
            StructuralPropertyDescriptor[] path = pathes[p];
            ASTNode current = node;
            int d = path.length - 1;
            while (d >= 0 && current != null) {
                StructuralPropertyDescriptor descriptor = path[d];
                if (!descriptor.equals(current.getLocationInParent())) break;
                current = current.getParent();
                --d;
            }
            if (d < 0) {
                return current;
            }
            ++p;
        }
        return null;
    }

    public static ASTNode getNormalizedNode(ASTNode node) {
        ASTNode current = node;
        if (QualifiedName.NAME_PROPERTY.equals(current.getLocationInParent())) {
            current = current.getParent();
        }
        if (QualifiedType.NAME_PROPERTY.equals(current.getLocationInParent()) || SimpleType.NAME_PROPERTY.equals(current.getLocationInParent()) || NameQualifiedType.NAME_PROPERTY.equals(current.getLocationInParent())) {
            current = current.getParent();
        }
        if (ParameterizedType.TYPE_PROPERTY.equals(current.getLocationInParent())) {
            current = current.getParent();
        }
        return current;
    }

    public static boolean isParent(ASTNode node, ASTNode parent) {
        Assert.isNotNull((Object)parent);
        do {
            if ((node = node.getParent()) != parent) continue;
            return true;
        } while (node != null);
        return false;
    }

    public static int getExclusiveEnd(ASTNode node) {
        return node.getStartPosition() + node.getLength();
    }

    public static int getInclusiveEnd(ASTNode node) {
        return node.getStartPosition() + node.getLength() - 1;
    }

    public static IMethodBinding getMethodBinding(Name node) {
        IBinding binding = node.resolveBinding();
        if (binding instanceof IMethodBinding) {
            return (IMethodBinding)binding;
        }
        return null;
    }

    public static IVariableBinding getVariableBinding(Name node) {
        IBinding binding = node.resolveBinding();
        if (binding instanceof IVariableBinding) {
            return (IVariableBinding)binding;
        }
        return null;
    }

    public static IVariableBinding getLocalVariableBinding(Name node) {
        IVariableBinding result = ASTNodes.getVariableBinding(node);
        if (result == null || result.isField()) {
            return null;
        }
        return result;
    }

    public static IVariableBinding getFieldBinding(Name node) {
        IVariableBinding result = ASTNodes.getVariableBinding(node);
        if (result == null || !result.isField()) {
            return null;
        }
        return result;
    }

    public static ITypeBinding getTypeBinding(Name node) {
        IBinding binding = node.resolveBinding();
        if (binding instanceof ITypeBinding) {
            return (ITypeBinding)binding;
        }
        return null;
    }

    public static ITypeBinding getReceiverTypeBinding(MethodInvocation invocation) {
        ITypeBinding result = null;
        Expression exp = invocation.getExpression();
        if (exp != null) {
            return exp.resolveTypeBinding();
        }
        AbstractTypeDeclaration type = (AbstractTypeDeclaration)ASTNodes.getParent((ASTNode)invocation, AbstractTypeDeclaration.class);
        if (type != null) {
            return type.resolveBinding();
        }
        return result;
    }

    public static ITypeBinding getEnclosingType(ASTNode node) {
        while (node != null) {
            if (node instanceof AbstractTypeDeclaration) {
                return ((AbstractTypeDeclaration)node).resolveBinding();
            }
            if (node instanceof AnonymousClassDeclaration) {
                return ((AnonymousClassDeclaration)node).resolveBinding();
            }
            node = node.getParent();
        }
        return null;
    }

    public static IProblem[] getProblems(ASTNode node, int scope, int severity) {
        ASTNode root = node.getRoot();
        if (!(root instanceof CompilationUnit)) {
            return EMPTY_PROBLEMS;
        }
        IProblem[] problems = ((CompilationUnit)root).getProblems();
        if (root == node) {
            return problems;
        }
        int iterations = ASTNodes.computeIterations(scope);
        ArrayList<IProblem> result = new ArrayList<IProblem>(5);
        int i = 0;
        while (i < problems.length) {
            IProblem problem = problems[i];
            boolean consider = false;
            if ((severity & 3) == 3) {
                consider = true;
            } else if ((severity & 1) != 0) {
                consider = problem.isWarning();
            } else if ((severity & 2) != 0) {
                consider = problem.isError();
            }
            if (consider) {
                ASTNode temp = node;
                int count = iterations;
                do {
                    int problemOffset;
                    int nodeOffset;
                    if ((nodeOffset = temp.getStartPosition()) <= (problemOffset = problem.getSourceStart()) && problemOffset < nodeOffset + temp.getLength()) {
                        result.add(problem);
                        count = 0;
                        continue;
                    }
                    --count;
                } while ((temp = temp.getParent()) != null && count > 0);
            }
            ++i;
        }
        return result.toArray(new IProblem[result.size()]);
    }

    public static Message[] getMessages(ASTNode node, int flags) {
        ASTNode root = node.getRoot();
        if (!(root instanceof CompilationUnit)) {
            return EMPTY_MESSAGES;
        }
        Message[] messages = ((CompilationUnit)root).getMessages();
        if (root == node) {
            return messages;
        }
        int iterations = ASTNodes.computeIterations(flags);
        ArrayList<Message> result = new ArrayList<Message>(5);
        int i = 0;
        while (i < messages.length) {
            Message message = messages[i];
            ASTNode temp = node;
            int count = iterations;
            do {
                int messageOffset;
                int nodeOffset;
                if ((nodeOffset = temp.getStartPosition()) <= (messageOffset = message.getStartPosition()) && messageOffset < nodeOffset + temp.getLength()) {
                    result.add(message);
                    count = 0;
                    continue;
                }
                --count;
            } while ((temp = temp.getParent()) != null && count > 0);
            ++i;
        }
        return result.toArray(new Message[result.size()]);
    }

    private static int computeIterations(int flags) {
        switch (flags) {
            case 0: {
                return 1;
            }
            case 2: {
                return Integer.MAX_VALUE;
            }
            case 1: {
                return 2;
            }
        }
        return 1;
    }

    private static int getOrderPreference(BodyDeclaration member, MembersOrderPreferenceCache store) {
        int memberType = member.getNodeType();
        int modifiers = member.getModifiers();
        switch (memberType) {
            case 55: 
            case 71: 
            case 81: {
                return store.getCategoryIndex(0) * 2;
            }
            case 23: {
                if (Modifier.isStatic((int)modifiers)) {
                    int index = store.getCategoryIndex(5) * 2;
                    if (Modifier.isFinal((int)modifiers)) {
                        return index;
                    }
                    return index + 1;
                }
                return store.getCategoryIndex(3) * 2;
            }
            case 28: {
                if (Modifier.isStatic((int)modifiers)) {
                    return store.getCategoryIndex(6) * 2;
                }
                return store.getCategoryIndex(4) * 2;
            }
            case 82: {
                return store.getCategoryIndex(2) * 2;
            }
            case 31: {
                if (Modifier.isStatic((int)modifiers)) {
                    return store.getCategoryIndex(7) * 2;
                }
                if (((MethodDeclaration)member).isConstructor()) {
                    return store.getCategoryIndex(1) * 2;
                }
                return store.getCategoryIndex(2) * 2;
            }
        }
        return 100;
    }

    public static int getInsertionIndex(BodyDeclaration member, List<? extends BodyDeclaration> container) {
        int containerSize = container.size();
        MembersOrderPreferenceCache orderStore = JavaPlugin.getDefault().getMemberOrderPreferenceCache();
        int orderIndex = ASTNodes.getOrderPreference(member, orderStore);
        int insertPos = containerSize;
        int insertPosOrderIndex = -1;
        int i = containerSize - 1;
        while (i >= 0) {
            int currOrderIndex = ASTNodes.getOrderPreference(container.get(i), orderStore);
            if (orderIndex == currOrderIndex) {
                if (insertPosOrderIndex != orderIndex) {
                    insertPos = i + 1;
                    insertPosOrderIndex = orderIndex;
                }
            } else if (insertPosOrderIndex != orderIndex) {
                if (currOrderIndex < orderIndex) {
                    if (insertPosOrderIndex == -1) {
                        insertPos = i + 1;
                        insertPosOrderIndex = currOrderIndex;
                    }
                } else {
                    insertPos = i;
                    insertPosOrderIndex = currOrderIndex;
                }
            }
            --i;
        }
        return insertPos;
    }

    public static SimpleName getLeftMostSimpleName(Name name) {
        if (name instanceof SimpleName) {
            return (SimpleName)name;
        }
        final SimpleName[] result = new SimpleName[1];
        ASTVisitor visitor = new ASTVisitor(){

            public boolean visit(QualifiedName qualifiedName) {
                Name left = qualifiedName.getQualifier();
                if (left instanceof SimpleName) {
                    result[0] = (SimpleName)left;
                } else {
                    left.accept((ASTVisitor)this);
                }
                return false;
            }
        };
        name.accept(visitor);
        return result[0];
    }

    public static Name getTopMostName(Name name) {
        Name result = name;
        while (result.getParent() instanceof Name) {
            result = (Name)result.getParent();
        }
        return result;
    }

    public static Type getTopMostType(ASTNode node) {
        ASTNode result = null;
        while (node instanceof Type && !(node instanceof UnionType) || node instanceof Name || node instanceof Annotation || node instanceof MemberValuePair || node instanceof Expression) {
            result = node;
            node = node.getParent();
        }
        if (result instanceof Type) {
            return (Type)result;
        }
        return null;
    }

    public static int changeVisibility(int modifiers, int visibility) {
        return modifiers & 0xFFFFFFF8 | visibility;
    }

    public static void setFlagsToAST(ASTNode root, final int flags) {
        root.accept((ASTVisitor)new GenericVisitor(true){

            protected boolean visitNode(ASTNode node) {
                node.setFlags(node.getFlags() | flags);
                return true;
            }
        });
    }

    public static String getQualifier(Name name) {
        if (name.isQualifiedName()) {
            return ((QualifiedName)name).getQualifier().getFullyQualifiedName();
        }
        return "";
    }

    public static String getSimpleNameIdentifier(Name name) {
        if (name.isQualifiedName()) {
            return ((QualifiedName)name).getName().getIdentifier();
        }
        return ((SimpleName)name).getIdentifier();
    }

    public static boolean isDeclaration(Name name) {
        if (name.isQualifiedName()) {
            return ((QualifiedName)name).getName().isDeclaration();
        }
        return ((SimpleName)name).isDeclaration();
    }

    public static Modifier findModifierNode(int flag, List<IExtendedModifier> modifiers) {
        int i = 0;
        while (i < modifiers.size()) {
            IExtendedModifier curr = modifiers.get(i);
            if (curr instanceof Modifier && ((Modifier)curr).getKeyword().toFlagValue() == flag) {
                return (Modifier)curr;
            }
            ++i;
        }
        return null;
    }

    public static ITypeBinding getTypeBinding(CompilationUnit root, IType type) throws JavaModelException {
        if (type.isAnonymous()) {
            IJavaElement parent = type.getParent();
            if (parent instanceof IField && Flags.isEnum((int)((IMember)parent).getFlags())) {
                AnonymousClassDeclaration declaration;
                EnumConstantDeclaration constant = (EnumConstantDeclaration)NodeFinder.perform((ASTNode)root, (ISourceRange)((ISourceReference)parent).getSourceRange());
                if (constant != null && (declaration = constant.getAnonymousClassDeclaration()) != null) {
                    return declaration.resolveBinding();
                }
            } else {
                ClassInstanceCreation creation = (ClassInstanceCreation)ASTNodes.getParent(NodeFinder.perform((ASTNode)root, (ISourceRange)type.getNameRange()), ClassInstanceCreation.class);
                if (creation != null) {
                    return creation.resolveTypeBinding();
                }
            }
        } else {
            AbstractTypeDeclaration declaration = (AbstractTypeDeclaration)ASTNodes.getParent(NodeFinder.perform((ASTNode)root, (ISourceRange)type.getNameRange()), AbstractTypeDeclaration.class);
            if (declaration != null) {
                return declaration.resolveBinding();
            }
        }
        return null;
    }

    public static String getEscapedStringLiteral(String stringValue) {
        StringLiteral stringLiteral = AST.newAST((int)8).newStringLiteral();
        stringLiteral.setLiteralValue(stringValue);
        return stringLiteral.getEscapedValue();
    }

    public static String getEscapedCharacterLiteral(char ch) {
        CharacterLiteral characterLiteral = AST.newAST((int)8).newCharacterLiteral();
        characterLiteral.setCharValue(ch);
        return characterLiteral.getEscapedValue();
    }

    public static ASTNode getCopyOrReplacement(ASTRewrite rewrite, ASTNode node, TextEditGroup group) {
        ASTNode rewrittenNode = (ASTNode)rewrite.get(node.getParent(), node.getLocationInParent());
        if (rewrittenNode != node) {
            rewrite.replace(rewrittenNode, node, group);
            return rewrittenNode;
        }
        return rewrite.createCopyTarget(node);
    }

    public static <T extends ASTNode> T createMoveTarget(ASTRewrite rewrite, T node) {
        return (T)rewrite.createMoveTarget(node);
    }

    public static <T extends ASTNode> T copySubtree(AST target, T node) {
        return (T)ASTNode.copySubtree((AST)target, node);
    }

    public static List<String> getVisibleLocalVariablesInScope(ASTNode node) {
        IBinding[] bindings;
        ArrayList<String> variableNames = new ArrayList<String>();
        CompilationUnit root = (CompilationUnit)node.getRoot();
        IBinding[] iBindingArray = bindings = new ScopeAnalyzer(root).getDeclarationsInScope(node.getStartPosition(), 18);
        int n = bindings.length;
        int n2 = 0;
        while (n2 < n) {
            IBinding binding = iBindingArray[n2];
            if (binding instanceof IVariableBinding && !((IVariableBinding)binding).isField()) {
                variableNames.add(binding.getName());
            }
            ++n2;
        }
        return variableNames;
    }

    public static boolean hasSemicolon(ExpressionStatement exprStatement, ICompilationUnit cu) {
        boolean hasSemicolon = true;
        if ((exprStatement.getFlags() & 8) != 0) {
            try {
                Expression expression = exprStatement.getExpression();
                TokenScanner scanner = new TokenScanner((ITypeRoot)cu);
                hasSemicolon = scanner.readNext(expression.getStartPosition() + expression.getLength(), true) == 64;
            }
            catch (CoreException coreException) {
                hasSemicolon = false;
            }
        }
        return hasSemicolon;
    }

    private static class AmbiguousTargetMethodAnalyzer
    implements TypeBindingVisitor {
        private ITypeBinding fDeclaringType;
        private IMethodBinding fOriginalMethod;
        private int fArgIndex;
        private int fArgumentCount;
        private boolean fExpressionIsExplicitlyTyped;

        public AmbiguousTargetMethodAnalyzer(ITypeBinding declaringType, IMethodBinding originalMethod, int argumentIndex, int argumentCount, boolean expressionIsExplicitlyTyped) {
            this.fDeclaringType = declaringType;
            this.fOriginalMethod = originalMethod;
            this.fArgIndex = argumentIndex;
            this.fArgumentCount = argumentCount;
            this.fExpressionIsExplicitlyTyped = expressionIsExplicitlyTyped;
        }

        public boolean visit(ITypeBinding type) {
            IMethodBinding[] methods = type.getDeclaredMethods();
            int i = 0;
            while (i < methods.length) {
                block13: {
                    IMethodBinding candidate;
                    block14: {
                        candidate = methods[i];
                        if (candidate.getMethodDeclaration() == this.fOriginalMethod.getMethodDeclaration()) break block13;
                        ITypeBinding candidateDeclaringType = candidate.getDeclaringClass();
                        if (this.fDeclaringType == candidateDeclaringType) break block14;
                        int modifiers = candidate.getModifiers();
                        if (candidateDeclaringType.isInterface() && Modifier.isStatic((int)modifiers) || Modifier.isPrivate((int)modifiers)) break block13;
                    }
                    if (this.fOriginalMethod.getName().equals(candidate.getName()) && !this.fOriginalMethod.overrides(candidate)) {
                        ITypeBinding parameterType;
                        boolean couldBeAmbiguous;
                        ITypeBinding[] candidateParameterTypes;
                        ITypeBinding[] originalParameterTypes = this.fOriginalMethod.getParameterTypes();
                        if (originalParameterTypes.length == (candidateParameterTypes = candidate.getParameterTypes()).length) {
                            couldBeAmbiguous = true;
                        } else if (this.fOriginalMethod.isVarargs() || candidate.isVarargs()) {
                            int candidateMinArgumentCount = candidateParameterTypes.length;
                            if (candidate.isVarargs()) {
                                --candidateMinArgumentCount;
                            }
                            couldBeAmbiguous = this.fArgumentCount >= candidateMinArgumentCount;
                        } else {
                            couldBeAmbiguous = false;
                        }
                        if (couldBeAmbiguous && (parameterType = ASTResolving.getParameterTypeBinding(candidate, this.fArgIndex)) != null && parameterType.getFunctionalInterfaceMethod() != null) {
                            boolean candidateIsVoidCompatible;
                            if (!this.fExpressionIsExplicitlyTyped) {
                                return false;
                            }
                            ITypeBinding origParamType = ASTResolving.getParameterTypeBinding(this.fOriginalMethod, this.fArgIndex);
                            boolean originalIsVoidCompatible = Bindings.isVoidType(origParamType.getFunctionalInterfaceMethod().getReturnType());
                            if (originalIsVoidCompatible == (candidateIsVoidCompatible = Bindings.isVoidType(parameterType.getFunctionalInterfaceMethod().getReturnType()))) {
                                return false;
                            }
                        }
                    }
                }
                ++i;
            }
            return true;
        }
    }

    private static class ChildrenCollector
    extends GenericVisitor {
        public List<ASTNode> result = null;

        public ChildrenCollector() {
            super(true);
        }

        protected boolean visitNode(ASTNode node) {
            if (this.result == null) {
                this.result = new ArrayList<ASTNode>();
                return true;
            }
            this.result.add(node);
            return false;
        }
    }
}

