/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.report.internal;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rcptt.reporting.Q7Info;
import org.eclipse.rcptt.reporting.ResultStatus;
import org.eclipse.rcptt.reporting.core.Q7ReportIterator;
import org.eclipse.rcptt.reporting.internal.ReportUtils;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Node;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Report;
import org.eclipse.rcptt.sherlock.core.reporting.SimpleReportGenerator;
import org.eclipse.rcptt.ui.report.internal.ReportEntry;

class ReportEntryContentProvider
implements IStructuredContentProvider {
    private List<ReportEntry> entries = Collections.emptyList();
    private Viewer viewer = null;

    ReportEntryContentProvider() {
    }

    public void dispose() {
        Job.getJobManager().cancel((Object)this);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
        Job.getJobManager().cancel((Object)this);
        if (newInput instanceof Q7ReportIterator) {
            new UpdateJob((Q7ReportIterator)newInput).schedule();
        }
    }

    public Object[] getElements(Object inputElement) {
        return this.entries.toArray();
    }

    private class UpdateJob
    extends Job {
        private final Q7ReportIterator iterator;

        public boolean belongsTo(Object family) {
            return ReportEntryContentProvider.this == family;
        }

        public UpdateJob(Q7ReportIterator iterator) {
            super("Building test list for report");
            Preconditions.checkNotNull((Object)iterator);
            this.iterator = iterator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            ArrayList<ReportEntry> entries = new ArrayList<ReportEntry>();
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            Q7ReportIterator q7ReportIterator = this.iterator;
            synchronized (q7ReportIterator) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                this.iterator.reset();
                int failCount = 0;
                while (this.iterator.hasNext()) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    Report next = this.iterator.next();
                    if (next == null) break;
                    ReportEntry re = new ReportEntry();
                    Node root = next.getRoot();
                    re.name = root.getName();
                    re.time = (int)(root.getEndTime() - root.getStartTime());
                    EMap properties = root.getProperties();
                    Q7Info info = (Q7Info)properties.get((Object)"q7");
                    if (info == null) continue;
                    StringBuilder details = new StringBuilder();
                    String fail = ReportUtils.getFailMessage((Node)root);
                    if (fail.length() > 0) {
                        details.append(fail).append("\n");
                    }
                    ReportUtils.collectDetails((Node)root, (StringBuilder)details);
                    if (details.length() > 0) {
                        re.warning = true;
                    }
                    re.status = info.getResult();
                    if (re.status != ResultStatus.PASS) {
                        re.message = ++failCount < 100 ? new SimpleReportGenerator().generateContent(next) : "Too many errors";
                    }
                    re.id = info.getId();
                    entries.add(re);
                }
            }
            ReportEntryContentProvider.this.entries = entries;
            ReportEntryContentProvider.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!ReportEntryContentProvider.this.viewer.getControl().isDisposed()) {
                        ReportEntryContentProvider.this.viewer.refresh();
                    }
                }
            });
            return Status.OK_STATUS;
        }
    }
}

