/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.report.internal;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.IDisposeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.rcptt.reporting.core.Q7ReportIterator;
import org.eclipse.rcptt.ui.controls.IEmbeddedComposite;
import org.eclipse.rcptt.ui.controls.SectionWithToolbar;
import org.eclipse.rcptt.ui.report.ReportWizard;
import org.eclipse.rcptt.ui.report.internal.DetailsComposite;
import org.eclipse.rcptt.ui.report.internal.RcpttReportEditor;
import org.eclipse.rcptt.ui.report.internal.StatisticsComposite;
import org.eclipse.rcptt.ui.report.internal.TestCasesComposite;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.internal.forms.widgets.FormImages;

public class ReportInformationPage
extends FormPage {
    DataBindingContext dbc = new DataBindingContext();
    private Label nameLabel;
    private Text nameText;
    private Section descriptionSection;
    private final IObservableValue reportIterator;

    public ReportInformationPage(FormEditor editor, IObservableValue reportIterator, String id, String title) {
        super(editor, id, title);
        this.reportIterator = reportIterator;
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        Composite parent = form.getBody();
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(0, 0).equalWidth(true).applyTo(parent);
        this.createGeneralContent(parent, toolkit);
        Composite composite = toolkit.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(0, 0).equalWidth(false).applyTo(composite);
        final StatisticsComposite statistics = new StatisticsComposite();
        this.descriptionSection = new SectionWithToolbar((IEmbeddedComposite)statistics, 256).create(composite, toolkit);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.descriptionSection);
        SashForm composite2 = new SashForm(composite, 65792);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite2);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(5, 5).spacing(0, 0).equalWidth(true).applyTo((Composite)composite2);
        final DetailsComposite detailsComposite = new DetailsComposite();
        final TestCasesComposite testCases = new TestCasesComposite(){

            @Override
            protected void doOpen(String id, String title) {
                ReportInformationPage.this.openReport(id, title);
            }

            @Override
            protected void doSelection(String id, String name, String msg) {
                detailsComposite.updateText(msg);
            }
        };
        new SectionWithToolbar((IEmbeddedComposite)testCases, 256).create((Composite)composite2, toolkit);
        new SectionWithToolbar((IEmbeddedComposite)detailsComposite, 256).create((Composite)composite2, toolkit);
        composite2.setWeights(new int[]{60, 40});
        this.reportIterator.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                Q7ReportIterator iterator = (Q7ReportIterator)event.diff.getNewValue();
                statistics.setReports(iterator);
                testCases.setReports(iterator);
            }
        });
        this.reportIterator.addDisposeListener(new IDisposeListener(){

            public void handleDispose(org.eclipse.core.databinding.observable.DisposeEvent event) {
                statistics.setReports(null);
                testCases.setReports(null);
            }
        });
        this.reportIterator.getRealm().asyncExec(new Runnable(){

            @Override
            public void run() {
                Q7ReportIterator iterator = (Q7ReportIterator)ReportInformationPage.this.reportIterator.getValue();
                statistics.setReports(iterator);
                testCases.setReports(iterator);
            }
        });
    }

    protected void openReport(String id, String title) {
        this.getReportEditor().openReport(id, title);
    }

    protected Composite createGeneralContent(Composite parent, FormToolkit toolkit) {
        Composite composite = toolkit.createComposite(parent);
        GridLayoutFactory.swtDefaults().numColumns(4).applyTo(composite);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)composite);
        this.createNameControl(composite, toolkit);
        this.createSaveButton(composite, toolkit);
        int height = composite.computeSize((int)-1, (int)-1).y;
        Color top = toolkit.getColors().getColor("org.eclipse.ui.forms.H_GRADIENT_END");
        Color bot = toolkit.getColors().getColor("org.eclipse.ui.forms.H_GRADIENT_START");
        Image gradientImage = FormImages.getInstance().getGradient(new Color[]{top, bot}, new int[]{100}, height, true, toolkit.getColors().getColor("org.eclipse.ui.forms.TB_BG"), composite.getDisplay());
        composite.setBackgroundImage(gradientImage);
        Composite c1 = toolkit.createComposite(parent);
        GridDataFactory.fillDefaults().hint(-1, 1).span(4, 1).grab(true, false).applyTo((Control)c1);
        c1.setBackground(toolkit.getColors().getColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE1"));
        Composite c2 = toolkit.createComposite(parent);
        GridDataFactory.fillDefaults().hint(-1, 1).span(4, 1).grab(true, false).applyTo((Control)c2);
        c2.setBackground(toolkit.getColors().getColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE2"));
        if (!Platform.getOS().equals("macosx")) {
            composite.layout();
        }
        return composite;
    }

    protected void setBackgroundToHeaderLabel(Label label, Image backgroundImage) {
        Rectangle bounds = label.getBounds();
        bounds.x = 0;
        bounds.width = 1;
        final Image image = new Image((Device)label.getDisplay(), bounds);
        GC gc = new GC((Drawable)image);
        gc.drawImage(backgroundImage, bounds.x, bounds.y, bounds.width, bounds.height, 0, 0, bounds.width, bounds.height);
        gc.dispose();
        label.setBackgroundImage(image);
        label.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                image.dispose();
            }
        });
    }

    protected void createNameControl(Composite parent, FormToolkit toolkit) {
        this.nameLabel = this.createLabel(parent, toolkit, "Name:");
        this.nameText = this.createWrappedText(parent, toolkit, this.getEditor().getPartName(), 2);
        this.nameText.setEditable(false);
        this.nameText.setBackground(null);
    }

    protected Label createLabel(Composite parent, FormToolkit toolkit, String label) {
        Label labelControl = new Label(parent, 0);
        labelControl.setText(label);
        labelControl.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        GridDataFactory.swtDefaults().align(1, 0x1000000).applyTo((Control)labelControl);
        labelControl.setBackground(null);
        return labelControl;
    }

    protected Text createWrappedText(Composite parent, FormToolkit toolkit, String text, int hSpan) {
        Composite composite = toolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().equalWidth(true).applyTo(composite);
        GridDataFactory.swtDefaults().align(4, 0x1000000).span(hSpan, 1).grab(true, false).applyTo((Control)composite);
        Text textControl = toolkit.createText(composite, text, 2048);
        GridDataFactory.swtDefaults().align(4, 4).grab(true, true).hint(111, -1).applyTo((Control)textControl);
        textControl.setBackground(null);
        return textControl;
    }

    protected Button createSaveButton(Composite composite, FormToolkit toolkit) {
        Button button = toolkit.createButton(composite, "Save as...", 8);
        button.setImage(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_SAVE_EDIT").createImage());
        button.setBackground(null);
        GridDataFactory.fillDefaults().applyTo((Control)button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Q7ReportIterator iterator = (Q7ReportIterator)ReportInformationPage.this.reportIterator.getValue();
                if (iterator == null) {
                    return;
                }
                ReportWizard wizard = new ReportWizard(new Q7ReportIterator(iterator.getReportFile()), new Path(ReportInformationPage.this.getEditorInput().getName()).removeFileExtension().toString());
                wizard.setDisabledReports(new String[]{"report"});
                wizard.setInitialWorkspaceLocation(ReportInformationPage.this.getReportEditor().getInitialWorkspaceLocation());
                wizard.setNeedsProgressMonitor(true);
                WizardDialog dialog = new WizardDialog(ReportInformationPage.this.nameLabel.getShell(), (IWizard)wizard);
                dialog.open();
            }
        });
        return button;
    }

    private RcpttReportEditor getReportEditor() {
        return (RcpttReportEditor)this.getEditor();
    }
}

