/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.tools;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.util.FileExtensionFilter;
import org.eclipse.pde.internal.ui.util.FileValidator;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ConvertPreferencesWizardPage
extends WizardPage {
    private String fPreferencesFilePath;
    private String fPluginCustomizeFilePath;
    private boolean fOverwrite;
    private Combo fPreferenceCombo;
    private Combo fPluginCustomizeCombo;
    private Button fOverwriteButton;
    private Button fMergeButton;

    public ConvertPreferencesWizardPage(String pluginCustomizationFilePath, String preferencesFilePath, boolean overwrite) {
        super("ConvertPreferencesWizardPage");
        this.setTitle(PDEUIMessages.ConvertPreferencesWizardPage_title);
        this.setDescription(PDEUIMessages.ConvertPreferencesWizardPage_description);
        this.fPreferencesFilePath = preferencesFilePath;
        this.fPluginCustomizeFilePath = pluginCustomizationFilePath;
        this.fOverwrite = overwrite;
    }

    public void dispose() {
        super.dispose();
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 5;
        container.setLayout((Layout)layout);
        Group group = new Group(container, 0);
        group.setLayout((Layout)new GridLayout(3, false));
        group.setLayoutData((Object)new GridData(768));
        group.setText(PDEUIMessages.ConvertPreferencesWizardPage_sourceFileGroup);
        Label label = new Label((Composite)group, 0);
        label.setText(PDEUIMessages.ConvertPreferencesWizardPage_file);
        this.fPreferenceCombo = new Combo((Composite)group, 2048);
        this.fPreferenceCombo.setLayoutData((Object)new GridData(768));
        Button browse = new Button((Composite)group, 8);
        browse.setText(PDEUIMessages.ConvertPreferencesWizardPage_browse);
        browse.setLayoutData((Object)new GridData());
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConvertPreferencesWizardPage.this.handleBrowsePreferences();
            }
        });
        SWTUtil.setButtonDimensionHint(browse);
        File prefs = this.getPreferencesFile();
        if (prefs != null) {
            this.fPreferenceCombo.add(this.fPreferencesFilePath, 0);
            this.fPreferenceCombo.setText(this.fPreferencesFilePath);
            if (!prefs.exists()) {
                this.setErrorMessage(NLS.bind((String)PDEUIMessages.ConvertPreferencesWizard_errorFileNotFound, (Object)prefs.getAbsolutePath()));
            }
        }
        this.fPreferenceCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                ConvertPreferencesWizardPage.this.pageChanged(true);
            }
        });
        group = new Group(container, 0);
        group.setLayout((Layout)new GridLayout(3, false));
        group.setLayoutData((Object)new GridData(768));
        group.setText(PDEUIMessages.ConvertPreferencesWizardPage_targetFileGroup);
        label = new Label((Composite)group, 0);
        label.setText(PDEUIMessages.ConvertPreferencesWizardPage_file);
        this.fPluginCustomizeCombo = new Combo((Composite)group, 2048);
        this.fPluginCustomizeCombo.setLayoutData((Object)new GridData(768));
        IFile customization = this.getCustomizationFile(this.fPluginCustomizeFilePath);
        if (customization != null && customization.exists()) {
            this.fPluginCustomizeCombo.add(this.fPluginCustomizeFilePath, 0);
            this.fPluginCustomizeCombo.setText(this.fPluginCustomizeFilePath);
        }
        this.fPluginCustomizeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                ConvertPreferencesWizardPage.this.pageChanged(true);
            }
        });
        browse = new Button((Composite)group, 8);
        browse.setText(PDEUIMessages.ConvertPreferencesWizardPage_browse);
        browse.setLayoutData((Object)new GridData());
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConvertPreferencesWizardPage.this.handleBrowsePluginCustomization();
            }
        });
        SWTUtil.setButtonDimensionHint(browse);
        group = new Group(container, 0);
        group.setText(PDEUIMessages.ConvertPreferencesWizardPage_options);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        this.fMergeButton = new Button((Composite)group, 16);
        this.fMergeButton.setText(PDEUIMessages.ConvertPreferencesWizardPage_merge);
        this.fOverwriteButton = new Button((Composite)group, 16);
        this.fOverwriteButton.setText(PDEUIMessages.ConvertPreferencesWizardPage_overwrite);
        this.fOverwriteButton.setSelection(this.fOverwrite);
        this.fMergeButton.setSelection(!this.fOverwrite);
        this.setControl((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.pde.doc.user.convert_preferences_page");
        Dialog.applyDialogFont((Control)container);
        this.pageChanged(false);
    }

    private void handleBrowsePluginCustomization() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setValidator((ISelectionStatusValidator)new FileValidator());
        dialog.setAllowMultiple(false);
        dialog.setTitle(PDEUIMessages.ConvertPreferencesWizardPage_customFileTitle);
        dialog.setMessage(PDEUIMessages.ConvertPreferencesWizardPage_customFileMessage);
        dialog.addFilter((ViewerFilter)new FileExtensionFilter("ini"));
        dialog.setInput((Object)PDEPlugin.getWorkspace().getRoot());
        IFile ini = this.getPluginCustomizeFile();
        if (ini != null) {
            dialog.setInitialSelection((Object)ini);
        }
        dialog.create();
        if (dialog.open() == 0) {
            IFile file = (IFile)dialog.getFirstResult();
            String value = file.getFullPath().toString();
            if (this.fPluginCustomizeCombo.indexOf(value) == -1) {
                this.fPluginCustomizeCombo.add(value, 0);
            }
            this.fPluginCustomizeCombo.setText(value);
            this.fPluginCustomizeFilePath = value;
            this.pageChanged(true);
        }
    }

    private IFile getCustomizationFile(String path) {
        if (path == null || path.length() == 0) {
            return null;
        }
        Path thePath = new Path(path);
        return thePath.segmentCount() < 2 ? null : PDEPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path));
    }

    private File getPreferencesFile(String path) {
        if (path == null || path.length() == 0) {
            return null;
        }
        return new File(path);
    }

    private void handleBrowsePreferences() {
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setText(PDEUIMessages.ConvertPreferencesWizardPage_fileTitle);
        dialog.setFilterExtensions(new String[]{"*.epf"});
        dialog.setText(PDEUIMessages.ConvertPreferencesWizardPage_fileMessage);
        dialog.setFileName(this.fPreferencesFilePath);
        String path = dialog.open();
        if (path != null) {
            if (this.fPreferenceCombo.indexOf(path) == -1) {
                this.fPreferenceCombo.add(path, 0);
            }
            this.fPreferenceCombo.setText(path);
            this.fPreferencesFilePath = path;
            this.pageChanged(true);
        }
    }

    public File getPreferencesFile() {
        return this.getPreferencesFile(this.fPreferencesFilePath);
    }

    public IFile getPluginCustomizeFile() {
        return this.getCustomizationFile(this.fPluginCustomizeFilePath);
    }

    public boolean getOverwrite() {
        if (this.fOverwriteButton != null && !this.fOverwriteButton.isDisposed()) {
            this.fOverwrite = this.fOverwriteButton.getSelection();
        }
        return this.fOverwrite;
    }

    private void pageChanged(boolean reportError) {
        File file = this.getPreferencesFile(this.fPreferenceCombo.getText());
        String error = null;
        if (file == null) {
            error = PDEUIMessages.ConvertPreferencesWizard_errorNoFileSpecified;
            this.fPreferenceCombo.setFocus();
        } else if (!file.exists()) {
            error = NLS.bind((String)PDEUIMessages.ConvertPreferencesWizard_errorFileNotFound, (Object)file.getAbsolutePath());
            this.fPreferenceCombo.setFocus();
        }
        IFile file2 = this.getCustomizationFile(this.fPluginCustomizeCombo.getText());
        if (file2 == null) {
            error = PDEUIMessages.ConvertPreferencesWizard_errorNoFileSpecified;
            this.fPluginCustomizeCombo.setFocus();
        } else if (!file2.exists()) {
            error = NLS.bind((String)PDEUIMessages.ConvertPreferencesWizard_errorFileNotFound, (Object)file2.getFullPath().toString());
            this.fPluginCustomizeCombo.setFocus();
        }
        if (error != null && reportError) {
            this.setErrorMessage(error);
        } else {
            this.setErrorMessage(null);
        }
        this.setPageComplete(error == null);
    }
}

