/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching.ext;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.rcptt.internal.launching.ext.Q7ExtLaunchingPlugin;

public class UpdateVMArgs {
    public static final Function<String, String> ESCAPE = new Function<String, String>(){

        public String apply(String input) {
            return UpdateVMArgs.escapeCommandArg(input);
        }
    };

    public static String escapeCommandArg(String arg) {
        if (arg == null || arg.length() == 0) {
            return "\"\"";
        }
        if (!Platform.getOS().equals("win32")) {
            arg = arg.replace("\\", "\\\\");
        }
        return (arg = arg.replace("\"", "\\\"")).contains(" ") ? String.format("\"%s\"", arg) : arg;
    }

    public static void updateVMArgs(ILaunchConfigurationWorkingCopy configuration) {
        try {
            String attribute = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "");
            String finalValue = UpdateVMArgs.updateAttr(attribute);
            if (finalValue != null) {
                configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, finalValue);
            }
        }
        catch (CoreException e) {
            Q7ExtLaunchingPlugin.getDefault().log(e);
        }
    }

    public static void addIfAbsent(List<String> target, String prefix, String value) {
        if (!Iterables.any(target, (Predicate)new StartsWith(prefix))) {
            target.add(String.valueOf(prefix) + value);
        }
    }

    public static String updateAttr(String arguments) {
        return Joiner.on((String)" ").join(UpdateVMArgs.updateAttr(Arrays.asList(DebugPlugin.parseArguments((String)arguments))));
    }

    private static String addWeavingHook(String extensions, IPluginModelBase hook) {
        Preconditions.checkNotNull((Object)hook);
        String ajref = String.format("reference:file:%s", hook.getInstallLocation());
        if (extensions == null) {
            return ajref;
        }
        StringBuilder result = new StringBuilder();
        String[] stringArray = extensions.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String extension = stringArray[n2];
            if (!extensions.contains("org.eclipse.equinox.weaving.hook") && !extension.isEmpty()) {
                result.append(extension).append(',');
            }
            ++n2;
        }
        result.append(ajref).append(',');
        result.setLength(result.length() - 1);
        return result.toString();
    }

    public static List<String> addHook(List<String> vmArguments, IPluginModelBase hook, String defaultExtensions) {
        ArrayList result = Lists.newArrayList(vmArguments);
        String extensions = "";
        Iterator argIter = result.iterator();
        while (argIter.hasNext()) {
            String argument = (String)argIter.next();
            if (!argument.startsWith("-Dosgi.framework.extensions=")) continue;
            extensions = argument.substring("-Dosgi.framework.extensions=".length());
            argIter.remove();
        }
        if (extensions.isEmpty()) {
            extensions = Strings.nullToEmpty((String)defaultExtensions);
        }
        result.add("-Dosgi.framework.extensions=" + UpdateVMArgs.addWeavingHook(extensions, hook));
        return result;
    }

    public static List<String> updateAttr(List<String> attribute) {
        ArrayList result = Lists.newArrayList(attribute);
        UpdateVMArgs.addIfAbsent(result, "-Xmx", "512m");
        UpdateVMArgs.addIfAbsent(result, "-XX:MaxPermSize", "=128m");
        if (Platform.getOS().equals("macosx")) {
            UpdateVMArgs.addIfAbsent(result, "-XstartOnFirstThread", "");
            UpdateVMArgs.addIfAbsent(result, "-Dorg.eclipse.swt.internal.carbon.smallFonts", "");
        }
        return result;
    }

    static class StartsWith
    implements Predicate<String> {
        private final String prefix;

        public StartsWith(String prefix) {
            this.prefix = prefix;
        }

        public boolean apply(String input) {
            return input.startsWith(this.prefix);
        }
    }
}

