/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.internal.workbench.PartActivationHistory;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MGenericStack;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MArea;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.e4.ui.model.application.ui.basic.MInputPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.services.EContextService;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.IPartListener;
import org.eclipse.e4.ui.workbench.modeling.ISaveHandler;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class PartServiceImpl
implements EPartService {
    private EventHandler selectedHandler = new EventHandler(){

        public void handleEvent(Event event) {
            if (!PartServiceImpl.this.listeners.isEmpty()) {
                MPart selectedPart;
                Object selected;
                Object oldSelected = event.getProperty("OldValue");
                if (oldSelected instanceof MPlaceholder) {
                    oldSelected = ((MPlaceholder)oldSelected).getRef();
                }
                if ((selected = event.getProperty("NewValue")) instanceof MPlaceholder) {
                    selected = ((MPlaceholder)selected).getRef();
                }
                MPart oldSelectedPart = oldSelected instanceof MPart ? (MPart)oldSelected : null;
                MPart mPart = selectedPart = selected instanceof MPart ? (MPart)selected : null;
                if (oldSelectedPart != null && PartServiceImpl.this.getParts().contains(selectedPart)) {
                    PartServiceImpl.this.firePartHidden(oldSelectedPart);
                }
                if (selectedPart != null && selectedPart.isToBeRendered() && PartServiceImpl.this.getParts().contains(selectedPart)) {
                    MPlaceholder placeholder = selectedPart.getCurSharedRef();
                    if (placeholder == null) {
                        if (selectedPart.getParent().getRenderer() != null) {
                            PartServiceImpl.this.engine.createGui((MUIElement)selectedPart);
                            PartServiceImpl.this.firePartVisible(selectedPart);
                            PartServiceImpl.this.firePartBroughtToTop(selectedPart);
                        }
                    } else if (placeholder.getParent().getRenderer() != null) {
                        PartServiceImpl.this.engine.createGui((MUIElement)placeholder);
                        PartServiceImpl.this.firePartVisible(selectedPart);
                        PartServiceImpl.this.firePartBroughtToTop(selectedPart);
                    }
                }
            }
        }
    };
    private EventHandler minimizedPartHandler = new EventHandler(){

        public void handleEvent(Event event) {
            boolean minimizedTagRemoved;
            Object element = event.getProperty("ChangedElement");
            if (!(element instanceof MPartStack)) {
                return;
            }
            Object newValue = event.getProperty("NewValue");
            Object oldValue = event.getProperty("OldValue");
            boolean minimizedTagAdded = UIEvents.isADD(event) && "Minimized".equals(newValue);
            boolean bl = minimizedTagRemoved = UIEvents.isREMOVE(event) && "Minimized".equals(oldValue);
            if (!minimizedTagAdded && !minimizedTagRemoved) {
                return;
            }
            MPart part = this.toPart((MStackElement)((MPartStack)element).getSelectedElement());
            if (part != null && minimizedTagAdded) {
                PartServiceImpl.this.firePartHidden(part);
            } else if (part != null) {
                PartServiceImpl.this.firePartVisible(part);
            }
        }

        private MPart toPart(MStackElement stackElement) {
            if (stackElement != null) {
                return stackElement instanceof MPlaceholder ? (MPart)((MPlaceholder)stackElement).getRef() : (MPart)stackElement;
            }
            return null;
        }
    };
    private MApplication application;
    private MWindow workbenchWindow;
    @Inject
    private IPresentationEngine engine;
    @Inject
    private EModelService modelService;
    @Inject
    private Logger logger;
    @Inject
    @Optional
    private ISaveHandler saveHandler;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    @Optional
    private EContextService contextService;
    @Inject
    @Optional
    private ContextManager contextManager;
    private PartActivationHistory partActivationHistory;
    private MPart activePart;
    private ListenerList listeners = new ListenerList();
    private boolean constructed = false;

    @Inject
    public PartServiceImpl(MApplication application, @Optional MWindow window) {
        this.application = application;
        this.workbenchWindow = window;
    }

    private void log(String unidentifiedMessage, String identifiedMessage, String id, Exception e) {
        if (id == null || id.length() == 0) {
            this.logger.error((Throwable)e, unidentifiedMessage);
        } else {
            this.logger.error((Throwable)e, NLS.bind((String)identifiedMessage, (Object)id));
        }
    }

    @Inject
    void setPart(@Optional @Named(value="e4ActivePart") MPart p) {
        if (this.activePart != p) {
            if (p != null) {
                boolean inCurrentPerspective;
                MPerspective persp = this.modelService.getPerspectiveFor((MUIElement)p);
                boolean bl = inCurrentPerspective = persp == null || persp == persp.getParent().getSelectedElement();
                if (inCurrentPerspective) {
                    this.activate(p, true, true);
                }
            } else {
                this.activate(p, true, true);
            }
        }
    }

    @PostConstruct
    void postConstruct() {
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/selectedElement/*", this.selectedHandler);
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/application/ApplicationElement/tags/*", this.minimizedPartHandler);
        this.constructed = true;
        this.partActivationHistory = new PartActivationHistory(this, this.modelService);
        if (this.activePart != null) {
            this.partActivationHistory.prepend(this.activePart);
        }
    }

    @PreDestroy
    void preDestroy() {
        this.constructed = false;
        this.eventBroker.unsubscribe(this.selectedHandler);
        this.eventBroker.unsubscribe(this.minimizedPartHandler);
        this.partActivationHistory.clear();
    }

    private void firePartActivated(final MPart part) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            final Object listener = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    ((IPartListener)listener).partActivated(part);
                }

                public void handleException(Throwable throwable) {
                    PartServiceImpl.this.logger.error(throwable, "An exception occurred while notifying part listeners");
                }
            });
            ++n2;
        }
    }

    private void firePartDeactivated(final MPart part) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            final Object listener = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    ((IPartListener)listener).partDeactivated(part);
                }

                public void handleException(Throwable throwable) {
                    PartServiceImpl.this.logger.error(throwable, "An exception occurred while notifying part listeners");
                }
            });
            ++n2;
        }
    }

    private void firePartHidden(final MPart part) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            final Object listener = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    ((IPartListener)listener).partHidden(part);
                }

                public void handleException(Throwable throwable) {
                    PartServiceImpl.this.logger.error(throwable, "An exception occurred while notifying part listeners");
                }
            });
            ++n2;
        }
    }

    private void firePartVisible(final MPart part) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            final Object listener = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    ((IPartListener)listener).partVisible(part);
                }

                public void handleException(Throwable throwable) {
                    PartServiceImpl.this.logger.error(throwable, "An exception occurred while notifying part listeners");
                }
            });
            ++n2;
        }
    }

    private void firePartBroughtToTop(final MPart part) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            final Object listener = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    ((IPartListener)listener).partBroughtToTop(part);
                }

                public void handleException(Throwable throwable) {
                    PartServiceImpl.this.logger.error(throwable, "An exception occurred while notifying part listeners");
                }
            });
            ++n2;
        }
    }

    @Override
    public void addPartListener(IPartListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removePartListener(IPartListener listener) {
        this.listeners.remove((Object)listener);
    }

    private MWindow getWindow() {
        if (this.workbenchWindow != null) {
            return this.workbenchWindow;
        }
        if (this.application.getSelectedElement() != null) {
            return (MWindow)this.application.getSelectedElement();
        }
        List windows = this.application.getChildren();
        if (windows.size() != 0) {
            return (MWindow)windows.get(0);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private MContext getParentWithContext(MUIElement part) {
        block4: {
            parent = part.getParent();
            intermediate = parent;
            if (intermediate != null) ** GOTO lbl10
            intermediate = part;
            break block4;
lbl-1000:
            // 1 sources

            {
                if (parent instanceof MContext && ((MContext)parent).getContext() != null) {
                    return (MContext)parent;
                }
                intermediate = parent;
                parent = parent.getParent();
lbl10:
                // 2 sources

                ** while (parent != null)
            }
        }
        placeholder = this.modelService.findPlaceholderFor(this.getWindow(), (MUIElement)intermediate);
        parent = placeholder.getParent();
        while (parent != null) {
            if (parent instanceof MContext && ((MContext)parent).getContext() != null) {
                return (MContext)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    @Override
    public void bringToTop(MPart part) {
        if (this.isInContainer((MUIElement)part)) {
            MPlaceholder activePH;
            MElementContainer activeParent;
            MPart currentElement = part;
            MElementContainer parent = part.getParent();
            if (parent == null) {
                currentElement = this.modelService.findPlaceholderFor(this.getWindow(), (MUIElement)part);
                parent = currentElement.getParent();
            }
            MElementContainer mElementContainer = activeParent = this.activePart != null ? this.activePart.getParent() : null;
            if (this.activePart != null && activeParent == null && (activePH = this.modelService.findPlaceholderFor(this.getWindow(), (MUIElement)this.activePart)) != null) {
                activeParent = activePH.getParent();
            }
            if (parent == activeParent && part != this.activePart) {
                this.activate(part);
                return;
            }
            MUIElement oldSelectedElement = parent.getSelectedElement();
            this.delegateBringToTop(part);
            if (oldSelectedElement != currentElement && parent.getChildren().contains(oldSelectedElement) && parent instanceof MGenericStack) {
                if (oldSelectedElement instanceof MPlaceholder) {
                    oldSelectedElement = ((MPlaceholder)oldSelectedElement).getRef();
                }
                this.internalFixContext(part, oldSelectedElement);
            }
        }
    }

    private IEclipseContext getSubContext(MUIElement element) {
        if (element instanceof MContext) {
            return ((MContext)element).getContext();
        }
        if (element instanceof MElementContainer) {
            MUIElement selectedElement = ((MElementContainer)element).getSelectedElement();
            if (selectedElement instanceof MContext) {
                return ((MContext)selectedElement).getContext();
            }
            if (selectedElement instanceof MElementContainer) {
                return this.getSubContext(selectedElement);
            }
        }
        return null;
    }

    private void internalFixContext(MPart part, MUIElement oldSelectedElement) {
        if (oldSelectedElement == null) {
            return;
        }
        MContext parentPart = this.getParentWithContext(oldSelectedElement);
        if (parentPart == null) {
            return;
        }
        IEclipseContext parentContext = parentPart.getContext();
        IEclipseContext oldContext = this.getSubContext(oldSelectedElement);
        IEclipseContext child = parentContext.getActiveChild();
        if (child == null || oldContext == null || child == oldContext) {
            if (part == null) {
                IEclipseContext currentActive = parentContext.getActiveChild();
                if (currentActive != null) {
                    currentActive.deactivate();
                }
            } else {
                part.getContext().activate();
            }
        }
    }

    @Override
    public MPart findPart(String id) {
        List<MPart> parts = this.getParts(MPart.class, id);
        return parts.size() > 0 ? parts.get(0) : null;
    }

    private <T> List<T> getParts(Class<T> cls, String id) {
        return this.modelService.findElements((MUIElement)this.workbenchWindow, id, cls, null, 11);
    }

    @Override
    public Collection<MPart> getParts() {
        return this.getParts(MPart.class, null);
    }

    @Override
    public boolean isPartVisible(MPart part) {
        if (this.isInContainer((MUIElement)part)) {
            MPart element = part;
            MElementContainer parent = part.getParent();
            if (parent == null) {
                element = part.getCurSharedRef();
                if (element == null) {
                    return false;
                }
                parent = element.getParent();
                if (parent == null) {
                    return false;
                }
            }
            if (parent instanceof MPartStack) {
                return parent.getSelectedElement() == element;
            }
            return element.isVisible();
        }
        return false;
    }

    private boolean isInContainer(MUIElement element) {
        if (this.modelService.isHostedElement(element, this.getWindow())) {
            return true;
        }
        List<MUIElement> allPerspectiveElements = this.modelService.findElements((MUIElement)this.workbenchWindow, null, MUIElement.class, null, 11);
        return allPerspectiveElements.contains(element);
    }

    boolean isInContainer(MElementContainer<?> container, MUIElement element) {
        for (Object object : container.getChildren()) {
            if (object == element) {
                return true;
            }
            if (object instanceof MElementContainer) {
                if (!this.isInContainer((MElementContainer)object, element)) continue;
                return true;
            }
            if (object instanceof MPlaceholder) {
                MUIElement ref = ((MPlaceholder)object).getRef();
                if (ref == element) {
                    return true;
                }
                if (!(ref instanceof MElementContainer) || !this.isInContainer((MElementContainer)ref, element)) continue;
                return true;
            }
            if (object instanceof MPerspective) {
                MPerspective persp = (MPerspective)object;
                for (MWindow dw : persp.getWindows()) {
                    if (!this.isInContainer((MElementContainer<?>)dw, element)) continue;
                    return true;
                }
                continue;
            }
            if (!(object instanceof MWindow)) continue;
            MWindow win = (MWindow)object;
            for (MWindow dw : win.getWindows()) {
                if (!this.isInContainer((MElementContainer<?>)dw, element)) continue;
                return true;
            }
        }
        if (container instanceof MWindow) {
            MWindow win = (MWindow)container;
            for (MWindow dw : win.getWindows()) {
                if (!this.isInContainer((MElementContainer<?>)dw, element)) continue;
                return true;
            }
        }
        if (container instanceof MPerspective) {
            MPerspective persp = (MPerspective)container;
            for (MWindow dw : persp.getWindows()) {
                if (!this.isInContainer((MElementContainer<?>)dw, element)) continue;
                return true;
            }
        }
        return false;
    }

    MPlaceholder getLocalPlaceholder(MUIElement part) {
        return this.modelService.findPlaceholderFor(this.getWindow(), part);
    }

    @Override
    public void switchPerspective(MPerspective perspective) {
        Assert.isNotNull((Object)perspective);
        MWindow window = this.getWindow();
        if (window != null && this.isInContainer((MElementContainer<?>)window, (MUIElement)perspective)) {
            MPart candidate;
            perspective.getParent().setSelectedElement((MUIElement)perspective);
            List<MPart> newPerspectiveParts = this.modelService.findElements((MUIElement)perspective, null, MPart.class, null);
            if (newPerspectiveParts.contains(this.activePart) && this.partActivationHistory.isValid(perspective, (MUIElement)this.activePart)) {
                MPart target = this.activePart;
                IEclipseContext activeChild = this.activePart.getContext().getParent().getActiveChild();
                if (activeChild != null) {
                    activeChild.deactivate();
                }
                perspective.getContext().activate();
                this.modelService.bringToTop((MUIElement)target);
                this.activate(target, true, false);
                return;
            }
            MPart newActivePart = (MPart)perspective.getContext().getActiveLeaf().get(MPart.class);
            if (newActivePart == null && (candidate = this.partActivationHistory.getActivationCandidate(perspective)) != null) {
                this.modelService.bringToTop((MUIElement)candidate);
                this.activate(candidate, true, false);
                return;
            }
            if (newActivePart == null) {
                this.modelService.bringToTop((MUIElement)perspective);
                perspective.getContext().activate();
            } else {
                if ((this.modelService.getElementLocation((MUIElement)newActivePart) & 8) != 0 && newActivePart.getParent().getSelectedElement() != newActivePart) {
                    newActivePart = (MPart)newActivePart.getParent().getSelectedElement();
                }
                this.activate(newActivePart, true, false);
            }
        }
    }

    @Override
    public void activate(MPart part) {
        this.activate(part, true);
    }

    @Override
    public void activate(MPart part, boolean requiresFocus) {
        this.activate(part, requiresFocus, true);
    }

    private void activate(MPart part, boolean requiresFocus, boolean activateBranch) {
        MPart inner;
        IEclipseContext pContext;
        if (part == null) {
            if (this.constructed && this.activePart != null) {
                this.firePartDeactivated(this.activePart);
            }
            this.activePart = part;
            return;
        }
        if (part instanceof MCompositePart && part.getContext() != null && (pContext = part.getContext()).getActiveLeaf() != null && (inner = (MPart)pContext.getActiveLeaf().get(MPart.class)) != null) {
            part = inner;
        }
        if (!this.isInContainer((MUIElement)part)) {
            return;
        }
        MWindow window = this.getWindow();
        IEclipseContext windowContext = window.getContext();
        if (windowContext.getParent().getActiveChild() == windowContext && part == this.activePart) {
            this.partActivationHistory.prepend(part);
            UIEvents.publishEvent("org/eclipse/e4/ui/LifeCycle/activate", (MUIElement)part);
            return;
        }
        if (this.contextService != null) {
            this.contextService.deferUpdates(true);
        }
        if (this.contextManager != null) {
            this.contextManager.deferUpdates(true);
        }
        MPart lastActivePart = this.activePart;
        this.activePart = part;
        if (this.constructed && lastActivePart != null && lastActivePart != this.activePart) {
            this.firePartDeactivated(lastActivePart);
        }
        try {
            this.recordStackActivation(part);
            this.delegateBringToTop(part);
            window.getParent().setSelectedElement((MUIElement)window);
            this.partActivationHistory.activate(part, activateBranch);
            if (requiresFocus) {
                IPresentationEngine pe = (IPresentationEngine)part.getContext().get(IPresentationEngine.class);
                pe.focusGui((MUIElement)part);
            }
            this.firePartActivated(part);
            UIEvents.publishEvent("org/eclipse/e4/ui/LifeCycle/activate", (MUIElement)part);
        }
        finally {
            if (this.contextService != null) {
                this.contextService.deferUpdates(false);
            }
            if (this.contextManager != null) {
                this.contextManager.deferUpdates(false);
            }
        }
    }

    private void delegateBringToTop(MPart part) {
        this.modelService.bringToTop((MUIElement)part);
        this.createElement((MUIElement)part);
    }

    private void recordStackActivation(MPart part) {
        MPlaceholder placeholder;
        MElementContainer parent = part.getParent();
        if (parent instanceof MGenericStack) {
            this.recordSelectedActivation((MElementContainer<? extends MUIElement>)parent);
        } else if (parent == null && (placeholder = part.getCurSharedRef()) != null && (parent = placeholder.getParent()) instanceof MGenericStack) {
            this.recordSelectedActivation((MElementContainer<? extends MUIElement>)parent);
        }
    }

    private void recordSelectedActivation(MElementContainer<? extends MUIElement> parent) {
        MUIElement ref;
        MUIElement selectedElement = parent.getSelectedElement();
        if (selectedElement instanceof MPart) {
            this.partActivationHistory.append((MPart)selectedElement);
        } else if (selectedElement instanceof MPlaceholder && (ref = ((MPlaceholder)selectedElement).getRef()) instanceof MPart) {
            this.partActivationHistory.append((MPart)ref);
        }
    }

    @Override
    public MPart getActivePart() {
        return this.activePart;
    }

    private MPart createPart(MPartDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        MPart part = this.modelService.createModelElement(MPart.class);
        part.setElementId(descriptor.getElementId());
        part.getMenus().addAll(EcoreUtil.copyAll((Collection)descriptor.getMenus()));
        if (descriptor.getToolbar() != null) {
            part.setToolbar((MToolBar)EcoreUtil.copy((EObject)((EObject)descriptor.getToolbar())));
        }
        part.setContributorURI(descriptor.getContributorURI());
        part.setCloseable(descriptor.isCloseable());
        part.setContributionURI(descriptor.getContributionURI());
        part.setLabel(descriptor.getLabel());
        part.setIconURI(descriptor.getIconURI());
        part.setTooltip(descriptor.getTooltip());
        part.getHandlers().addAll(EcoreUtil.copyAll((Collection)descriptor.getHandlers()));
        part.getTags().addAll(descriptor.getTags());
        part.getPersistedState().putAll(descriptor.getPersistedState());
        part.getBindingContexts().addAll(descriptor.getBindingContexts());
        return part;
    }

    @Override
    public MPart createPart(String id) {
        MPartDescriptor descriptor = this.modelService.getPartDescriptor(id);
        return this.createPart(descriptor);
    }

    @Override
    public MPlaceholder createSharedPart(String id) {
        return this.createSharedPart(id, false);
    }

    @Override
    public MPlaceholder createSharedPart(String id, boolean force) {
        MWindow sharedWindow = this.getWindow();
        MPart sharedPart = null;
        if (!force) {
            for (MUIElement element : sharedWindow.getSharedElements()) {
                if (!element.getElementId().equals(id)) continue;
                sharedPart = (MPart)element;
                break;
            }
        }
        if (sharedPart == null) {
            MPartDescriptor descriptor = this.modelService.getPartDescriptor(id);
            sharedPart = this.createPart(descriptor);
            if (sharedPart == null) {
                return null;
            }
            sharedPart.setElementId(id);
            sharedWindow.getSharedElements().add(sharedPart);
        }
        return this.createSharedPart(sharedPart);
    }

    private MPlaceholder createSharedPart(MPart sharedPart) {
        MPlaceholder sharedPartRef = this.modelService.createModelElement(MPlaceholder.class);
        sharedPartRef.setElementId(sharedPart.getElementId());
        sharedPartRef.setRef((MUIElement)sharedPart);
        return sharedPartRef;
    }

    private MPart addPart(MPart providedPart, MPart localPart) {
        MPartDescriptor descriptor = this.modelService.getPartDescriptor(providedPart.getElementId());
        if (descriptor == null) {
            if (!this.isInContainer((MUIElement)providedPart)) {
                this.adjustPlaceholder(providedPart);
                this.addToLastContainer(null, providedPart);
            }
        } else {
            if (providedPart != localPart && !descriptor.isAllowMultiple()) {
                return localPart;
            }
            if (this.isInContainer((MUIElement)providedPart)) {
                return providedPart;
            }
            this.adjustPlaceholder(providedPart);
            String category = descriptor.getCategory();
            if (category == null) {
                this.addToLastContainer(null, providedPart);
            } else if ("org.eclipse.e4.primaryDataStack".equals(category)) {
                MElementContainer<MUIElement> container = this.getContainer();
                MUIElement area = this.modelService.find("org.eclipse.ui.editorss", (MUIElement)container);
                MPartStack activeStack = null;
                if (area instanceof MPlaceholder && ((MPlaceholder)area).getRef() instanceof MArea) {
                    MArea a = (MArea)((MPlaceholder)area).getRef();
                    MUIElement curActive = a.getSelectedElement();
                    while (curActive instanceof MElementContainer) {
                        if (curActive instanceof MPartStack) {
                            activeStack = (MPartStack)curActive;
                            break;
                        }
                        MElementContainer curContainer = (MElementContainer)curActive;
                        curActive = curContainer.getSelectedElement();
                    }
                }
                if (activeStack != null) {
                    activeStack.getChildren().add(providedPart);
                } else {
                    List<MPartStack> sharedStacks = this.modelService.findElements(area, null, MPartStack.class, null);
                    if (sharedStacks.size() > 0) {
                        for (MPartStack stack : sharedStacks) {
                            if (!stack.isToBeRendered()) continue;
                            stack.getChildren().add(providedPart);
                            break;
                        }
                    } else {
                        this.addToLastContainer(null, providedPart);
                    }
                }
            } else {
                List<MElementContainer> containers = this.modelService.findElements((MUIElement)this.getContainer(), null, MElementContainer.class, Collections.singletonList(category), 11);
                if (containers.isEmpty()) {
                    this.addToLastContainer(category, providedPart);
                } else {
                    MElementContainer container = containers.get(0);
                    MPlaceholder placeholder = providedPart.getCurSharedRef();
                    if (placeholder == null) {
                        container.getChildren().add(providedPart);
                    } else {
                        container.getChildren().add(placeholder);
                    }
                }
            }
        }
        return providedPart;
    }

    private void adjustPlaceholder(MPart part) {
        MPlaceholder placeholder;
        if (this.isShared(part) && ((placeholder = part.getCurSharedRef()) == null || placeholder.getParent() != null && !this.isInContainer((MUIElement)placeholder))) {
            placeholder = this.createSharedPart(part);
            part.setCurSharedRef(placeholder);
        }
    }

    private boolean isShared(MPart part) {
        return this.getWindow().getSharedElements().contains(part);
    }

    private void addToLastContainer(String category, MPart part) {
        int colonIndex;
        String partId = part.getElementId();
        int n = colonIndex = partId == null ? -1 : partId.indexOf(58);
        if (colonIndex >= 0) {
            MElementContainer phParent;
            String descId = part.getElementId().substring(0, colonIndex);
            List<MPlaceholder> phList = this.modelService.findElements((MUIElement)this.workbenchWindow, descId = String.valueOf(descId) + ":*", MPlaceholder.class, null, 11);
            if (phList.size() > 0 && (phParent = phList.get(0).getParent()) instanceof MPartStack) {
                MPartStack theStack = (MPartStack)phParent;
                int phIndex = theStack.getChildren().indexOf(phList.get(0));
                this.adjustPlaceholder(part);
                MPlaceholder placeholder = part.getCurSharedRef();
                if (placeholder == null) {
                    theStack.getChildren().add(phIndex, part);
                } else {
                    theStack.getChildren().add(phIndex, placeholder);
                }
                return;
            }
        }
        MElementContainer<?> lastContainer = this.getLastContainer();
        MPlaceholder placeholder = part.getCurSharedRef();
        if (placeholder == null) {
            lastContainer.getChildren().add(part);
        } else {
            lastContainer.getChildren().add(placeholder);
        }
        if (category != null) {
            lastContainer.getTags().add(category);
        }
    }

    private MElementContainer<?> getLastContainer() {
        MElementContainer<MUIElement> searchRoot = this.getContainer();
        List children = searchRoot.getChildren();
        if (children.size() == 0) {
            MPartStack stack = this.modelService.createModelElement(MPartStack.class);
            searchRoot.getChildren().add(stack);
            return stack;
        }
        MElementContainer<?> lastContainer = this.getLastContainer(searchRoot, children);
        if (lastContainer instanceof MPartStack) {
            return lastContainer;
        }
        MPartStack stack = this.modelService.createModelElement(MPartStack.class);
        stack.setElementId("CreatedByGetLastContainer");
        if (children.get(0) instanceof MPartSashContainer) {
            MPartSashContainer psc = (MPartSashContainer)children.get(0);
            psc.getChildren().add(stack);
        } else {
            this.modelService.insert((MPartSashContainerElement)stack, (MPartSashContainerElement)children.get(0), 3, 0.5f);
        }
        return stack;
    }

    private MElementContainer<?> getLastContainer(MElementContainer<?> container, List<?> children) {
        if (children.isEmpty()) {
            return null;
        }
        int i = children.size() - 1;
        while (i > -1) {
            MElementContainer childContainer;
            MElementContainer<?> lastContainer;
            Object muiElement = children.get(i);
            if (muiElement instanceof MElementContainer && (lastContainer = this.getLastContainer(childContainer = (MElementContainer)muiElement, childContainer.getChildren())) != null) {
                return lastContainer;
            }
            --i;
        }
        return container;
    }

    private MElementContainer<MUIElement> getParent(MUIElement element) {
        MElementContainer parent = element.getParent();
        if (parent == null) {
            MPlaceholder placeholder = element.getCurSharedRef();
            if (placeholder == null) {
                MElementContainer<MUIElement> container = this.getContainer();
                return this.findContainer(container, element);
            }
            return placeholder.getParent();
        }
        return parent;
    }

    private MElementContainer<MUIElement> findContainer(MElementContainer<?> container, MUIElement element) {
        for (Object child : container.getChildren()) {
            MElementContainer<MUIElement> match;
            if (child == element) {
                return container;
            }
            if (child instanceof MPlaceholder) {
                MElementContainer<MUIElement> match2;
                MPlaceholder placeholder = (MPlaceholder)child;
                MUIElement ref = placeholder.getRef();
                if (ref == element) {
                    return container;
                }
                if (!(ref instanceof MElementContainer) || (match2 = this.findContainer((MElementContainer)ref, element)) == null) continue;
                return match2;
            }
            if (!(child instanceof MElementContainer) || (match = this.findContainer((MElementContainer)child, element)) == null) continue;
            return match;
        }
        return null;
    }

    private MUIElement getRemoveTarget(MPart part) {
        MPlaceholder placeholder = this.getLocalPlaceholder((MUIElement)part);
        return placeholder == null ? part : placeholder;
    }

    public MPart addPart(MPart part) {
        Assert.isNotNull((Object)part);
        MPart localPart = this.findPart(part.getElementId());
        return this.addPart(part, localPart == null ? part : localPart);
    }

    @Override
    public MPart showPart(String id, EPartService.PartState partState) {
        MPartDescriptor descriptor;
        Assert.isNotNull((Object)id);
        Assert.isNotNull((Object)((Object)partState));
        MPart part = this.findPart(id);
        if (part == null && (part = this.createPart(descriptor = this.modelService.getPartDescriptor(id))) == null) {
            return null;
        }
        return this.showPart(this.addPart(part), partState);
    }

    @Override
    public MPart showPart(MPart part, EPartService.PartState partState) {
        Assert.isNotNull((Object)part);
        Assert.isNotNull((Object)((Object)partState));
        MPart addedPart = this.addPart(part);
        MPlaceholder localPlaceholder = this.getLocalPlaceholder((MUIElement)addedPart);
        if (localPlaceholder != null && addedPart.getCurSharedRef() != localPlaceholder) {
            addedPart.setCurSharedRef(localPlaceholder);
        }
        switch (partState) {
            case ACTIVATE: {
                this.activate(addedPart);
                return addedPart;
            }
            case VISIBLE: {
                MPart activePart = this.getActivePart();
                if (activePart == null || activePart != addedPart && this.getParent((MUIElement)activePart) == this.getParent((MUIElement)addedPart)) {
                    this.delegateBringToTop(addedPart);
                    this.activate(addedPart);
                } else {
                    this.bringToTop(addedPart);
                }
                return addedPart;
            }
            case CREATE: {
                this.createElement((MUIElement)addedPart);
                return addedPart;
            }
        }
        return addedPart;
    }

    private void createElement(MUIElement element) {
        if (this.modelService.isHostedElement(element, this.workbenchWindow)) {
            return;
        }
        MPlaceholder placeholder = element.getCurSharedRef();
        if (placeholder != null) {
            element.setToBeRendered(true);
            element = placeholder;
        }
        element.setToBeRendered(true);
        MWindow parentWindow = this.workbenchWindow;
        MElementContainer target = null;
        MElementContainer parent = element.getParent();
        while (parent != null && parent != parentWindow) {
            parent.setToBeRendered(true);
            if (parent.getWidget() == null) {
                target = parent;
            }
            parent = parent.getParent();
        }
        if (target != null) {
            this.engine.createGui((MUIElement)target);
        }
        if (element.getWidget() == null) {
            this.engine.createGui(element);
        }
        if ((parent = element.getParent()) != null && parent.getChildren().size() == 1) {
            parent.setSelectedElement(element);
        }
    }

    @Override
    public void requestActivation() {
        MPart candidate;
        if (this.activePart == null) {
            MPart candidate2 = this.partActivationHistory.getActivationCandidate(this.getParts());
            if (candidate2 != null) {
                this.activate(candidate2);
            }
        } else if (!(this.partActivationHistory.isValid((MUIElement)this.activePart) && this.getParts().contains(this.activePart) || (candidate = this.partActivationHistory.getNextActivationCandidate(this.getParts(), this.activePart)) == null)) {
            this.activate(candidate);
        }
    }

    @Override
    public void hidePart(MPart part) {
        this.hidePart(part, false);
    }

    @Override
    public void hidePart(MPart part, boolean force) {
        if (this.isInContainer((MUIElement)part)) {
            MPerspective thePersp;
            boolean needNewSel;
            MPlaceholder sharedRef = part.getCurSharedRef();
            MUIElement toBeRemoved = this.getRemoveTarget(part);
            MElementContainer<MUIElement> parent = this.getParent(toBeRemoved);
            List children = parent.getChildren();
            if (toBeRemoved != part && toBeRemoved instanceof MPlaceholder && sharedRef != toBeRemoved) {
                toBeRemoved.setToBeRendered(false);
                if (force || part.getTags().contains("removeOnHide")) {
                    parent.getChildren().remove(toBeRemoved);
                }
                return;
            }
            boolean isActiveChild = this.isActiveChild(part);
            MPart activationCandidate = null;
            if (isActiveChild) {
                activationCandidate = this.partActivationHistory.getNextActivationCandidate(this.getParts(), part);
            }
            boolean bl = needNewSel = (thePersp = this.modelService.getPerspectiveFor(toBeRemoved)) == null || !thePersp.getTags().contains("PerspClosing");
            if (needNewSel) {
                if (parent.getSelectedElement() == toBeRemoved) {
                    MUIElement candidate = this.partActivationHistory.getSiblingSelectionCandidate(part);
                    Object object = candidate == null ? null : (candidate = candidate.getCurSharedRef() == null ? candidate : candidate.getCurSharedRef());
                    if (candidate != null && children.contains(candidate)) {
                        parent.setSelectedElement(candidate);
                    } else {
                        for (MUIElement child : children) {
                            if (child == toBeRemoved || !child.isToBeRendered()) continue;
                            parent.setSelectedElement(child);
                            break;
                        }
                    }
                }
                if (activationCandidate == null) {
                    if (isActiveChild) {
                        part.getContext().deactivate();
                    }
                } else {
                    this.activate(activationCandidate);
                }
            }
            if (toBeRemoved != null) {
                toBeRemoved.setToBeRendered(false);
            } else {
                part.setToBeRendered(false);
            }
            if (parent.getSelectedElement() == toBeRemoved) {
                parent.setSelectedElement(null);
            }
            if (force || part.getTags().contains("removeOnHide")) {
                children.remove(toBeRemoved);
            }
            this.partActivationHistory.forget(this.getWindow(), part, toBeRemoved == part);
        }
    }

    private boolean isActiveChild(MPart part) {
        IEclipseContext context = part.getContext();
        return context != null && context.getParent().getActiveChild() == context;
    }

    @Override
    public Collection<MPart> getDirtyParts() {
        ArrayList<MPart> dirtyParts = new ArrayList<MPart>();
        for (MPart part : this.getParts()) {
            if (!part.isDirty()) continue;
            dirtyParts.add(part);
        }
        return dirtyParts;
    }

    @Override
    public boolean savePart(MPart part, boolean confirm) {
        if (!part.isDirty()) {
            return true;
        }
        if (this.saveHandler != null) {
            return this.saveHandler.save(part, confirm);
        }
        Object client = part.getObject();
        try {
            ContextInjectionFactory.invoke((Object)client, Persist.class, (IEclipseContext)part.getContext());
        }
        catch (InjectionException e) {
            this.log("Failed to persist contents of part", "Failed to persist contents of part ({0})", part.getElementId(), (Exception)((Object)e));
            return false;
        }
        catch (RuntimeException e) {
            this.log("Failed to persist contents of part via DI", "Failed to persist contents of part ({0}) via DI", part.getElementId(), e);
            return false;
        }
        return true;
    }

    @Override
    public boolean saveAll(boolean confirm) {
        Collection<MPart> dirtyParts = this.getDirtyParts();
        if (dirtyParts.isEmpty()) {
            return true;
        }
        if (this.saveHandler != null) {
            return this.saveHandler.saveParts(dirtyParts, confirm);
        }
        for (MPart dirtyPart : dirtyParts) {
            if (this.savePart(dirtyPart, false)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Collection<MInputPart> getInputParts(String inputUri) {
        Assert.isNotNull((Object)inputUri, (String)"Input uri must not be null");
        ArrayList<MInputPart> rv = new ArrayList<MInputPart>();
        for (MInputPart p : this.getParts(MInputPart.class, null)) {
            if (!inputUri.equals(p.getInputURI())) continue;
            rv.add(p);
        }
        return rv;
    }

    private MElementContainer<MUIElement> getContainer() {
        MWindow outerContainer;
        MWindow container = outerContainer = this.workbenchWindow != null ? this.workbenchWindow : this.application;
        while (container != null) {
            if (container instanceof MPerspective) {
                return container;
            }
            MUIElement child = container.getSelectedElement();
            if (child == null || !(child instanceof MElementContainer)) break;
            container = (MElementContainer)child;
        }
        return outerContainer;
    }
}

