/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.RepositorySaveableFilter;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.components.RefContentProposal;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.bindings.Trigger;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.ISaveableFilter;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.services.IServiceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIUtils {
    private static final char[] VALUE_HELP_ACTIVATIONCHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123457890*@ <>".toCharArray();
    public static final KeyStroke SUBMIT_KEY_STROKE = KeyStroke.getInstance((int)SWT.MOD1, (int)13);

    public static Font getFont(String id) {
        return PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry().get(id);
    }

    public static Font getBoldFont(String id) {
        return PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry().getBold(id);
    }

    public static Font getItalicFont(String id) {
        return PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry().getItalic(id);
    }

    public static int getControlIndent() {
        return 20;
    }

    public static Text createSelectableLabel(Composite parent, int style) {
        Text text = new Text(parent, style | 8);
        text.setBackground(text.getDisplay().getSystemColor(22));
        return text;
    }

    public static void addBulbDecorator(Control control, String tooltip) {
        ControlDecoration dec = new ControlDecoration(control, 16512);
        dec.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL").getImage());
        dec.setShowOnlyOnFocus(true);
        dec.setShowHover(true);
        dec.setDescriptionText(tooltip);
    }

    public static IPreviousValueProposalHandler addPreviousValuesContentProposalToText(final Text textField, final String preferenceKey) {
        KeyStroke stroke = UIUtils.getKeystrokeOfBestActiveBindingFor("org.eclipse.ui.edit.text.contentAssist.proposals");
        if (stroke == null) {
            UIUtils.addBulbDecorator((Control)textField, UIText.UIUtils_StartTypingForPreviousValuesMessage);
        } else {
            UIUtils.addBulbDecorator((Control)textField, NLS.bind((String)UIText.UIUtils_PressShortcutMessage, (Object)stroke.format()));
        }
        IContentProposalProvider cp = new IContentProposalProvider(){

            public IContentProposal[] getProposals(String contents, int position) {
                Pattern pattern;
                ArrayList<1> resultList = new ArrayList<1>();
                String patternString = contents;
                while (patternString.length() > 0 && patternString.charAt(0) == ' ') {
                    patternString = patternString.substring(1);
                }
                patternString = Pattern.quote(patternString);
                if (!(patternString = patternString.replaceAll("\\x2A", ".*")).endsWith(".*")) {
                    patternString = String.valueOf(patternString) + ".*";
                }
                try {
                    pattern = Pattern.compile(patternString, 2);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    pattern = null;
                }
                String[] proposals = Activator.getDefault().getDialogSettings().getArray(preferenceKey);
                if (proposals != null) {
                    String[] stringArray = proposals;
                    int n = proposals.length;
                    int n2 = 0;
                    while (n2 < n) {
                        final String uriString = stringArray[n2];
                        if (pattern == null || pattern.matcher(uriString).matches()) {
                            IContentProposal propsal = new IContentProposal(){

                                public String getLabel() {
                                    return null;
                                }

                                public String getDescription() {
                                    return null;
                                }

                                public int getCursorPosition() {
                                    return 0;
                                }

                                public String getContent() {
                                    return uriString;
                                }
                            };
                            resultList.add(propsal);
                        }
                        ++n2;
                    }
                }
                return resultList.toArray(new IContentProposal[resultList.size()]);
            }
        };
        ContentProposalAdapter adapter = new ContentProposalAdapter((Control)textField, (IControlContentAdapter)new TextContentAdapter(), cp, stroke, VALUE_HELP_ACTIVATIONCHARS);
        adapter.setProposalAcceptanceStyle(2);
        return new IPreviousValueProposalHandler(){

            public void updateProposals() {
                String value = textField.getText();
                if (value.length() > 0) {
                    IDialogSettings settings;
                    String[] existingValues;
                    if (value.length() > 2000) {
                        value = value.substring(0, 1999);
                    }
                    if ((existingValues = (settings = Activator.getDefault().getDialogSettings()).getArray(preferenceKey)) == null) {
                        existingValues = new String[]{value};
                        settings.put(preferenceKey, existingValues);
                    } else {
                        ArrayList<String> values = new ArrayList<String>(existingValues.length + 1);
                        String[] stringArray = existingValues;
                        int n = existingValues.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String existingValue = stringArray[n2];
                            values.add(existingValue);
                            ++n2;
                        }
                        if (values.indexOf(value) == 0) {
                            return;
                        }
                        values.remove(value);
                        values.add(0, value);
                        while (values.size() > 10) {
                            values.remove(values.size() - 1);
                        }
                        settings.put(preferenceKey, values.toArray(new String[values.size()]));
                    }
                }
            }
        };
    }

    public static final void addRefContentProposalToText(Text textField, final Repository repository, final IRefListProvider refListProvider) {
        KeyStroke stroke = UIUtils.getKeystrokeOfBestActiveBindingFor("org.eclipse.ui.edit.text.contentAssist.proposals");
        if (stroke == null) {
            UIUtils.addBulbDecorator((Control)textField, UIText.UIUtils_StartTypingForPreviousValuesMessage);
        } else {
            UIUtils.addBulbDecorator((Control)textField, NLS.bind((String)UIText.UIUtils_PressShortcutMessage, (Object)stroke.format()));
        }
        IContentProposalProvider cp = new IContentProposalProvider(){

            public IContentProposal[] getProposals(String contents, int position) {
                Pattern pattern;
                ArrayList<RefContentProposal> resultList = new ArrayList<RefContentProposal>();
                String patternString = contents;
                while (patternString.length() > 0 && patternString.charAt(0) == ' ') {
                    patternString = patternString.substring(1);
                }
                patternString = Pattern.quote(patternString);
                if (!(patternString = patternString.replaceAll("\\x2A", ".*")).endsWith(".*")) {
                    patternString = String.valueOf(patternString) + ".*";
                }
                try {
                    pattern = Pattern.compile(patternString, 2);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    pattern = null;
                }
                List<Ref> proposals = refListProvider.getRefList();
                if (proposals != null) {
                    for (Ref ref : proposals) {
                        String shortenedName = Repository.shortenRefName((String)ref.getName());
                        if (pattern != null && !pattern.matcher(ref.getName()).matches() && !pattern.matcher(shortenedName).matches()) continue;
                        RefContentProposal propsal = new RefContentProposal(repository, ref);
                        resultList.add(propsal);
                    }
                }
                return resultList.toArray(new IContentProposal[resultList.size()]);
            }
        };
        ContentProposalAdapter adapter = new ContentProposalAdapter((Control)textField, (IControlContentAdapter)new TextContentAdapter(), cp, stroke, VALUE_HELP_ACTIVATIONCHARS);
        adapter.setProposalAcceptanceStyle(2);
    }

    public static void setEnabledRecursively(Control control, boolean enable) {
        control.setEnabled(enable);
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                UIUtils.setEnabledRecursively(child, enable);
                ++n2;
            }
        }
    }

    public static void hookDisposal(Widget widget, final Resource resource) {
        if (widget == null || resource == null) {
            return;
        }
        widget.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                resource.dispose();
            }
        });
    }

    public static void hookDisposal(Widget widget, final ResourceManager resources) {
        if (widget == null || resources == null) {
            return;
        }
        widget.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                resources.dispose();
            }
        });
    }

    public static ImageDescriptor getEditorImage(String path) {
        String name;
        if (path != null && path.length() > 0 && (name = new Path(path).lastSegment()) != null) {
            return PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(name);
        }
        return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE");
    }

    public static Point getSize(ImageDescriptor descriptor) {
        ImageData data = descriptor.getImageData();
        if (data == null) {
            return new Point(0, 0);
        }
        return new Point(data.width, data.height);
    }

    public static ToolBar addExpansionItems(ToolBar toolbar, final AbstractTreeViewer viewer) {
        ToolItem collapseItem = new ToolItem(toolbar, 8);
        Image collapseImage = UIIcons.COLLAPSEALL.createImage();
        UIUtils.hookDisposal((Widget)collapseItem, (Resource)collapseImage);
        collapseItem.setImage(collapseImage);
        collapseItem.setToolTipText(UIText.UIUtils_CollapseAll);
        collapseItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                viewer.collapseAll();
            }
        });
        ToolItem expandItem = new ToolItem(toolbar, 8);
        Image expandImage = UIIcons.EXPAND_ALL.createImage();
        UIUtils.hookDisposal((Widget)expandItem, (Resource)expandImage);
        expandItem.setImage(expandImage);
        expandItem.setToolTipText(UIText.UIUtils_ExpandAll);
        expandItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                viewer.expandAll();
            }
        });
        return toolbar;
    }

    public static IDialogSettings getDialogBoundSettings(Class<?> clazz) {
        return UIUtils.getDialogSettings(String.valueOf(clazz.getName()) + ".dialogBounds");
    }

    public static IDialogSettings getDialogSettings(String sectionName) {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(sectionName);
        if (section == null) {
            section = settings.addNewSection(sectionName);
        }
        return section;
    }

    public static String getDefaultRepositoryDir() {
        String dir = Activator.getDefault().getPreferenceStore().getString("default_repository_dir");
        IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
        try {
            return manager.performStringSubstitution(dir);
        }
        catch (CoreException coreException) {
            return "";
        }
    }

    public static boolean isUsable(Viewer viewer) {
        return viewer != null && UIUtils.isUsable(viewer.getControl());
    }

    public static boolean isUsable(Control control) {
        return control != null && !control.isDisposed();
    }

    public static void executeCommand(IHandlerService service, String id) {
        UIUtils.executeCommand(service, id, null);
    }

    public static void executeCommand(IHandlerService service, String id, Event event) {
        try {
            service.executeCommand(id, event);
        }
        catch (ExecutionException e) {
            Activator.handleError(e.getMessage(), e, false);
        }
        catch (NotDefinedException e) {
            Activator.handleError(e.getMessage(), e, false);
        }
        catch (NotEnabledException e) {
            Activator.handleError(e.getMessage(), e, false);
        }
        catch (NotHandledException e) {
            Activator.handleError(e.getMessage(), e, false);
        }
    }

    public static boolean isSubmitKeyEvent(KeyEvent event) {
        return (event.stateMask & SWT.MODIFIER_MASK) != 0 && event.keyCode == SUBMIT_KEY_STROKE.getNaturalKey();
    }

    public static boolean saveAllEditors(Repository repository) {
        return UIUtils.saveAllEditors(repository, null);
    }

    public static boolean saveAllEditors(Repository repository, String cancelConfirmationQuestion) {
        RepositorySaveableFilter filter;
        IWorkbenchWindow window;
        IWorkbench workbench = PlatformUI.getWorkbench();
        boolean success = workbench.saveAll((IShellProvider)(window = workbench.getActiveWorkbenchWindow()), (IRunnableContext)window, (ISaveableFilter)(filter = new RepositorySaveableFilter(repository)), true);
        if (success && cancelConfirmationQuestion != null && filter.isAnythingSaved()) {
            String[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL};
            MessageDialog dialog = new MessageDialog(window.getShell(), UIText.CancelAfterSaveDialog_Title, null, cancelConfirmationQuestion, 3, buttons, 0){

                protected int getShellStyle() {
                    return 0x10010820 | 8.getDefaultOrientation();
                }
            };
            int choice = dialog.open();
            if (choice != 1) {
                return false;
            }
        }
        return success;
    }

    public static MenuManager createShowInMenu(IWorkbenchWindow workbenchWindow) {
        MenuManager showInSubMenu = new MenuManager(UIUtils.getShowInMenuLabel());
        showInSubMenu.add(ContributionItemFactory.VIEWS_SHOW_IN.create(workbenchWindow));
        return showInSubMenu;
    }

    public static void applyHyperlinkDetectorStyleRanges(ITextViewer textViewer, IHyperlinkDetector[] hyperlinkDetectors) {
        StyleRange[] styleRanges = UIUtils.getHyperlinkDetectorStyleRanges(textViewer, hyperlinkDetectors);
        StyledText styledText = textViewer.getTextWidget();
        StyleRange[] styleRangeArray = styleRanges;
        int n = styleRanges.length;
        int n2 = 0;
        while (n2 < n) {
            StyleRange styleRange = styleRangeArray[n2];
            styledText.setStyleRange(styleRange);
            ++n2;
        }
    }

    public static StyleRange[] getHyperlinkDetectorStyleRanges(ITextViewer textViewer, IHyperlinkDetector[] hyperlinkDetectors) {
        LinkedHashSet<StyleRange> styleRangeList = new LinkedHashSet<StyleRange>();
        if (hyperlinkDetectors != null && hyperlinkDetectors.length > 0) {
            IDocument doc = textViewer.getDocument();
            int line = 0;
            while (line < doc.getNumberOfLines()) {
                try {
                    IRegion region = doc.getLineInformation(line);
                    IHyperlinkDetector[] iHyperlinkDetectorArray = hyperlinkDetectors;
                    int n = hyperlinkDetectors.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IHyperlinkDetector hyperLinkDetector = iHyperlinkDetectorArray[n2];
                        IHyperlink[] hyperlinks = hyperLinkDetector.detectHyperlinks(textViewer, region, true);
                        if (hyperlinks != null) {
                            IHyperlink[] iHyperlinkArray = hyperlinks;
                            int n3 = hyperlinks.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IHyperlink hyperlink = iHyperlinkArray[n4];
                                StyleRange hyperlinkStyleRange = new StyleRange(hyperlink.getHyperlinkRegion().getOffset(), hyperlink.getHyperlinkRegion().getLength(), Display.getDefault().getSystemColor(9), Display.getDefault().getSystemColor(1));
                                hyperlinkStyleRange.underline = true;
                                styleRangeList.add(hyperlinkStyleRange);
                                ++n4;
                            }
                        }
                        ++n2;
                    }
                }
                catch (BadLocationException e) {
                    Activator.logError(e.getMessage(), e);
                    break;
                }
                ++line;
            }
        }
        StyleRange[] styleRangeArray = new StyleRange[styleRangeList.size()];
        styleRangeList.toArray(styleRangeArray);
        return styleRangeArray;
    }

    private static String getShowInMenuLabel() {
        String keyBinding;
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        if (bindingService != null && (keyBinding = bindingService.getBestActiveBindingFormattedFor("org.eclipse.ui.navigate.showInQuickMenu")) != null) {
            return String.valueOf(UIText.UIUtils_ShowInMenuLabel) + '\t' + keyBinding;
        }
        return UIText.UIUtils_ShowInMenuLabel;
    }

    public static KeyStroke getKeystrokeOfBestActiveBindingFor(String commandId) {
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        TriggerSequence ts = bindingService.getBestActiveBindingFor(commandId);
        if (ts == null) {
            return null;
        }
        Trigger[] triggers = ts.getTriggers();
        if (triggers.length == 1 && triggers[0] instanceof KeyStroke) {
            return (KeyStroke)triggers[0];
        }
        return null;
    }

    public static void setButtonLayoutData(Button button) {
        GC gc = new GC((Drawable)button);
        gc.setFont(JFaceResources.getDialogFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        GridData data = new GridData(256);
        int widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)61);
        Point minSize = button.computeSize(-1, -1, true);
        data.widthHint = Math.max(widthHint, minSize.x);
        button.setLayoutData((Object)data);
    }

    public static void notifySelectionChangedWithCurrentSelection(ISelectionListener selectionListener, IServiceLocator serviceLocator) {
        IHandlerService handlerService = CommonUtils.getService(serviceLocator, IHandlerService.class);
        IEvaluationContext state = handlerService.getCurrentState();
        Object partObject = state.getVariable("activePart");
        Object selectionObject = state.getVariable("selection");
        if (partObject instanceof IWorkbenchPart && selectionObject instanceof ISelection) {
            IWorkbenchPart part = (IWorkbenchPart)partObject;
            ISelection selection = (ISelection)selectionObject;
            if (!selection.isEmpty()) {
                selectionListener.selectionChanged(part, selection);
            }
        }
    }

    public static interface IPreviousValueProposalHandler {
        public void updateProposals();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IRefListProvider {
        public List<Ref> getRefList();
    }
}

