/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.SystemReader;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;

public class ConfigurationChecker {
    public static void checkConfiguration() {
        Job job = new Job(UIText.ConfigurationChecker_checkConfiguration){

            protected IStatus run(IProgressMonitor monitor) {
                if (PlatformUI.isWorkbenchRunning()) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            ConfigurationChecker.check();
                        }
                    });
                } else {
                    this.schedule(1000L);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private static void check() {
        ConfigurationChecker.checkGitPrefix();
        ConfigurationChecker.checkHome();
    }

    private static void checkGitPrefix() {
        boolean hidden;
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        boolean bl = hidden = !store.getBoolean("show_git_prefix_warning");
        if (!hidden && FS.DETECTED.gitPrefix() == null) {
            Activator.handleIssue(2, UIText.ConfigurationChecker_gitPrefixWarningMessage, null, false);
        }
    }

    private static void checkHome() {
        boolean hidden;
        String home = System.getenv("HOME");
        if (home != null) {
            return;
        }
        home = ConfigurationChecker.calcHomeDir();
        String message = NLS.bind((String)UIText.ConfigurationChecker_homeNotSet, (Object)home);
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        boolean bl = hidden = !store.getBoolean("show_home_drive_warning");
        if (!hidden) {
            Activator.handleIssue(2, message, null, false);
        }
    }

    private static String calcHomeDir() {
        if (ConfigurationChecker.runsOnWindows()) {
            String homeDrive = System.getenv("HOMEDRIVE");
            if (homeDrive != null) {
                String homePath = SystemReader.getInstance().getenv("HOMEPATH");
                return new File(homeDrive, homePath).getAbsolutePath();
            }
            return System.getenv("HOMESHARE");
        }
        return System.getProperty("user.home");
    }

    private static boolean runsOnWindows() {
        String os;
        try {
            os = System.getProperty("os.name");
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
        return os.indexOf("Windows") != -1;
    }
}

