/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history.command;

import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.core.op.MergeOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.actions.MergeActionHandler;
import org.eclipse.egit.ui.internal.dialogs.BranchSelectionDialog;
import org.eclipse.egit.ui.internal.history.command.AbstractHistoryCommandHandler;
import org.eclipse.egit.ui.internal.merge.MergeResultDialog;
import org.eclipse.egit.ui.internal.repository.tree.RefNode;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class MergeHandler
extends AbstractHistoryCommandHandler {
    public boolean isEnabled() {
        Repository repository = this.getRepository(this.getPage());
        if (repository == null) {
            return false;
        }
        return repository.getRepositoryState().equals((Object)RepositoryState.SAFE);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String refName;
        ObjectId commitId = this.getSelectedCommitId(event);
        final Repository repository = this.getRepository(event);
        if (repository == null) {
            return null;
        }
        if (!MergeActionHandler.checkMergeIsPossible(repository, this.getShell(event))) {
            return null;
        }
        List<RefNode> nodes = this.getRefNodes(commitId, repository, "refs/");
        if (nodes.isEmpty()) {
            refName = commitId.getName();
        } else if (nodes.size() == 1) {
            refName = ((Ref)nodes.get(0).getObject()).getName();
        } else {
            BranchSelectionDialog<RefNode> dlg = new BranchSelectionDialog<RefNode>(HandlerUtil.getActiveShellChecked((ExecutionEvent)event), nodes, UIText.MergeHandler_SelectBranchTitle, UIText.MergeHandler_SelectBranchMessage, 4);
            if (dlg.open() == 0) {
                refName = ((Ref)dlg.getSelectedNode().getObject()).getName();
            } else {
                return null;
            }
        }
        String jobname = NLS.bind((String)UIText.MergeAction_JobNameMerge, (Object)refName);
        final MergeOperation op = new MergeOperation(repository, refName);
        WorkspaceJob job = new WorkspaceJob(jobname){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                try {
                    op.execute(monitor);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.setRule(op.getSchedulingRule());
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent cevent) {
                IStatus result = cevent.getJob().getResult();
                if (result.getSeverity() == 8) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                            MessageDialog.openInformation((Shell)shell, (String)UIText.MergeAction_MergeCanceledTitle, (String)UIText.MergeAction_MergeCanceledMessage);
                        }
                    });
                } else if (!result.isOK()) {
                    Activator.handleError(result.getMessage(), result.getException(), true);
                } else {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                            MergeResultDialog.getDialog(shell, repository, op.getResult()).open();
                        }
                    });
                }
            }
        });
        job.schedule();
        return null;
    }

    public Shell getShell(ExecutionEvent event) {
        return HandlerUtil.getActiveShell((ExecutionEvent)event);
    }
}

