/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.op.StashDropOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.repository.tree.StashedCommitNode;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StashDropCommand
extends RepositoriesViewCommandHandler<StashedCommitNode> {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        final List nodes = this.getSelectedNodes(event);
        if (nodes.isEmpty()) {
            return null;
        }
        final Repository repo = ((StashedCommitNode)nodes.get(0)).getRepository();
        if (repo == null) {
            return null;
        }
        final AtomicBoolean confirmed = new AtomicBoolean();
        final Shell shell = this.getActiveShell(event);
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                String message = nodes.size() > 1 ? MessageFormat.format(UIText.StashDropCommand_confirmMultiple, Integer.toString(nodes.size())) : MessageFormat.format(UIText.StashDropCommand_confirmSingle, Integer.toString(((StashedCommitNode)nodes.get(0)).getIndex()));
                confirmed.set(MessageDialog.openConfirm((Shell)shell, (String)UIText.StashDropCommand_confirmTitle, (String)message));
            }
        });
        if (!confirmed.get()) {
            return null;
        }
        Job job = new Job(UIText.StashDropCommand_jobTitle){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(UIText.StashDropCommand_jobTitle, nodes.size());
                Collections.sort(nodes, new Comparator<StashedCommitNode>(){

                    @Override
                    public int compare(StashedCommitNode n1, StashedCommitNode n2) {
                        return n1.getIndex() < n2.getIndex() ? 1 : -1;
                    }
                });
                for (StashedCommitNode node : nodes) {
                    int index = node.getIndex();
                    if (index < 0) {
                        return null;
                    }
                    RevCommit commit = (RevCommit)node.getObject();
                    if (commit == null) {
                        return null;
                    }
                    String stashName = ((RevCommit)node.getObject()).getName();
                    StashDropOperation op = new StashDropOperation(repo, node.getIndex());
                    monitor.subTask(stashName);
                    try {
                        op.execute(monitor);
                    }
                    catch (CoreException e) {
                        Activator.logError(MessageFormat.format(UIText.StashDropCommand_dropFailed, ((RevCommit)node.getObject()).name()), e);
                    }
                    monitor.worked(1);
                }
                monitor.done();
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (JobFamilies.STASH.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        job.setUser(true);
        job.setRule(new StashDropOperation(repo, ((StashedCommitNode)nodes.get(0)).getIndex()).getSchedulingRule());
        job.schedule();
        return null;
    }
}

