/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ITestSuite;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.internal.launching.Executable;
import org.eclipse.rcptt.launching.AutLaunch;

public class TestSuiteExecutable
extends Executable {
    private final AutLaunch launch;
    private final ITestSuite testSuite;
    private final Executable[] kids;

    public TestSuiteExecutable(AutLaunch launch, ITestSuite testSuite, Executable[] children, boolean debug) {
        super(debug);
        this.launch = launch;
        this.testSuite = testSuite;
        this.kids = new Executable[children.length];
        if (children.length > 0) {
            System.arraycopy(children, 0, this.kids, 0, children.length);
        }
        Executable[] executableArray = this.kids;
        int n = this.kids.length;
        int n2 = 0;
        while (n2 < n) {
            Executable child = executableArray[n2];
            child.setParent(this);
            ++n2;
        }
    }

    @Override
    public String getName() {
        String nameByDocument = Q7SearchCore.findNameByDocument((IQ7Element)this.testSuite);
        if (nameByDocument != null) {
            return nameByDocument;
        }
        try {
            return this.testSuite.getElementName();
        }
        catch (ModelException modelException) {
            return "Unresolved element";
        }
    }

    @Override
    public AutLaunch getAut() {
        return this.launch;
    }

    @Override
    public IQ7NamedElement getActualElement() {
        return this.testSuite;
    }

    @Override
    public IStatus getResultStatus() {
        Executable[] executableArray = this.kids;
        int n = this.kids.length;
        int n2 = 0;
        while (n2 < n) {
            Executable child = executableArray[n2];
            IStatus status = child.getResultStatus();
            if (status != null && !status.isOK()) {
                return status;
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }

    @Override
    public boolean isTerminated() {
        Executable[] executableArray = this.kids;
        int n = this.kids.length;
        int n2 = 0;
        while (n2 < n) {
            Executable child = executableArray[n2];
            if (child.isTerminated()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public int getStatus() {
        int status = 0;
        Executable[] executableArray = this.kids;
        int n = this.kids.length;
        int n2 = 0;
        while (n2 < n) {
            Executable child = executableArray[n2];
            status = Math.max(status, child.getStatus());
            ++n2;
        }
        return status;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public long getTime() {
        long total = 0L;
        Executable[] executableArray = this.kids;
        int n = this.kids.length;
        int n2 = 0;
        while (n2 < n) {
            Executable child = executableArray[n2];
            total += child.getTime();
            ++n2;
        }
        return total;
    }

    @Override
    public Executable[] getChildren() {
        return this.kids;
    }

    @Override
    public void startLaunching() {
        if (this.kids.length > 0) {
            this.kids[0].startLaunching();
        }
    }

    @Override
    public void terminate(boolean user) {
    }

    @Override
    public IStatus execute() throws InterruptedException {
        return Status.OK_STATUS;
    }

    @Override
    public void postExecute() {
    }
}

