/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.snippeteditor;

import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.JavaSnippetEditor;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.SelectImportsDialog;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.SnippetAction;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.SnippetMessages;
import org.eclipse.jdt.ui.ISharedImages;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.PlatformUI;

public class SelectImportsAction
extends SnippetAction {
    public SelectImportsAction(JavaSnippetEditor editor) {
        super(editor);
        this.setText(SnippetMessages.getString("SelectImports.label"));
        this.setToolTipText(SnippetMessages.getString("SelectImports.tooltip"));
        this.setDescription(SnippetMessages.getString("SelectImports.description"));
        ISharedImages sharedImages = JavaUI.getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("org.eclipse.jdt.ui.impc_obj.gif"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, IJavaDebugHelpContextIds.SCRAPBOOK_IMPORTS_ACTION);
    }

    public void run() {
        if (!this.getEditor().isInJavaProject()) {
            this.getEditor().reportNotInJavaProjectError();
            return;
        }
        this.chooseImports();
    }

    private void chooseImports() {
        String[] imports = this.getEditor().getImports();
        SelectImportsDialog dialog = new SelectImportsDialog(this.getEditor(), imports);
        dialog.open();
    }

    public void snippetStateChanged(JavaSnippetEditor editor) {
        this.setEnabled(editor != null && !editor.isEvaluating());
    }
}

