/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.equinox.http.servlet.internal.context.ContextController;
import org.eclipse.equinox.http.servlet.internal.context.DispatchTargets;
import org.eclipse.equinox.http.servlet.internal.context.ProxyContext;
import org.eclipse.equinox.http.servlet.internal.customizer.FilterTrackerCustomizer;
import org.eclipse.equinox.http.servlet.internal.customizer.ListenerTrackerCustomizer;
import org.eclipse.equinox.http.servlet.internal.customizer.ResourceTrackerCustomizer;
import org.eclipse.equinox.http.servlet.internal.customizer.ServletTrackerCustomizer;
import org.eclipse.equinox.http.servlet.internal.error.NullContextNamesException;
import org.eclipse.equinox.http.servlet.internal.error.NullServletContextHelperException;
import org.eclipse.equinox.http.servlet.internal.servlet.HttpServletRequestBuilder;
import org.eclipse.equinox.http.servlet.internal.servlet.HttpServletResponseWrapperImpl;
import org.eclipse.equinox.http.servlet.internal.servlet.Match;
import org.eclipse.equinox.http.servlet.internal.servlet.ResponseStateHandler;
import org.eclipse.equinox.http.servlet.internal.util.StringPlus;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.context.ServletContextHelper;
import org.osgi.service.http.runtime.HttpServiceRuntime;
import org.osgi.service.http.runtime.dto.RequestInfoDTO;
import org.osgi.service.http.runtime.dto.RuntimeDTO;
import org.osgi.service.http.runtime.dto.ServletContextDTO;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class HttpServiceRuntimeImpl
implements HttpServiceRuntime,
ServiceTrackerCustomizer<ServletContextHelper, ContextController> {
    private Map<String, Object> attributes;
    private BundleContext bundleContext;
    private ConcurrentMap<String, Set<ContextController>> contextPathMap = new ConcurrentHashMap<String, Set<ContextController>>();
    private ServiceTracker<ServletContextHelper, ContextController> contextServiceTracker;
    private ConcurrentMap<ContextController, ServletContextHelper> controllerMap = new ConcurrentHashMap<ContextController, ServletContextHelper>();
    private ServiceTracker<javax.servlet.Filter, javax.servlet.Filter> filterServiceTracker;
    private AtomicLong legacyServiceIdGenerator = new AtomicLong(0L);
    private ServiceTracker<EventListener, EventListener> listenerServiceTracker;
    private ServletContext parentServletContext;
    private Set<Servlet> registeredServlets = new HashSet<Servlet>();
    private Set<String> registeredContextNames = new ConcurrentSkipListSet<String>();
    private ServiceTracker<Servlet, Servlet> resourceServiceTracker;
    private ServiceTracker<Servlet, Servlet> servletServiceTracker;

    public HttpServiceRuntimeImpl(BundleContext bundleContext, ServletContext parentServletContext, Map<String, Object> attributes) {
        this.bundleContext = bundleContext;
        this.parentServletContext = parentServletContext;
        this.attributes = Collections.unmodifiableMap(attributes);
        this.contextServiceTracker = new ServiceTracker(bundleContext, ServletContextHelper.class, (ServiceTrackerCustomizer)this);
        this.contextServiceTracker.open();
        this.listenerServiceTracker = new ServiceTracker(bundleContext, EventListener.class, (ServiceTrackerCustomizer)new ListenerTrackerCustomizer(bundleContext, this));
        this.listenerServiceTracker.open();
        this.filterServiceTracker = new ServiceTracker(bundleContext, this.getFilteFilter(), (ServiceTrackerCustomizer)new FilterTrackerCustomizer(bundleContext, this));
        this.filterServiceTracker.open();
        this.servletServiceTracker = new ServiceTracker(bundleContext, this.getServletFilter(), (ServiceTrackerCustomizer)new ServletTrackerCustomizer(bundleContext, this));
        this.servletServiceTracker.open();
        this.resourceServiceTracker = new ServiceTracker(bundleContext, this.getResourceFilter(), (ServiceTrackerCustomizer)new ResourceTrackerCustomizer(bundleContext, this));
        this.resourceServiceTracker.open();
    }

    public synchronized ContextController addingService(ServiceReference<ServletContextHelper> serviceReference) {
        if (!this.matches(serviceReference)) {
            return null;
        }
        List<String> contextNames = StringPlus.from(serviceReference.getProperty("osgi.http.whiteboard.context.name"));
        if (contextNames.isEmpty()) {
            this.parentServletContext.log("This context's property osgi.http.whiteboard.context.name is null. Ignoring!");
            return null;
        }
        for (String contextName : contextNames) {
            if (!this.registeredContextNames.contains(contextName)) continue;
            this.parentServletContext.log("ContextName " + contextName + " is already in use. Ignoring!");
            return null;
        }
        String contextPath = (String)serviceReference.getProperty("osgi.http.whiteboard.context.path");
        if (contextPath == null) {
            contextPath = "";
        }
        long serviceId = (Long)serviceReference.getProperty("service.id");
        ServletContextHelper servletContextHelper = (ServletContextHelper)this.bundleContext.getService(serviceReference);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        String[] stringArray = serviceReference.getPropertyKeys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            properties.put(key, serviceReference.getProperty(key));
            ++n2;
        }
        properties.putAll(this.attributes);
        return this.addServletContextHelper(serviceReference.getBundle(), servletContextHelper, contextNames, contextPath, serviceId, properties);
    }

    public ContextController addServletContextHelper(Bundle bundle, ServletContextHelper servletContextHelper, List<String> contextNames, String contextPath, long serviceId, Map<String, Object> properties) {
        ContextController contextController;
        if (servletContextHelper == null) {
            throw new NullServletContextHelperException();
        }
        if (this.controllerMap.containsKey(servletContextHelper)) {
            throw new IllegalArgumentException("ServletContextHelper is already registered.");
        }
        if (contextNames == null || contextNames.size() < 1) {
            throw new NullContextNamesException();
        }
        if (contextPath == null) {
            contextPath = "";
        }
        if ((contextController = this.createContextController(bundle, servletContextHelper, contextNames, contextPath, serviceId, properties)) != null) {
            for (String contextName : contextNames) {
                this.registeredContextNames.add(contextName);
            }
        }
        this.controllerMap.putIfAbsent(contextController, servletContextHelper);
        return contextController;
    }

    public RequestInfoDTO calculateRequestInfoDTO(String path) {
        RequestInfoDTO requestInfoDTO = new RequestInfoDTO();
        requestInfoDTO.path = path;
        try {
            this.doDispatch(null, null, path, requestInfoDTO);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return requestInfoDTO;
    }

    public void destroy() {
        this.resourceServiceTracker.close();
        this.servletServiceTracker.close();
        this.filterServiceTracker.close();
        this.listenerServiceTracker.close();
        this.contextServiceTracker.close();
        this.controllerMap.clear();
        this.contextPathMap.clear();
        this.registeredServlets.clear();
        this.attributes = null;
        this.bundleContext = null;
        this.contextPathMap = null;
        this.legacyServiceIdGenerator = null;
        this.parentServletContext = null;
        this.registeredServlets = null;
        this.contextServiceTracker = null;
    }

    public boolean doDispatch(HttpServletRequest request, HttpServletResponse response, String path) throws ServletException, IOException {
        return this.doDispatch(request, response, path, null);
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public Map<String, String> getAttributesAsInitParams() {
        HashMap<String, String> initParameters = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : this.getAttributes().entrySet()) {
            initParameters.put(entry.getKey(), String.valueOf(entry.getValue()));
        }
        return initParameters;
    }

    public ContextController getOrAddContextController(String contextSelector, BundleContext selectorBundleContext) {
        Bundle bundle = selectorBundleContext.getBundle();
        Filter targetFilter = this.getContextSelectorFilter(bundle, contextSelector);
        ContextController contextController = this.getContextController(targetFilter);
        if (contextController != null) {
            return contextController;
        }
        if (contextSelector == null) {
            Hashtable<String, Object> properties = new Hashtable<String, Object>(this.getAttributes());
            properties.put("osgi.http.whiteboard.context.name", String.valueOf(bundle.getBundleId()));
            selectorBundleContext.registerService(ServletContextHelper.class, (Object)new ServletContextHelper(bundle){}, properties);
        }
        contextController = this.getContextController(targetFilter);
        return contextController;
    }

    public ContextController getContextController(Filter targetFilter) {
        for (ContextController contextController : this.controllerMap.keySet()) {
            if (!contextController.matches(targetFilter)) continue;
            return contextController;
        }
        return null;
    }

    public Filter getContextSelectorFilter(Bundle bundle, String contextSelector) {
        if (contextSelector == null) {
            contextSelector = "(osgi.http.whiteboard.context.name=" + String.valueOf(bundle.getBundleId()) + ")";
        } else if (!contextSelector.startsWith("(")) {
            contextSelector = "(osgi.http.whiteboard.context.name=" + contextSelector + ")";
        }
        try {
            return FrameworkUtil.createFilter((String)contextSelector);
        }
        catch (InvalidSyntaxException ise) {
            throw new IllegalArgumentException(ise);
        }
    }

    public Filter getFilteFilter() {
        StringBuilder sb = new StringBuilder();
        sb.append("(&(objectClass=");
        sb.append(javax.servlet.Filter.class.getName());
        sb.append(")(|(");
        sb.append("osgi.http.whiteboard.filter.pattern");
        sb.append("=*)(");
        sb.append("osgi.http.whiteboard.filter.regex");
        sb.append("=*)(");
        sb.append("osgi.http.whiteboard.filter.servlet");
        sb.append("=*)))");
        try {
            return this.bundleContext.createFilter(sb.toString());
        }
        catch (InvalidSyntaxException ise) {
            throw new IllegalArgumentException(ise);
        }
    }

    public Set<Servlet> getRegisteredServlets() {
        return this.registeredServlets;
    }

    public List<String> getHttpServiceEndpoints() {
        return StringPlus.from(this.attributes.get("osgi.http.endpoint"));
    }

    public Filter getResourceFilter() {
        StringBuilder sb = new StringBuilder();
        sb.append("(&(objectClass=");
        sb.append(Servlet.class.getName());
        sb.append(")(");
        sb.append("osgi.http.whiteboard.resource.prefix");
        sb.append("=*)(");
        sb.append("osgi.http.whiteboard.servlet.pattern");
        sb.append("=*))");
        try {
            return this.bundleContext.createFilter(sb.toString());
        }
        catch (InvalidSyntaxException ise) {
            throw new IllegalArgumentException(ise);
        }
    }

    public RuntimeDTO getRuntimeDTO() {
        RuntimeDTO runtimeDTO = new RuntimeDTO();
        runtimeDTO.attributes = this.serializeAttributes();
        runtimeDTO.failedErrorPageDTOs = null;
        runtimeDTO.failedFilterDTOs = null;
        runtimeDTO.failedListenerDTOs = null;
        runtimeDTO.failedResourceDTOs = null;
        runtimeDTO.failedServletContextDTOs = null;
        runtimeDTO.failedServletDTOs = null;
        runtimeDTO.servletContextDTOs = this.getServletContextDTOs();
        return runtimeDTO;
    }

    public Filter getServletFilter() {
        StringBuilder sb = new StringBuilder();
        sb.append("(&(objectClass=");
        sb.append(Servlet.class.getName());
        sb.append(")(|(");
        sb.append("osgi.http.whiteboard.servlet.errorPage");
        sb.append("=*)(");
        sb.append("osgi.http.whiteboard.servlet.pattern");
        sb.append("=*))(!(");
        sb.append("osgi.http.whiteboard.resource.prefix");
        sb.append("=*)))");
        try {
            return this.bundleContext.createFilter(sb.toString());
        }
        catch (InvalidSyntaxException ise) {
            throw new IllegalArgumentException(ise);
        }
    }

    public void log(String message, Throwable t) {
        this.parentServletContext.log(message, t);
    }

    public boolean matches(ServiceReference<?> serviceReference) {
        Filter targetFilter;
        String target = (String)serviceReference.getProperty("osgi.http.whiteboard.target");
        if (target == null) {
            return true;
        }
        try {
            targetFilter = FrameworkUtil.createFilter((String)target);
        }
        catch (InvalidSyntaxException ise) {
            throw new IllegalArgumentException(ise);
        }
        return targetFilter.matches(this.attributes);
    }

    public synchronized void modifiedService(ServiceReference<ServletContextHelper> serviceReference, ContextController contextController) {
    }

    public synchronized void removedService(ServiceReference<ServletContextHelper> serviceReference, ContextController contextController) {
        this.bundleContext.ungetService(serviceReference);
        this.removeContextController(contextController);
    }

    public void removeContextController(ContextController contextController) {
        Set<ContextController> contextControllers = this.getContextControllerPathSet(contextController.getContextPath(), false);
        if (contextControllers != null) {
            contextControllers.remove(contextController);
        }
        for (String contextName : contextController.getContextNames()) {
            this.registeredContextNames.remove(contextName);
        }
        this.controllerMap.remove(contextController);
        contextController.destroy();
    }

    Set<ContextController> getContextControllerPathSet(String contextPath, boolean add) {
        Set existingSet;
        Set set;
        if (contextPath == null) {
            contextPath = "";
        }
        if ((set = (HashSet)this.contextPathMap.get(contextPath)) == null && add && (existingSet = (Set)this.contextPathMap.putIfAbsent(contextPath, set = new HashSet())) != null) {
            set = existingSet;
        }
        return set;
    }

    Set<ContextController> getContextControllers(String requestURI) {
        int pos = requestURI.lastIndexOf(47);
        while (true) {
            Set contextControllers;
            if ((contextControllers = (Set)this.contextPathMap.get(requestURI)) != null) {
                return contextControllers;
            }
            if (pos <= -1) break;
            requestURI = requestURI.substring(0, pos);
            pos = requestURI.lastIndexOf(47);
        }
        return null;
    }

    AtomicLong getLegacyServiceIdGenerator() {
        return this.legacyServiceIdGenerator;
    }

    private ContextController createContextController(Bundle bundle, ServletContextHelper servletContextHelper, List<String> contextNames, String contextPath, long serviceId, Map<String, Object> initParams) {
        ContextController contextController = new ContextController(bundle, servletContextHelper, new ProxyContext(this.parentServletContext), this, contextNames, contextPath, serviceId, this.registeredServlets, initParams);
        Set<ContextController> contextControllers = this.getContextControllerPathSet(contextPath, true);
        contextControllers.add(contextController);
        this.contextPathMap.put(contextPath, contextControllers);
        return contextController;
    }

    private boolean doDispatch(HttpServletRequest request, HttpServletResponse response, String path, RequestInfoDTO requestInfoDTO) throws ServletException, IOException {
        if (this.doDispatch(request, response, path, null, Match.EXACT, requestInfoDTO)) {
            return true;
        }
        String extensionAlias = this.findExtensionAlias(path);
        if (this.doDispatch(request, response, path, extensionAlias, Match.EXTENSION, requestInfoDTO)) {
            return true;
        }
        if (this.doDispatch(request, response, path, null, Match.REGEX, requestInfoDTO)) {
            return true;
        }
        return this.doDispatch(request, response, path, null, Match.DEFAULT_SERVLET, requestInfoDTO);
    }

    private boolean doDispatch(HttpServletRequest request, HttpServletResponse response, String requestURI, String extension, Match match, RequestInfoDTO requestInfoDTO) throws ServletException, IOException {
        DispatchTargets dispatchTargets = this.getDispatchTargets(request, requestURI, extension, match, requestInfoDTO);
        if (dispatchTargets == null || requestInfoDTO != null) {
            return false;
        }
        ContextController contextController = dispatchTargets.getContextController();
        DispatcherType dispatcherType = DispatcherType.REQUEST;
        if (request.getAttribute("javax.servlet.include.request_uri") != null) {
            request.setAttribute("javax.servlet.include.context_path", (Object)contextController.getContextPath());
            request.setAttribute("javax.servlet.include.path_info", (Object)dispatchTargets.getPathInfo());
            request.setAttribute("javax.servlet.include.query_string", (Object)request.getQueryString());
            request.setAttribute("javax.servlet.include.request_uri", (Object)requestURI);
            request.setAttribute("javax.servlet.include.servlet_path", (Object)dispatchTargets.getServletPath());
            dispatcherType = DispatcherType.INCLUDE;
        }
        HttpServletRequest wrappedRequest = new HttpServletRequestBuilder(request, dispatchTargets).build();
        HttpServletResponseWrapperImpl wrapperResponse = new HttpServletResponseWrapperImpl(response);
        ResponseStateHandler responseStateHandler = new ResponseStateHandler(wrappedRequest, (HttpServletResponse)wrapperResponse, dispatchTargets, dispatcherType);
        responseStateHandler.processRequest();
        return true;
    }

    private String findExtensionAlias(String alias) {
        String lastSegment = alias.substring(alias.lastIndexOf(47) + 1);
        int dot = lastSegment.lastIndexOf(46);
        if (dot == -1) {
            return null;
        }
        return lastSegment.substring(dot + 1);
    }

    private DispatchTargets getDispatchTargets(HttpServletRequest request, String requestURI, String extension, Match match, RequestInfoDTO requestInfoDTO) {
        Set<ContextController> contextControllers = this.getContextControllers(requestURI);
        if (contextControllers == null || contextControllers.isEmpty()) {
            return null;
        }
        String contextPath = contextControllers.iterator().next().getContextPath();
        requestURI = requestURI.substring(contextPath.length());
        int pos = requestURI.lastIndexOf(47);
        String servletPath = requestURI;
        String pathInfo = null;
        if (match == Match.DEFAULT_SERVLET) {
            pathInfo = servletPath;
            servletPath = "/";
        }
        while (true) {
            for (ContextController contextController : contextControllers) {
                DispatchTargets dispatchTargets = contextController.getDispatchTargets(request, null, requestURI, servletPath, pathInfo, extension, match, requestInfoDTO);
                if (dispatchTargets == null) continue;
                return dispatchTargets;
            }
            if (match == Match.EXACT || extension != null || pos <= -1) break;
            String newServletPath = requestURI.substring(0, pos);
            pathInfo = requestURI.substring(pos);
            servletPath = newServletPath;
            pos = servletPath.lastIndexOf(47);
        }
        return null;
    }

    private ServletContextDTO[] getServletContextDTOs() {
        ArrayList<ServletContextDTO> servletContextDTOs = new ArrayList<ServletContextDTO>();
        for (ContextController contextController : this.controllerMap.keySet()) {
            servletContextDTOs.add(contextController.getServletContextDTO());
        }
        return servletContextDTOs.toArray(new ServletContextDTO[servletContextDTOs.size()]);
    }

    private Map<String, String> serializeAttributes() {
        HashMap<String, String> temp = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
            temp.put(entry.getKey(), String.valueOf(entry.getValue()));
        }
        return temp;
    }
}

