/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.context;

import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.equinox.http.servlet.internal.HttpServiceRuntimeImpl;
import org.eclipse.equinox.http.servlet.internal.context.DispatchTargets;
import org.eclipse.equinox.http.servlet.internal.context.ProxyContext;
import org.eclipse.equinox.http.servlet.internal.customizer.ContextFilterTrackerCustomizer;
import org.eclipse.equinox.http.servlet.internal.customizer.ContextListenerTrackerCustomizer;
import org.eclipse.equinox.http.servlet.internal.customizer.ContextResourceTrackerCustomizer;
import org.eclipse.equinox.http.servlet.internal.customizer.ContextServletTrackerCustomizer;
import org.eclipse.equinox.http.servlet.internal.error.RegisteredFilterException;
import org.eclipse.equinox.http.servlet.internal.registration.EndpointRegistration;
import org.eclipse.equinox.http.servlet.internal.registration.FilterRegistration;
import org.eclipse.equinox.http.servlet.internal.registration.ListenerRegistration;
import org.eclipse.equinox.http.servlet.internal.registration.ResourceRegistration;
import org.eclipse.equinox.http.servlet.internal.registration.ServletRegistration;
import org.eclipse.equinox.http.servlet.internal.servlet.FilterConfigImpl;
import org.eclipse.equinox.http.servlet.internal.servlet.Match;
import org.eclipse.equinox.http.servlet.internal.servlet.ResourceServlet;
import org.eclipse.equinox.http.servlet.internal.servlet.ServletConfigImpl;
import org.eclipse.equinox.http.servlet.internal.servlet.ServletContextAdaptor;
import org.eclipse.equinox.http.servlet.internal.util.Const;
import org.eclipse.equinox.http.servlet.internal.util.EventListeners;
import org.eclipse.equinox.http.servlet.internal.util.UMDictionaryMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.http.context.ServletContextHelper;
import org.osgi.service.http.runtime.dto.ErrorPageDTO;
import org.osgi.service.http.runtime.dto.FilterDTO;
import org.osgi.service.http.runtime.dto.ListenerDTO;
import org.osgi.service.http.runtime.dto.RequestInfoDTO;
import org.osgi.service.http.runtime.dto.ResourceDTO;
import org.osgi.service.http.runtime.dto.ServletContextDTO;
import org.osgi.service.http.runtime.dto.ServletDTO;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ContextController {
    private static final String[] DISPATCHER = new String[]{Const.Dispatcher.REQUEST.toString()};
    private Map<String, Object> attributes;
    private Map<String, String> initParams;
    private final Bundle bundle;
    private final BundleContext bundleContext;
    private List<String> contextNames;
    private final String contextPath;
    private final long contextServiceId;
    private final Set<EndpointRegistration<?>> endpointRegistrations = new HashSet();
    private EventListeners eventListeners = new EventListeners();
    private final Set<FilterRegistration> filterRegistrations = new HashSet<FilterRegistration>();
    private ServiceTracker<javax.servlet.Filter, FilterRegistration> filterServiceTracker;
    private HttpServiceRuntimeImpl httpServiceRuntime;
    private ServiceTracker<EventListener, ListenerRegistration> listenerServiceTracker;
    private final Set<ListenerRegistration> listenerRegistrations = new HashSet<ListenerRegistration>();
    private ProxyContext proxyContext;
    private Set<Servlet> registeredServlets;
    private ServiceTracker<Servlet, ServletRegistration> servletServiceTracker;
    private ServiceTracker<Servlet, ResourceRegistration> resourceServiceTracker;
    ServletContextHelper servletContextHelper;
    private boolean shutdown;

    public ContextController(Bundle bundle, ServletContextHelper servletContextHelper, ProxyContext proxyContext, HttpServiceRuntimeImpl httpServiceRuntime, List<String> contextNames, String contextPath, long serviceId, Set<Servlet> registeredServlets, Map<String, Object> attributes) {
        this.bundle = bundle;
        this.servletContextHelper = servletContextHelper;
        this.proxyContext = proxyContext;
        this.httpServiceRuntime = httpServiceRuntime;
        this.contextNames = contextNames;
        this.contextPath = contextPath;
        this.contextServiceId = serviceId;
        this.registeredServlets = registeredServlets;
        attributes = new HashMap<String, Object>(attributes);
        attributes.put("osgi.http.whiteboard.context.name", contextNames);
        attributes.put("osgi.http.whiteboard.context.path", contextPath);
        attributes.put("service.id", serviceId);
        this.attributes = attributes;
        HashMap<String, String> initParams = new HashMap<String, String>();
        for (String key : this.attributes.keySet()) {
            initParams.put(key, String.valueOf(attributes.get(key)));
        }
        this.initParams = Collections.unmodifiableMap(initParams);
        this.bundleContext = bundle.getBundleContext();
        this.listenerServiceTracker = new ServiceTracker(this.bundleContext, EventListener.class, (ServiceTrackerCustomizer)new ContextListenerTrackerCustomizer(this.bundleContext, httpServiceRuntime, this));
        this.listenerServiceTracker.open();
        this.filterServiceTracker = new ServiceTracker(this.bundleContext, this.getFilteFilter(), (ServiceTrackerCustomizer)new ContextFilterTrackerCustomizer(this.bundleContext, httpServiceRuntime, this));
        this.filterServiceTracker.open();
        this.servletServiceTracker = new ServiceTracker(this.bundleContext, this.getServletFilter(), (ServiceTrackerCustomizer)new ContextServletTrackerCustomizer(this.bundleContext, httpServiceRuntime, this));
        this.servletServiceTracker.open();
        this.resourceServiceTracker = new ServiceTracker(this.bundleContext, this.getResourceFilter(), (ServiceTrackerCustomizer)new ContextResourceTrackerCustomizer(this.bundleContext, httpServiceRuntime, this));
        this.resourceServiceTracker.open();
    }

    public FilterRegistration addFilterRegistration(String alias, javax.servlet.Filter filter, Dictionary<String, String> initparams, long serviceId) throws ServletException {
        this.checkShutdown();
        if (filter == null) {
            throw new IllegalArgumentException("Filter cannot be null");
        }
        String filterName = initparams.get("filter-name");
        filterName = filterName != null ? filterName : filter.getClass().getName();
        int filterPriority = this.findFilterPriority(initparams);
        return this.addFilterRegistration(filter, false, DISPATCHER, filterPriority, new UMDictionaryMap<String, String>(initparams), filterName, new String[]{alias}, serviceId, Const.EMPTY_ARRAY);
    }

    public FilterRegistration addFilterRegistration(javax.servlet.Filter filter, boolean asyncSupported, String[] dispatcher, int filterPriority, Map<String, String> initparams, String name, String[] patterns, long serviceId, String[] servletNames) throws ServletException {
        this.checkShutdown();
        if (!(patterns != null && patterns.length != 0 || servletNames != null && servletNames.length != 0)) {
            throw new IllegalArgumentException("Patterns or servletNames must contain a value.");
        }
        if (patterns != null) {
            String[] stringArray = patterns;
            int n = patterns.length;
            int n2 = 0;
            while (n2 < n) {
                String pattern = stringArray[n2];
                this.checkPattern(pattern);
                ++n2;
            }
        }
        if (name == null) {
            name = filter.getClass().getName();
        }
        if (filter == null) {
            throw new IllegalArgumentException("Filter cannot be null");
        }
        for (FilterRegistration filterRegistration : this.filterRegistrations) {
            if (!((javax.servlet.Filter)filterRegistration.getT()).equals(filter)) continue;
            throw new RegisteredFilterException(filter);
        }
        dispatcher = this.checkDispatcher(dispatcher);
        FilterDTO filterDTO = new FilterDTO();
        filterDTO.asyncSupported = asyncSupported;
        filterDTO.dispatcher = this.sort(dispatcher);
        filterDTO.initParams = initparams;
        filterDTO.name = name;
        filterDTO.patterns = this.sort(patterns);
        filterDTO.serviceId = serviceId;
        filterDTO.servletContextId = this.contextServiceId;
        filterDTO.servletNames = this.sort(servletNames);
        ServletContextHelper curServletContextHelper = this.getServletContextHelper(this.bundle);
        ServletContext servletContext = this.createServletContext(this.bundle, curServletContextHelper);
        FilterRegistration filterRegistration = new FilterRegistration(filter, filterDTO, filterPriority, curServletContextHelper, this);
        FilterConfigImpl filterConfig = new FilterConfigImpl(name, initparams, servletContext);
        filterRegistration.init(filterConfig);
        this.filterRegistrations.add(filterRegistration);
        return filterRegistration;
    }

    public ListenerRegistration addListenerRegistration(EventListener eventListener, long serviceId) throws ServletException {
        this.checkShutdown();
        List<Class<? extends EventListener>> classes = this.getListenerClasses(eventListener);
        if (classes.isEmpty()) {
            throw new IllegalArgumentException("EventListener does not implement a supported type.");
        }
        for (ListenerRegistration listenerRegistration : this.listenerRegistrations) {
            if (!listenerRegistration.getT().equals(eventListener)) continue;
            throw new ServletException("EventListener has already been registered.");
        }
        ListenerDTO listenerDTO = new ListenerDTO();
        listenerDTO.serviceId = serviceId;
        listenerDTO.servletContextId = this.contextServiceId;
        listenerDTO.types = this.asStringArray(classes);
        ServletContextHelper curServletContextHelper = this.getServletContextHelper(this.bundle);
        ServletContext servletContext = this.createServletContext(this.bundle, curServletContextHelper);
        ListenerRegistration listenerRegistration = new ListenerRegistration(eventListener, classes, listenerDTO, servletContext, curServletContextHelper, this);
        if (classes.contains(ServletContextListener.class)) {
            ServletContextListener servletContextListener = (ServletContextListener)listenerRegistration.getT();
            servletContextListener.contextInitialized(new ServletContextEvent(servletContext));
        }
        this.listenerRegistrations.add(listenerRegistration);
        this.eventListeners.put(classes, listenerRegistration);
        return listenerRegistration;
    }

    public ResourceRegistration addResourceRegistration(String pattern, String prefix, long serviceId) {
        this.checkShutdown();
        if (pattern.startsWith("/*.")) {
            pattern = pattern.substring(1);
        } else if (!(pattern.contains("*.") || pattern.endsWith("/*") || pattern.endsWith("/"))) {
            pattern = String.valueOf(pattern) + "/*";
        }
        return this.addResourceRegistration(new String[]{pattern}, prefix, serviceId, true);
    }

    public ResourceRegistration addResourceRegistration(String[] patterns, String prefix, long serviceId, boolean legacyMatching) {
        this.checkShutdown();
        this.checkPrefix(prefix);
        if (patterns == null || patterns.length < 1) {
            throw new IllegalArgumentException("Patterns must contain a value.");
        }
        String[] stringArray = patterns;
        int n = patterns.length;
        int n2 = 0;
        while (n2 < n) {
            String pattern = stringArray[n2];
            this.checkPattern(pattern);
            ++n2;
        }
        ResourceServlet servlet = new ResourceServlet(prefix, this.servletContextHelper, AccessController.getContext());
        ResourceDTO resourceDTO = new ResourceDTO();
        resourceDTO.patterns = this.sort(patterns);
        resourceDTO.prefix = prefix;
        resourceDTO.serviceId = serviceId;
        resourceDTO.servletContextId = this.contextServiceId;
        ServletContextHelper curServletContextHelper = this.getServletContextHelper(this.bundle);
        ServletContext servletContext = this.createServletContext(this.bundle, curServletContextHelper);
        ResourceRegistration resourceRegistration = new ResourceRegistration((Servlet)servlet, resourceDTO, curServletContextHelper, this, legacyMatching);
        ServletConfigImpl servletConfig = new ServletConfigImpl(resourceRegistration.getName(), new HashMap<String, String>(), servletContext);
        try {
            resourceRegistration.init(servletConfig);
        }
        catch (ServletException servletException) {
            return null;
        }
        this.endpointRegistrations.add(resourceRegistration);
        this.registeredServlets.add((Servlet)servlet);
        return resourceRegistration;
    }

    public ServletRegistration addServletRegistration(String pattern, Servlet servlet, Dictionary<String, String> initparams, long serviceId) throws ServletException {
        this.checkShutdown();
        if (servlet == null) {
            throw new IllegalArgumentException("Servlet cannot be null");
        }
        String servletName = servlet.getClass().getName();
        if (initparams != null && initparams.get("servlet-name") != null) {
            servletName = initparams.get("servlet-name");
        }
        if (pattern == null) {
            throw new IllegalArgumentException("Pattern cannot be null");
        }
        return this.addServletRegistration(servlet, false, Const.EMPTY_ARRAY, new UMDictionaryMap<String, String>(initparams), new String[]{pattern}, serviceId, servletName, true);
    }

    public ServletRegistration addServletRegistration(Servlet servlet, boolean asyncSupported, String[] errorPages, Map<String, String> initparams, String[] patterns, long serviceId, String servletName, boolean legacyMatching) throws ServletException {
        this.checkShutdown();
        if (!(patterns != null && patterns.length != 0 || errorPages != null && errorPages.length != 0)) {
            throw new IllegalArgumentException("Either patterns or errorPages must contain a value.");
        }
        if (patterns != null) {
            String[] stringArray = patterns;
            int n = patterns.length;
            int n2 = 0;
            while (n2 < n) {
                String pattern = stringArray[n2];
                this.checkPattern(pattern);
                ++n2;
            }
        }
        if (servlet == null) {
            throw new IllegalArgumentException("Servlet cannot be null");
        }
        ServletDTO servletDTO = new ServletDTO();
        servletDTO.asyncSupported = asyncSupported;
        servletDTO.initParams = initparams;
        servletDTO.name = servletName;
        servletDTO.patterns = this.sort(patterns);
        servletDTO.serviceId = serviceId;
        servletDTO.servletContextId = this.contextServiceId;
        servletDTO.servletInfo = servlet.getServletInfo();
        ErrorPageDTO errorPageDTO = null;
        if (errorPages != null && errorPages.length > 0) {
            errorPageDTO = new ErrorPageDTO();
            errorPageDTO.asyncSupported = asyncSupported;
            long[] errorCodes = new long[]{};
            ArrayList<String> exceptions = new ArrayList<String>();
            String[] stringArray = errorPages;
            int n = errorPages.length;
            int n3 = 0;
            while (n3 < n) {
                String errorPage = stringArray[n3];
                try {
                    long longValue = Long.parseLong(errorPage);
                    errorCodes = Arrays.copyOf(errorCodes, errorCodes.length + 1);
                    errorCodes[errorCodes.length - 1] = longValue;
                }
                catch (NumberFormatException numberFormatException) {
                    exceptions.add(errorPage);
                }
                ++n3;
            }
            errorPageDTO.errorCodes = errorCodes;
            errorPageDTO.exceptions = exceptions.toArray(new String[exceptions.size()]);
            errorPageDTO.initParams = initparams;
            errorPageDTO.name = servletName;
            errorPageDTO.serviceId = serviceId;
            errorPageDTO.servletContextId = this.contextServiceId;
            errorPageDTO.servletInfo = servlet.getServletInfo();
        }
        ServletContextHelper curServletContextHelper = this.getServletContextHelper(this.bundle);
        ServletContext servletContext = this.createServletContext(this.bundle, curServletContextHelper);
        ServletRegistration servletRegistration = new ServletRegistration(servlet, servletDTO, errorPageDTO, curServletContextHelper, this, legacyMatching);
        ServletConfigImpl servletConfig = new ServletConfigImpl(servletName, initparams, servletContext);
        servletRegistration.init(servletConfig);
        this.endpointRegistrations.add(servletRegistration);
        this.registeredServlets.add(servlet);
        return servletRegistration;
    }

    public void destroy() {
        this.resourceServiceTracker.close();
        this.servletServiceTracker.close();
        this.filterServiceTracker.close();
        this.listenerServiceTracker.close();
        this.endpointRegistrations.clear();
        this.filterRegistrations.clear();
        this.listenerRegistrations.clear();
        this.eventListeners.clear();
        this.proxyContext.destroy();
        this.eventListeners = null;
        this.registeredServlets = null;
        this.contextNames = null;
        this.proxyContext = null;
        this.shutdown = true;
    }

    public ClassLoader getClassLoader() {
        return ((BundleWiring)this.bundle.adapt(BundleWiring.class)).getClassLoader();
    }

    public List<String> getContextNames() {
        this.checkShutdown();
        return this.contextNames;
    }

    public String getContextPath() {
        this.checkShutdown();
        return this.contextPath;
    }

    public DispatchTargets getDispatchTargets(HttpServletRequest request, String servletName, String requestURI, String servletPath, String pathInfo, String extension, Match match, RequestInfoDTO requestInfoDTO) {
        this.checkShutdown();
        this.getProxyContext().initializeServletPath(request);
        EndpointRegistration<?> endpointRegistration = null;
        String pattern = null;
        for (EndpointRegistration<?> curEndpointRegistration : this.endpointRegistrations) {
            pattern = curEndpointRegistration.match(servletName, servletPath, pathInfo, extension, match);
            if (pattern == null) continue;
            endpointRegistration = curEndpointRegistration;
            break;
        }
        if (endpointRegistration == null) {
            return null;
        }
        endpointRegistration.addReference();
        this.addEnpointRegistrationsToRequestInfo(endpointRegistration, requestInfoDTO);
        if (this.filterRegistrations.isEmpty()) {
            return new DispatchTargets(this, endpointRegistration, servletPath, pathInfo, pattern);
        }
        String originalServletPath = servletPath;
        String originalPathInfo = pathInfo;
        ArrayList<FilterRegistration> matchingFilterRegistrations = new ArrayList<FilterRegistration>();
        Match[] matchArray = Match.values();
        int n = matchArray.length;
        int n2 = 0;
        while (n2 < n) {
            Match curMatch = matchArray[n2];
            this.collectFilters(matchingFilterRegistrations, servletName, requestURI, curMatch);
            ++n2;
        }
        this.addFilterRegistrationsToRequestInfo(matchingFilterRegistrations, requestInfoDTO);
        return new DispatchTargets(this, endpointRegistration, matchingFilterRegistrations, originalServletPath, originalPathInfo, pattern);
    }

    private void collectFilters(List<FilterRegistration> matchingFilterRegistrations, String servletName, String requestURI, Match match) {
        String servletPath = requestURI;
        String pathInfo = "";
        String extension = null;
        int pos = -1;
        if (requestURI != null) {
            pos = requestURI.lastIndexOf(47);
            if (match == Match.EXTENSION) {
                int x = requestURI.lastIndexOf(46);
                if (x != -1) {
                    extension = requestURI.substring(x + 1);
                }
                if (extension == null) {
                    return;
                }
            }
        }
        while (true) {
            for (FilterRegistration filterRegistration : this.filterRegistrations) {
                if (filterRegistration.match(servletName, servletPath, pathInfo, extension, match) == null || matchingFilterRegistrations.contains(filterRegistration)) continue;
                matchingFilterRegistrations.add(filterRegistration);
                filterRegistration.addReference();
            }
            if (pos <= -1) break;
            String newServletPath = requestURI.substring(0, pos);
            pathInfo = requestURI.substring(pos);
            servletPath = newServletPath;
            pos = servletPath.lastIndexOf(47);
        }
    }

    public Set<EndpointRegistration<?>> getEndpointRegistrations() {
        this.checkShutdown();
        return this.endpointRegistrations;
    }

    public EventListeners getEventListeners() {
        this.checkShutdown();
        return this.eventListeners;
    }

    public Set<FilterRegistration> getFilterRegistrations() {
        this.checkShutdown();
        return this.filterRegistrations;
    }

    public String getFullContextPath() {
        List<String> endpoints = this.httpServiceRuntime.getHttpServiceEndpoints();
        if (endpoints.isEmpty()) {
            return this.proxyContext.getServletPath().concat(this.contextPath);
        }
        String defaultEndpoint = endpoints.get(0);
        if (defaultEndpoint.length() > 0 && defaultEndpoint.endsWith("/")) {
            defaultEndpoint = defaultEndpoint.substring(0, defaultEndpoint.length() - 1);
        }
        return String.valueOf(defaultEndpoint) + this.contextPath;
    }

    public HttpServiceRuntimeImpl getHttpServiceRuntime() {
        this.checkShutdown();
        return this.httpServiceRuntime;
    }

    public Map<String, String> getInitParams() {
        return this.initParams;
    }

    public Set<ListenerRegistration> getListenerRegistrations() {
        this.checkShutdown();
        return this.listenerRegistrations;
    }

    public ProxyContext getProxyContext() {
        this.checkShutdown();
        return this.proxyContext;
    }

    public Set<Servlet> getRegisteredServlets() {
        this.checkShutdown();
        return this.registeredServlets;
    }

    public long getServiceId() {
        this.checkShutdown();
        return this.contextServiceId;
    }

    public synchronized ServletContextDTO getServletContextDTO() {
        this.checkShutdown();
        ServletContextDTO servletContextDTO = new ServletContextDTO();
        ServletContext servletContext = this.getProxyContext().getServletContext();
        servletContextDTO.attributes = this.getAttributes(servletContext);
        servletContextDTO.contextName = servletContext.getServletContextName();
        servletContextDTO.contextPath = servletContext.getContextPath();
        servletContextDTO.initParams = this.initParams;
        servletContextDTO.names = this.getContextNames().toArray(new String[0]);
        servletContextDTO.serviceId = this.getServiceId();
        servletContextDTO.errorPageDTOs = new ErrorPageDTO[0];
        this.collectEndpointDTOs(servletContextDTO);
        this.collectFilterDTOs(servletContextDTO);
        this.collectListenerDTOs(servletContextDTO);
        return servletContextDTO;
    }

    public ServletContextHelper getServletContextHelper() {
        return this.servletContextHelper;
    }

    public boolean matches(String contextSelector) {
        Filter targetFilter;
        if (contextSelector == null) {
            return true;
        }
        if (!contextSelector.startsWith("(")) {
            contextSelector = "(osgi.http.whiteboard.context.name=" + contextSelector + ")";
        }
        try {
            targetFilter = FrameworkUtil.createFilter((String)contextSelector);
        }
        catch (InvalidSyntaxException ise) {
            throw new IllegalArgumentException(ise);
        }
        return this.matches(targetFilter);
    }

    public boolean matches(Filter targetFilter) {
        return targetFilter.matches(this.attributes);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + '[' + this.getContextNames().get(0) + ']';
    }

    private void addEnpointRegistrationsToRequestInfo(EndpointRegistration<?> endpointRegistration, RequestInfoDTO requestInfoDTO) {
        if (requestInfoDTO == null) {
            return;
        }
        requestInfoDTO.servletContextId = this.getServiceId();
        if (endpointRegistration instanceof ResourceRegistration) {
            requestInfoDTO.resourceDTO = (ResourceDTO)endpointRegistration.getD();
        } else {
            requestInfoDTO.servletDTO = (ServletDTO)endpointRegistration.getD();
        }
    }

    private void addFilterRegistrationsToRequestInfo(List<FilterRegistration> matchedFilterRegistrations, RequestInfoDTO requestInfoDTO) {
        if (requestInfoDTO == null) {
            return;
        }
        FilterDTO[] filterDTOs = new FilterDTO[matchedFilterRegistrations.size()];
        int i = 0;
        while (i < filterDTOs.length) {
            FilterRegistration filterRegistration = matchedFilterRegistrations.get(i);
            filterDTOs[i] = (FilterDTO)filterRegistration.getD();
            ++i;
        }
        requestInfoDTO.filterDTOs = filterDTOs;
    }

    private String[] asStringArray(List<Class<? extends EventListener>> clazzes) {
        Object[] classesArray = new String[clazzes.size()];
        int i = 0;
        while (i < classesArray.length) {
            classesArray[i] = clazzes.get(i).getName();
            ++i;
        }
        Arrays.sort(classesArray);
        return classesArray;
    }

    private String[] checkDispatcher(String[] dispatcher) {
        if (dispatcher == null || dispatcher.length == 0) {
            return DISPATCHER;
        }
        String[] stringArray = dispatcher;
        int n = dispatcher.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            try {
                Const.Dispatcher.valueOf(type);
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException("Invalid dispatcher '" + type + "'", iae);
            }
            ++n2;
        }
        Arrays.sort(dispatcher);
        return dispatcher;
    }

    private void checkPattern(String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Pattern cannot be null");
        }
        if (pattern.indexOf("*.") == 0) {
            return;
        }
        if (!pattern.startsWith("/") || pattern.endsWith("/") && !pattern.equals("/")) {
            throw new IllegalArgumentException("Invalid pattern '" + pattern + "'");
        }
    }

    private void checkPrefix(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("Prefix cannot be null");
        }
        if (prefix.endsWith("/") && !prefix.equals("/")) {
            throw new IllegalArgumentException("Invalid prefix '" + prefix + "'");
        }
    }

    private void checkShutdown() {
        if (this.shutdown) {
            throw new IllegalStateException("Context is already shutdown");
        }
    }

    private ServletContext createServletContext(Bundle curBundle, ServletContextHelper curServletContextHelper) {
        ServletContextAdaptor adaptor = new ServletContextAdaptor(this, curBundle, curServletContextHelper, this.eventListeners, AccessController.getContext());
        return adaptor.createServletContext();
    }

    private void collectEndpointDTOs(ServletContextDTO servletContextDTO) {
        ArrayList<ResourceDTO> resourceDTOs = new ArrayList<ResourceDTO>();
        ArrayList<ServletDTO> servletDTOs = new ArrayList<ServletDTO>();
        for (EndpointRegistration<?> endpointRegistration : this.endpointRegistrations) {
            if (endpointRegistration instanceof ResourceRegistration) {
                resourceDTOs.add((ResourceDTO)endpointRegistration.getD());
                continue;
            }
            servletDTOs.add((ServletDTO)endpointRegistration.getD());
        }
        servletContextDTO.resourceDTOs = resourceDTOs.toArray(new ResourceDTO[resourceDTOs.size()]);
        servletContextDTO.servletDTOs = servletDTOs.toArray(new ServletDTO[servletDTOs.size()]);
    }

    private void collectFilterDTOs(ServletContextDTO servletContextDTO) {
        ArrayList<FilterDTO> filterDTOs = new ArrayList<FilterDTO>();
        for (FilterRegistration filterRegistration : this.filterRegistrations) {
            filterDTOs.add((FilterDTO)filterRegistration.getD());
        }
        servletContextDTO.filterDTOs = filterDTOs.toArray(new FilterDTO[filterDTOs.size()]);
    }

    private void collectListenerDTOs(ServletContextDTO servletContextDTO) {
        ArrayList<ListenerDTO> listenerDTOs = new ArrayList<ListenerDTO>();
        for (ListenerRegistration listenerRegistration : this.listenerRegistrations) {
            listenerDTOs.add((ListenerDTO)listenerRegistration.getD());
        }
        servletContextDTO.listenerDTOs = listenerDTOs.toArray(new ListenerDTO[listenerDTOs.size()]);
    }

    private int findFilterPriority(Dictionary<String, String> initparams) {
        if (initparams == null) {
            return 0;
        }
        String filterPriority = initparams.get("filter-priority");
        if (filterPriority == null) {
            return 0;
        }
        try {
            int result = Integer.parseInt(filterPriority);
            if (result >= -1000 && result <= 1000) {
                return result;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        throw new IllegalArgumentException("filter-priority must be an integer between -1000 and 1000 but was: " + filterPriority);
    }

    private Map<String, Object> getAttributes(ServletContext servletContext) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Enumeration names = servletContext.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            map.put(name, servletContext.getAttribute(name));
        }
        return Collections.unmodifiableMap(map);
    }

    private List<Class<? extends EventListener>> getListenerClasses(EventListener eventListener) {
        ArrayList<Class<? extends EventListener>> classes = new ArrayList<Class<? extends EventListener>>();
        if (ServletContextListener.class.isInstance(eventListener)) {
            classes.add(ServletContextListener.class);
        }
        if (ServletContextAttributeListener.class.isInstance(eventListener)) {
            classes.add(ServletContextAttributeListener.class);
        }
        if (ServletRequestListener.class.isInstance(eventListener)) {
            classes.add(ServletRequestListener.class);
        }
        if (ServletRequestAttributeListener.class.isInstance(eventListener)) {
            classes.add(ServletRequestAttributeListener.class);
        }
        if (HttpSessionListener.class.isInstance(eventListener)) {
            classes.add(HttpSessionListener.class);
        }
        if (HttpSessionAttributeListener.class.isInstance(eventListener)) {
            classes.add(HttpSessionAttributeListener.class);
        }
        return classes;
    }

    private ServletContextHelper getServletContextHelper(Bundle curBundle) {
        if (curBundle == this.bundle) {
            return this.servletContextHelper;
        }
        return new ServletContextHelper(curBundle){

            public String getMimeType(String name) {
                return ContextController.this.servletContextHelper.getMimeType(name);
            }

            public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
                return ContextController.this.servletContextHelper.handleSecurity(request, response);
            }
        };
    }

    private Filter getFilteFilter() {
        StringBuilder sb = new StringBuilder();
        sb.append("(&(objectClass=");
        sb.append(javax.servlet.Filter.class.getName());
        sb.append(")(|(");
        sb.append("osgi.http.whiteboard.filter.pattern");
        sb.append("=*)(");
        sb.append("osgi.http.whiteboard.filter.regex");
        sb.append("=*)(");
        sb.append("osgi.http.whiteboard.filter.servlet");
        sb.append("=*)))");
        try {
            return this.bundleContext.createFilter(sb.toString());
        }
        catch (InvalidSyntaxException ise) {
            throw new IllegalArgumentException(ise);
        }
    }

    private Filter getResourceFilter() {
        StringBuilder sb = new StringBuilder();
        sb.append("(&(objectClass=");
        sb.append(Servlet.class.getName());
        sb.append(")(");
        sb.append("osgi.http.whiteboard.resource.prefix");
        sb.append("=*)(");
        sb.append("osgi.http.whiteboard.servlet.pattern");
        sb.append("=*))");
        try {
            return this.bundleContext.createFilter(sb.toString());
        }
        catch (InvalidSyntaxException ise) {
            throw new IllegalArgumentException(ise);
        }
    }

    private Filter getServletFilter() {
        StringBuilder sb = new StringBuilder();
        sb.append("(&(objectClass=");
        sb.append(Servlet.class.getName());
        sb.append(")(|(");
        sb.append("osgi.http.whiteboard.servlet.errorPage");
        sb.append("=*)(");
        sb.append("osgi.http.whiteboard.servlet.pattern");
        sb.append("=*))(!(");
        sb.append("osgi.http.whiteboard.resource.prefix");
        sb.append("=*)))");
        try {
            return this.bundleContext.createFilter(sb.toString());
        }
        catch (InvalidSyntaxException ise) {
            throw new IllegalArgumentException(ise);
        }
    }

    private String[] sort(String[] values) {
        if (values == null) {
            return null;
        }
        Arrays.sort(values);
        return values;
    }
}

