/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.ParameterInfo;
import org.eclipse.jdt.internal.corext.refactoring.code.IntroduceParameterRefactoring;
import org.eclipse.jdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.jdt.internal.ui.refactoring.ChangeParametersControl;
import org.eclipse.jdt.internal.ui.refactoring.DelegateUIHelper;
import org.eclipse.jdt.internal.ui.refactoring.IParameterListChangeListener;
import org.eclipse.jdt.internal.ui.refactoring.InputPageUtil;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class IntroduceParameterWizard
extends RefactoringWizard {
    public IntroduceParameterWizard(IntroduceParameterRefactoring ref) {
        super((Refactoring)ref, 36);
        this.setDefaultPageTitle(RefactoringMessages.IntroduceParameterWizard_defaultPageTitle);
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new IntroduceParameterInputPage(this.getIntroduceParameterRefactoring().guessParameterNames()));
    }

    private IntroduceParameterRefactoring getIntroduceParameterRefactoring() {
        return (IntroduceParameterRefactoring)this.getRefactoring();
    }

    private static class IntroduceParameterInputPage
    extends UserInputWizardPage {
        private static final String DESCRIPTION = RefactoringMessages.IntroduceParameterInputPage_description;
        public static final String PAGE_NAME = "IntroduceParameterInputPage";
        private String[] fParamNameProposals;
        private JavaSourceViewer fSignaturePreview;
        private Button fLeaveDelegateCheckBox;
        private Button fDeprecateDelegateCheckBox;

        public IntroduceParameterInputPage(String[] tempNameProposals) {
            super(PAGE_NAME);
            this.setDescription(DESCRIPTION);
            Assert.isNotNull((Object)tempNameProposals);
            this.fParamNameProposals = tempNameProposals;
        }

        private IntroduceParameterRefactoring getIntroduceParameterRefactoring() {
            return (IntroduceParameterRefactoring)this.getRefactoring();
        }

        public void createControl(Composite parent) {
            Composite result = new Composite(parent, 0);
            this.setControl((Control)result);
            GridLayout layout = new GridLayout();
            result.setLayout((Layout)layout);
            this.createParameterTableControl(result);
            this.fLeaveDelegateCheckBox = DelegateUIHelper.generateLeaveDelegateCheckbox(result, this.getRefactoring(), false);
            if (this.fLeaveDelegateCheckBox != null) {
                this.fDeprecateDelegateCheckBox = new Button(result, 32);
                GridData data = new GridData();
                data.horizontalAlignment = 4;
                data.horizontalIndent = layout.marginWidth + this.fDeprecateDelegateCheckBox.computeSize((int)-1, (int)-1).x;
                this.fDeprecateDelegateCheckBox.setLayoutData((Object)data);
                this.fDeprecateDelegateCheckBox.setText(DelegateUIHelper.getDeprecateDelegateCheckBoxTitle());
                final IntroduceParameterRefactoring refactoring = this.getIntroduceParameterRefactoring();
                this.fDeprecateDelegateCheckBox.setSelection(DelegateUIHelper.loadDeprecateDelegateSetting(refactoring));
                refactoring.setDeprecateDelegates(this.fDeprecateDelegateCheckBox.getSelection());
                this.fDeprecateDelegateCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        refactoring.setDeprecateDelegates(IntroduceParameterInputPage.this.fDeprecateDelegateCheckBox.getSelection());
                    }
                });
                this.fDeprecateDelegateCheckBox.setEnabled(this.fLeaveDelegateCheckBox.getSelection());
                this.fLeaveDelegateCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        IntroduceParameterInputPage.this.fDeprecateDelegateCheckBox.setEnabled(IntroduceParameterInputPage.this.fLeaveDelegateCheckBox.getSelection());
                    }
                });
            }
            Label sep = new Label(result, 258);
            sep.setLayoutData((Object)new GridData(768));
            this.createSignaturePreview(result);
            this.update(false);
            Dialog.applyDialogFont((Control)result);
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.jdt.ui.introduce_parameter_page_context");
        }

        private ChangeParametersControl createParameterTableControl(Composite composite) {
            String labelText = RefactoringMessages.IntroduceParameterWizard_parameters;
            ChangeParametersControl cp = new ChangeParametersControl(composite, 0, labelText, new IParameterListChangeListener(){

                public void parameterChanged(ParameterInfo parameter) {
                    IntroduceParameterInputPage.this.update(true);
                }

                public void parameterListChanged() {
                    IntroduceParameterInputPage.this.update(true);
                }

                public void parameterAdded(ParameterInfo parameter) {
                    IntroduceParameterInputPage.this.update(true);
                }
            }, ChangeParametersControl.Mode.INTRODUCE_PARAMETER, this.fParamNameProposals);
            cp.setLayoutData(new GridData(1808));
            cp.setInput(this.getIntroduceParameterRefactoring().getParameterInfos());
            cp.editParameter(this.getIntroduceParameterRefactoring().getAddedParameterInfo());
            return cp;
        }

        public void dispose() {
            DelegateUIHelper.saveLeaveDelegateSetting(this.fLeaveDelegateCheckBox);
            DelegateUIHelper.saveDeprecateDelegateSetting(this.fDeprecateDelegateCheckBox);
            super.dispose();
        }

        private void createSignaturePreview(Composite composite) {
            Label previewLabel = new Label(composite, 0);
            previewLabel.setText(RefactoringMessages.ChangeSignatureInputPage_method_Signature_Preview);
            this.fSignaturePreview = InputPageUtil.createSignaturePreview(composite);
        }

        private void update(boolean displayErrorMessage) {
            this.updateStatus(displayErrorMessage);
            this.updateSignaturePreview();
        }

        private void updateStatus(boolean displayErrorMessage) {
            RefactoringStatus nameCheck = this.getIntroduceParameterRefactoring().validateInput();
            if (displayErrorMessage) {
                this.setPageComplete(nameCheck);
            } else {
                this.setErrorMessage(null);
                this.setPageComplete(true);
            }
        }

        private void updateSignaturePreview() {
            try {
                int top = this.fSignaturePreview.getTextWidget().getTopPixel();
                this.fSignaturePreview.getDocument().set(this.getIntroduceParameterRefactoring().getMethodSignaturePreview());
                this.fSignaturePreview.getTextWidget().setTopPixel(top);
            }
            catch (JavaModelException e) {
                ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.IntroduceParameterWizard_defaultPageTitle, RefactoringMessages.ChangeSignatureInputPage_exception);
            }
        }
    }
}

